/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.editor.completion;

import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.db.sql.analyzer.SQLStatementKind;
import org.netbeans.modules.db.sql.editor.StringUtils;
import org.netbeans.modules.db.sql.lexer.SQLTokenId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLStatementAnalyzer {
    public static SQLStatementKind analyzeKind(TokenSequence<SQLTokenId> tokenSequence) {
        tokenSequence.moveStart();
        if (!tokenSequence.moveNext()) {
            return null;
        }
        if (tokenSequence.token() != null && SQLTokenId.WHITESPACE.equals(tokenSequence.token().id())) {
            tokenSequence.moveNext();
        }
        if (SQLStatementAnalyzer.isKeyword("SELECT", tokenSequence)) {
            return SQLStatementKind.SELECT;
        }
        if (SQLStatementAnalyzer.isKeyword("INSERT", tokenSequence)) {
            return SQLStatementKind.INSERT;
        }
        return null;
    }

    public static boolean isKeyword(CharSequence charSequence, TokenSequence<SQLTokenId> tokenSequence) {
        return tokenSequence.token().id() == SQLTokenId.KEYWORD && StringUtils.textEqualsIgnoreCase(tokenSequence.token().text(), charSequence);
    }
}

