/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.analyzer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.netbeans.api.db.sql.support.SQLIdentifiers;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.db.sql.analyzer.FromClause;
import org.netbeans.modules.db.sql.analyzer.QualIdent;
import org.netbeans.modules.db.sql.analyzer.SQLStatementKind;
import org.netbeans.modules.db.sql.analyzer.SelectStatement;
import org.netbeans.modules.db.sql.editor.StringUtils;
import org.netbeans.modules.db.sql.editor.completion.SQLStatementAnalyzer;
import org.netbeans.modules.db.sql.lexer.SQLTokenId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectStatementAnalyzer {
    private final TokenSequence<SQLTokenId> seq;
    private final boolean detectKind;
    private final SQLIdentifiers.Quoter quoter;
    private final List<List<String>> selectValues = new ArrayList<List<String>>();
    private final List<FromTable> fromTables = new ArrayList<FromTable>();
    private final List<SelectStatement> subqueries = new ArrayList<SelectStatement>();
    private final SortedMap<Integer, SelectStatement.SelectContext> offset2Context = new TreeMap<Integer, SelectStatement.SelectContext>();
    private int startOffset;
    private State state = State.START;

    public static SelectStatement analyze(TokenSequence<SQLTokenId> tokenSequence, SQLIdentifiers.Quoter quoter) {
        SelectStatementAnalyzer selectStatementAnalyzer = SelectStatementAnalyzer.doParse(tokenSequence, quoter, false);
        if (!selectStatementAnalyzer.state.isAfter(State.START)) {
            return null;
        }
        FromClause fromClause = selectStatementAnalyzer.state.isAfter(State.FROM) ? selectStatementAnalyzer.createFromClause() : null;
        return new SelectStatement(SQLStatementKind.SELECT, selectStatementAnalyzer.startOffset, tokenSequence.offset() + tokenSequence.token().length(), Collections.unmodifiableList(selectStatementAnalyzer.selectValues), fromClause, Collections.unmodifiableList(selectStatementAnalyzer.subqueries), selectStatementAnalyzer.offset2Context);
    }

    private static SelectStatementAnalyzer doParse(TokenSequence<SQLTokenId> tokenSequence, SQLIdentifiers.Quoter quoter, boolean bl) {
        tokenSequence.moveStart();
        if (!tokenSequence.moveNext()) {
            return null;
        }
        SelectStatementAnalyzer selectStatementAnalyzer = new SelectStatementAnalyzer(tokenSequence, quoter, bl);
        selectStatementAnalyzer.parse();
        return selectStatementAnalyzer;
    }

    private SelectStatementAnalyzer(TokenSequence<SQLTokenId> tokenSequence, SQLIdentifiers.Quoter quoter, boolean bl) {
        this.seq = tokenSequence;
        this.quoter = quoter;
        this.detectKind = bl;
    }

    private FromClause createFromClause() {
        HashSet<QualIdent> hashSet = new HashSet<QualIdent>();
        HashMap<String, QualIdent> hashMap = new HashMap<String, QualIdent>();
        for (FromTable fromTable : this.fromTables) {
            if (fromTable.alias == null) {
                hashSet.add(fromTable.tableName);
                continue;
            }
            if (hashMap.containsKey(fromTable.alias)) continue;
            hashMap.put(fromTable.alias, fromTable.tableName);
        }
        return new FromClause(Collections.unmodifiableSet(hashSet), Collections.unmodifiableMap(hashMap));
    }

    private void parse() {
        this.startOffset = this.seq.offset();
        boolean bl = false;
        block21: do {
            switch (this.state) {
                case START: {
                    if (!SQLStatementAnalyzer.isKeyword("SELECT", this.seq)) continue block21;
                    this.moveToState(State.SELECT);
                    if (!this.detectKind) continue block21;
                    return;
                }
                case SELECT: {
                    Object object;
                    switch ((SQLTokenId)this.seq.token().id()) {
                        case IDENTIFIER: {
                            object = this.analyzeSelectValue();
                            if (object.isEmpty()) break;
                            this.selectValues.add((List<String>)object);
                            break;
                        }
                        case KEYWORD: {
                            if (!SQLStatementAnalyzer.isKeyword("FROM", this.seq)) break;
                            this.moveToState(State.FROM);
                            bl = true;
                        }
                    }
                    continue block21;
                }
                case FROM: {
                    Object object;
                    switch ((SQLTokenId)this.seq.token().id()) {
                        case IDENTIFIER: {
                            if (!bl) break;
                            object = this.parseFromTable();
                            if (object != null) {
                                this.fromTables.add((FromTable)object);
                            }
                            bl = false;
                            break;
                        }
                        case COMMA: {
                            bl = true;
                            break;
                        }
                        case KEYWORD: {
                            if (SQLStatementAnalyzer.isKeyword("JOIN", this.seq)) {
                                bl = true;
                                break;
                            }
                            object = this.getStateForKeywordAfterFrom();
                            if (object == null) break;
                            this.moveToState((State)((Object)object));
                        }
                    }
                    continue block21;
                }
                case JOIN_CONDITION: {
                    switch ((SQLTokenId)this.seq.token().id()) {
                        case COMMA: {
                            this.moveToState(State.FROM);
                            bl = true;
                            break;
                        }
                        case KEYWORD: {
                            if (!SQLStatementAnalyzer.isKeyword("JOIN", this.seq)) break;
                            this.moveToState(State.FROM);
                            bl = true;
                        }
                    }
                    continue block21;
                }
                case GROUP_WITHOUT_BY: {
                    if (!SQLStatementAnalyzer.isKeyword("BY", this.seq)) continue block21;
                    this.moveToState(State.GROUP_BY);
                    break;
                }
                case ORDER_WITHOUT_BY: {
                    if (!SQLStatementAnalyzer.isKeyword("BY", this.seq)) continue block21;
                    this.moveToState(State.ORDER_BY);
                    break;
                }
                default: {
                    Object object = this.getStateForKeywordAfterFrom();
                    if (object == null) continue block21;
                    this.moveToState((State)((Object)object));
                }
            }
        } while (this.nextToken());
    }

    private List<String> analyzeSelectValue() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.getUnquotedIdentifier());
        boolean bl = false;
        block7: while (true) {
            if (!this.nextToken()) {
                return arrayList;
            }
            switch ((SQLTokenId)this.seq.token().id()) {
                case DOT: {
                    bl = true;
                    continue block7;
                }
                case IDENTIFIER: {
                    if (bl) {
                        bl = false;
                        arrayList.add(this.getUnquotedIdentifier());
                        continue block7;
                    }
                    arrayList.clear();
                    arrayList.add(this.getUnquotedIdentifier());
                    continue block7;
                }
                case LPAREN: {
                    arrayList.clear();
                    continue block7;
                }
                case COMMA: {
                    break block7;
                }
                case KEYWORD: {
                    if (SQLStatementAnalyzer.isKeyword("AS", this.seq)) {
                        bl = false;
                        arrayList.clear();
                        continue block7;
                    }
                    if (!SQLStatementAnalyzer.isKeyword("FROM", this.seq) && !this.isKeywordAfterFrom()) continue block7;
                    break block7;
                }
                default: {
                    continue block7;
                }
            }
            break;
        }
        this.seq.movePrevious();
        return arrayList;
    }

    private FromTable parseFromTable() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.getUnquotedIdentifier());
        boolean bl = false;
        String string = null;
        block5: while (this.nextToken()) {
            switch ((SQLTokenId)this.seq.token().id()) {
                case DOT: {
                    bl = true;
                    continue block5;
                }
                case IDENTIFIER: {
                    if (bl && string == null) {
                        bl = false;
                        arrayList.add(this.getUnquotedIdentifier());
                        continue block5;
                    }
                    string = this.getUnquotedIdentifier();
                    continue block5;
                }
                case KEYWORD: {
                    if (SQLStatementAnalyzer.isKeyword("AS", this.seq)) {
                        bl = false;
                        continue block5;
                    }
                    this.seq.movePrevious();
                    break block5;
                }
                default: {
                    this.seq.movePrevious();
                    break block5;
                }
            }
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            if (((String)iterator.next()).length() != 0) continue;
            iterator.remove();
        }
        if (string != null && string.length() == 0) {
            string = null;
        }
        if (!arrayList.isEmpty()) {
            return new FromTable(new QualIdent(arrayList), string);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean nextToken() {
        boolean bl;
        block7: while (bl = this.seq.moveNext()) {
            switch ((SQLTokenId)this.seq.token().id()) {
                case WHITESPACE: 
                case LINE_COMMENT: 
                case BLOCK_COMMENT: {
                    continue block7;
                }
            }
        }
        if (!this.state.isAfter(State.SELECT)) return bl;
        if (!SQLStatementAnalyzer.isKeyword("SELECT", this.seq)) return bl;
        int n = this.seq.offset();
        int n2 = 1;
        while (bl = this.seq.moveNext()) {
            switch ((SQLTokenId)this.seq.token().id()) {
                case LPAREN: {
                    ++n2;
                    break;
                }
                case RPAREN: {
                    if (--n2 != 0) break;
                    TokenSequence tokenSequence = this.seq.subSequence(n, this.seq.offset());
                    SelectStatement selectStatement = SelectStatementAnalyzer.analyze((TokenSequence<SQLTokenId>)tokenSequence, this.quoter);
                    if (selectStatement == null) return bl;
                    this.subqueries.add(selectStatement);
                    return bl;
                }
            }
        }
        return bl;
    }

    private void moveToState(State state) {
        this.state = state;
        SelectStatement.SelectContext selectContext = state.getContext();
        if (selectContext != null) {
            this.offset2Context.put(this.seq.offset() + this.seq.token().length(), selectContext);
        }
    }

    private boolean isKeywordAfterFrom() {
        return this.getStateForKeywordAfterFrom() != null;
    }

    private State getStateForKeywordAfterFrom() {
        if (this.seq.token().id() != SQLTokenId.KEYWORD) {
            return null;
        }
        CharSequence charSequence = this.seq.token().text();
        if (StringUtils.textEqualsIgnoreCase("ON", charSequence)) {
            return State.JOIN_CONDITION;
        }
        if (StringUtils.textEqualsIgnoreCase("WHERE", charSequence)) {
            return State.WHERE;
        }
        if (StringUtils.textEqualsIgnoreCase("GROUP", charSequence)) {
            return State.GROUP_WITHOUT_BY;
        }
        if (StringUtils.textEqualsIgnoreCase("HAVING", charSequence)) {
            return State.HAVING;
        }
        if (StringUtils.textEqualsIgnoreCase("ORDER", charSequence)) {
            return State.ORDER_WITHOUT_BY;
        }
        return null;
    }

    private String getUnquotedIdentifier() {
        return this.quoter.unquote(((Object)this.seq.token().text()).toString());
    }

    private static class FromTable {
        private final QualIdent tableName;
        private final String alias;

        public FromTable(QualIdent qualIdent, String string) {
            this.tableName = qualIdent;
            this.alias = string;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        START(0, null),
        SELECT(1, SelectStatement.SelectContext.SELECT),
        FROM(2, SelectStatement.SelectContext.FROM),
        JOIN_CONDITION(3, SelectStatement.SelectContext.JOIN_CONDITION),
        WHERE(4, SelectStatement.SelectContext.WHERE),
        GROUP_WITHOUT_BY(5, null),
        GROUP_BY(6, SelectStatement.SelectContext.GROUP_BY),
        HAVING(7, SelectStatement.SelectContext.HAVING),
        ORDER_WITHOUT_BY(8, null),
        ORDER_BY(9, SelectStatement.SelectContext.ORDER_BY);

        private final int order;
        private final SelectStatement.SelectContext context;

        private State(int n2, SelectStatement.SelectContext selectContext) {
            this.order = n2;
            this.context = selectContext;
        }

        public boolean isAfter(State state) {
            return this.order >= state.order;
        }

        public SelectStatement.SelectContext getContext() {
            return this.context;
        }
    }
}

