/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.repository.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.apache.maven.artifact.Artifact;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.core.spi.multiview.MultiViewElementCallback;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.indexer.api.NBVersionInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryQueries;
import org.netbeans.modules.maven.indexer.api.RepositoryUtil;
import org.netbeans.modules.maven.indexer.spi.ui.ArtifactViewerFactory;
import org.openide.awt.Actions;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

public class BasicArtifactPanel
extends TopComponent
implements MultiViewElement {
    private MultiViewElementCallback callback;
    private JToolBar toolbar;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JLabel lblArtifactId;
    private JLabel lblClassifier;
    private JLabel lblGroupId;
    private JLabel lblPackaging;
    private JLabel lblVersion;
    private JList lstClassifiers;
    private JList lstVersions;
    private JTextField txtArtifactId;
    private JTextField txtClassifier;
    private JTextField txtGroupId;
    private JTextField txtLastModified;
    private JTextField txtPackaging;
    private JTextField txtSHA;
    private JTextField txtSize;
    private JTextField txtVersion;

    public BasicArtifactPanel(Lookup lookup) {
        super(lookup);
        this.initComponents();
        this.lstVersions.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                super.mouseClicked(mouseEvent);
                if (mouseEvent.getClickCount() > 1 && mouseEvent.getButton() == 1) {
                    Object e = BasicArtifactPanel.this.lstVersions.getSelectedValue();
                    if (e instanceof String) {
                        return;
                    }
                    NBVersionInfo nBVersionInfo = (NBVersionInfo)e;
                    if (nBVersionInfo != null) {
                        int n = BasicArtifactPanel.this.callback.getTopComponent().getTabPosition();
                        ArtifactViewerFactory artifactViewerFactory = (ArtifactViewerFactory)Lookup.getDefault().lookup(ArtifactViewerFactory.class);
                        TopComponent topComponent = artifactViewerFactory.createTopComponent(nBVersionInfo);
                        topComponent.openAtTabPosition(n);
                        BasicArtifactPanel.this.callback.getTopComponent().close();
                        topComponent.requestActive();
                    }
                }
            }

            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            }

            public void mouseDragged(MouseEvent mouseEvent) {
            }

            public void mouseMoved(MouseEvent mouseEvent) {
            }
        });
        this.lstVersions.setCellRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                if (object instanceof NBVersionInfo) {
                    NBVersionInfo nBVersionInfo = (NBVersionInfo)object;
                    ((JLabel)component).setText(nBVersionInfo.getVersion());
                }
                return component;
            }
        });
        this.lstVersions.setSelectionMode(0);
    }

    private String computeSize(long l) {
        long l2 = l / 1024L;
        if (l2 == 0L) {
            return NbBundle.getMessage(BasicArtifactPanel.class, (String)"TXT_Bytes", (Object)l);
        }
        long l3 = l2 / 1024L;
        if (l3 == 0L) {
            return NbBundle.getMessage(BasicArtifactPanel.class, (String)"TXT_kb", (Object)l2);
        }
        return NbBundle.getMessage(BasicArtifactPanel.class, (String)"TXT_Mb", (Object)l3);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jPanel3 = new JPanel();
        this.jPanel1 = new JPanel();
        this.lblGroupId = new JLabel();
        this.txtGroupId = new JTextField();
        this.lblArtifactId = new JLabel();
        this.txtArtifactId = new JTextField();
        this.lblVersion = new JLabel();
        this.txtVersion = new JTextField();
        this.lblPackaging = new JLabel();
        this.txtPackaging = new JTextField();
        this.lblClassifier = new JLabel();
        this.txtClassifier = new JTextField();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.txtSize = new JTextField();
        this.jLabel2 = new JLabel();
        this.txtLastModified = new JTextField();
        this.jLabel3 = new JLabel();
        this.txtSHA = new JTextField();
        this.jPanel4 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.lstVersions = new JList();
        this.jLabel4 = new JLabel();
        this.jPanel5 = new JPanel();
        this.jScrollPane3 = new JScrollPane();
        this.lstClassifiers = new JList();
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(BasicArtifactPanel.class, (String)"BasicArtifactPanel.jPanel1.border.title")));
        this.lblGroupId.setLabelFor(this.txtGroupId);
        this.lblGroupId.setText(NbBundle.getMessage(BasicArtifactPanel.class, (String)"BasicArtifactPanel.lblGroupId.text"));
        this.txtGroupId.setEditable(false);
        this.lblArtifactId.setLabelFor(this.txtArtifactId);
        this.lblArtifactId.setText(NbBundle.getMessage(BasicArtifactPanel.class, (String)"BasicArtifactPanel.lblArtifactId.text"));
        this.txtArtifactId.setEditable(false);
        this.lblVersion.setLabelFor(this.txtVersion);
        this.lblVersion.setText(NbBundle.getMessage(BasicArtifactPanel.class, (String)"BasicArtifactPanel.lblVersion.text"));
        this.txtVersion.setEditable(false);
        this.lblPackaging.setText(NbBundle.getMessage(BasicArtifactPanel.class, (String)"BasicArtifactPanel.lblPackaging.text"));
        this.txtPackaging.setEditable(false);
        this.lblClassifier.setText(NbBundle.getMessage(BasicArtifactPanel.class, (String)"BasicArtifactPanel.lblClassifier.text"));
        this.txtClassifier.setEditable(false);
        GroupLayout groupLayout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.lblGroupId).add((Component)this.lblArtifactId).add((Component)this.lblVersion).add((Component)this.lblPackaging)).add(18, 18, 18).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.txtArtifactId, -1, 311, Short.MAX_VALUE).add((Component)this.txtGroupId, -1, 311, Short.MAX_VALUE).add((Component)this.txtVersion, -1, 311, Short.MAX_VALUE).add((Component)this.txtPackaging, -1, 311, Short.MAX_VALUE))).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.lblClassifier).addPreferredGap(1).add((Component)this.txtClassifier, -1, 310, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblGroupId).add((Component)this.txtGroupId, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblArtifactId).add((Component)this.txtArtifactId, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblVersion).add((Component)this.txtVersion, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblPackaging).add((Component)this.txtPackaging, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((Component)this.lblClassifier).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.txtClassifier, -2, -1, -2).add(1, 1, 1))).addContainerGap(29, Short.MAX_VALUE)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(BasicArtifactPanel.class, (String)"TIT_PrimaryArtifact")));
        this.jLabel1.setText(NbBundle.getMessage(BasicArtifactPanel.class, (String)"BasicArtifactPanel.jLabel1.text"));
        this.txtSize.setEditable(false);
        this.jLabel2.setText(NbBundle.getMessage(BasicArtifactPanel.class, (String)"BasicArtifactPanel.jLabel2.text"));
        this.txtLastModified.setEditable(false);
        this.jLabel3.setText(NbBundle.getMessage(BasicArtifactPanel.class, (String)"BasicArtifactPanel.jLabel3.text"));
        this.txtSHA.setEditable(false);
        GroupLayout groupLayout2 = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.jLabel2).add((Component)this.jLabel1).add((Component)this.jLabel3)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.txtLastModified, -1, 273, Short.MAX_VALUE).add((Component)this.txtSize, -1, 273, Short.MAX_VALUE).add((Component)this.txtSHA, -1, 273, Short.MAX_VALUE)).addContainerGap()));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.txtSize, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.txtLastModified, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.txtSHA, -2, -1, -2)).addContainerGap(104, Short.MAX_VALUE)));
        this.jPanel4.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(BasicArtifactPanel.class, (String)"TIT_Versions")));
        this.jScrollPane2.setViewportView(this.lstVersions);
        this.jLabel4.setText(NbBundle.getMessage(BasicArtifactPanel.class, (String)"BasicArtifactPanel.jLabel4.text"));
        GroupLayout groupLayout3 = new GroupLayout((Container)this.jPanel4);
        this.jPanel4.setLayout((LayoutManager)groupLayout3);
        groupLayout3.setHorizontalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout3.createParallelGroup(1).add(2, (Component)this.jScrollPane2, -1, 211, Short.MAX_VALUE).add(2, (Component)this.jLabel4, -1, 211, Short.MAX_VALUE)).addContainerGap()));
        groupLayout3.setVerticalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().add((Component)this.jLabel4).addPreferredGap(0).add((Component)this.jScrollPane2, -1, 116, Short.MAX_VALUE).addContainerGap()));
        this.jPanel5.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(BasicArtifactPanel.class, (String)"TIT_SecondaryArtifacts")));
        this.jScrollPane3.setViewportView(this.lstClassifiers);
        GroupLayout groupLayout4 = new GroupLayout((Container)this.jPanel5);
        this.jPanel5.setLayout((LayoutManager)groupLayout4);
        groupLayout4.setHorizontalGroup((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((GroupLayout.Group)groupLayout4.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane3, -1, 211, Short.MAX_VALUE).addContainerGap()));
        groupLayout4.setVerticalGroup((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((GroupLayout.Group)groupLayout4.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane3, -1, 149, Short.MAX_VALUE).addContainerGap()));
        GroupLayout groupLayout5 = new GroupLayout((Container)this.jPanel3);
        this.jPanel3.setLayout((LayoutManager)groupLayout5);
        groupLayout5.setHorizontalGroup((GroupLayout.Group)groupLayout5.createParallelGroup(1).add((GroupLayout.Group)groupLayout5.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout5.createParallelGroup(1).add((Component)this.jPanel2, -1, -1, Short.MAX_VALUE).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)groupLayout5.createParallelGroup(1).add((Component)this.jPanel4, -1, -1, Short.MAX_VALUE).add((Component)this.jPanel5, -1, -1, Short.MAX_VALUE)).add(15, 15, 15)));
        groupLayout5.setVerticalGroup((GroupLayout.Group)groupLayout5.createParallelGroup(1).add((GroupLayout.Group)groupLayout5.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout5.createParallelGroup(1).add((Component)this.jPanel4, -1, -1, Short.MAX_VALUE).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)groupLayout5.createParallelGroup(1).add((Component)this.jPanel5, -1, -1, Short.MAX_VALUE).add((Component)this.jPanel2, -1, -1, Short.MAX_VALUE)).add(123, 123, 123)));
        this.jScrollPane1.setViewportView(this.jPanel3);
        GroupLayout groupLayout6 = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)groupLayout6);
        groupLayout6.setHorizontalGroup((GroupLayout.Group)groupLayout6.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 699, Short.MAX_VALUE));
        groupLayout6.setVerticalGroup((GroupLayout.Group)groupLayout6.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 491, Short.MAX_VALUE));
    }

    public JComponent getVisualRepresentation() {
        return this;
    }

    public JComponent getToolbarRepresentation() {
        if (this.toolbar == null) {
            this.toolbar = new JToolBar();
            this.toolbar.setFloatable(false);
            Action[] actionArray = new Action[1];
            Action[] actionArray2 = (Action[])this.getLookup().lookup(actionArray.getClass());
            Dimension dimension = new Dimension(3, 0);
            this.toolbar.addSeparator(dimension);
            for (Action action : actionArray2) {
                JButton jButton = new JButton();
                Actions.connect((AbstractButton)jButton, (Action)action);
                this.toolbar.add(jButton);
                this.toolbar.addSeparator(dimension);
            }
        }
        return this.toolbar;
    }

    public void setMultiViewCallback(MultiViewElementCallback multiViewElementCallback) {
        this.callback = multiViewElementCallback;
    }

    public CloseOperationState canCloseElement() {
        return CloseOperationState.STATE_OK;
    }

    public void componentActivated() {
        super.componentActivated();
    }

    public void componentClosed() {
        super.componentClosed();
    }

    public void componentDeactivated() {
        super.componentDeactivated();
    }

    public void componentHidden() {
        super.componentHidden();
    }

    public void componentOpened() {
        final Artifact artifact = (Artifact)this.getLookup().lookup(Artifact.class);
        assert (artifact != null);
        NBVersionInfo nBVersionInfo = (NBVersionInfo)this.getLookup().lookup(NBVersionInfo.class);
        if (nBVersionInfo != null) {
            this.txtGroupId.setText(nBVersionInfo.getGroupId());
            this.txtArtifactId.setText(nBVersionInfo.getArtifactId());
            this.txtVersion.setText(nBVersionInfo.getVersion());
            this.txtPackaging.setText(nBVersionInfo.getType());
            this.txtClassifier.setText(nBVersionInfo.getClassifier());
            this.txtSize.setText(this.computeSize(nBVersionInfo.getSize()));
            this.txtLastModified.setText("" + new Date(nBVersionInfo.getLastModified()));
        } else {
            this.txtGroupId.setText(artifact.getGroupId());
            this.txtArtifactId.setText(artifact.getArtifactId());
            this.txtVersion.setText(artifact.getVersion());
            this.txtPackaging.setText(artifact.getType());
            this.txtClassifier.setText(artifact.getClassifier());
        }
        final DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        defaultListModel.addElement(NbBundle.getMessage(BasicArtifactPanel.class, (String)"TXT_Loading"));
        this.lstVersions.setModel(defaultListModel);
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                final List list = RepositoryQueries.getVersions((String)artifact.getGroupId(), (String)artifact.getArtifactId(), (RepositoryInfo[])new RepositoryInfo[0]);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        defaultListModel.removeAllElements();
                        for (NBVersionInfo nBVersionInfo : list) {
                            defaultListModel.addElement(nBVersionInfo);
                        }
                    }
                });
            }
        });
        final DefaultListModel<String> defaultListModel2 = new DefaultListModel<String>();
        defaultListModel2.addElement(NbBundle.getMessage(BasicArtifactPanel.class, (String)"TXT_Loading"));
        this.lstClassifiers.setModel(defaultListModel2);
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                List list = RepositoryQueries.getRecords((String)artifact.getGroupId(), (String)artifact.getArtifactId(), (String)artifact.getVersion(), (RepositoryInfo[])new RepositoryInfo[0]);
                final TreeSet<String> treeSet = new TreeSet<String>();
                boolean bl = false;
                boolean bl2 = false;
                for (NBVersionInfo nBVersionInfo : list) {
                    if (nBVersionInfo.getClassifier() != null) {
                        treeSet.add(nBVersionInfo.getClassifier());
                    }
                    if (nBVersionInfo.isJavadocExists()) {
                        bl = true;
                    }
                    if (!nBVersionInfo.isSourcesExists()) continue;
                    bl2 = true;
                }
                if (bl2) {
                    treeSet.add("source");
                }
                if (bl) {
                    treeSet.add("javadoc");
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        defaultListModel2.removeAllElements();
                        for (String string : treeSet) {
                            defaultListModel2.addElement(string);
                        }
                    }
                });
            }
        });
        File file = FileUtilities.convertArtifactToLocalRepositoryFile((Artifact)artifact);
        if (file.exists()) {
            try {
                String string = RepositoryUtil.calculateSHA1Checksum((File)file);
                this.txtSHA.setText(string);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
                this.txtSHA.setText(NbBundle.getMessage(BasicArtifactPanel.class, (String)"MSG_FailedSHA1"));
            }
        } else {
            this.txtSHA.setText(NbBundle.getMessage(BasicArtifactPanel.class, (String)"MSG_NOSHA"));
        }
    }

    public void componentShowing() {
        super.componentShowing();
    }
}

