/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JSeparator;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionsList {
    private static final Logger LOG = Logger.getLogger(ActionsList.class.getName());
    private final List<Object> all;
    private final List<Action> actions;

    protected ActionsList(List<FileObject> list, boolean bl, boolean bl2) {
        Pair pair = ActionsList.convertImpl(list == null ? Collections.emptyList() : list, bl, bl2);
        this.all = pair.all;
        this.actions = pair.actions;
    }

    public List<Object> getAllInstances() {
        return this.all;
    }

    public List<Action> getActionsOnly() {
        return this.actions;
    }

    public static List<Object> convert(List<FileObject> list, boolean bl) {
        return ActionsList.convertImpl(list, (boolean)false, (boolean)bl).all;
    }

    private static Pair convertImpl(List<FileObject> list, boolean bl, boolean bl2) {
        ArrayList<DataObject> arrayList = new ArrayList<DataObject>();
        ArrayList<Action> arrayList2 = new ArrayList<Action>();
        for (FileObject fileObject : list) {
            Object e;
            Object object;
            block14: {
                DataObject dataObject;
                block13: {
                    try {
                        dataObject = DataObject.find((FileObject)fileObject);
                        if (dataObject != null || !bl2 || !LOG.isLoggable(Level.WARNING)) break block13;
                        LOG.warning("ActionsList: DataObject is null for item=" + fileObject + "\n");
                    }
                    catch (DataObjectNotFoundException dataObjectNotFoundException) {
                        if (bl2) {
                            if (!LOG.isLoggable(Level.WARNING)) continue;
                            LOG.warning("ActionsList: DataObject not found for item=" + fileObject + "\n");
                            continue;
                        }
                        if (!LOG.isLoggable(Level.FINE)) continue;
                        LOG.log(Level.FINE, "DataObject not found for action fileObject=" + fileObject);
                        continue;
                    }
                }
                object = null;
                InstanceCookie instanceCookie = (InstanceCookie)dataObject.getLookup().lookup(InstanceCookie.class);
                if (bl2 && instanceCookie == null) {
                    if (!LOG.isLoggable(Level.WARNING)) continue;
                    LOG.warning("ActionsList: InstanceCookie not found for item=" + fileObject + "\n");
                    continue;
                }
                if (instanceCookie != null) {
                    try {
                        if (!ActionsList.isSeparator(instanceCookie) && (object = instanceCookie.instanceCreate()) == null && bl2 && LOG.isLoggable(Level.WARNING)) {
                            LOG.warning("ActionsList: InstanceCookie.instanceCreate() null for item=" + fileObject + "\n");
                        }
                        break block14;
                    }
                    catch (Exception exception) {
                        LOG.log(Level.WARNING, "Can't instantiate object", exception);
                        continue;
                    }
                }
                object = dataObject instanceof DataFolder ? dataObject : dataObject.getName();
            }
            if (arrayList.size() > 0 && (Utilities.compareObjects(e = arrayList.get(arrayList.size() - 1), (Object)object) || ActionsList.isSeparator(e) && ActionsList.isSeparator(object))) continue;
            if (object instanceof Action) {
                arrayList2.add((Action)object);
            } else if (ActionsList.isSeparator(object)) {
                if (bl2 && LOG.isLoggable(Level.WARNING)) {
                    LOG.warning("ActionsList: Separator for item=" + fileObject + "\n");
                }
                arrayList2.add(null);
            }
            arrayList.add((DataObject)object);
        }
        Pair pair = new Pair();
        pair.all = arrayList.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(arrayList);
        pair.actions = arrayList2.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(arrayList2);
        return pair;
    }

    private static boolean isSeparator(Object object) {
        return object == null || object instanceof JSeparator;
    }

    private static boolean isSeparator(InstanceCookie instanceCookie) throws Exception {
        return instanceCookie instanceof InstanceCookie.Of && ((InstanceCookie.Of)instanceCookie).instanceOf(JSeparator.class) || JSeparator.class.isAssignableFrom(instanceCookie.instanceClass());
    }

    private static class Pair {
        List<Object> all;
        List<Action> actions;

        private Pair() {
        }
    }
}

