/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class WLPluginProperties {
    private static final Logger LOGGER = Logger.getLogger(WLPluginProperties.class.getName());
    private static final boolean verboseRegistration = System.getProperty("netbeans.weblogic.registration") != null;
    private static final String CONFIG_XML = "config/config.xml";
    public static final String SERVER_ROOT_ATTR = "serverRoot";
    public static final String DOMAIN_ROOT_ATTR = "domainRoot";
    public static final String IS_LOCAL_ATTR = "isLocal";
    public static final String HOST_ATTR = "host";
    public static final String PORT_ATTR = "port";
    public static final String DEBUGGER_PORT_ATTR = "debuggerPort";
    private static WLPluginProperties pluginProperties = null;
    private String installLocation;
    private static final String INSTALL_ROOT_KEY = "installRoot";
    private FileObject propertiesFile = null;
    public static final String DOMAIN_LIST = "common/nodemanager/nodemanager.domains";
    private static Collection fileColl = new ArrayList();

    public static WLPluginProperties getInstance() {
        if (pluginProperties == null) {
            pluginProperties = new WLPluginProperties();
        }
        return pluginProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private WLPluginProperties() {
        InputStream inputStream = null;
        try {
            try {
                this.propertiesFile = this.getPropertiesFile();
                if (null != this.propertiesFile) {
                    inputStream = this.propertiesFile.getInputStream();
                }
                this.loadPluginProperties(inputStream);
                if (null == inputStream) return;
            }
            catch (FileNotFoundException fileNotFoundException) {
                Logger.getLogger("global").log(Level.INFO, null, fileNotFoundException);
                this.loadPluginProperties(inputStream);
                if (null == inputStream) return;
                inputStream.close();
                return;
            }
            catch (IOException iOException) {
                Logger.getLogger("global").log(Level.INFO, null, iOException);
                this.loadPluginProperties(inputStream);
                if (null == inputStream) return;
                {
                    catch (Throwable throwable) {
                        this.loadPluginProperties(inputStream);
                        if (null == inputStream) throw throwable;
                        inputStream.close();
                        throw throwable;
                    }
                }
                inputStream.close();
                return;
            }
            inputStream.close();
            return;
        }
        catch (IOException iOException) {
            Logger.getLogger("global").log(Level.INFO, null, iOException);
        }
    }

    void loadPluginProperties(InputStream inputStream) {
        String string;
        Properties properties = new Properties();
        if (null != inputStream) {
            try {
                properties.load(inputStream);
            }
            catch (IOException iOException) {
                Logger.getLogger("global").log(Level.INFO, null, iOException);
            }
        }
        if ((string = properties.getProperty(INSTALL_ROOT_KEY)) != null) {
            this.setInstallLocation(string);
        }
    }

    private FileObject getPropertiesFile() throws IOException {
        FileObject fileObject = FileUtil.getConfigFile((String)"J2EE");
        FileObject fileObject2 = null;
        if (null != fileObject && null == (fileObject2 = fileObject.getFileObject("weblogic", "properties"))) {
            fileObject2 = fileObject.createData("weblogic", "properties");
        }
        return fileObject2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveProperties() {
        block11: {
            Properties properties = new Properties();
            String string = this.getInstallLocation();
            if (string != null) {
                properties.setProperty(INSTALL_ROOT_KEY, string);
            }
            FileLock fileLock = null;
            OutputStream outputStream = null;
            try {
                if (null == this.propertiesFile) break block11;
                try {
                    fileLock = this.propertiesFile.lock();
                    outputStream = this.propertiesFile.getOutputStream(fileLock);
                    if (null != outputStream) {
                        properties.store(outputStream, "");
                    }
                }
                catch (IOException iOException) {
                    Logger.getLogger("global").log(Level.INFO, null, iOException);
                }
                finally {
                    if (null != outputStream) {
                        outputStream.close();
                    }
                    if (null != fileLock) {
                        fileLock.releaseLock();
                    }
                }
            }
            catch (IOException iOException) {
                Logger.getLogger("global").log(Level.INFO, null, iOException);
            }
        }
    }

    public static boolean domainListExists(File file) {
        return null != file && file.exists() && file.canRead() && file.isDirectory() && new File(file.getPath() + File.separator + DOMAIN_LIST).exists();
    }

    public static boolean isGoodServerLocation(File file) {
        return null != file && file.exists() && file.canRead() && file.isDirectory() && WLPluginProperties.hasRequiredChildren(file, fileColl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isSupportedVersion(File file) {
        File file2 = new File(file, "server/lib/weblogic.jar");
        if (!file2.exists()) {
            return false;
        }
        try {
            JarFile jarFile = new JarFile(file2);
            try {
                Manifest manifest = jarFile.getManifest();
                String string = null;
                if (manifest != null) {
                    string = manifest.getMainAttributes().getValue("Implementation-Version");
                }
                if (string == null) return false;
                boolean bl = (string = string.trim()).startsWith("9.") || string.startsWith("10.");
                return bl;
            }
            finally {
                try {
                    jarFile.close();
                }
                catch (IOException iOException) {
                    LOGGER.log(Level.FINEST, null, iOException);
                }
            }
        }
        catch (IOException iOException) {
            LOGGER.log(Level.FINE, null, iOException);
        }
        return false;
    }

    public static String getWeblogicDomainVersion(String string) {
        File file = new File(string, CONFIG_XML);
        if (!file.exists()) {
            return null;
        }
        try {
            InputSource inputSource = new InputSource(new FileInputStream(file));
            Document document = XMLUtil.parse((InputSource)inputSource, (boolean)false, (boolean)false, null, null);
            if (document.getElementsByTagName("domain-version").getLength() > 0) {
                return document.getElementsByTagName("domain-version").item(0).getTextContent();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            Logger.getLogger("global").log(Level.INFO, null, fileNotFoundException);
        }
        catch (IOException iOException) {
            Logger.getLogger("global").log(Level.INFO, null, iOException);
        }
        catch (SAXException sAXException) {
            Logger.getLogger("global").log(Level.INFO, null, sAXException);
        }
        return null;
    }

    private static boolean hasRequiredChildren(File file, Collection collection) {
        if (null == file) {
            return false;
        }
        String[] stringArray = file.list();
        if (null == stringArray) {
            return false;
        }
        if (null == collection) {
            return true;
        }
        for (String string : collection) {
            File file2 = new File(file.getPath() + File.separator + string);
            if (file2.exists()) continue;
            return false;
        }
        return true;
    }

    public void setInstallLocation(String string) {
        if (string.endsWith("/") || string.endsWith("\\")) {
            string = string.substring(0, string.length() - 1);
        }
        this.installLocation = string;
    }

    public String getInstallLocation() {
        return this.installLocation;
    }

    static {
        fileColl.add("common");
        fileColl.add("uninstall");
        fileColl.add("common/bin");
        fileColl.add("server/lib/weblogic.jar");
    }
}

