/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.earproject;

import java.util.HashMap;
import java.util.Map;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ModuleType {
    WEB(NbBundle.getMessage(ModuleType.class, (String)"CTL_WebModule")),
    EJB(NbBundle.getMessage(ModuleType.class, (String)"CTL_EjbModule")),
    CLIENT(NbBundle.getMessage(ModuleType.class, (String)"CTL_ClientModule"));

    private final String description;
    private static final Map<String, ModuleType> DEFAULT_DD;

    private ModuleType(String string2) {
        this.description = string2;
    }

    public String getDescription() {
        return this.description;
    }

    public static Map<FileObject, ModuleType> detectModules(FileObject fileObject) {
        HashMap<FileObject, ModuleType> hashMap = new HashMap<FileObject, ModuleType>();
        for (FileObject fileObject2 : fileObject.getChildren()) {
            ModuleType moduleType;
            if (!fileObject2.isFolder() || (moduleType = ModuleType.detectModuleType(fileObject2)) == null) continue;
            hashMap.put(fileObject2, moduleType);
        }
        return hashMap;
    }

    public static ModuleType detectModuleType(FileObject fileObject) {
        ModuleType moduleType = null;
        for (Map.Entry<String, ModuleType> entry : DEFAULT_DD.entrySet()) {
            FileObject fileObject2 = fileObject.getFileObject(entry.getKey());
            if (fileObject2 == null || !fileObject2.isData()) continue;
            moduleType = entry.getValue();
        }
        return moduleType;
    }

    static {
        DEFAULT_DD = new HashMap<String, ModuleType>();
        DEFAULT_DD.put("web/WEB-INF/web.xml", WEB);
        DEFAULT_DD.put("src/conf/ejb-jar.xml", EJB);
        DEFAULT_DD.put("src/conf/application-client.xml", CLIENT);
    }
}

