/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.elements;

import java.awt.Image;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jrubyparser.ast.INameNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.SymbolNode;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.RubyParseResult;
import org.netbeans.modules.ruby.RubyParser;
import org.netbeans.modules.ruby.RubyType;
import org.netbeans.modules.ruby.elements.AstAttributeElement;
import org.netbeans.modules.ruby.elements.AstClassElement;
import org.netbeans.modules.ruby.elements.AstFieldElement;
import org.netbeans.modules.ruby.elements.AstMethodElement;
import org.netbeans.modules.ruby.elements.AstModuleElement;
import org.netbeans.modules.ruby.elements.AstNameElement;
import org.netbeans.modules.ruby.elements.RubyElement;
import org.netbeans.modules.ruby.lexer.LexUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AstElement
extends RubyElement {
    protected Node node;
    protected ParserResult info;
    protected ArrayList<AstElement> children;
    protected String name;
    private String in;
    protected Set<Modifier> modifiers;
    private RubyType type;

    public AstElement(ParserResult parserResult, Node node) {
        this.info = parserResult;
        this.node = node;
        this.type = RubyType.createUnknown();
    }

    public String getFqn() {
        return this.name;
    }

    public Node getNode() {
        return this.node;
    }

    @Override
    public abstract String getName();

    public String getDisplayName() {
        return this.getName();
    }

    public String getDescription() {
        return this.getName();
    }

    public List<AstElement> getChildren() {
        if (this.children == null) {
            return Collections.emptyList();
        }
        return this.children;
    }

    public void addChild(AstElement astElement) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(astElement);
    }

    public static AstElement create(ParserResult parserResult, Node node) {
        switch (node.getNodeType()) {
            case DEFNNODE: 
            case DEFSNODE: {
                return new AstMethodElement(parserResult, node);
            }
            case CLASSNODE: 
            case SCLASSNODE: {
                return new AstClassElement(parserResult, node);
            }
            case MODULENODE: {
                return new AstModuleElement(parserResult, node);
            }
            case CONSTNODE: {
                return new AstNameElement(parserResult, node, ((INameNode)node).getName(), ElementKind.VARIABLE);
            }
            case CLASSVARNODE: 
            case CLASSVARDECLNODE: 
            case INSTASGNNODE: 
            case INSTVARNODE: {
                return new AstFieldElement(parserResult, node);
            }
            case CONSTDECLNODE: {
                return new AstNameElement(parserResult, node, ((INameNode)node).getName(), ElementKind.CONSTANT);
            }
            case SYMBOLNODE: {
                return new AstAttributeElement(parserResult, (SymbolNode)node, null);
            }
        }
        return null;
    }

    public String toString() {
        String string = this.getClass().getName();
        return string.substring(0, string.lastIndexOf(46)) + ":" + this.node.toString();
    }

    public Image getIcon() {
        return null;
    }

    @Override
    public String getIn() {
        return this.in;
    }

    public void setIn(String string) {
        this.in = string;
    }

    @Override
    public ElementKind getKind() {
        return ElementKind.OTHER;
    }

    @Override
    public Set<Modifier> getModifiers() {
        return Collections.emptySet();
    }

    public ParserResult getInfo() {
        return this.info;
    }

    public void setType(RubyType rubyType) {
        assert (rubyType != null) : "Cannot pass null to AstElement#setTypes";
        this.type = rubyType;
    }

    public RubyType getType() {
        return this.type;
    }

    @Override
    public OffsetRange getOffsetRange(ParserResult parserResult) {
        RubyParseResult rubyParseResult = AstUtilities.getParseResult((Parser.Result)parserResult);
        RubyElement rubyElement = RubyParser.resolveHandle(rubyParseResult, this);
        if (rubyElement instanceof AstElement) {
            Node node = ((AstElement)rubyElement).getNode();
            if (node != null) {
                OffsetRange offsetRange = AstUtilities.getRange(this.node);
                return LexUtilities.getLexerOffsets((Parser.Result)rubyParseResult, offsetRange);
            }
            return OffsetRange.NONE;
        }
        if (rubyElement != null) {
            Logger logger = Logger.getLogger(AstElement.class.getName());
            logger.log(Level.WARNING, "Foreign element: " + rubyElement + " of type " + (rubyElement != null ? rubyElement.getClass().getName() : "null"));
        } else if (this.getNode() != null) {
            OffsetRange offsetRange = AstUtilities.getRange(this.getNode());
            if (offsetRange != OffsetRange.NONE) {
                ParserResult parserResult2 = this.info;
                if (parserResult2 == null) {
                    parserResult2 = rubyParseResult;
                }
                return LexUtilities.getLexerOffsets((Parser.Result)parserResult2, offsetRange);
            }
            return OffsetRange.NONE;
        }
        return OffsetRange.NONE;
    }
}

