/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jrubyparser.ast.CallNode;
import org.jrubyparser.ast.ClassNode;
import org.jrubyparser.ast.Colon2Node;
import org.jrubyparser.ast.FCallNode;
import org.jrubyparser.ast.INameNode;
import org.jrubyparser.ast.ListNode;
import org.jrubyparser.ast.MethodDefNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.jrubyparser.ast.SClassNode;
import org.jrubyparser.ast.SelfNode;
import org.jrubyparser.ast.StrNode;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.indexing.Context;
import org.netbeans.modules.parsing.spi.indexing.EmbeddingIndexer;
import org.netbeans.modules.parsing.spi.indexing.EmbeddingIndexerFactory;
import org.netbeans.modules.parsing.spi.indexing.Indexable;
import org.netbeans.modules.parsing.spi.indexing.support.IndexDocument;
import org.netbeans.modules.parsing.spi.indexing.support.IndexingSupport;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.RubyIndex;
import org.netbeans.modules.ruby.RubyIndexerHelper;
import org.netbeans.modules.ruby.RubyParseResult;
import org.netbeans.modules.ruby.RubyStructureAnalyzer;
import org.netbeans.modules.ruby.RubyType;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.elements.AstElement;
import org.netbeans.modules.ruby.elements.ClassElement;
import org.netbeans.modules.ruby.elements.IndexedElement;
import org.netbeans.modules.ruby.elements.ModuleElement;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RubyIndexer
extends EmbeddingIndexer {
    private static final Logger LOG = Logger.getLogger(RubyIndexer.class.getName());
    private static final boolean INDEX_UNDOCUMENTED = true;
    static boolean preindexingTest = false;
    static boolean skipTypeInferenceForTests = false;
    private static final boolean PREINDEXING = Boolean.getBoolean("gsf.preindexing");
    static final String FIELD_EXTENDS_NAME = "extends";
    static final String FIELD_FQN_NAME = "fqn";
    static final String FIELD_IN = "in";
    static final String FIELD_CLASS_NAME = "class";
    static final String FIELD_CASE_INSENSITIVE_CLASS_NAME = "class-ig";
    static final String FIELD_REQUIRE = "require";
    static final String FIELD_REQUIRES = "requires";
    static final String FIELD_INCLUDES = "includes";
    static final String FIELD_EXTEND_WITH = "extendWith";
    private static final String[] FIXED_COLUMN_TYPES = new String[]{"binary", "boolean", "date", "datetime", "decimal", "float", "integer", "string", "text", "time", "timestamp"};
    static final String FIELD_METHOD_NAME = "method";
    static final String FIELD_FIELD_NAME = "field";
    static final String FIELD_GLOBAL_NAME = "global";
    static final String FIELD_ATTRIBUTE_NAME = "attribute";
    static final String FIELD_CONSTANT_NAME = "constant";
    static final String FIELD_CLASS_ATTRS = "attrs";
    static final String FIELD_DB_TABLE = "dbtable";
    static final String FIELD_DB_VERSION = "dbversion";
    static final String FIELD_DB_COLUMN = "dbcolumn";
    static final String SCHEMA_INDEX_VERSION = "schema";

    protected void index(Indexable indexable, Parser.Result result, Context context) {
        IndexingSupport indexingSupport;
        Node node = AstUtilities.getRoot(result);
        RubyParseResult rubyParseResult = AstUtilities.getParseResult(result);
        if (node == null) {
            return;
        }
        try {
            indexingSupport = IndexingSupport.getInstance((Context)context);
        }
        catch (IOException iOException) {
            LOG.log(Level.WARNING, null, iOException);
            return;
        }
        TreeAnalyzer treeAnalyzer = new TreeAnalyzer(rubyParseResult, indexingSupport, indexable);
        treeAnalyzer.analyze();
        for (IndexDocument indexDocument : treeAnalyzer.getDocuments()) {
            indexingSupport.addDocument(indexDocument);
        }
    }

    private static int getModifiersFlag(Set<Modifier> set) {
        int n;
        int n2 = n = set.contains(Modifier.STATIC) ? 16 : 0;
        if (set.contains(Modifier.PRIVATE)) {
            n |= 4;
        } else if (set.contains(Modifier.PROTECTED)) {
            n |= 2;
        }
        return n;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TreeAnalyzer {
        private final FileObject file;
        private final IndexingSupport support;
        private final Indexable indexable;
        private String requires;
        private final RubyParseResult result;
        private int docMode;
        private final List<IndexDocument> documents;
        private String url;
        private final boolean platform;

        private TreeAnalyzer(RubyParseResult rubyParseResult, IndexingSupport indexingSupport, Indexable indexable) {
            this.result = rubyParseResult;
            this.file = RubyUtils.getFileObject((Parser.Result)rubyParseResult);
            this.support = indexingSupport;
            this.indexable = indexable;
            this.documents = new ArrayList<IndexDocument>();
            this.platform = RubyUtils.isPlatformFile(this.file);
        }

        private String getRequireString(Set<String> set) {
            if (set != null && set.size() > 0) {
                StringBuilder stringBuilder = new StringBuilder(20 * set.size());
                for (String string : set) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append(string);
                }
                return stringBuilder.toString();
            }
            return null;
        }

        private String getIncludedString(Set<String> set) {
            if (set != null && set.size() > 0) {
                StringBuilder stringBuilder = new StringBuilder(20 * set.size());
                for (String string : set) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append(string);
                }
                return stringBuilder.toString();
            }
            return null;
        }

        List<IndexDocument> getDocuments() {
            return this.documents;
        }

        public void analyze() {
            try {
                this.url = this.file.getURL().toExternalForm();
                this.url = RubyIndex.getPreindexUrl(this.url);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            String string = this.file.getNameExt();
            if (Character.isDigit(string.charAt(0)) && (string.matches("^\\d\\d\\d_.*") || string.matches("^\\d\\d\\d\\d\\d\\d\\d\\d\\d\\d\\d\\d\\d\\d_.*"))) {
                if (this.file != null && this.file.getParent() != null && this.file.getParent().getName().equals("migrate")) {
                    this.handleMigration();
                }
            } else if ("schema.rb".equals(string) && this.file != null && this.file.getParent() != null && this.file.getParent().getName().equals("db")) {
                this.handleMigration();
            }
            RubyStructureAnalyzer.AnalysisResult analysisResult = this.result.getStructure();
            this.requires = this.getRequireString(analysisResult.getRequires());
            List<? extends AstElement> list = analysisResult.getElements();
            if (string.startsWith("acti")) {
                if ("action_controller.rb".equals(string)) {
                    this.handleRailsBase("ActionController");
                } else if ("active_record.rb".equals(string)) {
                    this.handleRailsBase("ActiveRecord");
                    this.handleMigrations();
                } else {
                    if ("action_mailer.rb".equals(string)) {
                        this.handleRailsBase("ActionMailer");
                        return;
                    }
                    if ("action_view.rb".equals(string)) {
                        this.handleRailsBase("ActionView");
                        this.handleActionViewHelpers();
                    }
                }
            } else if (string.equals("assertions.rb") && this.url.endsWith("lib/action_controller/assertions.rb")) {
                this.handleRailsClass("Test::Unit", "Test::Unit::TestCase", "TestCase", "TestCase");
            } else if (string.equals("schema_definitions.rb")) {
                this.handleSchemaDefinitions();
            }
            if (list == null || list.size() == 0) {
                if (this.requires != null) {
                    IndexDocument indexDocument = this.support.createDocument(this.indexable);
                    this.documents.add(indexDocument);
                    if (this.requires != null) {
                        indexDocument.addPair(RubyIndexer.FIELD_REQUIRES, this.requires, false, true);
                    }
                    this.addRequire(indexDocument);
                }
                return;
            }
            this.analyze(list);
        }

        private void handleSchemaDefinitions() {
            if (this.url.indexOf("activerecord-2") == -1) {
                return;
            }
            Node node = AstUtilities.getRoot((Parser.Result)this.result);
            if (node == null) {
                return;
            }
            HashSet<String> hashSet = new HashSet<String>();
            HashSet<String> hashSet2 = new HashSet<String>();
            this.scan(node, hashSet, hashSet2);
            IndexDocument indexDocument = this.support.createDocument(this.indexable);
            this.documents.add(indexDocument);
            String string = this.getRequireString(hashSet2);
            if (string != null) {
                indexDocument.addPair(RubyIndexer.FIELD_REQUIRES, string, false, true);
            }
            this.addRequire(indexDocument);
            String string2 = this.getIncludedString(hashSet);
            if (string2 != null) {
                indexDocument.addPair(RubyIndexer.FIELD_INCLUDES, string2, false, true);
            }
            int n = 0;
            indexDocument.addPair(RubyIndexer.FIELD_CLASS_ATTRS, IndexedElement.flagToString(n), false, true);
            String string3 = "TableDefinition";
            String string4 = "ActiveRecord::ConnectionAdapters";
            String string5 = string4 + "::" + string3;
            String string6 = string3.toLowerCase();
            indexDocument.addPair(RubyIndexer.FIELD_FQN_NAME, string5, true, true);
            indexDocument.addPair(RubyIndexer.FIELD_CASE_INSENSITIVE_CLASS_NAME, string6, true, true);
            indexDocument.addPair(RubyIndexer.FIELD_CLASS_NAME, string3, true, true);
            indexDocument.addPair(RubyIndexer.FIELD_IN, string4, false, true);
            for (String string7 : new String[]{"string", "text", "integer", "float", "decimal", "datetime", "timestamp", "time", "date", "binary", "boolean"}) {
                EnumSet<Modifier> enumSet = EnumSet.of(Modifier.PUBLIC);
                int n2 = RubyIndexer.getModifiersFlag(enumSet);
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(string7);
                stringBuilder.append("(names,options);");
                stringBuilder.append(IndexedElement.flagToFirstChar(n2));
                stringBuilder.append(IndexedElement.flagToSecondChar(n2));
                stringBuilder.append(";;;options(=>limit|default:nil|null:bool|precision|scale)");
                String string8 = stringBuilder.toString();
                indexDocument.addPair(RubyIndexer.FIELD_METHOD_NAME, string8, true, true);
            }
        }

        private void handleRailsBase(String string) {
            this.handleRailsClass(string, string + "::Base", "Base", "base");
        }

        private void handleRailsClass(String string, String string2, String string3, String string4) {
            Node node = AstUtilities.getRoot((Parser.Result)this.result);
            if (node == null) {
                return;
            }
            IndexDocument indexDocument = this.support.createDocument(this.indexable);
            this.documents.add(indexDocument);
            HashSet<String> hashSet = new HashSet<String>();
            HashSet<String> hashSet2 = new HashSet<String>();
            this.scan(node, hashSet, hashSet2);
            String string5 = this.getRequireString(hashSet2);
            if (string5 != null) {
                indexDocument.addPair(RubyIndexer.FIELD_REQUIRES, string5, false, true);
            }
            this.addRequire(indexDocument);
            String string6 = this.getIncludedString(hashSet);
            if (string6 != null) {
                indexDocument.addPair(RubyIndexer.FIELD_INCLUDES, string6, false, true);
            }
            int n = 0;
            indexDocument.addPair(RubyIndexer.FIELD_CLASS_ATTRS, IndexedElement.flagToString(n), false, true);
            indexDocument.addPair(RubyIndexer.FIELD_FQN_NAME, string2, true, true);
            indexDocument.addPair(RubyIndexer.FIELD_CASE_INSENSITIVE_CLASS_NAME, string4, true, true);
            indexDocument.addPair(RubyIndexer.FIELD_CLASS_NAME, string3, true, true);
            indexDocument.addPair(RubyIndexer.FIELD_IN, string, false, true);
        }

        private void addClassIncludes(String string, String string2, String string3, int n, String string4) {
            IndexDocument indexDocument = this.support.createDocument(this.indexable);
            this.documents.add(indexDocument);
            if (string4 != null) {
                indexDocument.addPair(RubyIndexer.FIELD_INCLUDES, string4, false, true);
            }
            indexDocument.addPair(RubyIndexer.FIELD_CLASS_ATTRS, IndexedElement.flagToString(n), false, true);
            indexDocument.addPair(RubyIndexer.FIELD_FQN_NAME, string2, true, true);
            indexDocument.addPair(RubyIndexer.FIELD_CASE_INSENSITIVE_CLASS_NAME, string.toLowerCase(), true, true);
            indexDocument.addPair(RubyIndexer.FIELD_CLASS_NAME, string, true, true);
            if (string3 != null) {
                indexDocument.addPair(RubyIndexer.FIELD_IN, string3, false, true);
            }
        }

        private void handleMigrations() {
            int n = 0;
            this.addClassIncludes("Migration", "ActiveRecord::Migration", "ActiveRecord", n, "ActiveRecord::ConnectionAdapters::SchemaStatements");
        }

        private void handleMigration() {
            Object object;
            String string;
            Node node = AstUtilities.getRoot((Parser.Result)this.result);
            if (node == null) {
                return;
            }
            String string2 = this.file.getName();
            Node object2 = null;
            if (RubyIndexer.SCHEMA_INDEX_VERSION.equals(string2)) {
                object2 = node;
                string = RubyIndexer.SCHEMA_INDEX_VERSION;
            } else {
                if (string2.charAt(3) == '_') {
                    string = string2.substring(0, 3);
                    object = RubyUtils.underlinedNameToCamel(string2.substring(4));
                } else {
                    string = string2.substring(0, 14);
                    object = RubyUtils.underlinedNameToCamel(string2.substring(15));
                }
                String string3 = (String)object + "#up";
                Node entry = AstUtilities.findBySignature(node, string3);
                if (entry == null) {
                    return;
                }
                object2 = entry;
            }
            object = new HashMap<String, List<String>>();
            this.scanMigration(object2, (Map<String, List<String>>)object, null);
            if (object.size() > 0) {
                for (Map.Entry entry : object.entrySet()) {
                    IndexDocument indexDocument = this.support.createDocument(this.indexable);
                    this.documents.add(indexDocument);
                    String string3 = (String)entry.getKey();
                    indexDocument.addPair(RubyIndexer.FIELD_DB_TABLE, string3, true, true);
                    indexDocument.addPair(RubyIndexer.FIELD_DB_VERSION, string, false, true);
                    List list = (List)entry.getValue();
                    for (String string4 : list) {
                        indexDocument.addPair(RubyIndexer.FIELD_DB_COLUMN, string4, false, true);
                    }
                }
            }
        }

        private void scanMigration(Node node, Map<String, List<String>> map, String string) {
            List<String> list;
            Node node2;
            Object object;
            if (node.getNodeType() == NodeType.FCALLNODE) {
                object = AstUtilities.getCallName(node);
                if ("create_table".equals(object)) {
                    Node node3;
                    List list2 = node.childNodes();
                    if (list2.size() > 0 && (node2 = (Node)list2.get(0)).getNodeType() == NodeType.ARRAYNODE && (list = node2.childNodes()).size() > 0 && ((node3 = (Node)list.get(0)).getNodeType() == NodeType.SYMBOLNODE || node3.getNodeType() == NodeType.STRNODE)) {
                        Node node4;
                        String string2 = this.getString(node3);
                        map.put(string2, new ArrayList());
                        if (list2.size() > 1 && (node4 = (Node)list2.get(1)).getNodeType() == NodeType.ITERNODE) {
                            this.scanMigration(node4, map, string2);
                        }
                        return;
                    }
                } else {
                    if ("add_column".equals(object) || "remove_column".equals(object)) {
                        ArrayList<Node> arrayList = new ArrayList<Node>();
                        AstUtilities.addNodesByType(node, new NodeType[]{NodeType.SYMBOLNODE, NodeType.STRNODE}, arrayList);
                        if (arrayList.size() >= 2) {
                            List<String> list3;
                            String string3 = this.getString((Node)arrayList.get(0));
                            String string4 = this.getString((Node)arrayList.get(1));
                            String string5 = null;
                            boolean bl = "add_column".equals(object);
                            if (bl && arrayList.size() >= 3) {
                                string5 = this.getString((Node)arrayList.get(2));
                            }
                            if ((list3 = map.get(string3)) == null) {
                                list3 = new ArrayList<String>();
                                map.put(string3, list3);
                            }
                            StringBuilder stringBuilder = new StringBuilder();
                            stringBuilder.append(string4);
                            stringBuilder.append(';');
                            if (bl) {
                                if (string5 != null) {
                                    stringBuilder.append(string5);
                                }
                            } else {
                                stringBuilder.append("-");
                            }
                            list3.add(stringBuilder.toString());
                        }
                        return;
                    }
                    if ("rename_column".equals(object)) {
                        ArrayList<Node> arrayList = new ArrayList<Node>();
                        AstUtilities.addNodesByType(node, new NodeType[]{NodeType.SYMBOLNODE, NodeType.STRNODE}, arrayList);
                        if (arrayList.size() >= 3) {
                            String string6 = this.getString((Node)arrayList.get(0));
                            String string7 = this.getString((Node)arrayList.get(1));
                            String string8 = this.getString((Node)arrayList.get(2));
                            List<String> list4 = map.get(string6);
                            if (list4 == null) {
                                list4 = new ArrayList<String>();
                                map.put(string6, list4);
                            }
                            list4.add(string7 + ";-");
                            list4.add(string8);
                        }
                        return;
                    }
                }
            } else if (node.getNodeType() == NodeType.CALLNODE && string != null) {
                object = AstUtilities.getCallName(node);
                if ("column".equals(object)) {
                    List list5 = node.childNodes();
                    if (list5.size() >= 2) {
                        Node node5 = (Node)list5.get(0);
                        if (node5.getNodeType() != NodeType.DVARNODE) {
                            return;
                        }
                        node5 = (Node)list5.get(1);
                        ArrayList<Node> arrayList = new ArrayList<Node>();
                        AstUtilities.addNodesByType(node5, new NodeType[]{NodeType.SYMBOLNODE, NodeType.STRNODE}, arrayList);
                        if (arrayList.size() >= 2) {
                            String string9 = this.getString((Node)arrayList.get(0));
                            String string10 = this.getString((Node)arrayList.get(1));
                            List<String> list6 = map.get(string);
                            if (list6 == null) {
                                list6 = new ArrayList<String>();
                                map.put(string, list6);
                            }
                            StringBuilder stringBuilder = new StringBuilder();
                            stringBuilder.append(string9);
                            stringBuilder.append(';');
                            stringBuilder.append(string10);
                            list6.add(stringBuilder.toString());
                        }
                    }
                    return;
                }
                if ("timestamps".equals(object)) {
                    List list7 = node.childNodes();
                    if (list7.size() >= 1) {
                        node2 = (Node)list7.get(0);
                        if (node2.getNodeType() != NodeType.DVARNODE) {
                            return;
                        }
                        list = map.get(string);
                        if (list == null) {
                            list = new ArrayList<String>();
                            map.put(string, list);
                        }
                        list.add("created_at;datetime");
                        list.add("updated_at;datetime");
                    }
                } else {
                    int n = Arrays.binarySearch(FIXED_COLUMN_TYPES, object);
                    if (n >= 0 && n < FIXED_COLUMN_TYPES.length) {
                        String string11 = FIXED_COLUMN_TYPES[n];
                        List list8 = node.childNodes();
                        if (list8.size() >= 2) {
                            Node node6 = (Node)list8.get(0);
                            if (node6.getNodeType() != NodeType.DVARNODE) {
                                return;
                            }
                            node6 = (Node)list8.get(1);
                            List list9 = node6.childNodes();
                            for (Node node7 : list9) {
                                if (node7.getNodeType() != NodeType.SYMBOLNODE && node7.getNodeType() != NodeType.STRNODE) continue;
                                String string12 = this.getString(node7);
                                List<String> list10 = map.get(string);
                                if (list10 == null) {
                                    list10 = new ArrayList<String>();
                                    map.put(string, list10);
                                }
                                StringBuilder stringBuilder = new StringBuilder();
                                stringBuilder.append(string12);
                                stringBuilder.append(';');
                                stringBuilder.append(string11);
                                list10.add(stringBuilder.toString());
                            }
                        }
                        return;
                    }
                }
            }
            object = node.childNodes();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                node2 = (Node)iterator.next();
                if (node2.isInvisible()) continue;
                this.scanMigration(node2, map, string);
            }
        }

        private String getString(Node node) {
            if (node.getNodeType() == NodeType.STRNODE) {
                return ((StrNode)node).getValue().toString();
            }
            return ((INameNode)node).getName();
        }

        private void handleActionViewHelpers() {
            if (this.file == null || this.file.getParent() == null) {
                return;
            }
            assert (this.file.getName().equals("action_view"));
            FileObject fileObject = this.file.getParent().getFileObject("action_view/helpers");
            if (fileObject == null) {
                return;
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (FileObject fileObject2 : fileObject.getChildren()) {
                String string = fileObject2.getName();
                if (!string.endsWith("_helper")) continue;
                String string2 = RubyUtils.underlinedNameToCamel(string);
                String string3 = "ActionView::Helpers::" + string2;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(string3);
            }
            if (stringBuilder.length() > 0) {
                int n = 0;
                this.addClassIncludes("Base", "ActionView::Base", "ActionView", n, stringBuilder.toString());
            }
        }

        private boolean scan(Node node, Set<String> set, Set<String> set2) {
            Node node2;
            Node node3;
            Object object;
            boolean bl = false;
            if (node instanceof FCallNode) {
                Node node4;
                object = ((INameNode)node).getName();
                if (((String)object).equals(RubyIndexer.FIELD_REQUIRE)) {
                    String string;
                    node3 = ((FCallNode)node).getArgsNode();
                    if (node3 instanceof ListNode && (node2 = (ListNode)node3).size() > 0 && (node4 = node2.get(0)) instanceof StrNode && (string = ((StrNode)node4).getValue()) != null && string.length() > 0) {
                        set2.add(string.toString());
                    }
                } else if (set != null && ((String)object).equals("include") && (node3 = ((FCallNode)node).getArgsNode()) instanceof ListNode && (node2 = (ListNode)node3).size() > 0) {
                    node4 = node2.get(0);
                    if (node4 instanceof Colon2Node) {
                        set.add(AstUtilities.getFqn((Colon2Node)node4));
                    } else if (node4 instanceof INameNode) {
                        set.add(((INameNode)node4).getName());
                    }
                }
            } else if (node instanceof CallNode && (object = (CallNode)node).getName().equals("class_eval")) {
                bl = true;
            }
            object = node.childNodes();
            node3 = object.iterator();
            while (node3.hasNext()) {
                node2 = (Node)node3.next();
                if (node2.isInvisible() || !this.scan(node2, set, set2)) continue;
                bl = true;
            }
            return bl;
        }

        private void analyze(List<? extends AstElement> list) {
            ArrayList<AstElement> arrayList = null;
            IndexDocument indexDocument = null;
            Iterator<? extends AstElement> iterator = list.iterator();
            while (iterator.hasNext()) {
                AstElement astElement;
                AstElement astElement2 = astElement = iterator.next();
                switch (astElement2.getKind()) {
                    case MODULE: 
                    case CLASS: {
                        IndexDocument indexDocument2 = this.analyzeClassOrModule(astElement2);
                        if (indexDocument != null) break;
                        indexDocument = indexDocument2;
                        break;
                    }
                    case METHOD: {
                        if (!this.shouldIndexTopLevel()) break;
                        if (arrayList == null) {
                            arrayList = new ArrayList<AstElement>();
                        }
                        arrayList.add(astElement2);
                        break;
                    }
                    case GLOBAL: {
                        if (indexDocument == null) {
                            indexDocument = this.support.createDocument(this.indexable);
                            this.documents.add(indexDocument);
                        }
                        this.indexGlobal(astElement2, indexDocument);
                        break;
                    }
                }
            }
            if (arrayList != null) {
                this.analyzeTopLevelMethods(arrayList);
            }
        }

        private boolean shouldIndexTopLevel() {
            String string;
            return !(this.platform && !preindexingTest || (string = this.file.getNameExt()).endsWith("_spec.rb") || string.endsWith("_test.rb") || this.url != null && this.url.indexOf("/vendor/") != -1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        private IndexDocument analyzeClassOrModule(AstElement var1_1) {
            var2_2 = this.docMode;
            var3_3 = null;
            try {
                block45: {
                    block44: {
                        var4_4 = 0;
                        var5_5 = false;
                        if (this.platform) {
                            var6_6 = RubyIndexerHelper.isNodocClass(var1_1, this.result.getSnapshot());
                            if (var6_6 == 2) {
                                this.docMode = 0;
                            } else if (var6_6 == 3) {
                                var4_4 |= 32;
                                var5_5 = true;
                                this.docMode = 3;
                            } else if (var6_6 == 1 || this.docMode == 3) {
                                var4_4 |= 32;
                                var5_5 = true;
                            }
                        }
                        var3_3 = this.support.createDocument(this.indexable);
                        var7_8 = var1_1.getNode();
                        if (var1_1.getKind() != ElementKind.CLASS) break block44;
                        var8_9 = (ClassElement)var1_1;
                        var6_7 = var8_9.getFqn();
                        if (!(var7_8 instanceof SClassNode)) ** GOTO lbl34
                        var9_10 = ((SClassNode)var7_8).getReceiverNode();
                        if (var9_10 instanceof Colon2Node) {
                            var6_7 = AstUtilities.getFqn((Colon2Node)var9_10);
                        } else if (var9_10 instanceof INameNode) {
                            var6_7 = ((INameNode)var9_10).getName();
                        } else {
                            var10_11 = var3_3;
                            return var10_11;
lbl34:
                            // 1 sources

                            var9_10 = (ClassNode)var7_8;
                            var10_12 = var9_10.getSuperNode();
                            var11_14 = null;
                            if (var10_12 != null) {
                                var11_14 = AstUtilities.getSuperclass((ClassNode)var9_10);
                            }
                            if (var11_14 != null) {
                                var3_3.addPair("extends", var11_14, true, true);
                            }
                        }
                        var9_10 = this.getIncludedString(var8_9.getIncludes());
                        if (var9_10 != null) {
                            var3_3.addPair("includes", var9_10, false, true);
                        }
                        break block45;
                    }
                    if (!TreeAnalyzer.$assertionsDisabled && var1_1.getKind() != ElementKind.MODULE) {
                        throw new AssertionError();
                    }
                    var8_9 = (ModuleElement)var1_1;
                    var6_7 = var8_9.getFqn();
                    var9_10 = var8_9.getExtendWith();
                    if (var9_10 != null) {
                        var3_3.addPair("extendWith", var9_10, false, true);
                    }
                    var4_4 |= 64;
                }
                var8_9 = var1_1.getName();
                var10_13 = var6_7.lastIndexOf("::");
                var9_10 = var10_13 != -1 ? var6_7.substring(0, var10_13) : null;
                var11_15 = this.isDocumented(var7_8);
                var12_16 = this.getDocumentSize(var7_8);
                if (var12_16 > 0) {
                    var4_4 |= 1;
                }
                var13_17 = new StringBuilder();
                var13_17.append(IndexedElement.flagToFirstChar(var4_4));
                var13_17.append(IndexedElement.flagToSecondChar(var4_4));
                if (var12_16 > 0) {
                    var13_17.append(";");
                    var13_17.append(Integer.toString(var12_16));
                }
                var3_3.addPair("attrs", var13_17.toString(), false, true);
                if (var1_1.getKind() == ElementKind.CLASS) {
                    // empty if block
                }
                var3_3.addPair("fqn", var6_7, true, true);
                var3_3.addPair("class-ig", var8_9.toLowerCase(), true, true);
                var3_3.addPair("class", (String)var8_9, true, true);
                if (var9_10 != null) {
                    var3_3.addPair("in", var9_10, false, true);
                }
                this.addRequire(var3_3);
                if (this.requires != null) {
                    var3_3.addPair("requires", this.requires, false, true);
                }
                block20: for (AstElement var15_19 : var1_1.getChildren()) {
                    switch (1.$SwitchMap$org$netbeans$modules$csl$api$ElementKind[var15_19.getKind().ordinal()]) {
                        case 1: 
                        case 2: {
                            if (var15_19.getNode() instanceof SClassNode && ((SClassNode)var15_19.getNode()).getReceiverNode() instanceof SelfNode) {
                                for (AstElement var17_21 : var15_19.getChildren()) {
                                    switch (1.$SwitchMap$org$netbeans$modules$csl$api$ElementKind[var17_21.getKind().ordinal()]) {
                                        case 3: 
                                        case 5: {
                                            this.indexMethod(var17_21, var3_3, false, var5_5);
                                            break;
                                        }
                                        case 1: 
                                        case 2: {
                                            this.analyzeClassOrModule(var17_21);
                                            break;
                                        }
                                        case 6: {
                                            this.indexField(var17_21, var3_3, var5_5);
                                            break;
                                        }
                                        case 4: {
                                            this.indexGlobal(var17_21, var3_3);
                                            break;
                                        }
                                        case 7: {
                                            this.indexAttribute(var17_21, var3_3, var5_5);
                                            break;
                                        }
                                        case 8: {
                                            this.indexConstant(var17_21, var3_3, var5_5);
                                        }
                                    }
                                }
                                continue block20;
                            }
                            this.analyzeClassOrModule(var15_19);
                            break;
                        }
                        case 3: 
                        case 5: {
                            this.indexMethod(var15_19, var3_3, false, var5_5);
                            break;
                        }
                        case 6: {
                            this.indexField(var15_19, var3_3, var5_5);
                            break;
                        }
                        case 4: {
                            this.indexGlobal(var15_19, var3_3);
                            break;
                        }
                        case 7: {
                            this.indexAttribute(var15_19, var3_3, var5_5);
                            break;
                        }
                        case 8: {
                            this.indexConstant(var15_19, var3_3, var5_5);
                        }
                    }
                }
                this.documents.add(var3_3);
            }
            finally {
                this.docMode = var2_2;
            }
            return var3_3;
        }

        private void analyzeTopLevelMethods(List<? extends AstElement> list) {
            IndexDocument indexDocument = this.support.createDocument(this.indexable);
            this.documents.add(indexDocument);
            String string = "Object";
            Object var4_4 = null;
            String string2 = "Object";
            int n = 0;
            indexDocument.addPair(RubyIndexer.FIELD_CLASS_ATTRS, IndexedElement.flagToString(n), false, true);
            indexDocument.addPair(RubyIndexer.FIELD_FQN_NAME, string2, true, true);
            indexDocument.addPair(RubyIndexer.FIELD_CASE_INSENSITIVE_CLASS_NAME, string.toLowerCase(), true, true);
            indexDocument.addPair(RubyIndexer.FIELD_CLASS_NAME, string, true, true);
            this.addRequire(indexDocument);
            if (this.requires != null) {
                indexDocument.addPair(RubyIndexer.FIELD_REQUIRES, this.requires, false, true);
            }
            for (AstElement astElement : list) {
                assert (astElement.getKind() == ElementKind.CONSTRUCTOR || astElement.getKind() == ElementKind.METHOD);
                this.indexMethod(astElement, indexDocument, true, false);
            }
        }

        private void indexMethod(AstElement astElement, IndexDocument indexDocument, boolean bl, boolean bl2) {
            StringBuilder stringBuilder;
            boolean bl3;
            MethodDefNode methodDefNode = (MethodDefNode)astElement.getNode();
            String string = AstUtilities.getDefSignature(methodDefNode);
            Set<Modifier> set = astElement.getModifiers();
            int n = RubyIndexer.getModifiersFlag(set);
            if (bl2) {
                n |= 0x20;
            }
            if (bl) {
                n |= 8;
            }
            if (bl3 = this.isDocumented((Node)methodDefNode)) {
                n |= 1;
            }
            if (n != 0) {
                stringBuilder = new StringBuilder(string);
                stringBuilder.append(';');
                stringBuilder.append(IndexedElement.flagToFirstChar(n));
                stringBuilder.append(IndexedElement.flagToSecondChar(n));
                string = stringBuilder.toString();
            }
            if (this.platform && !skipTypeInferenceForTests && (string = RubyIndexerHelper.getMethodSignature(astElement, (Node)(stringBuilder = AstUtilities.getRoot((Parser.Result)this.result)), n, string, this.file, this.result.getSnapshot())) == null) {
                return;
            }
            if (astElement.getType().isKnown()) {
                string = string + ";;" + astElement.getType().asIndexedString() + ";";
            }
            indexDocument.addPair(RubyIndexer.FIELD_METHOD_NAME, string, true, true);
            if (astElement.getName().equals("initialize")) {
                string = string.replaceFirst("initialize", "new");
                if ((n & 0x10) == 0) {
                    char c = IndexedElement.flagToFirstChar(n |= 0x10);
                    char c2 = IndexedElement.flagToSecondChar(n);
                    int n2 = string.indexOf(59);
                    string = n2 == -1 ? string + ";" + c + c2 : string.substring(0, n2 + 1) + c + c2 + string.substring(n2 + 3);
                }
                indexDocument.addPair(RubyIndexer.FIELD_METHOD_NAME, string, true, true);
            }
        }

        private void indexAttribute(AstElement astElement, IndexDocument indexDocument, boolean bl) {
            int n;
            String string = astElement.getName();
            boolean bl2 = this.isDocumented(astElement.getNode());
            int n2 = n = bl2 ? 1 : 0;
            if (bl) {
                n |= 0x20;
            }
            char c = IndexedElement.flagToFirstChar(n);
            char c2 = IndexedElement.flagToSecondChar(n);
            if (bl2) {
                string = string + ";" + c + c2;
            }
            indexDocument.addPair(RubyIndexer.FIELD_ATTRIBUTE_NAME, string, true, true);
        }

        private void indexConstant(AstElement astElement, IndexDocument indexDocument, boolean bl) {
            RubyType rubyType = astElement.getType();
            StringBuilder stringBuilder = new StringBuilder(astElement.getName() + ';');
            if (rubyType.isKnown()) {
                stringBuilder.append(rubyType.asIndexedString());
            }
            indexDocument.addPair(RubyIndexer.FIELD_CONSTANT_NAME, stringBuilder.toString(), true, true);
        }

        private void indexField(AstElement astElement, IndexDocument indexDocument, boolean bl) {
            String string = astElement.getName();
            int n = RubyIndexer.getModifiersFlag(astElement.getModifiers());
            if (bl) {
                n |= 0x20;
            }
            if (n != 0) {
                StringBuilder stringBuilder = new StringBuilder(string);
                stringBuilder.append(';');
                stringBuilder.append(IndexedElement.flagToFirstChar(n));
                stringBuilder.append(IndexedElement.flagToSecondChar(n));
                string = stringBuilder.toString();
            }
            indexDocument.addPair(RubyIndexer.FIELD_FIELD_NAME, string, true, true);
        }

        private void indexGlobal(AstElement astElement, IndexDocument indexDocument) {
            if (!this.platform || preindexingTest) {
                String string = astElement.getName();
                indexDocument.addPair(RubyIndexer.FIELD_GLOBAL_NAME, string, true, true);
            }
        }

        private int getDocumentSize(Node node) {
            List<String> list = AstUtilities.gatherDocumentation(this.result.getSnapshot(), node);
            if (list != null && list.size() > 0) {
                int n = 0;
                for (String string : list) {
                    n += string.length();
                }
                return n;
            }
            return 0;
        }

        private boolean isDocumented(Node node) {
            List<String> list = AstUtilities.gatherDocumentation(this.result.getSnapshot(), node);
            return list != null && list.size() > 0;
        }

        private void addRequire(IndexDocument indexDocument) {
            String string;
            String string2 = string = this.file.getParent() != null && this.file.getParent().getParent() != null ? this.file.getParent().getParent().getNameExt() : "";
            if (string.equals("rubystubs") && this.file.getName().startsWith("stub_")) {
                return;
            }
            String string3 = this.indexable.getRelativePath();
            if (string3 != null && string3.endsWith(".rb")) {
                string3 = string3.substring(0, string3.length() - 3);
                indexDocument.addPair(RubyIndexer.FIELD_REQUIRE, string3, true, true);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Factory
    extends EmbeddingIndexerFactory {
        public static final String NAME = "ruby";
        public static final int VERSION = 9;

        public EmbeddingIndexer createIndexer(Indexable indexable, Snapshot snapshot) {
            if (this.isIndexable(indexable, snapshot)) {
                return new RubyIndexer();
            }
            return null;
        }

        public int getIndexVersion() {
            return 9;
        }

        public String getIndexerName() {
            return NAME;
        }

        private boolean isIndexable(Indexable indexable, Snapshot snapshot) {
            String string = snapshot.getSource().getFileObject().getExt();
            return string.equals("rb");
        }

        public void filesDeleted(Collection<? extends Indexable> collection, Context context) {
            try {
                IndexingSupport indexingSupport = IndexingSupport.getInstance((Context)context);
                for (Indexable indexable : collection) {
                    indexingSupport.removeDocuments(indexable);
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }

        public void filesDirty(Collection<? extends Indexable> collection, Context context) {
            try {
                IndexingSupport indexingSupport = IndexingSupport.getInstance((Context)context);
                for (Indexable indexable : collection) {
                    indexingSupport.markDirtyDocuments(indexable);
                }
            }
            catch (IOException iOException) {
                LOG.log(Level.WARNING, null, iOException);
            }
        }
    }
}

