/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.api.ruby.platform.RubyPlatformManager;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.indexing.support.IndexResult;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.modules.ruby.DatabasePropertiesIndexer;
import org.netbeans.modules.ruby.RubyType;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.elements.IndexedClass;
import org.netbeans.modules.ruby.elements.IndexedConstant;
import org.netbeans.modules.ruby.elements.IndexedElement;
import org.netbeans.modules.ruby.elements.IndexedField;
import org.netbeans.modules.ruby.elements.IndexedMethod;
import org.netbeans.modules.ruby.elements.IndexedVariable;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RubyIndex {
    private static final Logger LOGGGER = Logger.getLogger(RubyIndex.class.getName());
    public static final String UNKNOWN_CLASS = "<Unknown>";
    public static final String OBJECT = "Object";
    private static final String CLASS = "Class";
    private static final String MODULE = "Module";
    private static final String CLUSTER_URL = "cluster:";
    private static final String RUBYHOME_URL = "ruby:";
    private static final String GEM_URL = "gem:";
    private static String clusterUrl = null;
    private static final RubyIndex EMPTY = new RubyIndex(null);
    private FileObject context;
    private final QuerySupport querySupport;
    private static final SortedSet<InvocationCounter> mostTimeConsumingInvocations = new TreeSet<InvocationCounter>();
    static final String ACTIVE_RECORD_BASE = "ActiveRecord::Base";

    private RubyIndex(QuerySupport querySupport) {
        this.querySupport = querySupport;
    }

    public static RubyIndex get(Collection<FileObject> collection) {
        try {
            return new RubyIndex(QuerySupport.forRoots((String)"ruby", (int)9, (FileObject[])collection.toArray(new FileObject[collection.size()])));
        }
        catch (IOException iOException) {
            LOGGGER.log(Level.WARNING, null, iOException);
            return EMPTY;
        }
    }

    public static RubyIndex get(Parser.Result result) {
        return RubyIndex.get(RubyUtils.getFileObject(result));
    }

    public static RubyIndex get(FileObject fileObject) {
        return fileObject == null ? null : RubyIndex.get(QuerySupport.findRoots((FileObject)fileObject, Collections.singleton("ruby/classpath/source"), Collections.singleton("ruby/classpath/boot"), Collections.emptySet()));
    }

    public Collection<? extends IndexResult> query(String string, String string2, QuerySupport.Kind kind, String ... stringArray) {
        if (this.querySupport != null) {
            try {
                return this.querySupport.query(string, string2, kind, stringArray);
            }
            catch (IOException iOException) {
                LOGGGER.log(Level.WARNING, null, iOException);
            }
        }
        return Collections.emptySet();
    }

    private boolean search(String string, String string2, QuerySupport.Kind kind, Set<IndexResult> set) {
        try {
            set.addAll(this.querySupport.query(string, string2, kind, (String[])null));
            return true;
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            return false;
        }
    }

    FileObject getContext() {
        return this.context;
    }

    Set<IndexedClass> getClasses(String string, QuerySupport.Kind kind, boolean bl, boolean bl2, boolean bl3) {
        return this.getClasses(string, kind, bl, bl2, bl3, null);
    }

    public Set<IndexedClass> getClasses(String string, QuerySupport.Kind kind, boolean bl, boolean bl2, boolean bl3, Set<String> set) {
        String string2;
        String string3 = null;
        if (string != null) {
            if (string.indexOf("::") != -1) {
                int n = string.lastIndexOf("::");
                string3 = string.substring(0, n);
                string = string.substring(n + 2);
            } else if (string.endsWith(":")) {
                string3 = string.substring(0, string.length() - 1);
                string = "";
            }
        }
        HashSet<IndexResult> hashSet = new HashSet<IndexResult>();
        switch (kind) {
            case EXACT: 
            case PREFIX: 
            case CAMEL_CASE: 
            case REGEXP: {
                string2 = "class";
                break;
            }
            case CASE_INSENSITIVE_PREFIX: 
            case CASE_INSENSITIVE_REGEXP: {
                string2 = "class-ig";
                break;
            }
            default: {
                throw new UnsupportedOperationException(kind.toString());
            }
        }
        this.search(string2, string, kind, hashSet);
        if (bl) {
            set = null;
        } else if (set == null) {
            set = new HashSet<String>();
        }
        HashSet<IndexedClass> hashSet2 = new HashSet<IndexedClass>();
        for (IndexResult indexResult : hashSet) {
            int n;
            int n2;
            String string4;
            String string5 = indexResult.getValue("class");
            if (string5 == null || kind == QuerySupport.Kind.PREFIX && !string5.startsWith(string) || kind == QuerySupport.Kind.CASE_INSENSITIVE_PREFIX && !string5.regionMatches(true, 0, string, 0, string.length())) continue;
            if (string3 != null) {
                if (kind == QuerySupport.Kind.CASE_INSENSITIVE_PREFIX || kind == QuerySupport.Kind.CASE_INSENSITIVE_REGEXP) {
                    if (!string3.equalsIgnoreCase(indexResult.getValue("in"))) {
                        continue;
                    }
                } else if (kind == QuerySupport.Kind.CAMEL_CASE) {
                    string4 = indexResult.getValue("in");
                    if (string4 == null) continue;
                    StringBuilder stringBuilder = new StringBuilder();
                    n2 = 0;
                    do {
                        int n3 = -1;
                        for (int i = n2 + 1; i < string3.length(); ++i) {
                            if (!Character.isUpperCase(string3.charAt(i))) continue;
                            n3 = i;
                            break;
                        }
                        String string6 = string3.substring(n2, (n = n3) == -1 ? string3.length() : n);
                        stringBuilder.append(string6);
                        stringBuilder.append(n != -1 ? "[\\p{javaLowerCase}\\p{Digit}_\\$]*" : ".*");
                        n2 = n;
                    } while (n != -1);
                    Pattern pattern = Pattern.compile(stringBuilder.toString());
                    if (!pattern.matcher(string4).matches()) {
                        continue;
                    }
                } else if (!string3.equals(indexResult.getValue("in"))) continue;
            }
            string4 = indexResult.getValue("attrs");
            boolean bl4 = true;
            if (string4 != null) {
                n2 = IndexedElement.stringToFlag(string4, 0);
                boolean bl5 = bl4 = (n2 & 0x40) == 0;
            }
            if (bl2 && bl4 || bl3 && !bl4) continue;
            String string7 = indexResult.getValue("fqn");
            if (!bl) {
                if (set.contains(string7)) {
                    boolean bl6;
                    n = 0;
                    int n4 = 0;
                    if (string4 != null) {
                        n4 = IndexedElement.stringToFlag(string4, 0);
                    }
                    boolean bl7 = bl6 = n4 & true;
                    if (bl6) {
                        int n5 = 0;
                        int n6 = string4.indexOf(59);
                        if (n6 != -1) {
                            int n7 = string4.indexOf(59, n6 + 1);
                            if (n7 == -1) {
                                n7 = string4.length();
                            }
                            n5 = Integer.parseInt(string4.substring(n6 + 1, n7));
                        }
                        for (IndexedClass indexedClass : hashSet2) {
                            if (!indexedClass.getSignature().equals(string7) || n5 <= indexedClass.getDocumentationLength()) continue;
                            hashSet2.remove(indexedClass);
                            n = 1;
                            break;
                        }
                    }
                    if (n == 0) {
                        continue;
                    }
                } else {
                    set.add(string7);
                }
            }
            hashSet2.add(this.createClass(string7, string5, indexResult));
        }
        return hashSet2;
    }

    public Set<IndexedClass> getSubClasses(String string, String string2, QuerySupport.Kind kind) {
        Collection<? extends IndexResult> collection = this.query("extends", string2, QuerySupport.Kind.EXACT, "extends");
        HashSet<IndexedClass> hashSet = new HashSet<IndexedClass>();
        for (IndexResult indexResult : collection) {
            String string3 = indexResult.getValue("class");
            if (string3 == null || kind == QuerySupport.Kind.PREFIX && !string3.startsWith(string) || kind == QuerySupport.Kind.CASE_INSENSITIVE_PREFIX && !string3.regionMatches(true, 0, string, 0, string.length())) continue;
            String string4 = indexResult.getValue("fqn");
            hashSet.add(this.createClass(string4, string3, indexResult));
        }
        return hashSet;
    }

    Set<? extends IndexedMethod> getMethods(String string, RubyType rubyType, QuerySupport.Kind kind) {
        HashSet<IndexedMethod> hashSet = new HashSet<IndexedMethod>();
        for (String string2 : rubyType.getRealTypes()) {
            hashSet.addAll(this.getMethods(string, string2, kind));
        }
        return hashSet;
    }

    Set<IndexedMethod> getMethods(String string, QuerySupport.Kind kind) {
        return this.getMethods(string, (String)null, kind);
    }

    public Set<IndexedMethod> getMethods(String string, String string2, QuerySupport.Kind kind) {
        boolean bl = string2 == null;
        HashSet<IndexResult> hashSet = new HashSet<IndexResult>();
        String string3 = "method";
        QuerySupport.Kind kind2 = kind;
        if (kind == QuerySupport.Kind.EXACT) {
            kind = QuerySupport.Kind.PREFIX;
        }
        this.search(string3, string, kind, hashSet);
        HashSet<IndexedMethod> hashSet2 = new HashSet<IndexedMethod>();
        for (IndexResult indexResult : hashSet) {
            int n;
            String[] stringArray;
            String[] stringArray2;
            if (string2 != null && !string2.equals(stringArray2 = indexResult.getValue("fqn"))) continue;
            stringArray2 = indexResult.getValues("method");
            if (stringArray2 != null) {
                stringArray = stringArray2;
                int n2 = stringArray.length;
                for (n = 0; n < n2; ++n) {
                    String string4;
                    block12: {
                        string4 = stringArray[n];
                        if ((string == null || string.length() == 0) && !Character.isLowerCase(string4.charAt(0)) || kind == QuerySupport.Kind.PREFIX && !string4.startsWith(string) || kind == QuerySupport.Kind.CASE_INSENSITIVE_PREFIX && !string4.regionMatches(true, 0, string, 0, string.length())) continue;
                        if (kind == QuerySupport.Kind.CASE_INSENSITIVE_REGEXP) {
                            int n3 = string4.length();
                            int n4 = string4.indexOf(40);
                            if (n4 == -1 && (n4 = string4.indexOf(59)) == -1) {
                                n4 = n3;
                            }
                            String string5 = n4 != n3 ? string4.substring(0, n4) : string4;
                            try {
                                if (!string5.matches(string)) {
                                    continue;
                                }
                                break block12;
                            }
                            catch (Exception exception) {
                                break block12;
                            }
                        }
                        if (kind2 == QuerySupport.Kind.EXACT && string4.length() > string.length() && string4.charAt(string.length()) != '(' && string4.charAt(string.length()) != ';') continue;
                    }
                    assert (indexResult != null);
                    hashSet2.add(this.createMethod(string4, indexResult, bl));
                }
            }
            if ((stringArray = indexResult.getValues("attribute")) == null) continue;
            String[] stringArray3 = stringArray;
            n = stringArray3.length;
            for (int i = 0; i < n; ++i) {
                String string6 = stringArray3[i];
                if ((string == null || string.length() == 0) && !Character.isLowerCase(string6.charAt(0)) || kind == QuerySupport.Kind.PREFIX && !string6.startsWith(string) || kind == QuerySupport.Kind.CASE_INSENSITIVE_PREFIX && !string6.regionMatches(true, 0, string, 0, string.length()) || kind == QuerySupport.Kind.CASE_INSENSITIVE_REGEXP && !string6.matches(string) || kind2 == QuerySupport.Kind.EXACT && string6.length() > string.length() && string6.charAt(string.length()) != ';') continue;
                assert (indexResult != null);
                hashSet2.add(this.createMethod(string6, indexResult, bl));
            }
        }
        return hashSet2;
    }

    public IndexedMethod createMethod(String string, IndexResult indexResult, boolean bl) {
        String string2 = indexResult.getValue("class");
        String string3 = indexResult.getValue("in");
        if (string2 == null) {
            string2 = string3;
        } else if (string3 != null && string3.length() > 0) {
            string2 = string3 + "::" + string2;
        }
        String string4 = indexResult.getValue("fqn");
        String string5 = indexResult.getValue("require");
        int n = string.indexOf(59);
        String string6 = null;
        int n2 = 0;
        if (n != -1) {
            n2 = IndexedElement.stringToFlag(string, n + 1);
            if (string.length() > n + 1) {
                string6 = string.substring(n + 1, string.length());
            }
            string = string.substring(0, n);
        }
        IndexedMethod indexedMethod = IndexedMethod.create(this, string, string4, string2, indexResult.getFile(), string5, string6, n2, this.context);
        indexedMethod.setInherited(bl);
        return indexedMethod;
    }

    public IndexedField createField(String string, IndexResult indexResult, boolean bl, boolean bl2) {
        String string2 = indexResult.getValue("class");
        String string3 = indexResult.getValue("in");
        if (string2 == null) {
            string2 = string3;
        } else if (string3 != null && string3.length() > 0) {
            string2 = string3 + "::" + string2;
        }
        String string4 = indexResult.getValue("fqn");
        String string5 = indexResult.getValue("require");
        int n = string.indexOf(59);
        String string6 = null;
        int n2 = 0;
        if (n != -1) {
            n2 = IndexedElement.stringToFlag(string, n + 1);
            if (string.length() > n + 1) {
                string6 = string.substring(n + 1, string.length());
            }
            string = string.substring(0, n);
        }
        IndexedField indexedField = IndexedField.create(this, string, string4, string2, indexResult, string5, string6, n2, this.context);
        indexedField.setInherited(bl2);
        return indexedField;
    }

    private static boolean isEmptyOrNull(String string) {
        return string == null || "".equals(string.trim());
    }

    public IndexedConstant createConstant(String string, IndexResult indexResult) {
        String string2 = indexResult.getValue("fqn");
        String string3 = indexResult.getValue("require");
        int n = string.indexOf(59);
        String string4 = n == -1 ? string : string.substring(0, n);
        int n2 = 0;
        String string5 = n == -1 ? null : string.substring(n + 1);
        RubyType rubyType = RubyIndex.isEmptyOrNull(string5) ? RubyType.createUnknown() : RubyType.create(string5);
        IndexedConstant indexedConstant = IndexedConstant.create(this, string4, string2, indexResult, string3, n2, this.context, rubyType);
        return indexedConstant;
    }

    public IndexedClass createClass(String string, String string2, IndexResult indexResult) {
        String string3 = indexResult.getValue("require");
        if (string2 == null) {
            string2 = indexResult.getValue("class");
        }
        String string4 = indexResult.getValue("attrs");
        int n = 0;
        if (string4 != null) {
            n = IndexedElement.stringToFlag(string4, 0);
        }
        IndexedClass indexedClass = IndexedClass.create(this, string2, string, indexResult, string3, string4, n, this.context);
        return indexedClass;
    }

    public Set<String[]> getRequires(String string, QuerySupport.Kind kind) {
        HashSet<IndexResult> hashSet = new HashSet<IndexResult>();
        String string2 = "require";
        this.search(string2, string, kind, hashSet);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (IndexResult object : hashSet) {
            Object object2 = object.getValues(string2);
            if (object2 == null) continue;
            for (String string3 : object2) {
                if (kind == QuerySupport.Kind.PREFIX && !string3.startsWith(string) || kind == QuerySupport.Kind.CASE_INSENSITIVE_PREFIX && !string3.regionMatches(true, 0, string, 0, string.length())) continue;
                assert (object != null);
                String string4 = object.getValue("fqn");
                String string5 = (String)hashMap.get(string3);
                if (string4 == null || string5 != null && (string5 == null || string5.length() >= string4.length())) continue;
                hashMap.put(string3, string4);
            }
        }
        HashSet hashSet2 = new HashSet();
        for (Object object2 : hashMap.keySet()) {
            String string6 = (String)hashMap.get(object2);
            String[] stringArray = new String[]{object2, string6};
            hashSet2.add(stringArray);
        }
        return hashSet2;
    }

    public Set<String> getRequiresTransitively(Set<String> set) {
        return set;
    }

    public Set<String> getClassesIn(String string) {
        HashSet<IndexResult> hashSet = new HashSet<IndexResult>();
        String string2 = "require";
        this.search(string2, string, QuerySupport.Kind.EXACT, hashSet);
        HashSet<String> hashSet2 = new HashSet<String>();
        for (IndexResult indexResult : hashSet) {
            String string3 = indexResult.getValue("fqn");
            if (string3 == null) continue;
            hashSet2.add(string3);
        }
        return hashSet2;
    }

    public IndexedClass getSuperclass(String string) {
        HashSet<IndexResult> hashSet = new HashSet<IndexResult>();
        QuerySupport.Kind kind = QuerySupport.Kind.EXACT;
        String string2 = "fqn";
        this.search(string2, string, kind, hashSet);
        for (IndexResult indexResult : hashSet) {
            assert (string.equals(indexResult.getValue("fqn")));
            String string3 = indexResult.getValue("extends");
            if (string3 == null) continue;
            hashSet.clear();
            if (!this.search(string2, string3, kind, hashSet)) {
                return null;
            }
            if (hashSet.size() > 0) {
                IndexResult indexResult2 = (IndexResult)hashSet.iterator().next();
                String string4 = indexResult2.getValue("fqn");
                return this.createClass(string4, string3, indexResult2);
            }
            return null;
        }
        return null;
    }

    private boolean addSubclasses(String string, Set<IndexedClass> set, Set<String> set2, Set<String> set3, boolean bl) {
        boolean bl2;
        if (set3.contains(string)) {
            return false;
        }
        set3.add(string);
        String string2 = "extends";
        HashSet<IndexResult> hashSet = new HashSet<IndexResult>();
        this.search(string2, string, QuerySupport.Kind.EXACT, hashSet);
        boolean bl3 = bl2 = hashSet.size() > 0;
        if (!bl2) {
            return bl2;
        }
        for (IndexResult indexResult : hashSet) {
            String string3 = indexResult.getValue("fqn");
            if (set2.contains(string3)) continue;
            IndexedClass indexedClass = this.createClass(string3, null, indexResult);
            set.add(indexedClass);
            set2.add(string3);
            if (bl) continue;
            this.addSubclasses(string3, set, set2, set3, bl);
        }
        return bl2;
    }

    public Set<IndexedClass> getSubClasses(String string, String string2, String string3, boolean bl) {
        HashSet<IndexedClass> hashSet = new HashSet<IndexedClass>();
        HashSet<String> hashSet2 = new HashSet<String>();
        HashSet<String> hashSet3 = new HashSet<String>();
        if (string != null) {
            this.addSubclasses(string, hashSet, hashSet3, hashSet2, bl);
        } else {
            string = string2;
            while (hashSet.size() == 0 && string.length() > 0) {
                boolean bl2 = this.addSubclasses(string + "::" + string3, hashSet, hashSet3, hashSet2, bl);
                if (bl2) {
                    return hashSet;
                }
                int n = string.lastIndexOf("::");
                if (n == -1) break;
                string = string.substring(0, n);
            }
            if (hashSet.size() == 0) {
                this.addSubclasses(string3, hashSet, hashSet3, hashSet2, bl);
            }
        }
        return hashSet;
    }

    public IndexedMethod getOverridingMethod(String string, String string2) {
        Set<IndexedMethod> set = this.getInheritedMethods(string, string2, QuerySupport.Kind.EXACT);
        for (IndexedMethod indexedMethod : set) {
            if (indexedMethod.getIn().equals(string)) continue;
            return indexedMethod;
        }
        return null;
    }

    Set<IndexedMethod> getInheritedMethods(RubyType rubyType, String string, QuerySupport.Kind kind) {
        HashSet<IndexedMethod> hashSet = new HashSet<IndexedMethod>();
        for (String string2 : rubyType.getRealTypes()) {
            hashSet.addAll(this.getInheritedMethods(string2, string, kind));
        }
        return hashSet;
    }

    public Set<IndexedMethod> getInheritedMethods(String string, String string2, QuerySupport.Kind kind) {
        boolean bl = false;
        if (string == null || string.equals(OBJECT)) {
            string = CLASS;
            bl = true;
        } else if (MODULE.equals(string) || CLASS.equals(string)) {
            bl = true;
        }
        HashSet<IndexedMethod> hashSet = new HashSet<IndexedMethod>();
        HashSet<String> hashSet2 = new HashSet<String>();
        HashSet<String> hashSet3 = new HashSet<String>();
        if (string2 == null) {
            string2 = "";
        }
        InvocationCounter invocationCounter = new InvocationCounter(string, string2);
        this.addMethodsFromClass(string2, kind, string, hashSet, hashSet3, hashSet2, bl, false, invocationCounter);
        invocationCounter.stop();
        this.addToMostTimeConsuming(invocationCounter);
        if (LOGGGER.isLoggable(Level.FINEST)) {
            LOGGGER.log(Level.FINEST, invocationCounter.display());
        }
        return hashSet;
    }

    void logMostTimeConsuming() {
        if (!LOGGGER.isLoggable(Level.FINE)) {
            return;
        }
        LOGGGER.fine("The most time consuming invocations ( " + mostTimeConsumingInvocations.size() + "):");
        LOGGGER.fine("===================================");
        for (InvocationCounter invocationCounter : mostTimeConsumingInvocations) {
            LOGGGER.log(Level.FINE, invocationCounter.display());
        }
        LOGGGER.fine("===================================");
    }

    private void addToMostTimeConsuming(InvocationCounter invocationCounter) {
        if (mostTimeConsumingInvocations.size() < 20) {
            mostTimeConsumingInvocations.add(invocationCounter);
        } else if (mostTimeConsumingInvocations.last().compareTo(invocationCounter) < 0) {
            mostTimeConsumingInvocations.remove(mostTimeConsumingInvocations.last());
            mostTimeConsumingInvocations.add(invocationCounter);
        }
    }

    private boolean addMethodsFromClass(String string, QuerySupport.Kind kind, String string2, Set<IndexedMethod> set, Set<String> set2, Set<String> set3, boolean bl, boolean bl2, InvocationCounter invocationCounter) {
        boolean bl3;
        invocationCounter.increment();
        if (set3.contains(string2)) {
            return false;
        }
        set3.add(string2);
        HashSet<IndexResult> hashSet = new HashSet<IndexResult>();
        this.search("fqn", string2, QuerySupport.Kind.EXACT, hashSet);
        boolean bl4 = bl3 = hashSet.size() > 0;
        if (!bl3) {
            return bl3;
        }
        String string3 = null;
        String string4 = null;
        int n = string2.lastIndexOf("::");
        if (n != -1) {
            string4 = string2.substring(0, n);
        }
        Object object = hashSet.iterator();
        while (object.hasNext()) {
            String[] stringArray;
            int n2;
            Object object2;
            Object object3;
            String string5;
            IndexResult indexResult = (IndexResult)object.next();
            assert (indexResult != null);
            if (string3 == null) {
                string3 = indexResult.getValue("extends");
            }
            if ((string5 = indexResult.getValue("includes")) != null) {
                object2 = object3 = string5.split(",");
                int n3 = ((String[])object2).length;
                for (n2 = 0; n2 < n3; ++n2) {
                    String string6 = object2[n2];
                    boolean bl5 = false;
                    if (string4 != null) {
                        bl5 = this.addMethodsFromClass(string, kind, string4 + "::" + string6, set, set2, set3, bl, true, invocationCounter);
                    }
                    if (bl5) continue;
                    this.addMethodsFromClass(string, kind, string6, set, set2, set3, bl, true, invocationCounter);
                }
            }
            if ((object3 = indexResult.getValue("extendWith")) != null) {
                boolean bl6 = false;
                if (string4 != null) {
                    bl6 = this.addMethodsFromClass(string, kind, string4 + "::" + (String)object3, set, set2, set3, bl, true, invocationCounter);
                }
                if (!bl6) {
                    this.addMethodsFromClass(string, kind, (String)object3, set, set2, set3, bl, true, invocationCounter);
                }
            }
            if ((object2 = indexResult.getValues("method")) != null) {
                Object object4 = object2;
                n2 = ((String[])object4).length;
                for (int i = 0; i < n2; ++i) {
                    String string7 = object4[i];
                    if (string.length() == 0 && !Character.isLowerCase(string7.charAt(0)) || set2.contains(string7) || !string7.startsWith(string)) continue;
                    if (kind == QuerySupport.Kind.EXACT) {
                        if (string7.length() > string.length() && string7.charAt(string.length()) != '(' && string7.charAt(string.length()) != ';') {
                            continue;
                        }
                    } else assert (kind == QuerySupport.Kind.PREFIX || kind == QuerySupport.Kind.CASE_INSENSITIVE_PREFIX);
                    set2.add(string7);
                    IndexedMethod indexedMethod = this.createMethod(string7, indexResult, bl2);
                    indexedMethod.setSmart(!bl);
                    set.add(indexedMethod);
                }
            }
            if ((stringArray = indexResult.getValues("attribute")) == null) continue;
            for (String string6 : stringArray) {
                if (string.length() == 0 && !Character.isLowerCase(string6.charAt(0)) || set2.contains(string6) || !string6.startsWith(string)) continue;
                if (kind == QuerySupport.Kind.EXACT) {
                    if (string6.length() > string.length() && string6.charAt(string.length()) != '(' && string6.charAt(string.length()) != ';') {
                        continue;
                    }
                } else assert (kind == QuerySupport.Kind.PREFIX || kind == QuerySupport.Kind.CASE_INSENSITIVE_PREFIX);
                set2.add(string6);
                IndexedMethod indexedMethod = this.createMethod(string6, indexResult, bl2);
                indexedMethod.setSmart(!bl);
                indexedMethod.setMethodType(IndexedMethod.MethodType.ATTRIBUTE);
                set.add(indexedMethod);
            }
        }
        if (string2.equals(OBJECT)) {
            return bl3;
        }
        if (string3 == null) {
            if (bl) {
                this.addMethodsFromClass(string, kind, OBJECT, set, set2, set3, true, true, invocationCounter);
            } else {
                this.addMethodsFromClass(string, kind, CLASS, set, set2, set3, true, true, invocationCounter);
            }
        } else {
            if (ACTIVE_RECORD_BASE.equals(string3)) {
                this.addDatabaseProperties(string, kind, string2, set);
            }
            if (!this.addMethodsFromClass(string, kind, string3, set, set2, set3, bl, true, invocationCounter)) {
                int n4;
                for (object = string4; object != null && !this.addMethodsFromClass(string, kind, (String)object + "::" + string3, set, set2, set3, bl, true, invocationCounter) && (n4 = ((String)object).lastIndexOf("::")) != -1; object = ((String)object).substring(0, n4)) {
                }
            }
        }
        return bl3;
    }

    private void addDatabaseProperties(String string, QuerySupport.Kind kind, String string2, Set<IndexedMethod> set) {
        DatabasePropertiesIndexer.indexDatabaseProperties(this, string, kind, string2, set);
    }

    public Set<String> getDatabaseTables(String string, QuerySupport.Kind kind) {
        String string2 = "dbtable";
        HashSet<IndexResult> hashSet = new HashSet<IndexResult>();
        this.search(string2, string, kind, hashSet);
        HashSet<String> hashSet2 = new HashSet<String>();
        for (IndexResult indexResult : hashSet) {
            assert (indexResult != null);
            String string3 = indexResult.getValue("dbtable");
            if (string3 == null) continue;
            hashSet2.add(string3);
        }
        return hashSet2;
    }

    public Set<IndexedVariable> getGlobals(String string, QuerySupport.Kind kind) {
        String string2 = "global";
        HashSet<IndexResult> hashSet = new HashSet<IndexResult>();
        this.search(string2, string, kind, hashSet);
        HashSet<IndexedVariable> hashSet2 = new HashSet<IndexedVariable>();
        for (IndexResult indexResult : hashSet) {
            assert (indexResult != null);
            String[] stringArray = indexResult.getValues("global");
            if (stringArray == null) continue;
            for (String string3 : stringArray) {
                int n = 0;
                IndexedVariable indexedVariable = IndexedVariable.create(this, string3, string3, null, indexResult, null, string3, n, ElementKind.GLOBAL, this.context);
                hashSet2.add(indexedVariable);
            }
        }
        return hashSet2;
    }

    public Set<? extends IndexedConstant> getConstants(String string) {
        String[] stringArray = RubyUtils.parseConstantName(string);
        return this.getConstants(stringArray[0], stringArray[1]);
    }

    public Set<? extends IndexedConstant> getConstants(RubyType rubyType, String string) {
        HashSet<? extends IndexedConstant> hashSet = new HashSet<IndexedConstant>();
        for (String string2 : rubyType.getRealTypes()) {
            hashSet.addAll(this.getConstants(string2, string));
        }
        return hashSet;
    }

    public Set<? extends IndexedConstant> getConstants(String string, String string2) {
        boolean bl = false;
        if (string == null || string.equals(OBJECT)) {
            string = CLASS;
            bl = true;
        } else if (MODULE.equals(string) || CLASS.equals(string)) {
            bl = true;
        }
        HashSet hashSet = new HashSet();
        if (string2 == null) {
            string2 = "";
        }
        this.addConstantsFromClass(string2, string, hashSet, bl);
        return hashSet;
    }

    private boolean addConstantsFromClass(String string, String string2, Set<? super IndexedConstant> set, boolean bl) {
        String string3 = "fqn";
        HashSet<IndexResult> hashSet = new HashSet<IndexResult>();
        this.search(string3, string2, QuerySupport.Kind.EXACT, hashSet);
        if (hashSet.size() <= 0) {
            return false;
        }
        for (IndexResult indexResult : hashSet) {
            assert (indexResult != null);
            String[] stringArray = indexResult.getValues("constant");
            if (stringArray == null) continue;
            for (String string4 : stringArray) {
                if (string.length() != 0 && !string4.startsWith(string)) continue;
                IndexedConstant indexedConstant = this.createConstant(string4, indexResult);
                indexedConstant.setSmart(!bl);
                set.add(indexedConstant);
            }
        }
        return true;
    }

    public Set<IndexedField> getInheritedFields(String string, String string2, QuerySupport.Kind kind, boolean bl) {
        boolean bl2 = false;
        if (string == null || string.equals(OBJECT)) {
            string = CLASS;
            bl2 = true;
        } else if (MODULE.equals(string) || CLASS.equals(string)) {
            bl2 = true;
        }
        HashSet<IndexedField> hashSet = new HashSet<IndexedField>();
        HashSet<String> hashSet2 = new HashSet<String>();
        HashSet<String> hashSet3 = new HashSet<String>();
        boolean bl3 = true;
        if (string2 == null) {
            string2 = "";
        } else if (string2.startsWith("@@")) {
            bl3 = false;
            string2 = string2.substring(2);
        } else if (string2.startsWith("@")) {
            string2 = string2.substring(1);
        }
        this.addFieldsFromClass(string2, kind, string, hashSet, hashSet3, hashSet2, bl2, bl3, bl);
        return hashSet;
    }

    private boolean addFieldsFromClass(String string, QuerySupport.Kind kind, String string2, Set<IndexedField> set, Set<String> set2, Set<String> set3, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4;
        if (set3.contains(string2)) {
            return false;
        }
        set3.add(string2);
        String string3 = "fqn";
        HashSet<IndexResult> hashSet = new HashSet<IndexResult>();
        this.search(string3, string2, QuerySupport.Kind.EXACT, hashSet);
        boolean bl5 = bl4 = hashSet.size() > 0;
        if (!bl4) {
            return bl4;
        }
        String string4 = null;
        String string5 = null;
        int n = string2.lastIndexOf("::");
        if (n != -1) {
            string5 = string2.substring(0, n);
        }
        Object object = hashSet.iterator();
        while (object.hasNext()) {
            int n2;
            Object object2;
            Object object3;
            String string6;
            IndexResult indexResult = (IndexResult)object.next();
            assert (indexResult != null);
            if (string4 == null) {
                string4 = indexResult.getValue("extends");
            }
            if ((string6 = indexResult.getValue("includes")) != null) {
                object2 = object3 = string6.split(",");
                int n3 = ((String[])object2).length;
                for (n2 = 0; n2 < n3; ++n2) {
                    String string7 = object2[n2];
                    boolean bl6 = false;
                    if (string5 != null) {
                        bl6 = this.addFieldsFromClass(string, kind, string5 + "::" + string7, set, set2, set3, bl, bl2, true);
                    }
                    if (bl6) continue;
                    this.addFieldsFromClass(string, kind, string7, set, set2, set3, bl, bl2, true);
                }
            }
            if ((object3 = indexResult.getValue("extendWith")) != null) {
                boolean bl7 = false;
                if (string5 != null) {
                    bl7 = this.addFieldsFromClass(string, kind, string5 + "::" + (String)object3, set, set2, set3, bl, bl2, true);
                }
                if (!bl7) {
                    this.addFieldsFromClass(string, kind, (String)object3, set, set2, set3, bl, bl2, true);
                }
            }
            if ((object2 = indexResult.getValues("field")) == null) continue;
            Object object4 = object2;
            n2 = ((String[])object4).length;
            for (int i = 0; i < n2; ++i) {
                String string8 = object4[i];
                if (string.length() == 0 && !Character.isLowerCase(string8.charAt(0)) || set2.contains(string8)) continue;
                boolean bl8 = true;
                int n4 = string8.indexOf(59);
                if (n4 != -1) {
                    int n5 = IndexedElement.stringToFlag(string8, n4 + 1);
                    boolean bl9 = bl8 = (n5 & 0x10) == 0;
                }
                if (bl8 != bl2 || !string8.startsWith(string)) continue;
                if (kind == QuerySupport.Kind.EXACT) {
                    if (string8.length() > string.length() && string8.charAt(string.length()) != '(' && string8.charAt(string.length()) != ';') {
                        continue;
                    }
                } else assert (kind == QuerySupport.Kind.PREFIX || kind == QuerySupport.Kind.CASE_INSENSITIVE_PREFIX);
                set2.add(string8);
                IndexedField indexedField = this.createField(string8, indexResult, bl8, bl3);
                indexedField.setSmart(!bl);
                set.add(indexedField);
            }
        }
        if (string2.equals(OBJECT)) {
            return bl4;
        }
        if (string4 == null) {
            if (bl) {
                this.addFieldsFromClass(string, kind, OBJECT, set, set2, set3, true, bl2, true);
            } else {
                this.addFieldsFromClass(string, kind, CLASS, set, set2, set3, true, bl2, true);
            }
        } else if (!this.addFieldsFromClass(string, kind, string4, set, set2, set3, bl, bl2, true)) {
            int n6;
            for (object = string5; object != null && !this.addFieldsFromClass(string, kind, (String)object + "::" + string4, set, set2, set3, bl, bl2, true) && (n6 = ((String)object).lastIndexOf("::")) != -1; object = ((String)object).substring(0, n6)) {
            }
        }
        return bl4;
    }

    public Set<? extends IndexedElement> getDocumented(String string) {
        assert (string != null && string.length() > 0);
        int n = string.indexOf(35);
        if (n == -1) {
            return this.getDocumentedClasses(string);
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        return this.getDocumentedMethods(string2, string3);
    }

    private Set<IndexedClass> getDocumentedClasses(String string) {
        HashSet<IndexResult> hashSet = new HashSet<IndexResult>();
        String string2 = "fqn";
        this.search(string2, string, QuerySupport.Kind.EXACT, hashSet);
        HashSet<IndexedClass> hashSet2 = new HashSet<IndexedClass>();
        for (IndexResult indexResult : hashSet) {
            int n;
            assert (indexResult != null);
            String string3 = indexResult.getValue("attrs");
            if (string3 == null || ((n = IndexedElement.stringToFlag(string3, 0)) & 1) == 0) continue;
            hashSet2.add(this.createClass(string, null, indexResult));
        }
        return hashSet2;
    }

    private Set<IndexedMethod> getDocumentedMethods(String string, String string2) {
        HashSet<IndexResult> hashSet = new HashSet<IndexResult>();
        String string3 = "fqn";
        this.search(string3, string, QuerySupport.Kind.EXACT, hashSet);
        HashSet<IndexedMethod> hashSet2 = new HashSet<IndexedMethod>();
        for (IndexResult indexResult : hashSet) {
            int n;
            String[] stringArray;
            String[] stringArray2 = indexResult.getValues("method");
            if (stringArray2 != null) {
                stringArray = stringArray2;
                int n2 = stringArray.length;
                for (n = 0; n < n2; ++n) {
                    int n3;
                    int n4;
                    String string4 = stringArray[n];
                    if ((string2 == null || string2.length() == 0) && !Character.isLowerCase(string4.charAt(0)) || !string4.startsWith(string2) || string4.length() > string2.length() && string4.charAt(string2.length()) != '(' && string4.charAt(string2.length()) != ';' || (n4 = string4.indexOf(59, string2.length())) == -1 || ((n3 = IndexedElement.stringToFlag(string4, n4 + 1)) & 1) == 0) continue;
                    assert (indexResult != null);
                    hashSet2.add(this.createMethod(string4, indexResult, false));
                }
            }
            if ((stringArray = indexResult.getValues("attribute")) == null) continue;
            String[] stringArray3 = stringArray;
            n = stringArray3.length;
            for (int i = 0; i < n; ++i) {
                String string5 = stringArray3[i];
                if ((string2 == null || string2.length() == 0) && !Character.isLowerCase(string5.charAt(0)) || !string5.startsWith(string2) || string5.length() > string2.length() && string5.charAt(string2.length()) != ';') continue;
                assert (indexResult != null);
                hashSet2.add(this.createMethod(string5, indexResult, false));
            }
        }
        return hashSet2;
    }

    public FileObject getRequiredFile(String string) {
        HashSet<IndexResult> hashSet = new HashSet<IndexResult>();
        String string2 = "require";
        this.search(string2, string, QuerySupport.Kind.EXACT, hashSet);
        for (IndexResult indexResult : hashSet) {
            FileObject fileObject = indexResult.getFile();
            if (fileObject == null) continue;
            return fileObject;
        }
        return null;
    }

    static String getClusterUrl() {
        if (clusterUrl == null) {
            File file = InstalledFileLocator.getDefault().locate("modules/org-netbeans-modules-ruby.jar", null, false);
            if (file == null) {
                throw new RuntimeException("Can't find cluster");
            }
            file = new File(file.getParentFile().getParentFile().getAbsolutePath());
            try {
                file = file.getCanonicalFile();
                clusterUrl = file.toURI().toURL().toExternalForm();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return clusterUrl;
    }

    public static void setClusterUrl(String string) {
        clusterUrl = string;
    }

    static String getPreindexUrl(String string) {
        return RubyIndex.getPreindexUrl(string, null);
    }

    static String getPreindexUrl(String string, FileObject fileObject) {
        String string2;
        RubyPlatform rubyPlatform = RubyPlatformManager.getDefaultPlatform();
        if (rubyPlatform != null) {
            string2 = RubyIndex.getGemHomeURL(rubyPlatform);
            if (string2 != null && string.startsWith(string2)) {
                return GEM_URL + string.substring(string2.length());
            }
            string2 = rubyPlatform.getHomeUrl();
            if (string.startsWith(string2)) {
                string = RUBYHOME_URL + string.substring(string2.length());
                return string;
            }
        }
        if (string.startsWith(string2 = RubyIndex.getClusterUrl())) {
            return CLUSTER_URL + string.substring(string2.length());
        }
        return string;
    }

    public static FileObject getFileObject(String string) {
        return RubyIndex.getFileObject(string, null);
    }

    public static FileObject getFileObject(String string, FileObject fileObject) {
        try {
            if (string.startsWith(RUBYHOME_URL)) {
                Object object;
                Project project;
                Iterator<RubyPlatform> iterator = null;
                if (fileObject != null && (project = FileOwnerQuery.getOwner((FileObject)fileObject)) != null && (object = RubyPlatform.platformFor((Project)project)) != null) {
                    iterator = Collections.singleton(object).iterator();
                }
                if (iterator == null) {
                    iterator = RubyPlatformManager.platformIterator();
                }
                while (iterator.hasNext()) {
                    project = (RubyPlatform)iterator.next();
                    object = project.getHomeUrl() + string.substring(RUBYHOME_URL.length());
                    FileObject fileObject2 = URLMapper.findFileObject((URL)new URL((String)object));
                    if (fileObject2 == null) continue;
                    return fileObject2;
                }
                return null;
            }
            if (string.startsWith(GEM_URL)) {
                RubyPlatform rubyPlatform;
                Project project;
                Iterator<RubyPlatform> iterator = null;
                if (fileObject != null && (project = FileOwnerQuery.getOwner((FileObject)fileObject)) != null && (rubyPlatform = RubyPlatform.platformFor((Project)project)) != null) {
                    iterator = Collections.singleton(rubyPlatform).iterator();
                }
                if (iterator == null) {
                    iterator = RubyPlatformManager.platformIterator();
                }
                while (iterator.hasNext()) {
                    String string2;
                    FileObject fileObject3;
                    project = (RubyPlatform)iterator.next();
                    if (!project.hasRubyGemsInstalled() || (rubyPlatform = project.getGemManager()) == null || (fileObject3 = URLMapper.findFileObject((URL)new URL(string2 = rubyPlatform.getGemHomeUrl() + string.substring(GEM_URL.length())))) == null) continue;
                    return fileObject3;
                }
                return null;
            }
            if (string.startsWith(CLUSTER_URL)) {
                string = RubyIndex.getClusterUrl() + string.substring(CLUSTER_URL.length());
            }
            return URLMapper.findFileObject((URL)new URL(string));
        }
        catch (MalformedURLException malformedURLException) {
            Exceptions.printStackTrace((Throwable)malformedURLException);
            return null;
        }
    }

    private static String getGemHomeURL(RubyPlatform rubyPlatform) {
        return rubyPlatform.hasRubyGemsInstalled() ? rubyPlatform.getGemManager().getGemHomeUrl() : null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class InvocationCounter
    implements Comparable<InvocationCounter> {
        private int count = 0;
        private final long start;
        private long stop;
        private final String classFqn;
        private final String prefix;

        public InvocationCounter(String string, String string2) {
            this.classFqn = string;
            this.prefix = string2;
            this.start = System.currentTimeMillis();
        }

        void increment() {
            ++this.count;
        }

        int result() {
            return this.count;
        }

        void stop() {
            this.stop = System.currentTimeMillis();
        }

        long time() {
            return this.stop - this.start;
        }

        String display() {
            return "Class: " + this.classFqn + ", prefix: " + this.prefix + ", time: " + this.time() + "ms, count: " + this.count;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            InvocationCounter invocationCounter = (InvocationCounter)object;
            if (this.classFqn == null ? invocationCounter.classFqn != null : !this.classFqn.equals(invocationCounter.classFqn)) {
                return false;
            }
            return this.time() == invocationCounter.time() && this.count == invocationCounter.count;
        }

        public int hashCode() {
            int n = 5;
            n = 29 * n + (this.prefix != null ? this.prefix.hashCode() : 0);
            return n;
        }

        @Override
        public int compareTo(InvocationCounter invocationCounter) {
            if (this.time() > invocationCounter.time()) {
                return -1;
            }
            if (this.time() < invocationCounter.time()) {
                return 1;
            }
            return 0;
        }
    }
}

