/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import org.jrubyparser.SourcePosition;
import org.jrubyparser.ast.AliasNode;
import org.jrubyparser.ast.ArgsCatNode;
import org.jrubyparser.ast.ArgsNode;
import org.jrubyparser.ast.ArgumentNode;
import org.jrubyparser.ast.AssignableNode;
import org.jrubyparser.ast.CallNode;
import org.jrubyparser.ast.ClassNode;
import org.jrubyparser.ast.Colon2Node;
import org.jrubyparser.ast.Colon3Node;
import org.jrubyparser.ast.ConstNode;
import org.jrubyparser.ast.FCallNode;
import org.jrubyparser.ast.INameNode;
import org.jrubyparser.ast.IScopingNode;
import org.jrubyparser.ast.ListNode;
import org.jrubyparser.ast.LocalAsgnNode;
import org.jrubyparser.ast.MethodDefNode;
import org.jrubyparser.ast.ModuleNode;
import org.jrubyparser.ast.MultipleAsgnNode;
import org.jrubyparser.ast.NewlineNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.jrubyparser.ast.SClassNode;
import org.jrubyparser.ast.StrNode;
import org.jrubyparser.ast.SymbolNode;
import org.jrubyparser.ast.VCallNode;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.modules.ruby.Arity;
import org.netbeans.modules.ruby.AstPath;
import org.netbeans.modules.ruby.RubyCodeCompleter;
import org.netbeans.modules.ruby.RubyIndex;
import org.netbeans.modules.ruby.RubyMethodCompleter;
import org.netbeans.modules.ruby.RubyParseResult;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.elements.IndexedElement;
import org.netbeans.modules.ruby.elements.IndexedField;
import org.netbeans.modules.ruby.elements.IndexedMethod;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AstUtilities {
    private static final Logger LOGGER = Logger.getLogger(AstUtilities.class.getName());
    private static final boolean INCLUDE_DEFS_PREFIX = false;

    public static RubyParseResult getParseResult(Parser.Result result) {
        if (!(result instanceof RubyParseResult)) {
            LOGGER.log(Level.WARNING, "Expected RubyParseResult, but have {0}", result);
            return null;
        }
        return (RubyParseResult)result;
    }

    public static int getAstOffset(Parser.Result result, int n) {
        RubyParseResult rubyParseResult = AstUtilities.getParseResult(result);
        if (rubyParseResult != null) {
            return rubyParseResult.getSnapshot().getEmbeddedOffset(n);
        }
        return n;
    }

    public static OffsetRange getAstOffsets(Parser.Result result, OffsetRange offsetRange) {
        RubyParseResult rubyParseResult = AstUtilities.getParseResult(result);
        if (rubyParseResult != null) {
            int n = offsetRange.getStart();
            int n2 = rubyParseResult.getSnapshot().getEmbeddedOffset(n);
            if (n2 == n) {
                return offsetRange;
            }
            if (n2 == -1) {
                return OffsetRange.NONE;
            }
            return new OffsetRange(n2, n2 + offsetRange.getLength());
        }
        return offsetRange;
    }

    private AstUtilities() {
    }

    public static List<String> gatherDocumentation(Snapshot snapshot, Node node) {
        LinkedList<String> linkedList = new LinkedList<String>();
        int n = node.getPosition().getStartOffset();
        try {
            if (n < 0 || n >= snapshot.getText().length()) {
                return null;
            }
            int n2 = GsfUtilities.getRowStart((CharSequence)snapshot.getText(), (int)n);
            --n2;
            while (n2 >= 0) {
                n2 = GsfUtilities.getRowStart((CharSequence)snapshot.getText(), (int)n2);
                if (!GsfUtilities.isRowEmpty((CharSequence)snapshot.getText(), (int)n2) && !GsfUtilities.isRowWhite((CharSequence)snapshot.getText(), (int)n2)) break;
                --n2;
            }
            if (n2 < 0) {
                return null;
            }
            block3: while (n2 >= 0) {
                n2 = GsfUtilities.getRowStart((CharSequence)snapshot.getText(), (int)n2);
                if (GsfUtilities.isRowEmpty((CharSequence)snapshot.getText(), (int)n2) || GsfUtilities.isRowWhite((CharSequence)snapshot.getText(), (int)n2)) break;
                int n3 = GsfUtilities.getRowFirstNonWhite((CharSequence)snapshot.getText(), (int)n2);
                int n4 = GsfUtilities.getRowLastNonWhite((CharSequence)snapshot.getText(), (int)n2) + 1;
                String string = ((Object)snapshot.getText().subSequence(n3, n4)).toString();
                if (string.startsWith("#")) {
                    linkedList.addFirst(string);
                } else {
                    if (linkedList.size() == 0 && string.startsWith("=end") && n3 == GsfUtilities.getRowStart((CharSequence)snapshot.getText(), (int)n2)) {
                        AstUtilities.gatherInlineDocumentation(linkedList, snapshot, n2);
                        return linkedList;
                    }
                    if (!string.equals("public") && !string.equals("private") && !string.equals("protected")) break;
                    --n2;
                    while (n2 >= 0) {
                        n2 = GsfUtilities.getRowStart((CharSequence)snapshot.getText(), (int)n2);
                        if (!GsfUtilities.isRowEmpty((CharSequence)snapshot.getText(), (int)n2) && !GsfUtilities.isRowWhite((CharSequence)snapshot.getText(), (int)n2)) continue block3;
                        --n2;
                    }
                    continue;
                }
                --n2;
            }
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
        return linkedList;
    }

    private static void gatherInlineDocumentation(LinkedList<String> linkedList, Snapshot snapshot, int n) throws BadLocationException {
        n = GsfUtilities.getRowStart((CharSequence)snapshot.getText(), (int)n);
        --n;
        while (n >= 0) {
            int n2 = n = GsfUtilities.getRowStart((CharSequence)snapshot.getText(), (int)n);
            int n3 = GsfUtilities.getRowEnd((CharSequence)snapshot.getText(), (int)n);
            String string = ((Object)snapshot.getText().subSequence(n2, n3)).toString();
            if (string.startsWith("=begin")) {
                return;
            }
            linkedList.addFirst(string);
            --n;
        }
    }

    public static Node getForeignNode(IndexedElement indexedElement) {
        return AstUtilities.getForeignNode(indexedElement, null);
    }

    public static Node getForeignNode(final IndexedElement indexedElement, final Parser.Result[] resultArray) {
        FileObject fileObject = indexedElement.getFileObject();
        if (fileObject == null) {
            return null;
        }
        Source source = Source.create((FileObject)fileObject);
        final Node[] nodeArray = new Node[1];
        try {
            ParserManager.parse(Collections.singleton(source), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    String string;
                    Node node;
                    Parser.Result result = resultIterator.getParserResult();
                    if (resultArray != null) {
                        assert (resultArray.length == 1);
                        resultArray[0] = result;
                    }
                    if ((node = AstUtilities.getRoot(result)) != null && (string = indexedElement.getSignature()) != null) {
                        Node node2 = AstUtilities.findBySignature(node, string);
                        if (node2 == null && "new".equals(indexedElement.getName())) {
                            string = string.indexOf("#new") != -1 ? string.replaceFirst("#new", "#initialize") : string.replaceFirst("new", "initialize");
                            node2 = AstUtilities.findBySignature(node, string);
                        }
                        nodeArray[0] = node2;
                    }
                }
            });
        }
        catch (ParseException parseException) {
            Exceptions.printStackTrace((Throwable)parseException);
            return null;
        }
        return nodeArray[0];
    }

    public static int boundCaretOffset(ParserResult parserResult, int n) {
        int n2;
        BaseDocument baseDocument = RubyUtils.getDocument((Parser.Result)parserResult);
        if (baseDocument != null && n > (n2 = baseDocument.getLength())) {
            n = n2;
        }
        return n;
    }

    public static Set<String> getRequires(Node node) {
        HashSet<String> hashSet = new HashSet<String>();
        AstUtilities.addRequires(node, hashSet);
        return hashSet;
    }

    private static void addRequires(Node node, Set<String> set) {
        ListNode listNode;
        Object object;
        Object object2;
        if (node.getNodeType() == NodeType.FCALLNODE) {
            String string;
            Node node2;
            object2 = AstUtilities.getName(node);
            if (((String)object2).equals("require") && (object = ((FCallNode)node).getArgsNode()) instanceof ListNode && (listNode = (ListNode)object).size() > 0 && (node2 = listNode.get(0)) instanceof StrNode && (string = ((StrNode)node2).getValue()) != null && string.length() > 0) {
                set.add(string.toString());
            }
        } else if (node.getNodeType() == NodeType.MODULENODE || node.getNodeType() == NodeType.CLASSNODE || node.getNodeType() == NodeType.DEFNNODE || node.getNodeType() == NodeType.DEFSNODE) {
            return;
        }
        object2 = node.childNodes();
        object = object2.iterator();
        while (object.hasNext()) {
            listNode = (Node)object.next();
            if (listNode.isInvisible()) continue;
            AstUtilities.addRequires((Node)listNode, set);
        }
    }

    public static MethodDefNode findMethod(Node node, String string, Arity arity) {
        Object object;
        if ((node.getNodeType() == NodeType.DEFNNODE || node.getNodeType() == NodeType.DEFSNODE) && AstUtilities.getName(node).equals(string) && Arity.matches(arity, (Arity)(object = Arity.getDefArity(node)))) {
            return (MethodDefNode)node;
        }
        object = node.childNodes();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            MethodDefNode methodDefNode;
            Node node2 = (Node)iterator.next();
            if (node2.isInvisible() || (methodDefNode = AstUtilities.findMethod(node2, string, arity)) == null) continue;
            return methodDefNode;
        }
        return null;
    }

    public static MethodDefNode findMethodAtOffset(Node node, int n) {
        AstPath astPath = new AstPath(node, n);
        ListIterator<Node> listIterator = astPath.leafToRoot();
        while (listIterator.hasNext()) {
            Node node2 = (Node)listIterator.next();
            if (node2.getNodeType() != NodeType.DEFNNODE && node2.getNodeType() != NodeType.DEFSNODE) continue;
            return (MethodDefNode)node2;
        }
        return null;
    }

    public static ClassNode findClassAtOffset(Node node, int n) {
        AstPath astPath = new AstPath(node, n);
        ListIterator<Node> listIterator = astPath.leafToRoot();
        while (listIterator.hasNext()) {
            Node node2 = (Node)listIterator.next();
            if (!(node2 instanceof ClassNode)) continue;
            return (ClassNode)node2;
        }
        return null;
    }

    public static Node findLocalScope(Node node, AstPath astPath) {
        MethodDefNode methodDefNode = AstUtilities.findMethod(astPath);
        if (methodDefNode == null) {
            ListIterator<Node> listIterator = astPath.leafToRoot();
            while (listIterator.hasNext()) {
                Node node2 = (Node)listIterator.next();
                switch (node2.getNodeType()) {
                    case DEFNNODE: 
                    case DEFSNODE: 
                    case CLASSNODE: 
                    case SCLASSNODE: 
                    case MODULENODE: {
                        return node2;
                    }
                }
            }
            if (astPath.root() != null) {
                return astPath.root();
            }
            methodDefNode = AstUtilities.findBlock(astPath);
        }
        if (methodDefNode == null) {
            methodDefNode = astPath.leafParent();
            if (methodDefNode.getNodeType() == NodeType.NEWLINENODE) {
                methodDefNode = astPath.leafGrandParent();
            }
            if (methodDefNode == null) {
                methodDefNode = node;
            }
        }
        return methodDefNode;
    }

    public static Node findDynamicScope(Node node, AstPath astPath) {
        Node node2 = AstUtilities.findBlock(astPath);
        if (node2 == null && (node2 = astPath.leafParent()) == null) {
            node2 = node;
        }
        return node2;
    }

    public static Node findBlock(AstPath astPath) {
        Node node = null;
        for (Node node2 : astPath) {
            switch (node2.getNodeType()) {
                case ITERNODE: {
                    node = node2;
                    break;
                }
                case DEFNNODE: 
                case DEFSNODE: 
                case CLASSNODE: 
                case SCLASSNODE: 
                case MODULENODE: {
                    return node;
                }
            }
        }
        return node;
    }

    public static MethodDefNode findMethod(AstPath astPath) {
        for (Node node : astPath) {
            if (node.getNodeType() == NodeType.DEFNNODE || node.getNodeType() == NodeType.DEFSNODE) {
                return (MethodDefNode)node;
            }
            if (node.getNodeType() != NodeType.CLASSNODE && node.getNodeType() != NodeType.SCLASSNODE && node.getNodeType() != NodeType.MODULENODE) continue;
            break;
        }
        return null;
    }

    public static ClassNode findClass(AstPath astPath) {
        for (Node node : astPath) {
            if (!(node instanceof ClassNode)) continue;
            return (ClassNode)node;
        }
        return null;
    }

    public static IScopingNode findClassOrModule(AstPath astPath) {
        for (Node node : astPath) {
            if (node.getNodeType() != NodeType.CLASSNODE && node.getNodeType() != NodeType.MODULENODE) continue;
            return (IScopingNode)node;
        }
        return null;
    }

    public static boolean isCall(Node node) {
        return node.getNodeType() == NodeType.FCALLNODE || node.getNodeType() == NodeType.VCALLNODE || node.getNodeType() == NodeType.CALLNODE;
    }

    public static String getCallName(Node node) {
        assert (AstUtilities.isCall(node));
        if (node instanceof INameNode) {
            return AstUtilities.getName(node);
        }
        assert (false) : node;
        return null;
    }

    public static String getDefName(Node node) {
        if (node instanceof MethodDefNode) {
            return AstUtilities.getName(node);
        }
        assert (false) : node;
        return null;
    }

    public static ArgumentNode getDefNameNode(MethodDefNode methodDefNode) {
        return methodDefNode.getNameNode();
    }

    public static boolean isConstructorMethod(MethodDefNode methodDefNode) {
        String string = methodDefNode.getName();
        return string.equals("new") || string.equals("initialize");
    }

    public static List<String> getDefArgs(MethodDefNode methodDefNode, boolean bl) {
        List list = methodDefNode.childNodes();
        for (Node node : list) {
            Object object;
            if (!(node instanceof ArgsNode)) continue;
            ArgsNode argsNode = (ArgsNode)node;
            List list2 = argsNode.childNodes();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Node node2 : list2) {
                if (!(node2 instanceof ListNode)) continue;
                List list3 = node2.childNodes();
                for (Node node3 : list3) {
                    if (!(node3 instanceof ArgumentNode) && !(node3 instanceof LocalAsgnNode)) continue;
                    String string = AstUtilities.getName(node3);
                    arrayList.add(string);
                }
            }
            if (argsNode.getRest() != null) {
                object = argsNode.getRest().getName();
                if (!bl) {
                    object = "*" + (String)object;
                }
                arrayList.add((String)object);
            }
            if (argsNode.getBlock() != null) {
                object = argsNode.getBlock().getName();
                if (!bl) {
                    object = "&" + (String)object;
                }
                arrayList.add((String)object);
            }
            return arrayList;
        }
        return null;
    }

    public static String getDefSignature(MethodDefNode methodDefNode) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(AstUtilities.getDefName((Node)methodDefNode));
        List<String> list = AstUtilities.getDefArgs(methodDefNode, false);
        if (list != null && list.size() > 0) {
            stringBuilder.append('(');
            Iterator<String> iterator = list.iterator();
            stringBuilder.append(iterator.next());
            while (iterator.hasNext()) {
                stringBuilder.append(',');
                stringBuilder.append(iterator.next());
            }
            stringBuilder.append(')');
        }
        return stringBuilder.toString();
    }

    public static int findArgumentIndex(Node node, int n) {
        switch (node.getNodeType()) {
            case FCALLNODE: {
                Node node2 = ((FCallNode)node).getArgsNode();
                if (node2 == null) {
                    return -1;
                }
                return AstUtilities.findArgumentIndex(node2, n);
            }
            case CALLNODE: {
                Node node3 = ((CallNode)node).getArgsNode();
                if (node3 == null) {
                    return -1;
                }
                return AstUtilities.findArgumentIndex(node3, n);
            }
            case ARGSCATNODE: {
                ArgsCatNode argsCatNode = (ArgsCatNode)node;
                int n2 = AstUtilities.findArgumentIndex(argsCatNode.getFirstNode(), n);
                if (n2 != -1) {
                    return n2;
                }
                n2 = AstUtilities.findArgumentIndex(argsCatNode.getSecondNode(), n);
                if (n2 != -1) {
                    return AstUtilities.getConstantArgs(argsCatNode) + n2;
                }
                SourcePosition sourcePosition = node.getPosition();
                if (n >= sourcePosition.getStartOffset() && n <= sourcePosition.getEndOffset()) {
                    return AstUtilities.getConstantArgs(argsCatNode);
                }
                return -1;
            }
            case HASHNODE: {
                return n;
            }
        }
        if (node instanceof ListNode) {
            List list = node.childNodes();
            int n3 = Integer.MAX_VALUE;
            for (int i = 0; i < list.size(); ++i) {
                OffsetRange offsetRange;
                Node node4 = (Node)list.get(i);
                if (node4.isInvisible()) continue;
                if (node4.getNodeType() == NodeType.HASHNODE) {
                    offsetRange = AstUtilities.getRange(node4);
                    if (n <= offsetRange.getEnd() && (n >= n3 || n >= offsetRange.getStart())) {
                        return i;
                    }
                    n3 = offsetRange.getEnd();
                    continue;
                }
                offsetRange = node4.getPosition();
                if (n <= offsetRange.getEndOffset() && (n >= n3 || n >= offsetRange.getStartOffset())) {
                    return i;
                }
                n3 = offsetRange.getEndOffset();
            }
            SourcePosition sourcePosition = node.getPosition();
            if (n > sourcePosition.getStartOffset() && n < sourcePosition.getEndOffset()) {
                return 0;
            }
        } else {
            SourcePosition sourcePosition = node.getPosition();
            if (n >= sourcePosition.getStartOffset() && n <= sourcePosition.getEndOffset()) {
                return 0;
            }
        }
        return -1;
    }

    private static int getConstantArgs(ArgsCatNode argsCatNode) {
        Node node = argsCatNode.getFirstNode();
        if (node instanceof ListNode) {
            List list = node.childNodes();
            return list.size();
        }
        return 1;
    }

    public static boolean isCallFor(Node node, Arity arity, Node node2) {
        assert (AstUtilities.isCall(node));
        assert (node2 instanceof MethodDefNode);
        return AstUtilities.getDefName(node2).equals(AstUtilities.getCallName(node)) && Arity.matches(arity, Arity.getDefArity(node2));
    }

    public static Node findBySignature(Node node, String string) {
        String string2 = string;
        boolean[] blArray = new boolean[1];
        String string3 = AstUtilities.getNextSigComponent(string, blArray);
        Node node2 = AstUtilities.findBySignature(node, string = string.substring(string3.length()), string3, blArray);
        if (node2 == null && string2.startsWith("Object#")) {
            string2 = string2.substring(string2.indexOf(35) + 1);
            string3 = AstUtilities.getNextSigComponent(string, blArray);
            string = string2.substring(string3.length());
            blArray[0] = true;
            node2 = AstUtilities.findBySignature(node, string, string3, blArray);
        }
        return node2;
    }

    private static String getNextSigComponent(String string, boolean[] blArray) {
        char c;
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = string.length();
        for (n = 0; n < n2; ++n) {
            c = string.charAt(n);
            if (c == '#') {
                blArray[0] = true;
                continue;
            }
            if (c != ':' && c != '(') break;
        }
        while (n < n2 && (c = string.charAt(n)) != '#' && c != ':' && c != '(') {
            stringBuilder.append(c);
            ++n;
        }
        return stringBuilder.toString();
    }

    private static Node findBySignature(Node node, String string, String string2, boolean[] blArray) {
        String[] stringArray;
        Object object;
        switch (node.getNodeType()) {
            case INSTASGNNODE: {
                if (string2.charAt(0) != '@' || !string2.equals(object = AstUtilities.getName(node))) break;
                return node;
            }
            case CLASSVARDECLNODE: 
            case CLASSVARASGNNODE: {
                if (!string2.startsWith("@@") || !string2.equals(object = AstUtilities.getName(node))) break;
                return node;
            }
            case DEFNNODE: 
            case DEFSNODE: {
                if (blArray[0] && string2.equals(AstUtilities.getDefName(node))) {
                    object = AstUtilities.getDefArgs((MethodDefNode)node, false);
                    if (string.length() == 0 && (object == null || object.size() == 0)) {
                        return node;
                    }
                    if (string.length() == 0) break;
                    assert (string.charAt(0) == '(') : string;
                    String string3 = string.substring(1, string.length() - 1);
                    stringArray = string3.split(",");
                    if (stringArray.length != object.size()) break;
                    int n = 1;
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (stringArray[i].equals(object.get(i))) continue;
                        n = 0;
                        break;
                    }
                    if (n == 0) break;
                    return node;
                }
                if (!AstUtilities.isAttr(node)) break;
                object = AstUtilities.getAttrSymbols(node);
                for (SymbolNode symbolNode : object) {
                    if (!string2.equals(symbolNode.getName())) continue;
                    return node;
                }
                break;
            }
            case CONSTDECLNODE: {
                if (!string2.equals(AstUtilities.getName(node))) break;
                return node;
            }
            case CLASSNODE: 
            case MODULENODE: {
                object = ((IScopingNode)node).getCPath();
                if (object instanceof Colon2Node) {
                    String string4 = AstUtilities.getFqn((Colon2Node)object);
                    if (!string4.startsWith(string2) || !string.startsWith(string4.substring(string2.length()))) break;
                    if ((string2 = AstUtilities.getNextSigComponent(string = string.substring(string4.substring(string2.length()).length()), blArray)).length() == 0) {
                        return node;
                    }
                    int n = string.indexOf(string2);
                    assert (n != -1);
                    string = string.substring(n + string2.length());
                    break;
                }
                if (!string2.equals(AstUtilities.getClassOrModuleName((IScopingNode)node))) break;
                string2 = AstUtilities.getNextSigComponent(string, blArray);
                if (string2.length() == 0) {
                    return node;
                }
                int n = string.indexOf(string2);
                assert (n != -1);
                string = string.substring(n + string2.length());
                break;
            }
            case SCLASSNODE: {
                object = ((SClassNode)node).getReceiverNode();
                String string5 = null;
                if (object instanceof Colon2Node) {
                    string5 = AstUtilities.getName((Node)object);
                } else if (object instanceof ConstNode) {
                    string5 = AstUtilities.getName((Node)object);
                }
                if (string5 == null || !string2.equals(string5)) break;
                string2 = AstUtilities.getNextSigComponent(string, blArray);
                if (string2.length() == 0) {
                    return node;
                }
                int n = string.indexOf(string2);
                assert (n != -1);
                string = string.substring(n + string2.length());
            }
        }
        object = node.childNodes();
        boolean bl = blArray[0];
        stringArray = object.iterator();
        while (stringArray.hasNext()) {
            Node node2;
            Node node3 = (Node)stringArray.next();
            if (node3.isInvisible() || (node2 = AstUtilities.findBySignature(node3, string, string2, blArray)) == null) continue;
            return node2;
        }
        blArray[0] = bl;
        return null;
    }

    public static boolean containsOffset(Node node, int n) {
        SourcePosition sourcePosition = node.getPosition();
        return n >= sourcePosition.getStartOffset() && n <= sourcePosition.getEndOffset();
    }

    public static OffsetRange getRange(Node node) {
        if (node.isInvisible()) {
            return OffsetRange.NONE;
        }
        if (node.getNodeType() == NodeType.NOTNODE) {
            Node node2;
            SourcePosition sourcePosition = node.getPosition();
            List list = node.childNodes();
            if (list != null && list.size() > 0 && (node2 = (Node)list.get(0)).getNodeType() == NodeType.NEWLINENODE) {
                OffsetRange offsetRange = AstUtilities.getRange(node2);
                return new OffsetRange(sourcePosition.getStartOffset(), offsetRange.getEnd());
            }
            return new OffsetRange(sourcePosition.getStartOffset(), sourcePosition.getEndOffset());
        }
        if (node.getNodeType() == NodeType.HASHNODE) {
            List list = node.childNodes();
            if (list != null && list.size() > 0) {
                int n = ((Node)list.get(0)).getPosition().getStartOffset();
                int n2 = ((Node)list.get(list.size() - 1)).getPosition().getEndOffset();
                return new OffsetRange(n, n2);
            }
            SourcePosition sourcePosition = node.getPosition();
            return new OffsetRange(sourcePosition.getStartOffset(), sourcePosition.getEndOffset());
        }
        if (node.getNodeType() == NodeType.NILNODE) {
            return OffsetRange.NONE;
        }
        SourcePosition sourcePosition = node.getPosition();
        try {
            return new OffsetRange(sourcePosition.getStartOffset(), sourcePosition.getEndOffset());
        }
        catch (Throwable throwable) {
            Exceptions.printStackTrace((Throwable)throwable);
            return OffsetRange.NONE;
        }
    }

    public static OffsetRange getLValueRange(AssignableNode assignableNode) {
        if (assignableNode instanceof MultipleAsgnNode) {
            MultipleAsgnNode multipleAsgnNode = (MultipleAsgnNode)assignableNode;
            if (multipleAsgnNode.getHeadNode() != null) {
                return AstUtilities.getNameRange((Node)multipleAsgnNode.getHeadNode());
            }
            return AstUtilities.getRange((Node)assignableNode);
        }
        assert (assignableNode instanceof INameNode) : assignableNode;
        SourcePosition sourcePosition = assignableNode.getPosition();
        OffsetRange offsetRange = new OffsetRange(sourcePosition.getStartOffset(), sourcePosition.getStartOffset() + AstUtilities.getName((Node)assignableNode).length());
        return offsetRange;
    }

    public static OffsetRange getNameRange(Node node) {
        if (node instanceof AssignableNode) {
            return AstUtilities.getLValueRange((AssignableNode)node);
        }
        if (node instanceof MethodDefNode) {
            return AstUtilities.getFunctionNameRange(node);
        }
        if (AstUtilities.isCall(node)) {
            return AstUtilities.getCallRange(node);
        }
        if (node instanceof ClassNode) {
            Colon3Node colon3Node = ((ClassNode)node).getCPath();
            if (colon3Node != null) {
                return AstUtilities.getRange((Node)colon3Node);
            }
            return AstUtilities.getRange(node);
        }
        if (node instanceof ModuleNode) {
            Colon3Node colon3Node = ((ModuleNode)node).getCPath();
            if (colon3Node != null) {
                return AstUtilities.getRange((Node)colon3Node);
            }
            return AstUtilities.getRange(node);
        }
        return AstUtilities.getRange(node);
    }

    public static OffsetRange getCallRange(Node node) {
        Node node2;
        SourcePosition sourcePosition = node.getPosition();
        int n = sourcePosition.getStartOffset();
        int n2 = sourcePosition.getEndOffset();
        assert (AstUtilities.isCall(node));
        assert (node instanceof INameNode);
        if (node instanceof CallNode && (node2 = ((CallNode)node).getReceiverNode()) != null && !node2.isInvisible()) {
            n = node2.getPosition().getEndOffset() + 1;
        }
        if (node instanceof INameNode) {
            n2 = n + AstUtilities.getName(node).length();
        }
        return new OffsetRange(n, n2);
    }

    public static OffsetRange getFunctionNameRange(Node node) {
        for (Node node2 : node.childNodes()) {
            if (!(node2 instanceof ArgumentNode)) continue;
            OffsetRange offsetRange = AstUtilities.getRange(node2);
            return offsetRange;
        }
        if (node instanceof MethodDefNode) {
            for (Node node2 : node.childNodes()) {
                if (!(node2 instanceof ConstNode)) continue;
                SourcePosition sourcePosition = node2.getPosition();
                int n = sourcePosition.getEndOffset();
                int n2 = n + 1;
                n = n + 1 + AstUtilities.getDefName(node).length();
                OffsetRange offsetRange = new OffsetRange(n2, n);
                return offsetRange;
            }
        }
        return OffsetRange.NONE;
    }

    public static OffsetRange getAliasNewRange(AliasNode aliasNode) {
        SourcePosition sourcePosition = aliasNode.getPosition();
        int n = sourcePosition.getStartOffset() + 6;
        return new OffsetRange(n, n + aliasNode.getNewName().length());
    }

    public static OffsetRange getAliasOldRange(AliasNode aliasNode) {
        SourcePosition sourcePosition = aliasNode.getPosition();
        int n = sourcePosition.getStartOffset() + 6 + aliasNode.getNewName().length() + 1;
        return new OffsetRange(n, n + aliasNode.getOldName().length());
    }

    public static String getClassOrModuleName(IScopingNode iScopingNode) {
        return AstUtilities.getName((Node)iScopingNode.getCPath());
    }

    public static List<ClassNode> getClasses(Node node) {
        ArrayList<ClassNode> arrayList = new ArrayList<ClassNode>();
        AstUtilities.addClasses(node, arrayList);
        return arrayList;
    }

    private static void addClasses(Node node, List<ClassNode> list) {
        if (node instanceof ClassNode) {
            list.add((ClassNode)node);
        }
        List list2 = node.childNodes();
        for (Node node2 : list2) {
            if (node2.isInvisible()) continue;
            AstUtilities.addClasses(node2, list);
        }
    }

    private static void addAncestorParents(Node node, StringBuilder stringBuilder) {
        if (node instanceof Colon2Node) {
            Colon2Node colon2Node = (Colon2Node)node;
            AstUtilities.addAncestorParents(colon2Node.getLeftNode(), stringBuilder);
            if (stringBuilder.length() > 0 && stringBuilder.charAt(stringBuilder.length() - 1) != ':') {
                stringBuilder.append("::");
            }
            stringBuilder.append(colon2Node.getName());
        } else if (node instanceof INameNode) {
            if (stringBuilder.length() > 0 && stringBuilder.charAt(stringBuilder.length() - 1) != ':') {
                stringBuilder.append("::");
            }
            stringBuilder.append(AstUtilities.getName(node));
        }
    }

    public static String getFqn(Colon2Node colon2Node) {
        StringBuilder stringBuilder = new StringBuilder();
        AstUtilities.addAncestorParents((Node)colon2Node, stringBuilder);
        return stringBuilder.toString();
    }

    public static String getSuperclass(ClassNode classNode) {
        StringBuilder stringBuilder = new StringBuilder();
        if (classNode.getSuperNode() != null) {
            AstUtilities.addAncestorParents(classNode.getSuperNode(), stringBuilder);
            return stringBuilder.toString();
        }
        return null;
    }

    public static String getFqnName(AstPath astPath) {
        StringBuilder stringBuilder = new StringBuilder();
        ListIterator<Node> listIterator = astPath.rootToLeaf();
        while (listIterator.hasNext()) {
            Colon3Node colon3Node;
            Node node = (Node)listIterator.next();
            if (!(node instanceof ModuleNode) && !(node instanceof ClassNode) || (colon3Node = ((IScopingNode)node).getCPath()) == null) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append("::");
            }
            if (colon3Node instanceof Colon2Node) {
                stringBuilder.append(AstUtilities.getFqn((Colon2Node)colon3Node));
                continue;
            }
            stringBuilder.append(colon3Node.getName());
        }
        return stringBuilder.toString();
    }

    public static boolean isAttr(Node node) {
        if (!(node instanceof FCallNode)) {
            return false;
        }
        String string = AstUtilities.getName(node);
        return string.startsWith("attr") && ("attr".equals(string) || "attr_reader".equals(string) || "attr_accessor".equals(string) || "attr_writer".equals(string) || "attr_internal".equals(string) || "attr_internal_reader".equals(string) || "attr_internal_writer".equals(string) || "attr_internal_accessor".equals(string));
    }

    public static SymbolNode[] getAttrSymbols(Node node) {
        assert (AstUtilities.isAttr(node));
        List list = node.childNodes();
        for (Node node2 : list) {
            if (!(node2 instanceof ListNode)) continue;
            List list2 = node2.childNodes();
            ArrayList<SymbolNode> arrayList = new ArrayList<SymbolNode>(list2.size());
            for (Node node3 : list2) {
                if (!(node3 instanceof SymbolNode)) continue;
                arrayList.add((SymbolNode)node3);
            }
            return arrayList.toArray(new SymbolNode[arrayList.size()]);
        }
        return new SymbolNode[0];
    }

    static Node getRoot(FileObject fileObject) {
        Source source = Source.create((FileObject)fileObject);
        final Node[] nodeArray = new Node[1];
        try {
            ParserManager.parse(Collections.singleton(source), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    Parser.Result result = resultIterator.getParserResult();
                    nodeArray[0] = AstUtilities.getRoot(result);
                }
            });
        }
        catch (ParseException parseException) {
            Exceptions.printStackTrace((Throwable)parseException);
        }
        return nodeArray[0];
    }

    public static Node getRoot(Parser.Result result) {
        if (!(result instanceof RubyParseResult)) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                String string = "Expected RubyParseResult, but got " + result;
                LOGGER.log(Level.WARNING, string, new Exception(string));
            }
            return null;
        }
        RubyParseResult rubyParseResult = (RubyParseResult)result;
        return rubyParseResult.getRootNode();
    }

    public static void findPrivateMethods(Node node, Set<Node> set, Set<Node> set2) {
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        HashSet<String> hashSet3 = new HashSet<String>();
        HashSet<Node> hashSet4 = new HashSet<Node>();
        List list = node.childNodes();
        Modifier modifier = Modifier.PUBLIC;
        for (Node object : list) {
            if (object.isInvisible()) continue;
            modifier = AstUtilities.getMethodAccess(object, modifier, hashSet, hashSet2, hashSet3, hashSet4, set, set2);
        }
        hashSet3.removeAll(hashSet);
        hashSet2.removeAll(hashSet);
        for (String string : hashSet3) {
            for (Node node2 : hashSet4) {
                if (!string.equals(AstUtilities.getDefName(node2))) continue;
                set2.add(node2);
            }
        }
        for (String string : hashSet2) {
            for (Node node2 : hashSet4) {
                if (!string.equals(AstUtilities.getDefName(node2))) continue;
                set.add(node2);
            }
        }
    }

    private static Modifier getMethodAccess(Node node, Modifier modifier, Set<String> set, Set<String> set2, Set<String> set3, Set<Node> set4, Set<Node> set5, Set<Node> set6) {
        if (node instanceof MethodDefNode) {
            if (modifier == Modifier.PRIVATE) {
                set6.add(node);
            } else if (modifier == Modifier.PUBLIC) {
                set4.add(node);
            } else if (modifier == Modifier.PROTECTED) {
                set5.add(node);
            }
            return modifier;
        }
        if (node instanceof VCallNode || node instanceof FCallNode) {
            String string = AstUtilities.getName(node);
            if ("private".equals(string)) {
                if (Arity.callHasArguments(node)) {
                    List list = node.childNodes();
                    for (Node node2 : list) {
                        if (!(node2 instanceof ListNode)) continue;
                        List list2 = node2.childNodes();
                        for (Node node3 : list2) {
                            if (!(node3 instanceof SymbolNode)) continue;
                            String string2 = AstUtilities.getName(node3);
                            set3.add(string2);
                        }
                    }
                } else {
                    modifier = Modifier.PRIVATE;
                }
                return modifier;
            }
            if ("protected".equals(string)) {
                if (Arity.callHasArguments(node)) {
                    List list = node.childNodes();
                    for (Node node4 : list) {
                        if (!(node4 instanceof ListNode)) continue;
                        List list3 = node4.childNodes();
                        for (Node node5 : list3) {
                            if (!(node5 instanceof SymbolNode)) continue;
                            String string3 = AstUtilities.getName(node5);
                            set2.add(string3);
                        }
                    }
                } else {
                    modifier = Modifier.PROTECTED;
                }
                return modifier;
            }
            if ("public".equals(string)) {
                if (!Arity.callHasArguments(node)) {
                    modifier = Modifier.PUBLIC;
                    return modifier;
                }
                List list = node.childNodes();
                for (Node node6 : list) {
                    if (!(node6 instanceof ListNode)) continue;
                    List list4 = node6.childNodes();
                    for (Node node7 : list4) {
                        if (!(node7 instanceof SymbolNode)) continue;
                        String string4 = AstUtilities.getName(node7);
                        set.add(string4);
                    }
                }
            }
            return modifier;
        }
        if (node instanceof ClassNode || node instanceof ModuleNode) {
            return modifier;
        }
        List list = node.childNodes();
        for (Node node8 : list) {
            if (node8.isInvisible()) continue;
            modifier = AstUtilities.getMethodAccess(node8, modifier, set, set2, set3, set4, set5, set6);
        }
        return modifier;
    }

    public static String getMethodName(FileObject fileObject, final int n) {
        Source source = Source.create((FileObject)fileObject);
        if (source == null) {
            return null;
        }
        final String[] stringArray = new String[1];
        try {
            ParserManager.parse(Collections.singleton(source), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    BaseDocument baseDocument;
                    Parser.Result result = resultIterator.getParserResult();
                    Node node = AstUtilities.getRoot(result);
                    if (node == null) {
                        return;
                    }
                    int n3 = AstUtilities.getAstOffset(result, n);
                    if (n3 == -1) {
                        return;
                    }
                    MethodDefNode methodDefNode = AstUtilities.findMethodAtOffset(node, n3);
                    if (methodDefNode == null && (baseDocument = RubyUtils.getDocument(result)) != null) {
                        try {
                            int n2 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n);
                            if (n2 != n) {
                                n3 = AstUtilities.getAstOffset(result, n2);
                                if (n3 == -1) {
                                    return;
                                }
                                methodDefNode = AstUtilities.findMethodAtOffset(node, n3);
                            }
                        }
                        catch (BadLocationException badLocationException) {
                            Exceptions.printStackTrace((Throwable)badLocationException);
                        }
                    }
                    if (methodDefNode != null) {
                        stringArray[0] = methodDefNode.getName();
                    }
                }
            });
        }
        catch (ParseException parseException) {
            Exceptions.printStackTrace((Throwable)parseException);
        }
        return stringArray[0];
    }

    public static String getTestName(FileObject fileObject, final int n) {
        Source source = Source.create((FileObject)fileObject);
        if (source == null) {
            return null;
        }
        final String[] stringArray = new String[1];
        try {
            ParserManager.parse(Collections.singleton(source), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    try {
                        Object object;
                        int n4;
                        Parser.Result result = resultIterator.getParserResult();
                        Node node = AstUtilities.getRoot(result);
                        if (node == null) {
                            return;
                        }
                        BaseDocument baseDocument = RubyUtils.getDocument(result, true);
                        if (baseDocument == null) {
                            return;
                        }
                        int n2 = n;
                        int n3 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n2);
                        if (n3 != -1 && n2 <= n3) {
                            n2 = n3 + 1;
                        }
                        if ((n4 = AstUtilities.getAstOffset(result, n2)) == -1) {
                            return;
                        }
                        AstPath astPath = new AstPath(node, n4);
                        ListIterator<Node> listIterator = astPath.leafToRoot();
                        ArrayList arrayList = new ArrayList();
                        boolean bl = true;
                        while (listIterator.hasNext()) {
                            Object object2;
                            object = (Node)listIterator.next();
                            if (object.getNodeType() == NodeType.FCALLNODE) {
                                String string;
                                object2 = (FCallNode)object;
                                if ("test".equals(object2.getName())) {
                                    string = AstUtilities.getNodeDesc(object2);
                                    if (string != null) {
                                        stringArray[0] = "test_" + string.replace(' ', '_');
                                    }
                                    return;
                                }
                                if ("should".equals(object2.getName())) {
                                    AstUtilities.buildShouldaMethod(" should " + AstUtilities.getNodeDesc(object2), arrayList, false);
                                    continue;
                                }
                                if (!"context".equals(object2.getName())) continue;
                                string = AstUtilities.getNodeDesc(object2);
                                if (string != null) {
                                    bl = false;
                                }
                                AstUtilities.buildShouldaMethod(string, arrayList, true);
                                continue;
                            }
                            if (object.getNodeType() == NodeType.CLASSNODE && bl) {
                                object2 = AstUtilities.getClassNameForShoulda((IScopingNode)object);
                                AstUtilities.buildShouldaMethod((String)object2, arrayList, false);
                                continue;
                            }
                            if (object.getNodeType() != NodeType.DEFNNODE && object.getNodeType() != NodeType.DEFSNODE) continue;
                            stringArray[0] = AstUtilities.getName((Node)object);
                            return;
                        }
                        if (!arrayList.isEmpty()) {
                            object = new StringBuilder();
                            for (String string : arrayList) {
                                ((StringBuilder)object).append(string);
                            }
                            stringArray[0] = AstUtilities.removeLeadingWhiteSpace(((StringBuilder)object).toString());
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        Exceptions.printStackTrace((Throwable)badLocationException);
                    }
                }
            });
        }
        catch (ParseException parseException) {
            Exceptions.printStackTrace((Throwable)parseException);
        }
        return stringArray[0];
    }

    private static String removeLeadingWhiteSpace(String string) {
        if (string.startsWith(" ")) {
            return string.substring(1);
        }
        return string;
    }

    private static String getClassNameForShoulda(IScopingNode iScopingNode) {
        String string = AstUtilities.getClassOrModuleName(iScopingNode);
        if (string != null && string.indexOf("Test") != -1) {
            return string.substring(0, string.indexOf("Test"));
        }
        return null;
    }

    private static void buildShouldaMethod(String string, List<String> list, boolean bl) {
        if (string == null) {
            return;
        }
        if (bl) {
            string = string.trim();
        }
        if (list.isEmpty()) {
            list.add(string);
        } else {
            list.add(0, " " + string);
        }
    }

    private static String getNodeDesc(FCallNode fCallNode) {
        if (fCallNode.getIterNode() == null) {
            return null;
        }
        Node node = fCallNode.getArgsNode();
        if (node instanceof ListNode) {
            ListNode listNode = (ListNode)node;
            int n = listNode.size();
            for (int i = 0; i < n; ++i) {
                Node node2 = listNode.get(i);
                if (!(node2 instanceof StrNode)) continue;
                String string = ((StrNode)node2).getValue();
                if (string == null || string.length() <= 0) break;
                return string.toString();
            }
        }
        return null;
    }

    public static int findOffset(FileObject fileObject, final String string) {
        Source source = Source.create((FileObject)fileObject);
        if (source == null) {
            return -1;
        }
        final int[] nArray = new int[]{-1};
        try {
            ParserManager.parse(Collections.singleton(source), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    Parser.Result result = resultIterator.getParserResult();
                    Node node = AstUtilities.getRoot(result);
                    if (node == null) {
                        return;
                    }
                    MethodDefNode methodDefNode = AstUtilities.findMethod(node, string, Arity.UNKNOWN);
                    if (methodDefNode != null) {
                        int n;
                        nArray[0] = n = methodDefNode.getPosition().getStartOffset();
                    }
                }
            });
        }
        catch (ParseException parseException) {
            Exceptions.printStackTrace((Throwable)parseException);
        }
        return nArray[0];
    }

    public static void addNodesByType(Node node, NodeType[] nodeTypeArray, List<Node> list) {
        for (int i = 0; i < nodeTypeArray.length; ++i) {
            if (node.getNodeType() != nodeTypeArray[i]) continue;
            list.add(node);
            break;
        }
        List list2 = node.childNodes();
        for (Node node2 : list2) {
            if (node2.isInvisible()) continue;
            AstUtilities.addNodesByType(node2, nodeTypeArray, list);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static List<Node> getApplicableBlocks(AstPath astPath, boolean bl) {
        Node node = AstUtilities.findBlock(astPath);
        if (node == null && (node = astPath.leafParent()) == null) {
            return Collections.emptyList();
        }
        ArrayList<Node> arrayList = new ArrayList<Node>();
        ListIterator<Node> listIterator = astPath.leafToRoot();
        if (bl && listIterator.hasNext()) {
            listIterator.next();
        }
        Node node2 = astPath.root();
        block4: while (listIterator.hasNext()) {
            Node node3 = (Node)listIterator.next();
            switch (node3.getNodeType()) {
                case ITERNODE: {
                    node2 = node3;
                    arrayList.add(node3);
                    break;
                }
                case DEFNNODE: 
                case DEFSNODE: 
                case CLASSNODE: 
                case SCLASSNODE: 
                case MODULENODE: {
                    node2 = node3;
                    break block4;
                }
            }
        }
        if (bl) {
            AstUtilities.addNodesByType(node2, new NodeType[]{NodeType.ITERNODE}, arrayList);
        }
        return arrayList;
    }

    public static String guessName(Parser.Result result, OffsetRange offsetRange, OffsetRange offsetRange2) {
        String string = "";
        IndexedMethod[] indexedMethodArray = new IndexedMethod[1];
        Set[] setArray = new Set[1];
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        if (!RubyMethodCompleter.computeMethodCall(result, offsetRange.getStart(), offsetRange2.getStart(), indexedMethodArray, nArray, nArray2, setArray, QuerySupport.Kind.PREFIX)) {
            return string;
        }
        IndexedMethod indexedMethod = indexedMethodArray[0];
        int n = nArray[0];
        List<String> list = indexedMethod.getParameters();
        if (list == null || list.size() <= n) {
            return string;
        }
        String string2 = list.get(n);
        if (string2.startsWith("*") || string2.startsWith("&")) {
            string2 = string2.substring(1);
        }
        return string2;
    }

    public static Set<String> getUsedFields(RubyIndex rubyIndex, AstPath astPath) {
        String string = AstUtilities.getFqnName(astPath);
        if (string == null || string.length() == 0) {
            return Collections.emptySet();
        }
        Set<IndexedField> set = rubyIndex.getInheritedFields(string, "", QuerySupport.Kind.PREFIX, false);
        HashSet<String> hashSet = new HashSet<String>();
        for (IndexedField indexedField : set) {
            hashSet.add(indexedField.getName());
        }
        return hashSet;
    }

    public static Set<String> getUsedMethods(RubyIndex rubyIndex, AstPath astPath) {
        String string = AstUtilities.getFqnName(astPath);
        if (string == null || string.length() == 0) {
            return Collections.emptySet();
        }
        Set<IndexedMethod> set = rubyIndex.getInheritedMethods(string, "", QuerySupport.Kind.PREFIX);
        HashSet<String> hashSet = new HashSet<String>();
        for (IndexedMethod indexedMethod : set) {
            hashSet.add(indexedMethod.getName());
        }
        return hashSet;
    }

    public static Set<String> getUsedConstants(RubyIndex rubyIndex, AstPath astPath) {
        return Collections.emptySet();
    }

    public static Set<String> getUsedLocalNames(AstPath astPath, Node node) {
        Node node2 = AstUtilities.findLocalScope(node, astPath);
        HashMap<String, Node> hashMap = new HashMap<String, Node>();
        RubyCodeCompleter.addLocals(node2, hashMap);
        List<Node> list = AstUtilities.getApplicableBlocks(astPath, false);
        for (Node node3 : list) {
            RubyCodeCompleter.addDynamic(node3, hashMap);
        }
        return hashMap.keySet();
    }

    public static String getName(Node node) {
        return ((INameNode)node).getName();
    }

    public static void findExitPoints(MethodDefNode methodDefNode, Set<? super Node> set) {
        Node node = methodDefNode.getBodyNode();
        if (node != null) {
            AstUtilities.findNonLastExitPoints(node, set);
            Node node2 = AstUtilities.findLastNode(node);
            if (node2 != null) {
                set.add((Node)node2);
            }
        }
    }

    private static Node findLastNode(Node node) {
        Node node2 = null;
        List list = node.childNodes();
        int n = list.size() - 1;
        if (n >= 0) {
            node2 = (Node)list.get(n);
            if (node2 instanceof ArgsNode || node2 instanceof ArgumentNode) {
                return null;
            }
            if (node2 instanceof ListNode) {
                node2 = (Node)node2.childNodes().get(node2.childNodes().size() - 1);
            }
            if (node2 instanceof NewlineNode && node2.childNodes().size() > 0) {
                node2 = (Node)node2.childNodes().get(node2.childNodes().size() - 1);
            }
        }
        return node2;
    }

    private static void findNonLastExitPoints(Node node, Set<? super Node> set) {
        Object object;
        switch (node.getNodeType()) {
            case RETURNNODE: 
            case YIELDNODE: {
                set.add((Node)node);
                break;
            }
            case CLASSNODE: 
            case SCLASSNODE: 
            case MODULENODE: {
                return;
            }
            case FCALLNODE: {
                object = (FCallNode)node;
                if (!"fail".equals(object.getName()) && !"raise".equals(object.getName())) break;
                set.add((Node)node);
            }
        }
        if (node instanceof MethodDefNode) {
            return;
        }
        object = node.childNodes();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            Node node2 = (Node)iterator.next();
            if (node2.isInvisible()) continue;
            AstUtilities.findNonLastExitPoints(node2, set);
        }
    }
}

