/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.java.RetoucheUtils;
import org.netbeans.modules.refactoring.java.SourceUtilsEx;
import org.netbeans.modules.refactoring.java.plugins.MoveRefactoringPlugin;
import org.netbeans.modules.refactoring.java.spi.RefactoringVisitor;
import org.netbeans.modules.refactoring.java.spi.ToPhaseException;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class MoveTransformer
extends RefactoringVisitor {
    private FileObject originalFolder;
    private MoveRefactoringPlugin move;
    private Set<Element> elementsToImport;
    private Set<ImportTree> importToRemove;
    private boolean isThisFileMoving;
    private boolean isThisFileReferencingOldPackage = false;
    private Set<Element> elementsAlreadyImported;
    private Problem problem;
    private boolean moveToDefaulPackageProblem = false;
    private String originalPackage;
    private SourceUtilsEx.Cache cacheOfSrcFiles = new SourceUtilsEx.Cache();
    private final Set<ElementHandle> classes2Move;

    public Problem getProblem() {
        return this.problem;
    }

    public MoveTransformer(MoveRefactoringPlugin moveRefactoringPlugin) {
        this.move = moveRefactoringPlugin;
        this.classes2Move = new HashSet<ElementHandle>(moveRefactoringPlugin.classes.values());
    }

    public void setWorkingCopy(WorkingCopy workingCopy) throws ToPhaseException {
        super.setWorkingCopy(workingCopy);
        this.originalFolder = this.workingCopy.getFileObject().getParent();
        this.originalPackage = RetoucheUtils.getPackageName(this.originalFolder);
        this.isThisFileMoving = this.move.filesToMove.contains(this.workingCopy.getFileObject());
        this.elementsToImport = new HashSet<Element>();
        this.isThisFileReferencingOldPackage = false;
        this.elementsAlreadyImported = new HashSet<Element>();
        this.importToRemove = new HashSet<ImportTree>();
    }

    public Tree visitMemberSelect(MemberSelectTree memberSelectTree, Element element) {
        if (!this.workingCopy.getTreeUtilities().isSynthetic(this.getCurrentPath())) {
            Element element2 = this.workingCopy.getTrees().getElement(this.getCurrentPath());
            if (element2 != null) {
                if (this.isElementMoving(element2)) {
                    this.elementsAlreadyImported.add(element2);
                    String string = this.getTargetPackageName(element2);
                    if (!"".equals(string)) {
                        MemberSelectTree memberSelectTree2 = this.make.MemberSelect((ExpressionTree)this.make.Identifier((CharSequence)string), element2);
                        this.rewrite(memberSelectTree, memberSelectTree2);
                    } else if (!this.moveToDefaulPackageProblem) {
                        this.problem = MoveTransformer.createProblem(this.problem, false, NbBundle.getMessage(MoveTransformer.class, (String)"ERR_MovingClassToDefaultPackage"));
                        this.moveToDefaulPackageProblem = true;
                    }
                } else if (this.isThisFileMoving) {
                    if (element2.getKind() != ElementKind.PACKAGE && this.getPackageOf(element2).toString().equals(this.originalPackage) && !element2.getModifiers().contains((Object)Modifier.PUBLIC) && !element2.getModifiers().contains((Object)Modifier.PROTECTED) && !this.move.filesToMove.contains(this.getFileObject(element2))) {
                        this.problem = MoveTransformer.createProblem(this.problem, false, NbBundle.getMessage(MoveTransformer.class, (String)"ERR_AccessesPackagePrivateFeature2", (Object)this.workingCopy.getFileObject().getName(), (Object)element2, (Object)this.getTypeElement(element2).getSimpleName()));
                    }
                } else if (element2.getKind() != ElementKind.PACKAGE && this.getPackageOf(element2).toString().equals(this.originalPackage) && !element2.getModifiers().contains((Object)Modifier.PUBLIC) && !element2.getModifiers().contains((Object)Modifier.PROTECTED) && this.move.filesToMove.contains(this.getFileObject(element2))) {
                    this.problem = MoveTransformer.createProblem(this.problem, false, NbBundle.getMessage(MoveTransformer.class, (String)"ERR_AccessesPackagePrivateFeature", (Object)this.workingCopy.getFileObject().getName(), (Object)element2, (Object)this.getTypeElement(element2).getSimpleName()));
                }
            } else if (this.isPackageRename() && "*".equals(memberSelectTree.getIdentifier().toString())) {
                ExpressionTree expressionTree = memberSelectTree.getExpression();
                TreePath treePath = this.workingCopy.getTrees().getPath(this.workingCopy.getCompilationUnit(), expressionTree);
                Element element3 = this.workingCopy.getTrees().getElement(treePath);
                if (element3 != null && element3.getKind() == ElementKind.PACKAGE && this.isThisPackageMoving((PackageElement)element3)) {
                    String string = this.getTargetPackageName(element3);
                    MemberSelectTree memberSelectTree3 = this.make.MemberSelect((ExpressionTree)this.make.Identifier((CharSequence)string), (CharSequence)"*");
                    this.rewrite(memberSelectTree, memberSelectTree3);
                }
            }
        }
        return (Tree)super.visitMemberSelect(memberSelectTree, element);
    }

    public Tree visitIdentifier(IdentifierTree identifierTree, Element element) {
        Element element2;
        if (!this.workingCopy.getTreeUtilities().isSynthetic(this.getCurrentPath()) && (element2 = this.workingCopy.getTrees().getElement(this.getCurrentPath())) != null) {
            if (!this.isThisFileMoving) {
                if (this.isElementMoving(element2)) {
                    if (!this.elementsAlreadyImported.contains(element2)) {
                        String string = this.getTargetPackageName(element2);
                        if (!RetoucheUtils.getPackageName(this.workingCopy.getCompilationUnit()).equals(string)) {
                            this.elementsToImport.add(element2);
                        }
                    }
                } else if (element2.getKind() != ElementKind.PACKAGE && !element2.getModifiers().contains((Object)Modifier.PUBLIC) && !element2.getModifiers().contains((Object)Modifier.PROTECTED) && this.getPackageOf(element2).toString().equals(this.originalPackage) && this.move.filesToMove.contains(this.getFileObject(element2))) {
                    this.problem = MoveTransformer.createProblem(this.problem, false, NbBundle.getMessage(MoveTransformer.class, (String)"ERR_AccessesPackagePrivateFeature", (Object)this.workingCopy.getFileObject().getName(), (Object)element2, (Object)this.getTypeElement(element2).getSimpleName()));
                }
            } else {
                Boolean[] booleanArray = new Boolean[1];
                if (!this.isThisFileReferencingOldPackage && this.isTopLevelClass(element2) && !this.isElementMoving(element2, booleanArray) && this.getPackageOf(element2).toString().equals(this.originalPackage)) {
                    this.isThisFileReferencingOldPackage = true;
                }
                if (!(element2.getKind() == ElementKind.PACKAGE || element2.getModifiers().contains((Object)Modifier.PUBLIC) || element2.getModifiers().contains((Object)Modifier.PROTECTED) || this.isElementMoving(element2, booleanArray) || !this.getPackageOf(element2).toString().equals(this.originalPackage) || this.move.filesToMove.contains(this.getFileObject(element2)))) {
                    this.problem = MoveTransformer.createProblem(this.problem, false, NbBundle.getMessage(MoveTransformer.class, (String)"ERR_AccessesPackagePrivateFeature2", (Object)this.workingCopy.getFileObject().getName(), (Object)element2, (Object)this.getTypeElement(element2).getSimpleName()));
                }
            }
        }
        return (Tree)super.visitIdentifier(identifierTree, element);
    }

    private FileObject getFileObject(Element element) {
        return SourceUtilsEx.getFile(element, this.workingCopy.getClasspathInfo(), this.cacheOfSrcFiles);
    }

    private boolean isThisPackageMoving(PackageElement packageElement) {
        return this.move.packages.contains(packageElement.getQualifiedName().toString());
    }

    private String getTargetPackageName(Element element) {
        return this.move.getTargetPackageName(this.getFileObject(element));
    }

    private TypeElement getTypeElement(Element element) {
        TypeElement typeElement = this.workingCopy.getElementUtilities().enclosingTypeElement(element);
        if (typeElement == null && element instanceof TypeElement) {
            return (TypeElement)element;
        }
        return typeElement;
    }

    static final Problem createProblem(Problem problem, boolean bl, String string) {
        Problem problem2 = new Problem(bl, string);
        if (problem == null) {
            return problem2;
        }
        problem2.setNext(problem);
        return problem2;
    }

    private PackageElement getPackageOf(Element element) {
        while (element.getKind() != ElementKind.PACKAGE) {
            element = element.getEnclosingElement();
        }
        return (PackageElement)element;
    }

    private boolean isPackageRename() {
        return this.move.isRenameRefactoring;
    }

    private boolean isThisFileReferencedbyOldPackage() {
        HashSet hashSet = new HashSet(this.move.whoReferences.get(this.workingCopy.getFileObject()));
        hashSet.removeAll(this.move.filesToMove);
        for (FileObject fileObject : hashSet) {
            if (!fileObject.getParent().equals(this.originalFolder)) continue;
            return true;
        }
        return false;
    }

    private boolean isElementMoving(Element element, Boolean[] booleanArray) {
        if (booleanArray[0] == null) {
            booleanArray[0] = this.isElementMoving(element);
        }
        return booleanArray[0];
    }

    private boolean isElementMoving(Element element) {
        ElementKind elementKind = element.getKind();
        if (!elementKind.isClass() && !elementKind.isInterface()) {
            return false;
        }
        ElementHandle elementHandle = ElementHandle.create((Element)element);
        return this.classes2Move.contains(elementHandle);
    }

    private boolean isTopLevelClass(Element element) {
        return (element.getKind().isClass() || element.getKind().isInterface()) && element.getEnclosingElement().getKind() == ElementKind.PACKAGE;
    }

    public Tree visitCompilationUnit(CompilationUnitTree compilationUnitTree, Element element) {
        Iterator<Element> iterator;
        Tree tree = (Tree)super.visitCompilationUnit(compilationUnitTree, element);
        if (this.workingCopy.getTreeUtilities().isSynthetic(this.getCurrentPath())) {
            return tree;
        }
        CompilationUnitTree compilationUnitTree2 = compilationUnitTree;
        Object object = compilationUnitTree2.getImports();
        if (!this.importToRemove.isEmpty()) {
            iterator = new ArrayList<ImportTree>((Collection<? extends ImportTree>)object);
            iterator.removeAll(this.importToRemove);
            object = iterator;
        }
        if (this.isThisFileMoving) {
            iterator = this.move.getTargetPackageName(this.workingCopy.getFileObject());
            if (compilationUnitTree.getPackageName() != null && !"".equals(iterator)) {
                if (this.importToRemove.isEmpty()) {
                    this.rewrite(compilationUnitTree.getPackageName(), this.make.Identifier(iterator));
                } else {
                    compilationUnitTree2 = this.make.CompilationUnit((ExpressionTree)this.make.Identifier(iterator), (List)object, compilationUnitTree.getTypeDecls(), compilationUnitTree.getSourceFile());
                }
            } else {
                compilationUnitTree2 = this.make.CompilationUnit((ExpressionTree)("".equals(iterator) ? null : this.make.Identifier(iterator)), (List)object, compilationUnitTree.getTypeDecls(), compilationUnitTree.getSourceFile());
            }
            if (this.isThisFileReferencingOldPackage) {
                ExpressionTree object2 = compilationUnitTree2.getPackageName();
                if (object2 != null) {
                    compilationUnitTree2 = this.insertImport(compilationUnitTree2, object2.toString() + ".*", null, null);
                } else if (!this.moveToDefaulPackageProblem) {
                    this.problem = MoveTransformer.createProblem(this.problem, false, NbBundle.getMessage(MoveTransformer.class, (String)"ERR_MovingClassToDefaultPackage"));
                    this.moveToDefaulPackageProblem = true;
                }
            }
        } else if (!this.importToRemove.isEmpty()) {
            compilationUnitTree2 = this.make.CompilationUnit(compilationUnitTree.getPackageName(), (List)object, compilationUnitTree.getTypeDecls(), compilationUnitTree.getSourceFile());
        }
        for (Element element2 : this.elementsToImport) {
            String string = this.getTargetPackageName(element2);
            if ("".equals(string)) continue;
            compilationUnitTree2 = this.insertImport(compilationUnitTree2, string + "." + element2.getSimpleName(), element2, string);
        }
        this.rewrite(compilationUnitTree, compilationUnitTree2);
        return tree;
    }

    private CompilationUnitTree insertImport(CompilationUnitTree compilationUnitTree, String string, Element element, String string2) {
        for (ImportTree importTree : compilationUnitTree.getImports()) {
            if (importTree.getQualifiedIdentifier().toString().equals(string)) {
                return compilationUnitTree;
            }
            if (element == null || !importTree.getQualifiedIdentifier().toString().equals(this.getPackageOf(element).getQualifiedName() + ".*") || !this.isPackageRename()) continue;
            this.rewrite(importTree.getQualifiedIdentifier(), this.make.Identifier((CharSequence)(string2 + ".*")));
            return compilationUnitTree;
        }
        CompilationUnitTree compilationUnitTree2 = this.make.insertCompUnitImport(compilationUnitTree, 0, this.make.Import((Tree)this.make.Identifier((CharSequence)string), false));
        return compilationUnitTree2;
    }

    public Tree visitImport(ImportTree importTree, Element element) {
        String string;
        String string2;
        Element element2;
        if (!this.workingCopy.getTreeUtilities().isSynthetic(this.getCurrentPath()) && (element2 = this.workingCopy.getTrees().getElement(new TreePath(this.getCurrentPath(), importTree.getQualifiedIdentifier()))) != null && this.isElementMoving(element2) && !"".equals(string2 = this.getTargetPackageName(element2)) && (string = RetoucheUtils.getPackageName(this.workingCopy.getCompilationUnit())).equals(string2)) {
            this.importToRemove.add(importTree);
            return importTree;
        }
        return (Tree)super.visitImport(importTree, element);
    }
}

