/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.net.URL;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TypeMirrorHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.java.RetoucheUtils;
import org.netbeans.modules.refactoring.java.api.ExtractInterfaceRefactoring;
import org.netbeans.modules.refactoring.java.plugins.JavaPluginUtils;
import org.netbeans.modules.refactoring.java.plugins.RetoucheCommit;
import org.netbeans.modules.refactoring.java.spi.DiffElement;
import org.netbeans.modules.refactoring.java.spi.JavaRefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.Transaction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.PositionBounds;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExtractInterfaceRefactoringPlugin
extends JavaRefactoringPlugin {
    private final ExtractInterfaceRefactoring refactoring;
    private String pkgName;
    private ElementHandle<TypeElement> classHandle;

    ExtractInterfaceRefactoringPlugin(ExtractInterfaceRefactoring extractInterfaceRefactoring) {
        this.refactoring = extractInterfaceRefactoring;
    }

    @Override
    public Problem fastCheckParameters() {
        FileObject[] fileObjectArray;
        Problem problem = null;
        String string = this.refactoring.getInterfaceName();
        if (!Utilities.isJavaIdentifier((String)string)) {
            problem = ExtractInterfaceRefactoringPlugin.createProblem(problem, true, NbBundle.getMessage(ExtractInterfaceRefactoringPlugin.class, (String)"ERR_InvalidIdentifier", (Object)string));
            return problem;
        }
        FileObject fileObject = this.refactoring.getSourceType().getFileObject();
        FileObject fileObject2 = fileObject.getParent();
        for (FileObject fileObject3 : fileObjectArray = fileObject2.getChildren()) {
            if (fileObject3.isVirtual() || !fileObject3.getName().equals(string) || !"java".equals(fileObject3.getExt())) continue;
            problem = ExtractInterfaceRefactoringPlugin.createProblem(problem, true, NbBundle.getMessage(ExtractInterfaceRefactoringPlugin.class, (String)"ERR_ClassClash", (Object)string, (Object)this.pkgName));
            return problem;
        }
        return null;
    }

    public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
        FileObject fileObject = this.refactoring.getSourceType().getFileObject();
        try {
            refactoringElementsBag.add((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)new CreateInterfaceElement(this.refactoring, fileObject.getParent(), this.classHandle));
            UpdateClassTask.create(refactoringElementsBag, fileObject, this.refactoring, this.classHandle);
        }
        catch (IOException iOException) {
            throw (RuntimeException)new RuntimeException().initCause(iOException);
        }
        return null;
    }

    @Override
    protected JavaSource getJavaSource(JavaRefactoringPlugin.Phase phase) {
        return JavaSource.forFileObject((FileObject)this.refactoring.getSourceType().getFileObject());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Problem preCheck(CompilationController compilationController) throws IOException {
        this.fireProgressListenerStart(1, 1);
        compilationController.toPhase(JavaSource.Phase.RESOLVED);
        try {
            TreePathHandle treePathHandle = this.refactoring.getSourceType();
            Problem problem = ExtractInterfaceRefactoringPlugin.isElementAvail(treePathHandle, (CompilationInfo)compilationController);
            if (problem != null) {
                Problem problem2 = problem;
                return problem2;
            }
            Element element = treePathHandle.resolveElement((CompilationInfo)compilationController);
            problem = JavaPluginUtils.isSourceElement(element, (CompilationInfo)compilationController);
            if (problem != null) {
                Problem problem3 = problem;
                return problem3;
            }
            if (element == null || element.getKind() != ElementKind.CLASS && element.getKind() != ElementKind.INTERFACE && element.getKind() != ElementKind.ENUM) {
                Problem problem4 = new Problem(true, NbBundle.getMessage(ExtractInterfaceRefactoringPlugin.class, (String)"ERR_ElementNotAvailable"));
                return problem4;
            }
            this.classHandle = ElementHandle.create((Element)((TypeElement)element));
            PackageElement packageElement = (PackageElement)compilationController.getElementUtilities().outermostTypeElement(element).getEnclosingElement();
            this.pkgName = packageElement.getQualifiedName().toString();
            this.fireProgressListenerStep();
            Problem problem5 = null;
            return problem5;
        }
        finally {
            this.fireProgressListenerStop();
        }
    }

    @Override
    protected Problem checkParameters(CompilationController compilationController) throws IOException {
        Set<Modifier> set;
        Element element;
        if (this.refactoring.getMethods().isEmpty() && this.refactoring.getFields().isEmpty() && this.refactoring.getImplements().isEmpty()) {
            return new Problem(true, NbBundle.getMessage(ExtractInterfaceRefactoringPlugin.class, (String)"ERR_ExtractInterface_MembersNotAvailable"));
        }
        compilationController.toPhase(JavaSource.Phase.RESOLVED);
        TypeElement typeElement = (TypeElement)this.refactoring.getSourceType().resolveElement((CompilationInfo)compilationController);
        assert (typeElement != null);
        HashSet<? extends Element> hashSet = new HashSet<Element>(typeElement.getEnclosedElements());
        for (ElementHandle<ExecutableElement> elementHandle : this.refactoring.getMethods()) {
            element = (ExecutableElement)elementHandle.resolve((CompilationInfo)compilationController);
            if (element == null) {
                return new Problem(true, NbBundle.getMessage(ExtractInterfaceRefactoringPlugin.class, (String)"ERR_ElementNotAvailable"));
            }
            if (compilationController.getElementUtilities().isSynthetic(element) || element.getKind() != ElementKind.METHOD) {
                return new Problem(true, NbBundle.getMessage(ExtractInterfaceRefactoringPlugin.class, (String)"ERR_ExtractInterface_UnknownMember", (Object)element.toString()));
            }
            if (!hashSet.contains(element)) {
                return new Problem(true, NbBundle.getMessage(ExtractInterfaceRefactoringPlugin.class, (String)"ERR_ExtractInterface_UnknownMember", (Object)element.toString()));
            }
            set = element.getModifiers();
            if (set.contains((Object)Modifier.PUBLIC) && !set.contains((Object)Modifier.STATIC)) continue;
            return new Problem(true, NbBundle.getMessage(ExtractInterfaceRefactoringPlugin.class, (String)"ERR_ExtractInterface_WrongModifiers", (Object)element.getSimpleName().toString()));
        }
        for (ElementHandle elementHandle : this.refactoring.getFields()) {
            VariableTree variableTree;
            element = (VariableElement)elementHandle.resolve((CompilationInfo)compilationController);
            if (element == null) {
                return new Problem(true, NbBundle.getMessage(ExtractInterfaceRefactoringPlugin.class, (String)"ERR_ElementNotAvailable"));
            }
            if (compilationController.getElementUtilities().isSynthetic(element) || element.getKind() != ElementKind.FIELD) {
                return new Problem(true, NbBundle.getMessage(ExtractInterfaceRefactoringPlugin.class, (String)"ERR_ExtractInterface_UnknownMember", (Object)element.toString()));
            }
            if (!hashSet.contains(element)) {
                return new Problem(true, NbBundle.getMessage(ExtractInterfaceRefactoringPlugin.class, (String)"ERR_ExtractInterface_UnknownMember", (Object)element.toString()));
            }
            set = element.getModifiers();
            if (set.contains((Object)Modifier.PUBLIC) && set.contains((Object)Modifier.STATIC) && set.contains((Object)Modifier.FINAL) && (variableTree = (VariableTree)compilationController.getTrees().getTree(element)).getInitializer() != null) continue;
            return new Problem(true, NbBundle.getMessage(ExtractInterfaceRefactoringPlugin.class, (String)"ERR_ExtractInterface_WrongModifiers", (Object)element.getSimpleName().toString()));
        }
        return null;
    }

    private static List<TypeMirror> findUsedGenericTypes(ExtractInterfaceRefactoring extractInterfaceRefactoring, CompilationInfo compilationInfo, TypeElement typeElement) {
        AnnotatedConstruct annotatedConstruct;
        TypeMirrorHandle typeMirrorHandle;
        List<TypeMirror> list = RetoucheUtils.resolveTypeParamsAsTypes(typeElement.getTypeParameters());
        if (list.isEmpty()) {
            return list;
        }
        Types types = compilationInfo.getTypes();
        ArrayList<TypeMirror> arrayList = new ArrayList<TypeMirror>(list.size());
        Iterator<ElementHandle<ExecutableElement>> iterator = extractInterfaceRefactoring.getMethods().iterator();
        while (iterator.hasNext() && !list.isEmpty()) {
            typeMirrorHandle = iterator.next();
            annotatedConstruct = (ExecutableElement)typeMirrorHandle.resolve(compilationInfo);
            RetoucheUtils.findUsedGenericTypes(types, list, arrayList, annotatedConstruct.getReturnType());
            Iterator<? extends VariableElement> iterator2 = annotatedConstruct.getParameters().iterator();
            while (iterator2.hasNext() && !list.isEmpty()) {
                VariableElement variableElement = iterator2.next();
                RetoucheUtils.findUsedGenericTypes(types, list, arrayList, variableElement.asType());
            }
        }
        iterator = extractInterfaceRefactoring.getImplements().iterator();
        while (iterator.hasNext() && !list.isEmpty()) {
            typeMirrorHandle = (TypeMirrorHandle)iterator.next();
            annotatedConstruct = typeMirrorHandle.resolve(compilationInfo);
            RetoucheUtils.findUsedGenericTypes(types, list, arrayList, (TypeMirror)annotatedConstruct);
        }
        return arrayList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class UpdateClassTask
    implements CancellableTask<WorkingCopy> {
        private final ExtractInterfaceRefactoring refactoring;
        private final ElementHandle<TypeElement> sourceType;

        private UpdateClassTask(ExtractInterfaceRefactoring extractInterfaceRefactoring, ElementHandle<TypeElement> elementHandle) {
            this.sourceType = elementHandle;
            this.refactoring = extractInterfaceRefactoring;
        }

        public static void create(RefactoringElementsBag refactoringElementsBag, FileObject fileObject, ExtractInterfaceRefactoring extractInterfaceRefactoring, ElementHandle<TypeElement> elementHandle) throws IOException {
            JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
            ModificationResult modificationResult = javaSource.runModificationTask((Task)new UpdateClassTask(extractInterfaceRefactoring, elementHandle));
            List list = modificationResult.getDifferences(fileObject);
            for (ModificationResult.Difference difference : list) {
                refactoringElementsBag.add((AbstractRefactoring)extractInterfaceRefactoring, (RefactoringElementImplementation)DiffElement.create(difference, fileObject, modificationResult));
            }
            refactoringElementsBag.registerTransaction((Transaction)new RetoucheCommit(Collections.singletonList(modificationResult)));
        }

        public void cancel() {
        }

        /*
         * WARNING - void declaration
         */
        public void run(WorkingCopy workingCopy) throws Exception {
            void var11_15;
            List<Tree> list;
            Object object22;
            AbstractCollection abstractCollection;
            Tree tree2;
            workingCopy.toPhase(JavaSource.Phase.RESOLVED);
            TypeElement typeElement = (TypeElement)this.sourceType.resolve((CompilationInfo)workingCopy);
            assert (typeElement != null);
            ClassTree classTree = workingCopy.getTrees().getTree(typeElement);
            TreeMaker treeMaker = workingCopy.getTreeMaker();
            List list2 = ExtractInterfaceRefactoringPlugin.findUsedGenericTypes(this.refactoring, (CompilationInfo)workingCopy, typeElement);
            if (list2.isEmpty()) {
                tree2 = treeMaker.Identifier((CharSequence)this.refactoring.getInterfaceName());
            } else {
                abstractCollection = new ArrayList(list2.size());
                for (Object object22 : list2) {
                    list = treeMaker.Type((TypeMirror)object22);
                    abstractCollection.add((ExpressionTree)((Object)list));
                }
                tree2 = treeMaker.ParameterizedType((Tree)treeMaker.Identifier((CharSequence)this.refactoring.getInterfaceName()), abstractCollection);
            }
            abstractCollection = new HashSet();
            HashSet hashSet = new HashSet();
            abstractCollection.addAll(this.getFields2Remove((CompilationInfo)workingCopy, this.refactoring.getFields()));
            abstractCollection.addAll(this.getMethods2Remove((CompilationInfo)workingCopy, this.refactoring.getMethods(), typeElement));
            hashSet.addAll(this.getImplements2Remove((CompilationInfo)workingCopy, this.refactoring.getImplements(), typeElement));
            object22 = new ArrayList();
            for (Tree tree3 : classTree.getMembers()) {
                if (abstractCollection.contains(tree3)) continue;
                object22.add(tree3);
            }
            list = UpdateClassTask.resolveImplements(classTree.getImplementsClause(), hashSet, tree2);
            if (typeElement.getKind() == ElementKind.CLASS) {
                ClassTree classTree2 = treeMaker.Class(classTree.getModifiers(), (CharSequence)classTree.getSimpleName(), classTree.getTypeParameters(), classTree.getExtendsClause(), list, (List)object22);
            } else if (typeElement.getKind() == ElementKind.INTERFACE) {
                ClassTree classTree3 = treeMaker.Interface(classTree.getModifiers(), (CharSequence)classTree.getSimpleName(), classTree.getTypeParameters(), list, (List)object22);
            } else if (typeElement.getKind() == ElementKind.ENUM) {
                ClassTree classTree4 = treeMaker.Enum(classTree.getModifiers(), (CharSequence)classTree.getSimpleName(), list, (List)object22);
            } else {
                throw new IllegalStateException(classTree.toString());
            }
            workingCopy.rewrite((Tree)classTree, (Tree)var11_15);
        }

        private List<Tree> getFields2Remove(CompilationInfo compilationInfo, List<ElementHandle<VariableElement>> list) {
            if (list.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<Tree> arrayList = new ArrayList<Tree>(list.size());
            for (ElementHandle<VariableElement> elementHandle : list) {
                VariableElement variableElement = (VariableElement)elementHandle.resolve(compilationInfo);
                assert (variableElement != null);
                Tree tree = compilationInfo.getTrees().getTree(variableElement);
                assert (tree != null);
                arrayList.add(tree);
            }
            return arrayList;
        }

        private List<Tree> getMethods2Remove(CompilationInfo compilationInfo, List<ElementHandle<ExecutableElement>> list, TypeElement typeElement) {
            if (list.isEmpty()) {
                return Collections.emptyList();
            }
            boolean bl = typeElement.getKind() == ElementKind.INTERFACE;
            ArrayList<Tree> arrayList = new ArrayList<Tree>(list.size());
            for (ElementHandle<ExecutableElement> elementHandle : list) {
                ExecutableElement executableElement = (ExecutableElement)elementHandle.resolve(compilationInfo);
                assert (executableElement != null);
                if (!bl && !executableElement.getModifiers().contains((Object)Modifier.ABSTRACT)) continue;
                MethodTree methodTree = compilationInfo.getTrees().getTree(executableElement);
                assert (methodTree != null);
                arrayList.add(methodTree);
            }
            return arrayList;
        }

        private List<Tree> getImplements2Remove(CompilationInfo compilationInfo, List<TypeMirrorHandle<TypeMirror>> list, TypeElement typeElement) {
            Object object;
            if (list.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<TypeMirror> arrayList = new ArrayList<TypeMirror>(list.size());
            for (TypeMirrorHandle<TypeMirror> object22 : list) {
                object = object22.resolve(compilationInfo);
                arrayList.add((TypeMirror)object);
            }
            ClassTree classTree = compilationInfo.getTrees().getTree(typeElement);
            ArrayList<Tree> arrayList2 = new ArrayList<Tree>();
            object = compilationInfo.getTypes();
            block1: for (Tree tree : classTree.getImplementsClause()) {
                TreePath treePath = compilationInfo.getTrees().getPath(compilationInfo.getCompilationUnit(), tree);
                TypeMirror typeMirror = compilationInfo.getTrees().getTypeMirror(treePath);
                for (TypeMirror typeMirror2 : arrayList) {
                    if (!object.isSameType(typeMirror2, typeMirror)) continue;
                    arrayList2.add(tree);
                    continue block1;
                }
            }
            return arrayList2;
        }

        private static List<Tree> resolveImplements(List<? extends Tree> list, Set<Tree> set, Tree tree) {
            ArrayList<Tree> arrayList;
            if (list == null) {
                arrayList = new ArrayList<Tree>(1);
            } else {
                arrayList = new ArrayList(list.size() + 1);
                arrayList.addAll(list);
            }
            if (set != null && !set.isEmpty()) {
                arrayList.removeAll(set);
            }
            arrayList.add(tree);
            return arrayList;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CreateInterfaceElement
    extends SimpleRefactoringElementImplementation
    implements CancellableTask<WorkingCopy> {
        private final URL folderURL;
        private URL ifcURL;
        private final String ifcName;
        private final ExtractInterfaceRefactoring refactoring;
        private final ElementHandle<TypeElement> sourceType;

        private CreateInterfaceElement(ExtractInterfaceRefactoring extractInterfaceRefactoring, FileObject fileObject, ElementHandle<TypeElement> elementHandle) {
            this.refactoring = extractInterfaceRefactoring;
            this.folderURL = URLMapper.findURL((FileObject)fileObject, (int)0);
            this.ifcName = extractInterfaceRefactoring.getInterfaceName();
            this.sourceType = elementHandle;
        }

        public void performChange() {
            try {
                FileObject fileObject = URLMapper.findFileObject((URL)this.folderURL);
                if (fileObject == null) {
                    return;
                }
                FileObject fileObject2 = FileUtil.getConfigFile((String)"Templates/Classes/Interface.java");
                DataFolder dataFolder = (DataFolder)DataObject.find((FileObject)fileObject);
                DataObject dataObject = DataObject.find((FileObject)fileObject2);
                DataObject dataObject2 = dataObject.createFromTemplate(dataFolder, this.ifcName);
                this.ifcURL = URLMapper.findURL((FileObject)dataObject2.getPrimaryFile(), (int)0);
                this.refactoring.getContext().add((Object)dataObject2.getPrimaryFile());
                JavaSource javaSource = JavaSource.forFileObject((FileObject)dataObject2.getPrimaryFile());
                javaSource.runModificationTask((Task)this).commit();
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }

        public void undoChange() {
            FileObject fileObject = null;
            if (this.ifcURL != null) {
                fileObject = URLMapper.findFileObject((URL)this.ifcURL);
            }
            if (fileObject != null) {
                try {
                    fileObject.delete();
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        }

        public String getText() {
            return NbBundle.getMessage(ExtractInterfaceRefactoringPlugin.class, (String)"TXT_ExtractInterface_CreateIfc", (Object)this.ifcName);
        }

        public String getDisplayText() {
            return this.getText();
        }

        public FileObject getParentFile() {
            return URLMapper.findFileObject((URL)this.folderURL);
        }

        public PositionBounds getPosition() {
            return null;
        }

        public Lookup getLookup() {
            FileObject fileObject = this.ifcURL == null ? null : URLMapper.findFileObject((URL)this.ifcURL);
            return fileObject != null ? Lookups.singleton((Object)fileObject) : Lookup.EMPTY;
        }

        public void cancel() {
        }

        public void run(WorkingCopy workingCopy) throws Exception {
            Tree tree;
            Object object2;
            workingCopy.toPhase(JavaSource.Phase.RESOLVED);
            ClassTree classTree = this.findInterface((CompilationInfo)workingCopy, this.ifcName);
            TreeMaker treeMaker = workingCopy.getTreeMaker();
            GeneratorUtilities generatorUtilities = GeneratorUtilities.get((WorkingCopy)workingCopy);
            List list = ExtractInterfaceRefactoringPlugin.findUsedGenericTypes(this.refactoring, (CompilationInfo)workingCopy, (TypeElement)this.sourceType.resolve((CompilationInfo)workingCopy));
            ArrayList<TypeParameterTree> arrayList = new ArrayList<TypeParameterTree>(list.size());
            TypeElement typeElement = (TypeElement)this.sourceType.resolve((CompilationInfo)workingCopy);
            for (TypeParameterElement object42 : typeElement.getTypeParameters()) {
                TypeMirror typeMirror = object42.asType();
                for (Object object2 : list) {
                    if (!workingCopy.getTypes().isSameType(typeMirror, (TypeMirror)object2) || (tree = workingCopy.getTrees().getTree(object42)).getKind() != Tree.Kind.TYPE_PARAMETER) continue;
                    TypeParameterTree typeParameterTree = (TypeParameterTree)tree;
                    if (!typeParameterTree.getBounds().isEmpty()) {
                        typeParameterTree = (TypeParameterTree)generatorUtilities.importFQNs(tree);
                    }
                    arrayList.add(typeParameterTree);
                }
            }
            ArrayList arrayList2 = new ArrayList();
            for (ElementHandle<VariableElement> elementHandle : this.refactoring.getFields()) {
                VariableElement variableElement = (VariableElement)elementHandle.resolve((CompilationInfo)workingCopy);
                object2 = (VariableTree)workingCopy.getTrees().getTree(variableElement);
                tree = treeMaker.Variable(treeMaker.Modifiers(Collections.emptySet(), object2.getModifiers().getAnnotations()), (CharSequence)object2.getName(), object2.getType(), object2.getInitializer());
                tree = (VariableTree)generatorUtilities.importFQNs(tree);
                RetoucheUtils.copyJavadoc(variableElement, tree, workingCopy);
                arrayList2.add(tree);
            }
            for (ElementHandle<ExecutableElement> elementHandle : this.refactoring.getMethods()) {
                ExecutableElement executableElement = (ExecutableElement)elementHandle.resolve((CompilationInfo)workingCopy);
                object2 = workingCopy.getTrees().getTree(executableElement);
                tree = treeMaker.Method(treeMaker.Modifiers(Collections.emptySet(), object2.getModifiers().getAnnotations()), (CharSequence)object2.getName(), object2.getReturnType(), object2.getTypeParameters(), object2.getParameters(), object2.getThrows(), (BlockTree)null, null);
                tree = (MethodTree)generatorUtilities.importFQNs(tree);
                RetoucheUtils.copyJavadoc(executableElement, tree, workingCopy);
                arrayList2.add(tree);
            }
            ArrayList<? extends Tree> arrayList3 = new ArrayList<Tree>();
            arrayList3.addAll(classTree.getImplementsClause());
            for (TypeMirrorHandle<TypeMirror> typeMirrorHandle : this.refactoring.getImplements()) {
                object2 = typeMirrorHandle.resolve((CompilationInfo)workingCopy);
                arrayList3.add(treeMaker.Type((TypeMirror)object2));
            }
            ClassTree classTree3 = treeMaker.Interface(classTree.getModifiers(), (CharSequence)classTree.getSimpleName(), arrayList, arrayList3, Collections.emptyList());
            classTree3 = generatorUtilities.insertClassMembers(classTree3, (Iterable)arrayList2);
            workingCopy.rewrite((Tree)classTree, (Tree)classTree3);
        }

        private ClassTree findInterface(CompilationInfo compilationInfo, String string) {
            for (Tree tree : compilationInfo.getCompilationUnit().getTypeDecls()) {
                if (Tree.Kind.CLASS != tree.getKind() || !compilationInfo.getTreeUtilities().isInterface((ClassTree)tree) || !string.contentEquals(((ClassTree)tree).getSimpleName())) continue;
                return (ClassTree)tree;
            }
            throw new IllegalStateException("wrong template, cannot find the interface in " + compilationInfo.getFileObject());
        }
    }
}

