/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.actions;

import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.net.URL;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.css.actions.CheckStyleAction;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.ExClipboard;

public abstract class CopyStyleAction
extends BaseAction {
    protected static final String comment = NbBundle.getMessage(CopyStyleAction.class, (String)"Style-Comment") + "\n";

    public CopyStyleAction(String string) {
        super(string);
    }

    public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
        BaseDocument baseDocument = Utilities.getDocument((JTextComponent)jTextComponent);
        if (baseDocument == null) {
            return;
        }
        DataObject dataObject = NbEditorUtilities.getDataObject((Document)baseDocument);
        if (dataObject == null) {
            return;
        }
        String string = this.createText(dataObject);
        StringSelection stringSelection = new StringSelection(string);
        ExClipboard exClipboard = (ExClipboard)Lookup.getDefault().lookup(ExClipboard.class);
        exClipboard.setContents((Transferable)stringSelection, null);
        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(CheckStyleAction.class, (String)"MSG_Style_tag_in_clipboard"));
    }

    protected abstract String createText(DataObject var1);

    public HelpCtx getHelpCtx() {
        return new HelpCtx(((Object)((Object)this)).getClass());
    }

    protected String getHref(FileObject fileObject) {
        URL uRL = URLMapper.findURL((FileObject)fileObject, (int)2);
        if (uRL != null) {
            return uRL.toExternalForm();
        }
        return fileObject.getPath();
    }

    public static final class HTML
    extends CopyStyleAction {
        public static final String copyStyleAction = NbBundle.getMessage(CopyStyleAction.class, (String)"Copy-HTML-Style");

        public HTML() {
            super(copyStyleAction);
            this.putValue("ShortDescription", copyStyleAction);
        }

        protected String createText(DataObject dataObject) {
            return comment + "<link rel=\"StyleSheet\" type=\"text/css\" href=\"" + this.getHref(dataObject.getPrimaryFile()) + "\" media=\"screen\" >";
        }
    }

    public static final class XML
    extends CopyStyleAction {
        public static final String copyStyleAction = NbBundle.getMessage(CopyStyleAction.class, (String)"Copy-XML-Style");

        public XML() {
            super(copyStyleAction);
            this.putValue("ShortDescription", copyStyleAction);
        }

        protected String createText(DataObject dataObject) {
            return comment + "<?xml-stylesheet type=\"text/css\" href=\"" + this.getHref(dataObject.getPrimaryFile()) + "\" ?>";
        }
    }
}

