/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.client.javascript.debugger.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JEditorPane;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.web.client.javascript.debugger.NbJSDebuggerEngineProvider;
import org.netbeans.modules.web.client.javascript.debugger.api.NbJSContextProviderWrapper;
import org.netbeans.modules.web.client.javascript.debugger.api.NbJSDebugger;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSDebuggerEvent;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSDebuggerEventListener;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSDebuggerState;
import org.netbeans.spi.debugger.ActionsProviderSupport;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.openide.awt.StatusDisplayer;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NbJSDebuggerActionsProvider
extends ActionsProviderSupport
implements PropertyChangeListener {
    static final String JAVASCRIPT_MIMETYPE = "text/javascript";
    static final String HTML_MIMETYPE = "text/html";
    private static final Set<Object> ACTIONS = Collections.unmodifiableSet(new HashSet<Object>(Arrays.asList(ActionsManager.ACTION_START, ActionsManager.ACTION_KILL, ActionsManager.ACTION_CONTINUE, ActionsManager.ACTION_PAUSE, ActionsManager.ACTION_STEP_INTO, ActionsManager.ACTION_STEP_OVER, ActionsManager.ACTION_STEP_OUT, ActionsManager.ACTION_RUN_TO_CURSOR)));
    private NbJSContextProviderWrapper contextProviderWrapper;
    private NbJSDebugger debugger;
    private JSDebuggerEventListener debuggerListener;

    public NbJSDebuggerActionsProvider(ContextProvider contextProvider) {
        this.contextProviderWrapper = NbJSContextProviderWrapper.getContextProviderWrapper(contextProvider);
        this.debugger = this.contextProviderWrapper.getNbJSDebugger();
        this.setEnabled(ActionsManager.ACTION_START, true);
        this.setEnabled(ActionsManager.ACTION_KILL, true);
        this.debuggerListener = new JSDebuggerEventListenerImpl();
        this.debugger.addJSDebuggerEventListener((JSDebuggerEventListener)WeakListeners.create(JSDebuggerEventListener.class, (EventListener)this.debuggerListener, (Object)this.debugger));
        EditorContextDispatcher editorContextDispatcher = EditorContextDispatcher.getDefault();
        editorContextDispatcher.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)editorContextDispatcher));
    }

    public Set<Object> getActions() {
        return ACTIONS;
    }

    public void doAction(Object object) {
        if (object == ActionsManager.ACTION_START) {
            this.debugger.startJSDebugging();
        } else if (object == ActionsManager.ACTION_KILL) {
            NbJSDebuggerEngineProvider nbJSDebuggerEngineProvider = this.contextProviderWrapper.getNbJSDebuggerEngineProvider();
            assert (nbJSDebuggerEngineProvider != null);
            this.debugger.finish(true, nbJSDebuggerEngineProvider.getDestructor());
        } else if (object == ActionsManager.ACTION_CONTINUE) {
            this.debugger.resume();
        } else if (object == ActionsManager.ACTION_PAUSE) {
            this.debugger.pause();
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(NbJSDebuggerActionsProvider.class, (String)"MSG_WILL_PAUSE"));
            this.setEnabled(ActionsManager.ACTION_PAUSE, false);
        } else if (object == ActionsManager.ACTION_STEP_OVER) {
            this.debugger.stepOver();
        } else if (object == ActionsManager.ACTION_STEP_INTO) {
            this.debugger.stepInto();
        } else if (object == ActionsManager.ACTION_STEP_OUT) {
            this.debugger.stepOut();
        } else if (object == ActionsManager.ACTION_RUN_TO_CURSOR) {
            this.debugger.runToCursor();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.handleRunToCursor();
    }

    private void handleRunToCursor() {
        JEditorPane jEditorPane = EditorContextDispatcher.getDefault().getCurrentEditor();
        this.setEnabled(ActionsManager.ACTION_RUN_TO_CURSOR, jEditorPane != null && NbJSDebuggerActionsProvider.getActionsManager().isEnabled(ActionsManager.ACTION_CONTINUE) && EditorContextDispatcher.getDefault().getCurrentLineNumber() >= 0 && (jEditorPane.getContentType().equals(JAVASCRIPT_MIMETYPE) || jEditorPane.getContentType().equals(HTML_MIMETYPE)));
    }

    static ActionsManager getActionsManager() {
        return DebuggerManager.getDebuggerManager().getCurrentEngine() == null ? DebuggerManager.getDebuggerManager().getActionsManager() : DebuggerManager.getDebuggerManager().getCurrentEngine().getActionsManager();
    }

    private class JSDebuggerEventListenerImpl
    implements JSDebuggerEventListener {
        private JSDebuggerEventListenerImpl() {
        }

        public void onDebuggerEvent(JSDebuggerEvent jSDebuggerEvent) {
            JSDebuggerState jSDebuggerState = jSDebuggerEvent.getDebuggerState();
            switch (jSDebuggerState.getState()) {
                case STARTING: {
                    NbJSDebuggerActionsProvider.this.setEnabled(ActionsManager.ACTION_START, false);
                    NbJSDebuggerActionsProvider.this.setEnabled(ActionsManager.ACTION_KILL, true);
                    NbJSDebuggerActionsProvider.this.setEnabled(ActionsManager.ACTION_CONTINUE, false);
                    NbJSDebuggerActionsProvider.this.setEnabled(ActionsManager.ACTION_PAUSE, false);
                    NbJSDebuggerActionsProvider.this.setEnabled(ActionsManager.ACTION_STEP_INTO, false);
                    NbJSDebuggerActionsProvider.this.setEnabled(ActionsManager.ACTION_STEP_OVER, false);
                    NbJSDebuggerActionsProvider.this.setEnabled(ActionsManager.ACTION_STEP_OUT, false);
                    break;
                }
                case RUNNING: {
                    NbJSDebuggerActionsProvider.this.setEnabled(ActionsManager.ACTION_START, false);
                    NbJSDebuggerActionsProvider.this.setEnabled(ActionsManager.ACTION_KILL, true);
                    NbJSDebuggerActionsProvider.this.setEnabled(ActionsManager.ACTION_CONTINUE, false);
                    NbJSDebuggerActionsProvider.this.setEnabled(ActionsManager.ACTION_PAUSE, true);
                    NbJSDebuggerActionsProvider.this.setEnabled(ActionsManager.ACTION_STEP_INTO, false);
                    NbJSDebuggerActionsProvider.this.setEnabled(ActionsManager.ACTION_STEP_OVER, false);
                    NbJSDebuggerActionsProvider.this.setEnabled(ActionsManager.ACTION_STEP_OUT, false);
                    break;
                }
                case SUSPENDED: {
                    NbJSDebuggerActionsProvider.this.setEnabled(ActionsManager.ACTION_START, false);
                    NbJSDebuggerActionsProvider.this.setEnabled(ActionsManager.ACTION_KILL, true);
                    NbJSDebuggerActionsProvider.this.setEnabled(ActionsManager.ACTION_CONTINUE, true);
                    NbJSDebuggerActionsProvider.this.setEnabled(ActionsManager.ACTION_PAUSE, false);
                    NbJSDebuggerActionsProvider.this.setEnabled(ActionsManager.ACTION_STEP_INTO, true);
                    NbJSDebuggerActionsProvider.this.setEnabled(ActionsManager.ACTION_STEP_OVER, true);
                    NbJSDebuggerActionsProvider.this.setEnabled(ActionsManager.ACTION_STEP_OUT, true);
                    break;
                }
                case DISCONNECTED: {
                    if (jSDebuggerState.getReason() == JSDebuggerState.Reason.NONE) {
                        NbJSDebuggerActionsProvider.this.contextProviderWrapper.getNbJSDebuggerEngineProvider().getDestructor().killEngine();
                        return;
                    }
                    NbJSDebuggerActionsProvider.this.setEnabled(ActionsManager.ACTION_START, false);
                    NbJSDebuggerActionsProvider.this.setEnabled(ActionsManager.ACTION_KILL, false);
                    NbJSDebuggerActionsProvider.this.setEnabled(ActionsManager.ACTION_CONTINUE, false);
                    NbJSDebuggerActionsProvider.this.setEnabled(ActionsManager.ACTION_PAUSE, false);
                    NbJSDebuggerActionsProvider.this.setEnabled(ActionsManager.ACTION_STEP_INTO, false);
                    NbJSDebuggerActionsProvider.this.setEnabled(ActionsManager.ACTION_STEP_OVER, false);
                    NbJSDebuggerActionsProvider.this.setEnabled(ActionsManager.ACTION_STEP_OUT, false);
                }
            }
            NbJSDebuggerActionsProvider.this.handleRunToCursor();
        }
    }
}

