/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.projects;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.debugger.Properties;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.java.classpath.GlobalPathRegistryEvent;
import org.netbeans.api.java.classpath.GlobalPathRegistryListener;
import org.netbeans.modules.debugger.jpda.projects.SourcePathProviderImpl;
import org.netbeans.spi.viewmodel.CheckNodeModelFilter;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.windows.WindowManager;

public class SourcesRemoteModel
implements TreeModel,
CheckNodeModelFilter,
NodeActionsProvider {
    private Vector<ModelListener> listeners = new Vector();
    private Set<String> disabledSourceRoots = new HashSet<String>();
    private List<String> additionalSourceRoots = new ArrayList<String>();
    private Properties sourcesProperties = Properties.getDefault().getProperties("debugger").getProperties("sources");
    private GlobalPathRegistryListener globalRegistryListener;
    private JFileChooser newSourceFileChooser;
    private final Action NEW_SOURCE_ROOT_ACTION = new AbstractAction(NbBundle.getMessage(SourcesRemoteModel.class, (String)"CTL_SourcesModel_Action_AddSrc")){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            if (SourcesRemoteModel.this.newSourceFileChooser == null) {
                SourcesRemoteModel.this.newSourceFileChooser = new JFileChooser();
                SourcesRemoteModel.this.newSourceFileChooser.setFileSelectionMode(2);
                SourcesRemoteModel.this.newSourceFileChooser.setFileFilter(new FileFilter(){

                    public String getDescription() {
                        return NbBundle.getMessage(SourcesRemoteModel.class, (String)"CTL_SourcesModel_AddSrc_Chooser_Filter_Description");
                    }

                    public boolean accept(File file) {
                        if (file.isDirectory()) {
                            return true;
                        }
                        try {
                            return FileUtil.isArchiveFile((URL)file.toURI().toURL());
                        }
                        catch (MalformedURLException malformedURLException) {
                            Exceptions.printStackTrace((Throwable)malformedURLException);
                            return false;
                        }
                    }
                });
            }
            if ((n = SourcesRemoteModel.this.newSourceFileChooser.showDialog(WindowManager.getDefault().getMainWindow(), NbBundle.getMessage(SourcesRemoteModel.class, (String)"CTL_SourcesModel_AddSrc_Btn"))) == 0) {
                File file = SourcesRemoteModel.this.newSourceFileChooser.getSelectedFile();
                try {
                    if (!file.isDirectory() && !FileUtil.isArchiveFile((URL)file.toURI().toURL())) {
                        return;
                    }
                    String string = file.getCanonicalPath();
                    SourcesRemoteModel sourcesRemoteModel = SourcesRemoteModel.this;
                    synchronized (sourcesRemoteModel) {
                        SourcesRemoteModel.this.additionalSourceRoots.add(string);
                    }
                    SourcesRemoteModel.this.saveAdditionalSourceRoots();
                    SourcesRemoteModel.this.fireTreeChanged();
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
            }
        }
    };
    private final Action DELETE_ACTION = Models.createAction((String)NbBundle.getBundle(SourcesRemoteModel.class).getString("CTL_SourcesModel_Action_Delete"), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object object) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void perform(Object[] objectArray) {
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                String string = (String)objectArray[i];
                SourcesRemoteModel sourcesRemoteModel = SourcesRemoteModel.this;
                synchronized (sourcesRemoteModel) {
                    SourcesRemoteModel.this.additionalSourceRoots.remove(string);
                    SourcesRemoteModel.this.disabledSourceRoots.remove(string);
                    continue;
                }
            }
            SourcesRemoteModel.this.saveAdditionalSourceRoots();
            SourcesRemoteModel.this.fireTreeChanged();
        }
    }, (int)Models.MULTISELECTION_TYPE_ANY);

    public SourcesRemoteModel() {
        this.loadSourceRoots();
        this.updateCachedRoots();
        this.DELETE_ACTION.putValue("AcceleratorKey", KeyStroke.getKeyStroke("DELETE"));
    }

    public Object getRoot() {
        return "Root";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getChildren(Object object, int n, int n2) throws UnknownTypeException {
        if (object == "Root") {
            if (this.globalRegistryListener == null) {
                this.globalRegistryListener = new GlobalPathRegistryListener(){

                    public void pathsAdded(GlobalPathRegistryEvent globalPathRegistryEvent) {
                        SourcesRemoteModel.this.fireTreeChanged();
                    }

                    public void pathsRemoved(GlobalPathRegistryEvent globalPathRegistryEvent) {
                        SourcesRemoteModel.this.fireTreeChanged();
                    }
                };
                GlobalPathRegistry.getDefault().addGlobalPathRegistryListener((GlobalPathRegistryListener)WeakListeners.create(GlobalPathRegistryListener.class, (EventListener)this.globalRegistryListener, (Object)GlobalPathRegistry.getDefault()));
            }
            TreeSet<FileObject> treeSet = new TreeSet<FileObject>(new SourcePathProviderImpl.FileObjectComparator());
            treeSet.addAll(GlobalPathRegistry.getDefault().getSourceRoots());
            int n3 = treeSet.size();
            ArrayList<String> arrayList = new ArrayList<String>(n3);
            Iterator iterator = treeSet.iterator();
            for (int i = 0; i < n3; ++i) {
                arrayList.add(SourcePathProviderImpl.getRoot((FileObject)iterator.next()));
            }
            Object[] objectArray = this;
            synchronized (this) {
                if (this.additionalSourceRoots.size() > 0) {
                    for (String string : this.additionalSourceRoots) {
                        if (arrayList.contains(string)) continue;
                        arrayList.add(string);
                    }
                }
                // ** MonitorExit[var8_9] (shouldn't be in output)
                objectArray = arrayList.toArray();
                n2 = Math.min(objectArray.length, n2);
                n = Math.min(objectArray.length, n);
                Object[] objectArray2 = new Object[n2 - n];
                System.arraycopy(objectArray, n, objectArray2, 0, n2 - n);
                return objectArray2;
            }
        }
        throw new UnknownTypeException(object);
    }

    public int getChildrenCount(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return Integer.MAX_VALUE;
        }
        throw new UnknownTypeException(object);
    }

    public boolean isLeaf(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return false;
        }
        if (object instanceof String) {
            return true;
        }
        throw new UnknownTypeException(object);
    }

    public void addModelListener(ModelListener modelListener) {
        this.listeners.add(modelListener);
    }

    public void removeModelListener(ModelListener modelListener) {
        this.listeners.remove(modelListener);
    }

    public void fireTreeChanged() {
        Vector vector = (Vector)this.listeners.clone();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            ((ModelListener)vector.get(i)).modelChanged(null);
        }
    }

    public Action[] getActions(Object object) throws UnknownTypeException {
        if (object instanceof String) {
            if (this.additionalSourceRoots.contains(object)) {
                return new Action[]{this.NEW_SOURCE_ROOT_ACTION, this.DELETE_ACTION};
            }
            return new Action[]{this.NEW_SOURCE_ROOT_ACTION};
        }
        throw new UnknownTypeException(object);
    }

    public void performDefaultAction(Object object) throws UnknownTypeException {
        if (object instanceof String) {
            return;
        }
        throw new UnknownTypeException(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isEnabled(String string) {
        SourcesRemoteModel sourcesRemoteModel = this;
        synchronized (sourcesRemoteModel) {
            return !this.disabledSourceRoots.contains(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setEnabled(String string, boolean bl) {
        SourcesRemoteModel sourcesRemoteModel = this;
        synchronized (sourcesRemoteModel) {
            if (bl) {
                this.disabledSourceRoots.remove(string);
            } else {
                this.disabledSourceRoots.add(string);
            }
            this.saveDisabledSourceRoots();
        }
    }

    private void loadSourceRoots() {
        this.disabledSourceRoots = new HashSet<String>(this.sourcesProperties.getProperties("source_roots").getCollection("remote_disabled", (Collection)Collections.EMPTY_SET));
        this.additionalSourceRoots = new ArrayList<String>(this.sourcesProperties.getProperties("additional_source_roots").getCollection("src_roots", (Collection)Collections.EMPTY_LIST));
    }

    private synchronized void saveDisabledSourceRoots() {
        this.sourcesProperties.getProperties("source_roots").setCollection("remote_disabled", this.disabledSourceRoots);
    }

    private synchronized void saveAdditionalSourceRoots() {
        this.sourcesProperties.getProperties("additional_source_roots").setCollection("src_roots", this.additionalSourceRoots);
    }

    private synchronized void updateCachedRoots() {
    }

    public boolean isCheckable(NodeModel nodeModel, Object object) throws UnknownTypeException {
        return true;
    }

    public boolean isCheckEnabled(NodeModel nodeModel, Object object) throws UnknownTypeException {
        return true;
    }

    public Boolean isSelected(NodeModel nodeModel, Object object) throws UnknownTypeException {
        if (object instanceof String) {
            return this.isEnabled((String)object);
        }
        throw new UnknownTypeException(object);
    }

    public void setSelected(NodeModel nodeModel, Object object, Boolean bl) throws UnknownTypeException {
        if (object instanceof String) {
            this.setEnabled((String)object, bl);
            return;
        }
        throw new UnknownTypeException(object);
    }

    public String getDisplayName(NodeModel nodeModel, Object object) throws UnknownTypeException {
        return nodeModel.getDisplayName(object);
    }

    public String getIconBase(NodeModel nodeModel, Object object) throws UnknownTypeException {
        return nodeModel.getIconBase(object);
    }

    public String getShortDescription(NodeModel nodeModel, Object object) throws UnknownTypeException {
        return nodeModel.getShortDescription(object);
    }
}

