/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.codetemplates.storage;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.KeyStroke;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.CodeTemplateDescription;
import org.netbeans.api.editor.settings.CodeTemplateSettings;
import org.netbeans.lib.editor.codetemplates.storage.CodeTemplateSettingsImpl;
import org.netbeans.spi.editor.mimelookup.MimeDataProvider;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public final class SettingsProvider
implements MimeDataProvider {
    private static final Logger LOG = Logger.getLogger(SettingsProvider.class.getName());

    public Lookup getLookup(MimePath mimePath) {
        return new MyLookup(mimePath);
    }

    private static MimePath[] computeInheritedMimePaths(MimePath mimePath) {
        Object object;
        Object object2;
        Object object3 = null;
        try {
            object2 = MimePath.class.getDeclaredMethod("getInheritedPaths", String.class, String.class);
            ((Method)object2).setAccessible(true);
            object3 = object = (List)((Method)object2).invoke((Object)mimePath, new Object[]{null, null});
        }
        catch (Exception exception) {
            LOG.log(Level.WARNING, "Can't call org.netbeans.api.editor.mimelookup.MimePath.getInheritedPaths method.", exception);
        }
        if (object3 != null) {
            object2 = new ArrayList(object3.size());
            object = object3.iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                ((ArrayList)object2).add(MimePath.parse((String)string));
            }
            return ((ArrayList)object2).toArray(new MimePath[((ArrayList)object2).size()]);
        }
        return new MimePath[]{mimePath, MimePath.EMPTY};
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CompositeCTS
    extends CodeTemplateSettings {
        private final CodeTemplateSettingsImpl[] allCtsi;
        private List<CodeTemplateDescription> codeTemplates;
        private KeyStroke expansionKey;

        public CompositeCTS(CodeTemplateSettingsImpl[] codeTemplateSettingsImplArray) {
            this.allCtsi = codeTemplateSettingsImplArray;
        }

        public List<CodeTemplateDescription> getCodeTemplateDescriptions() {
            if (this.codeTemplates == null) {
                Map<Object, Object> map;
                if (this.allCtsi.length > 1) {
                    map = new HashMap();
                    for (int i = this.allCtsi.length - 1; i >= 0; --i) {
                        map.putAll(this.allCtsi[i].getCodeTemplates());
                    }
                } else {
                    map = this.allCtsi[0].getCodeTemplates();
                }
                this.codeTemplates = Collections.unmodifiableList(new ArrayList<Object>(map.values()));
            }
            return this.codeTemplates;
        }

        public KeyStroke getExpandKey() {
            if (this.expansionKey == null) {
                this.expansionKey = this.allCtsi[this.allCtsi.length - 1].getExpandKey();
            }
            return this.expansionKey;
        }
    }

    private static final class MyLookup
    extends AbstractLookup
    implements PropertyChangeListener {
        private final MimePath mimePath;
        private final InstanceContent ic;
        private Object codeTemplateSettings = null;
        private CodeTemplateSettingsImpl[] allCtsi;

        public MyLookup(MimePath mimePath) {
            this(mimePath, new InstanceContent());
        }

        private MyLookup(MimePath mimePath, InstanceContent instanceContent) {
            super((AbstractLookup.Content)instanceContent);
            this.mimePath = mimePath;
            this.ic = instanceContent;
            MimePath[] mimePathArray = SettingsProvider.computeInheritedMimePaths(mimePath);
            this.allCtsi = new CodeTemplateSettingsImpl[mimePathArray.length];
            for (int i = 0; i < mimePathArray.length; ++i) {
                this.allCtsi[i] = CodeTemplateSettingsImpl.get(mimePathArray[i]);
                this.allCtsi[i].addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.allCtsi[i]));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void initialize() {
            MyLookup myLookup = this;
            synchronized (myLookup) {
                this.codeTemplateSettings = new CompositeCTS(this.allCtsi);
                this.ic.set(Arrays.asList(this.codeTemplateSettings), null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            MyLookup myLookup = this;
            synchronized (myLookup) {
                if (this.codeTemplateSettings != null) {
                    this.codeTemplateSettings = new CompositeCTS(this.allCtsi);
                    this.ic.set(Arrays.asList(this.codeTemplateSettings), null);
                }
            }
        }
    }
}

