/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.codetemplates;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.text.Position;
import org.netbeans.lib.editor.codetemplates.CodeTemplateInsertHandler;
import org.netbeans.lib.editor.codetemplates.CodeTemplateSpiPackageAccessor;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateParameter;
import org.netbeans.lib.editor.codetemplates.textsync.TextRegion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CodeTemplateParameterImpl {
    private static final String NULL_PARAMETER_NAME = "<null>";
    private static final String NULL_HINT_NAME = "<null>";
    private static final String TRUE_HINT_VALUE = "true";
    private final CodeTemplateInsertHandler handler;
    private final CodeTemplateParameter parameter;
    private String value;
    private int parametrizedTextStartOffset;
    private int parametrizedTextEndOffset;
    private CodeTemplateParameter master;
    private Collection<CodeTemplateParameter> slaves;
    private String name;
    private Map<String, String> hints;
    private Map<String, String> hintsUnmodifiable;
    private TextRegion<CodeTemplateParameterImpl> textRegion;
    private boolean editable;
    private boolean userModified;

    public static CodeTemplateParameterImpl get(CodeTemplateParameter codeTemplateParameter) {
        return CodeTemplateSpiPackageAccessor.get().getImpl(codeTemplateParameter);
    }

    CodeTemplateParameterImpl(CodeTemplateInsertHandler codeTemplateInsertHandler, String string, int n) {
        this.handler = codeTemplateInsertHandler;
        this.parametrizedTextStartOffset = n;
        this.parameter = CodeTemplateSpiPackageAccessor.get().createParameter(this);
        this.textRegion = new TextRegion();
        this.textRegion.setClientInfo(this);
        this.parseParameterContent(string);
    }

    public CodeTemplateParameter getParameter() {
        return this.parameter;
    }

    public CodeTemplateInsertHandler getHandler() {
        return this.handler;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.isSlave() ? this.master.getValue() : (this.handler != null && this.handler.isInserted() ? this.handler.getDocParameterValue(this) : this.value);
    }

    public void setValue(String string) {
        if (this.isSlave()) {
            throw new IllegalStateException("Cannot set value for slave parameter");
        }
        if (string == null) {
            throw new NullPointerException("newValue cannot be null");
        }
        if (!this.handler.isReleased()) {
            if (this.handler.isInserted()) {
                this.handler.setDocMasterParameterValue(this, string);
                return;
            }
            this.value = string;
            this.handler.resetCachedInsertText();
        }
    }

    public boolean isEditable() {
        return this.editable;
    }

    public boolean isUserModified() {
        return this.userModified;
    }

    void markUserModified() {
        this.userModified = true;
    }

    public int getParametrizedTextStartOffset() {
        return this.parametrizedTextStartOffset;
    }

    public int getParametrizedTextEndOffset() {
        return this.parametrizedTextEndOffset;
    }

    public int getInsertTextOffset() {
        if (this.handler != null) {
            if (!this.handler.isInserted()) {
                this.handler.checkInsertTextBuilt();
            }
            return this.textRegion.startOffset() - this.handler.getInsertOffset();
        }
        return this.textRegion.startOffset();
    }

    void resetPositions(Position position, Position position2) {
        this.textRegion.updateBounds(position, position2);
    }

    public TextRegion textRegion() {
        return this.textRegion;
    }

    public Map<String, String> getHints() {
        return this.hintsUnmodifiable != null ? this.hintsUnmodifiable : Collections.emptyMap();
    }

    public CodeTemplateParameter getMaster() {
        return this.master;
    }

    public Collection<? extends CodeTemplateParameter> getSlaves() {
        return this.slaves != null ? this.slaves : Collections.emptyList();
    }

    public boolean isSlave() {
        return this.master != null;
    }

    void markSlave(CodeTemplateParameter codeTemplateParameter) {
        CodeTemplateParameterImpl codeTemplateParameterImpl = CodeTemplateParameterImpl.paramImpl(codeTemplateParameter);
        if (this.getMaster() != null) {
            throw new IllegalStateException(this.toString() + " already slave of " + codeTemplateParameter);
        }
        this.setMaster(codeTemplateParameter);
        codeTemplateParameterImpl.addSlave(this.getParameter());
        if (this.slaves != null) {
            Iterator<CodeTemplateParameter> iterator = this.slaves.iterator();
            while (iterator.hasNext()) {
                CodeTemplateParameterImpl codeTemplateParameterImpl2 = CodeTemplateParameterImpl.paramImpl(iterator.next());
                codeTemplateParameterImpl2.setMaster(codeTemplateParameter);
                codeTemplateParameterImpl.addSlave(codeTemplateParameterImpl2.getParameter());
            }
            this.slaves.clear();
        }
    }

    private static CodeTemplateParameterImpl paramImpl(CodeTemplateParameter codeTemplateParameter) {
        return CodeTemplateSpiPackageAccessor.get().getImpl(codeTemplateParameter);
    }

    private void parseParameterContent(String string) {
        String string2;
        int n = this.parametrizedTextStartOffset + 2;
        String string3 = null;
        boolean bl = false;
        int n2 = -1;
        boolean bl2 = false;
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            string2 = null;
            if (n >= string.length()) break;
            char c = string.charAt(n);
            if (bl2) {
                if (c == '\"') {
                    bl2 = false;
                    string2 = stringBuffer.toString();
                    stringBuffer.setLength(0);
                } else if (c == '\\') {
                    n = this.escapedChar(string, n + 1, stringBuffer);
                } else {
                    stringBuffer.append(c);
                }
            } else if (Character.isWhitespace(c) || c == '=' || c == '}') {
                if (n2 != -1) {
                    string2 = string.substring(n2, n);
                    n2 = -1;
                }
            } else if (c == '\"') {
                bl2 = true;
            } else if (n2 == -1) {
                n2 = n;
            }
            if (string2 != null) {
                if (this.name == null) {
                    this.name = string2;
                } else {
                    if (this.hints == null) {
                        this.hints = new LinkedHashMap<String, String>(4);
                        this.hintsUnmodifiable = Collections.unmodifiableMap(this.hints);
                    }
                    if (string3 == null) {
                        if (bl) {
                            this.hints.put("<null>", string2);
                            bl = false;
                        } else {
                            string3 = string2;
                        }
                    } else if (bl) {
                        this.hints.put(string3, string2);
                        bl = false;
                        string3 = null;
                    } else {
                        this.hints.put(string3, TRUE_HINT_VALUE);
                        string3 = string2;
                    }
                }
            }
            if (!bl2) {
                if (c == '=') {
                    bl = true;
                } else if (c == '}') {
                    if (string3 == null) break;
                    this.hints.put(string3, TRUE_HINT_VALUE);
                    string3 = null;
                    break;
                }
            }
            ++n;
        }
        if (this.name == null) {
            this.name = "<null>";
        }
        if ((string2 = this.getHints().get("default")) == null) {
            string2 = this.name;
        }
        this.value = string2;
        if (this.name.equals("cursor")) {
            this.editable = false;
            this.value = "";
        } else if (this.name.equals("selection")) {
            this.editable = false;
            if (this.handler != null) {
                this.value = this.handler.getComponent().getSelectedText();
                this.value = this.value == null ? "" : this.value.trim();
                if (this.getHints().get("line") != null && !this.value.endsWith("\n")) {
                    this.value = this.value + "\n";
                }
            }
        } else {
            this.editable = !this.isHintValueFalse("editable");
        }
        this.parametrizedTextEndOffset = n + 1;
    }

    private boolean isHintValueFalse(String string) {
        String string2 = this.getHints().get(string);
        return string2 != null && "false".equals(string2.toLowerCase());
    }

    private int escapedChar(CharSequence charSequence, int n, StringBuffer stringBuffer) {
        if (n == charSequence.length()) {
            stringBuffer.append('\\');
        } else {
            switch (charSequence.charAt(n++)) {
                case '\\': {
                    stringBuffer.append('\\');
                    break;
                }
                case 'n': {
                    stringBuffer.append('\n');
                    break;
                }
                case 'r': {
                    stringBuffer.append('\r');
                    break;
                }
                case '\"': {
                    stringBuffer.append('\"');
                    break;
                }
                case '\'': {
                    stringBuffer.append('\'');
                    break;
                }
                case 'u': {
                    int n2 = 0;
                    for (int i = 0; i < 4; ++i) {
                        if (n < charSequence.length()) {
                            char c = charSequence.charAt(n);
                            if (c >= '0' && c <= '9') {
                                n2 = (n2 << 4) + (c - 48);
                            } else if (c >= 'a' && c <= 'f') {
                                n2 = (n2 << 4) + 10 + (c - 97);
                            } else {
                                if (c < 'A' || c > 'F') break;
                                n2 = (n2 << 4) + 10 + (c - 70);
                            }
                        }
                        ++n;
                    }
                    stringBuffer.append(n2);
                    break;
                }
                default: {
                    --n;
                    stringBuffer.append('\\');
                }
            }
        }
        return n;
    }

    private void addSlave(CodeTemplateParameter codeTemplateParameter) {
        if (this.slaves == null) {
            this.slaves = new ArrayList<CodeTemplateParameter>(2);
        }
        this.slaves.add(codeTemplateParameter);
    }

    private void setMaster(CodeTemplateParameter codeTemplateParameter) {
        this.master = codeTemplateParameter;
    }

    public String toString() {
        return "name=" + this.getName() + ", slave=" + this.isSlave() + ", value=" + this.getValue();
    }
}

