/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.ui;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.netbeans.modules.tasklist.ui.FoldingTaskListModel;

class TaskListTableUI
extends BasicTableUI {
    public TaskListTableUI() {
        if (null == UIManager.getColor("Table.selectionBackground")) {
            UIManager.put("Table.selectionBackground", new JTable().getSelectionBackground());
        }
        if (null == UIManager.getColor("Table.selectionForeground")) {
            UIManager.put("Table.selectionForeground", new JTable().getSelectionForeground());
        }
        if (null == UIManager.getColor("Table.gridColor")) {
            UIManager.put("Table.gridColor", new JTable().getGridColor());
        }
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        boolean bl;
        Rectangle rectangle = graphics.getClipBounds();
        Rectangle rectangle2 = this.table.getBounds();
        rectangle2.y = 0;
        rectangle2.x = 0;
        if (this.table.getRowCount() <= 0 || this.table.getColumnCount() <= 0 || !rectangle2.intersects(rectangle)) {
            return;
        }
        Point point = rectangle.getLocation();
        Point point2 = new Point(rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        int n = this.table.rowAtPoint(point);
        int n2 = this.table.rowAtPoint(point2);
        if (n == -1) {
            n = 0;
        }
        if (n2 == -1) {
            n2 = this.table.getRowCount() - 1;
        }
        int n3 = this.table.columnAtPoint((bl = this.table.getComponentOrientation().isLeftToRight()) ? point : point2);
        int n4 = this.table.columnAtPoint(bl ? point2 : point);
        if (n3 == -1) {
            n3 = 0;
        }
        if (n4 == -1) {
            n4 = this.table.getColumnCount() - 1;
        }
        this.paintGrid(graphics, n, n2, n3, n4);
        this.paintCells(graphics, n, n2, n3, n4);
    }

    private void paintGrid(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        graphics.setColor(this.table.getGridColor());
        Rectangle rectangle = this.table.getCellRect(n, n3, true);
        Rectangle rectangle2 = this.table.getCellRect(n2, n4, true);
        Rectangle rectangle3 = rectangle.union(rectangle2);
        if (this.table.getShowHorizontalLines()) {
            int n7 = rectangle3.x + rectangle3.width;
            n6 = rectangle3.y;
            for (n5 = n; n5 <= n2; ++n5) {
                graphics.drawLine(rectangle3.x, (n6 += this.table.getRowHeight(n5)) - 1, n7 - 1, n6 - 1);
            }
        }
        if (this.table.getShowVerticalLines()) {
            TableColumnModel tableColumnModel = this.table.getColumnModel();
            n6 = rectangle3.y + rectangle3.height;
            if (this.table.getComponentOrientation().isLeftToRight()) {
                n5 = rectangle3.x;
                for (int i = n3; i <= n4; ++i) {
                    int n8 = tableColumnModel.getColumn(i).getWidth();
                    graphics.drawLine((n5 += n8) - 1, 0, n5 - 1, n6 - 1);
                }
            } else {
                n5 = rectangle3.x + rectangle3.width;
                for (int i = n3; i < n4; ++i) {
                    int n9 = tableColumnModel.getColumn(i).getWidth();
                    graphics.drawLine((n5 -= n9) - 1, 0, n5 - 1, n6 - 1);
                }
                graphics.drawLine(n5 -= tableColumnModel.getColumn(n4).getWidth(), 0, n5, n6 - 1);
            }
        }
    }

    private int viewIndexForColumn(TableColumn tableColumn) {
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            if (tableColumnModel.getColumn(i) != tableColumn) continue;
            return i;
        }
        return -1;
    }

    private void paintCells(Graphics graphics, int n, int n2, int n3, int n4) {
        JTableHeader jTableHeader = this.table.getTableHeader();
        TableColumn tableColumn = jTableHeader == null ? null : jTableHeader.getDraggedColumn();
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        int n5 = tableColumnModel.getColumnMargin();
        if (this.table.getComponentOrientation().isLeftToRight()) {
            for (int i = n; i <= n2; ++i) {
                Rectangle rectangle = this.table.getCellRect(i, n3, false);
                if (this.isFoldingRow(i)) {
                    rectangle.x = 0;
                    rectangle.width = this.table.getColumnModel().getTotalColumnWidth() - n5;
                    this.paintCell(graphics, rectangle, i, 0);
                    continue;
                }
                for (int j = n3; j <= n4; ++j) {
                    TableColumn tableColumn2 = tableColumnModel.getColumn(j);
                    int n6 = tableColumn2.getWidth();
                    rectangle.width = n6 - n5;
                    if (tableColumn2 != tableColumn) {
                        this.paintCell(graphics, rectangle, i, j);
                    }
                    rectangle.x += n6;
                }
            }
        } else {
            for (int i = n; i <= n2; ++i) {
                int n7;
                Rectangle rectangle = this.table.getCellRect(i, n3, false);
                if (this.isFoldingRow(i)) {
                    rectangle.x = 0;
                    rectangle.width = this.table.getColumnModel().getTotalColumnWidth() - n5;
                    this.paintCell(graphics, rectangle, i, 0);
                    continue;
                }
                TableColumn tableColumn3 = tableColumnModel.getColumn(n3);
                if (tableColumn3 != tableColumn) {
                    n7 = tableColumn3.getWidth();
                    rectangle.width = n7 - n5;
                    this.paintCell(graphics, rectangle, i, n3);
                }
                for (int j = n3 + 1; j <= n4; ++j) {
                    tableColumn3 = tableColumnModel.getColumn(j);
                    n7 = tableColumn3.getWidth();
                    rectangle.width = n7 - n5;
                    rectangle.x -= n7;
                    if (tableColumn3 == tableColumn) continue;
                    this.paintCell(graphics, rectangle, i, j);
                }
            }
        }
        if (tableColumn != null) {
            this.paintDraggedArea(graphics, n, n2, tableColumn, jTableHeader.getDraggedDistance());
        }
        this.rendererPane.removeAll();
    }

    private void paintDraggedArea(Graphics graphics, int n, int n2, TableColumn tableColumn, int n3) {
        int n4;
        int n5;
        int n6 = this.viewIndexForColumn(tableColumn);
        Rectangle rectangle = this.table.getCellRect(n, n6, true);
        Rectangle rectangle2 = this.table.getCellRect(n2, n6, true);
        Rectangle rectangle3 = rectangle.union(rectangle2);
        graphics.setColor(this.table.getParent().getBackground());
        graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
        rectangle3.x += n3;
        graphics.setColor(this.table.getBackground());
        graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
        if (this.table.getShowVerticalLines()) {
            graphics.setColor(this.table.getGridColor());
            n5 = rectangle3.x;
            int n7 = rectangle3.y;
            int n8 = n5 + rectangle3.width - 1;
            n4 = n7 + rectangle3.height - 1;
            graphics.drawLine(n5 - 1, n7, n5 - 1, n4);
            graphics.drawLine(n8, n7, n8, n4);
        }
        for (n5 = n; n5 <= n2; ++n5) {
            Rectangle rectangle4 = this.table.getCellRect(n5, n6, false);
            rectangle4.x += n3;
            this.paintCell(graphics, rectangle4, n5, n6);
            if (!this.table.getShowHorizontalLines()) continue;
            graphics.setColor(this.table.getGridColor());
            Rectangle rectangle5 = this.table.getCellRect(n5, n6, true);
            rectangle5.x += n3;
            n4 = rectangle5.x;
            int n9 = rectangle5.y;
            int n10 = n4 + rectangle5.width - 1;
            int n11 = n9 + rectangle5.height - 1;
            graphics.drawLine(n4, n11, n10, n11);
        }
    }

    private void paintCell(Graphics graphics, Rectangle rectangle, int n, int n2) {
        if (this.table.isEditing() && this.table.getEditingRow() == n && this.table.getEditingColumn() == n2) {
            Component component = this.table.getEditorComponent();
            component.setBounds(rectangle);
            component.validate();
        } else {
            TableCellRenderer tableCellRenderer = this.table.getCellRenderer(n, n2);
            Component component = this.table.prepareRenderer(tableCellRenderer, n, n2);
            this.rendererPane.paintComponent(graphics, component, this.table, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
        }
    }

    private boolean isFoldingRow(int n) {
        boolean bl = false;
        if (this.table.getModel() instanceof FoldingTaskListModel) {
            bl = ((FoldingTaskListModel)this.table.getModel()).isGroupRow(n);
        }
        return bl;
    }
}

