/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.parsing.spi.indexing.Context;
import org.netbeans.modules.parsing.spi.indexing.CustomIndexer;
import org.netbeans.modules.parsing.spi.indexing.Indexable;
import org.netbeans.modules.parsing.spi.indexing.support.IndexDocument;
import org.netbeans.modules.parsing.spi.indexing.support.IndexingSupport;
import org.netbeans.modules.tasklist.filter.TaskFilter;
import org.netbeans.modules.tasklist.impl.ScannerDescriptor;
import org.netbeans.modules.tasklist.impl.TaskList;
import org.netbeans.modules.tasklist.impl.TaskManagerImpl;
import org.netbeans.modules.tasklist.trampoline.Accessor;
import org.netbeans.spi.tasklist.FileTaskScanner;
import org.netbeans.spi.tasklist.Task;
import org.netbeans.spi.tasklist.TaskScanningScope;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskIndexer
extends CustomIndexer {
    private final TaskList taskList;
    private static final Logger LOG = Logger.getLogger(TaskIndexer.class.getName());
    static final String KEY_SCANNER = "scanner";
    static final String KEY_TASK = "task";

    public TaskIndexer(TaskList taskList) {
        this.taskList = taskList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void index(Iterable<? extends Indexable> iterable, Context context) {
        block19: {
            TaskManagerImpl taskManagerImpl = TaskManagerImpl.getInstance();
            if (!taskManagerImpl.isObserved()) {
                taskManagerImpl.makeCacheDirty();
                return;
            }
            TaskFilter taskFilter = taskManagerImpl.getFilter();
            TaskScanningScope taskScanningScope = taskManagerImpl.getScope();
            ArrayList<Object> arrayList = null;
            try {
                IndexingSupport indexingSupport = IndexingSupport.getInstance((Context)context);
                for (Indexable indexable : iterable) {
                    Object object;
                    Object object2;
                    if (context.isCancelled()) {
                        LOG.log(Level.FINE, "Indexer cancelled");
                        return;
                    }
                    if (null == arrayList) {
                        arrayList = new ArrayList<Object>(20);
                        object2 = taskManagerImpl.getFileScanners().iterator();
                        while (object2.hasNext()) {
                            object = (FileTaskScanner)object2.next();
                            if (!taskFilter.isEnabled((FileTaskScanner)object)) continue;
                            object.notifyPrepare();
                            arrayList.add(object);
                            LOG.fine("Using FileTaskScanner: " + object);
                        }
                    }
                    if (null == (object2 = context.getRoot())) {
                        LOG.log(Level.FINE, "Context root not available");
                        return;
                    }
                    object = object2.getFileObject(indexable.getRelativePath());
                    if (null == object) {
                        LOG.log(Level.FINE, "Cannot find file [%0] under root [%1]", new Object[]{indexable.getRelativePath(), object2});
                        continue;
                    }
                    indexingSupport.removeDocuments(indexable);
                    FileTaskScanner fileTaskScanner = null;
                    for (FileTaskScanner fileTaskScanner2 : arrayList) {
                        List list = fileTaskScanner2.scan((FileObject)object);
                        if (null == list) continue;
                        if (taskScanningScope.isInScope((FileObject)object)) {
                            this.taskList.update(fileTaskScanner2, (FileObject)object, new ArrayList<Task>(list), taskFilter);
                        }
                        if (list.isEmpty()) continue;
                        if (null == fileTaskScanner) {
                            fileTaskScanner = indexingSupport.createDocument(indexable);
                            indexingSupport.addDocument((IndexDocument)fileTaskScanner);
                            fileTaskScanner.addPair(KEY_SCANNER, ScannerDescriptor.getType(fileTaskScanner2), true, true);
                        }
                        for (Task task : list) {
                            fileTaskScanner.addPair(KEY_TASK, TaskIndexer.encode(task), false, true);
                        }
                    }
                }
            }
            catch (IOException iOException) {
                LOG.log(Level.INFO, "Error while scanning file for tasks.", iOException);
            }
            finally {
                if (null == arrayList) break block19;
                for (FileTaskScanner fileTaskScanner : arrayList) {
                    fileTaskScanner.notifyFinish();
                }
            }
        }
    }

    private static String encode(Task task) {
        int n = Accessor.DEFAULT.getLine(task);
        String string = Accessor.DEFAULT.getGroup(task).getName();
        String string2 = Accessor.DEFAULT.getDescription(task);
        return String.valueOf(n) + "\n" + string + "\n" + string2;
    }

    public static Task decode(FileObject fileObject, String string) {
        int n = string.indexOf("\n");
        int n2 = Integer.valueOf(string.substring(0, n));
        string = string.substring(n + 1);
        n = string.indexOf("\n");
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        return Task.create((FileObject)fileObject, (String)string2, (String)string3, (int)n2);
    }
}

