/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.classview;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmQualifiedNamedElement;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.classview.ChildrenUpdater;
import org.netbeans.modules.cnd.classview.PersistentKey;
import org.netbeans.modules.cnd.classview.SortedName;
import org.netbeans.modules.cnd.classview.UpdatebleHost;
import org.netbeans.modules.cnd.classview.model.CVUtil;
import org.netbeans.modules.cnd.modelutil.AbstractCsmNode;
import org.netbeans.modules.cnd.utils.cache.CharSequenceKey;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HostKeyArray
extends Children.Keys<PersistentKey>
implements UpdatebleHost {
    private static final boolean traceEvents = Boolean.getBoolean("cnd.classview.key-events");
    private static final boolean noLoadinNode = Boolean.getBoolean("cnd.classview.no-loading-node");
    private static Comparator<Map.Entry<PersistentKey, SortedName>> COMARATOR = new MyComparator();
    private ChildrenUpdater childrenUpdater;
    private CsmProject myProject;
    private PersistentKey myID;
    private boolean update;
    private Map<PersistentKey, SortedName> myKeys;
    private Map<PersistentKey, ChangeListener> myChanges;
    private boolean isInited = false;
    private boolean isDisposed = false;

    public HostKeyArray(ChildrenUpdater childrenUpdater, CsmProject csmProject, PersistentKey persistentKey) {
        this.childrenUpdater = childrenUpdater;
        this.myProject = csmProject;
        this.myID = persistentKey;
        childrenUpdater.register(csmProject, persistentKey, this);
    }

    protected ChildrenUpdater getUpdater() {
        return this.childrenUpdater;
    }

    protected void dispose() {
        this.isDisposed = true;
        if (this.isInited) {
            this.isInited = false;
            this.myKeys.clear();
            this.myChanges.clear();
            this.childrenUpdater.unregister(this.myProject, this.myID);
        }
    }

    private synchronized void resetKeys() {
        ArrayList<Map.Entry<PersistentKey, SortedName>> arrayList = new ArrayList<Map.Entry<PersistentKey, SortedName>>();
        if (this.myKeys != null) {
            arrayList.addAll(this.myKeys.entrySet());
        }
        Collections.sort(arrayList, COMARATOR);
        ArrayList<PersistentKey> arrayList2 = new ArrayList<PersistentKey>();
        for (Map.Entry entry : arrayList) {
            PersistentKey persistentKey = (PersistentKey)entry.getKey();
            if (persistentKey == null) continue;
            arrayList2.add(persistentKey);
        }
        this.setKeys(arrayList2);
    }

    protected abstract Map<PersistentKey, SortedName> getMembers();

    protected abstract CsmOffsetableDeclaration findDeclaration(PersistentKey var1);

    protected abstract boolean canCreateNode(CsmOffsetableDeclaration var1);

    protected abstract Node createNode(PersistentKey var1);

    protected boolean isGlobalNamespace() {
        return false;
    }

    protected boolean isNamespace() {
        return false;
    }

    protected SortedName getSortedName(CsmNamespace csmNamespace) {
        return new SortedName(0, CVUtil.getNamespaceDisplayName(csmNamespace), 0);
    }

    protected SortedName getSortedName(CsmOffsetableDeclaration csmOffsetableDeclaration) {
        if (CsmKindUtilities.isClass((CsmObject)csmOffsetableDeclaration)) {
            return new SortedName(1, csmOffsetableDeclaration.getName(), 0);
        }
        if (csmOffsetableDeclaration.getKind() == CsmDeclaration.Kind.CLASS_FORWARD_DECLARATION) {
            return new SortedName(1, csmOffsetableDeclaration.getName(), 0);
        }
        if (csmOffsetableDeclaration.getKind() == CsmDeclaration.Kind.ENUM) {
            return new SortedName(1, csmOffsetableDeclaration.getName(), 1);
        }
        if (csmOffsetableDeclaration.getKind() == CsmDeclaration.Kind.TYPEDEF) {
            return new SortedName(1, csmOffsetableDeclaration.getName(), 2);
        }
        if (csmOffsetableDeclaration.getKind() == CsmDeclaration.Kind.VARIABLE) {
            return new SortedName(2, csmOffsetableDeclaration.getName(), 0);
        }
        if (csmOffsetableDeclaration.getKind() == CsmDeclaration.Kind.FUNCTION) {
            return new SortedName(3, CVUtil.getSignature((CsmFunction)csmOffsetableDeclaration), 0);
        }
        if (csmOffsetableDeclaration.getKind() == CsmDeclaration.Kind.FUNCTION_DEFINITION) {
            return new SortedName(3, CVUtil.getSignature((CsmFunction)csmOffsetableDeclaration), 1);
        }
        return new SortedName(9, csmOffsetableDeclaration.getName(), 0);
    }

    protected CsmProject getProject() {
        return this.myProject;
    }

    protected PersistentKey getHostId() {
        return this.myID;
    }

    @Override
    public boolean newNamespsce(CsmNamespace csmNamespace) {
        if (!this.isInited) {
            return false;
        }
        PersistentKey persistentKey = PersistentKey.createKey(csmNamespace);
        this.myKeys.put(persistentKey, this.getSortedName(csmNamespace));
        this.update = true;
        return true;
    }

    @Override
    public boolean removeNamespsce(CsmNamespace csmNamespace) {
        if (!this.isInited) {
            return false;
        }
        PersistentKey persistentKey = PersistentKey.createKey(csmNamespace);
        this.myKeys.remove(persistentKey);
        this.childrenUpdater.unregister(this.myProject, persistentKey);
        this.update = true;
        return true;
    }

    @Override
    public boolean newDeclaration(CsmOffsetableDeclaration csmOffsetableDeclaration) {
        PersistentKey persistentKey;
        CsmFunctionDefinition csmFunctionDefinition;
        Object object;
        if (!this.isInited) {
            return false;
        }
        if (CsmKindUtilities.isFunctionDefinition((CsmObject)csmOffsetableDeclaration)) {
            object = (CsmFunctionDefinition)csmOffsetableDeclaration;
            CsmFunction csmFunction = object.getDeclaration();
            if (csmFunction != null && csmFunction != csmOffsetableDeclaration) {
                PersistentKey persistentKey2 = PersistentKey.createKey(csmFunction);
                if (this.myKeys.containsKey(persistentKey2)) {
                    return false;
                }
                csmOffsetableDeclaration = csmFunction;
            }
        } else if (CsmKindUtilities.isFunctionDeclaration((CsmObject)csmOffsetableDeclaration) && (csmFunctionDefinition = (object = (CsmFunction)csmOffsetableDeclaration).getDefinition()) != null && csmFunctionDefinition != csmOffsetableDeclaration && this.myKeys.containsKey(persistentKey = PersistentKey.createKey(csmFunctionDefinition))) {
            this.myKeys.remove(persistentKey);
            this.myChanges.remove(persistentKey);
            this.childrenUpdater.unregister(this.myProject, persistentKey);
        }
        object = PersistentKey.createKey(csmOffsetableDeclaration);
        this.myKeys.put((PersistentKey)object, this.getSortedName(csmOffsetableDeclaration));
        this.myChanges.remove(object);
        this.update = true;
        return true;
    }

    @Override
    public boolean removeDeclaration(CsmOffsetableDeclaration csmOffsetableDeclaration) {
        if (!this.isInited) {
            return false;
        }
        PersistentKey persistentKey = PersistentKey.createKey(csmOffsetableDeclaration);
        if (!this.myKeys.containsKey(persistentKey)) {
            return false;
        }
        this.myKeys.remove(persistentKey);
        this.myChanges.remove(persistentKey);
        this.childrenUpdater.unregister(this.myProject, persistentKey);
        if (CsmKindUtilities.isFunctionDeclaration((CsmObject)csmOffsetableDeclaration)) {
            this.removeFunctionDeclaration(csmOffsetableDeclaration);
        } else if (CsmKindUtilities.isFunctionDefinition((CsmObject)csmOffsetableDeclaration)) {
            this.removeFunctionDefinition(csmOffsetableDeclaration);
        }
        this.update = true;
        return true;
    }

    private void removeFunctionDeclaration(CsmOffsetableDeclaration csmOffsetableDeclaration) {
        PersistentKey persistentKey;
        CsmFunctionDefinition csmFunctionDefinition;
        CsmFunction csmFunction = (CsmFunction)csmOffsetableDeclaration;
        CsmFile csmFile = csmFunction.getContainingFile();
        if (csmFile != null && csmFile.isValid() && (csmFunctionDefinition = (CsmOffsetableDeclaration)csmFile.getProject().findDeclaration(csmFunction.getUniqueName())) != null && !this.myKeys.containsKey(persistentKey = PersistentKey.createKey(csmFunctionDefinition))) {
            this.myKeys.put(persistentKey, this.getSortedName((CsmOffsetableDeclaration)csmFunctionDefinition));
            this.myChanges.remove(persistentKey);
            return;
        }
        csmFunctionDefinition = csmFunction.getDefinition();
        if (csmFunctionDefinition != null && csmFunctionDefinition != csmOffsetableDeclaration && (csmFile = csmFunction.getContainingFile()) != null && csmFile.isValid() && csmFile.getProject().findDeclaration(csmFunctionDefinition.getUniqueName()) != null && !this.myKeys.containsKey(persistentKey = PersistentKey.createKey(csmFunctionDefinition))) {
            this.myKeys.put(persistentKey, this.getSortedName((CsmOffsetableDeclaration)csmFunctionDefinition));
            this.myChanges.remove(persistentKey);
        }
    }

    private void removeFunctionDefinition(CsmOffsetableDeclaration csmOffsetableDeclaration) {
        PersistentKey persistentKey;
        CsmOffsetableDeclaration csmOffsetableDeclaration2;
        CsmFile csmFile;
        CsmFunctionDefinition csmFunctionDefinition = (CsmFunctionDefinition)csmOffsetableDeclaration;
        CsmFunction csmFunction = csmFunctionDefinition.getDeclaration();
        if (csmFunction != null && csmFunction != csmOffsetableDeclaration && (csmFile = csmFunction.getContainingFile()) != null && csmFile.isValid() && (csmOffsetableDeclaration2 = (CsmOffsetableDeclaration)csmFile.getProject().findDeclaration(csmFunction.getUniqueName())) != null && !this.myKeys.containsKey(persistentKey = PersistentKey.createKey(csmOffsetableDeclaration2))) {
            this.myKeys.put(persistentKey, this.getSortedName(csmOffsetableDeclaration2));
            this.myChanges.remove(persistentKey);
            return;
        }
        csmFile = csmFunctionDefinition.getContainingFile();
        if (csmFile != null && csmFile.isValid() && (csmOffsetableDeclaration2 = (CsmOffsetableDeclaration)csmFile.getProject().findDeclaration(csmFunctionDefinition.getUniqueName())) != null && !this.myKeys.containsKey(persistentKey = PersistentKey.createKey(csmOffsetableDeclaration2))) {
            this.myKeys.put(persistentKey, this.getSortedName(csmOffsetableDeclaration2));
            this.myChanges.remove(persistentKey);
        }
    }

    @Override
    public boolean changeDeclaration(CsmOffsetableDeclaration csmOffsetableDeclaration, CsmOffsetableDeclaration csmOffsetableDeclaration2) {
        if (!this.isInited) {
            return false;
        }
        PersistentKey persistentKey = PersistentKey.createKey(csmOffsetableDeclaration);
        if (csmOffsetableDeclaration2 == null) {
            this.myKeys.remove(persistentKey);
            this.myChanges.remove(persistentKey);
            this.childrenUpdater.unregister(this.myProject, persistentKey);
            this.update = true;
            return true;
        }
        PersistentKey persistentKey2 = PersistentKey.createKey(csmOffsetableDeclaration2);
        if (persistentKey.equals(persistentKey2)) {
            if (this.myKeys.containsKey(persistentKey2)) {
                this.myKeys.put(persistentKey2, this.getSortedName(csmOffsetableDeclaration2));
                ChangeListener changeListener = this.myChanges.get(persistentKey2);
                if (changeListener != null) {
                    changeListener.stateChanged(new ChangeEvent(csmOffsetableDeclaration2));
                }
                return this.updateFunction(csmOffsetableDeclaration2);
            }
            return this.newDeclaration(csmOffsetableDeclaration2);
        }
        this.removeDeclaration(csmOffsetableDeclaration);
        this.newDeclaration(csmOffsetableDeclaration2);
        this.update = true;
        return true;
    }

    private boolean updateFunction(CsmOffsetableDeclaration csmOffsetableDeclaration) {
        PersistentKey persistentKey;
        CsmFunctionDefinition csmFunctionDefinition;
        CsmFunction csmFunction;
        if (CsmKindUtilities.isFunctionDeclaration((CsmObject)csmOffsetableDeclaration)) {
            PersistentKey persistentKey2;
            CsmFunction csmFunction2 = (CsmFunction)csmOffsetableDeclaration;
            CsmFunctionDefinition csmFunctionDefinition2 = csmFunction2.getDefinition();
            if (csmFunctionDefinition2 != null && csmFunctionDefinition2 != csmOffsetableDeclaration && this.myKeys.containsKey(persistentKey2 = PersistentKey.createKey(csmFunctionDefinition2))) {
                this.myKeys.remove(persistentKey2);
                this.myChanges.remove(persistentKey2);
                this.childrenUpdater.unregister(this.myProject, persistentKey2);
                this.update = true;
                return true;
            }
        } else if (CsmKindUtilities.isFunctionDefinition((CsmObject)csmOffsetableDeclaration) && (csmFunction = (csmFunctionDefinition = (CsmFunctionDefinition)csmOffsetableDeclaration).getDeclaration()) != null && csmFunction != csmOffsetableDeclaration && this.myKeys.containsKey(persistentKey = PersistentKey.createKey(csmFunction))) {
            return this.removeDeclaration(csmOffsetableDeclaration);
        }
        return false;
    }

    @Override
    public boolean reset(CsmOffsetableDeclaration csmOffsetableDeclaration, List<CsmOffsetableDeclaration> list) {
        this.myID = PersistentKey.createKey(csmOffsetableDeclaration);
        if (!this.isInited) {
            return false;
        }
        boolean bl = false;
        Map<PersistentKey, SortedName> map = this.getMembers();
        ArrayList<PersistentKey> arrayList = null;
        for (PersistentKey object : this.myKeys.keySet()) {
            if (map.containsKey(object)) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<PersistentKey>();
            }
            arrayList.add(object);
        }
        if (arrayList != null) {
            for (PersistentKey persistentKey : arrayList) {
                this.myKeys.remove(persistentKey);
                this.myChanges.remove(persistentKey);
                bl = true;
            }
        }
        for (Map.Entry entry : map.entrySet()) {
            PersistentKey persistentKey = (PersistentKey)entry.getKey();
            if (this.myKeys.containsKey(persistentKey)) {
                this.myKeys.put(persistentKey, (SortedName)entry.getValue());
                CsmOffsetableDeclaration csmOffsetableDeclaration2 = this.findDeclaration(persistentKey);
                if (csmOffsetableDeclaration2 == null) {
                    this.myKeys.remove(persistentKey);
                    this.myChanges.remove(persistentKey);
                    bl = true;
                    continue;
                }
                ChangeListener changeListener = this.myChanges.get(persistentKey);
                if (changeListener != null) {
                    changeListener.stateChanged(new ChangeEvent(csmOffsetableDeclaration2));
                }
                if (!CsmKindUtilities.isClassifier((CsmObject)csmOffsetableDeclaration2) && !CsmKindUtilities.isEnum((CsmObject)csmOffsetableDeclaration2)) continue;
                list.add(csmOffsetableDeclaration2);
                continue;
            }
            this.myKeys.put(persistentKey, (SortedName)entry.getValue());
            this.myChanges.remove(persistentKey);
            bl = true;
        }
        if (bl) {
            this.update = true;
            return true;
        }
        return false;
    }

    @Override
    public void flush() {
        if (this.update && this.isInited) {
            this.resetKeys();
        }
        this.update = false;
    }

    protected Node[] createNodes(PersistentKey persistentKey) {
        Node node = this.createNode(persistentKey);
        if (node != null) {
            if (node instanceof ChangeListener) {
                this.myChanges.put(persistentKey, (ChangeListener)node);
            }
            return new Node[]{node};
        }
        return new Node[0];
    }

    public Node findChild(CsmObject csmObject) {
        Node[] nodeArray = this.getNodes();
        if (nodeArray.length == 0) {
            return null;
        }
        if (csmObject == null) {
            return nodeArray[0];
        }
        Node node = null;
        CharSequence charSequence = null;
        if (CsmKindUtilities.isQualified((CsmObject)csmObject)) {
            charSequence = ((CsmQualifiedNamedElement)csmObject).getQualifiedName();
        }
        CharSequence charSequence2 = null;
        if (CsmKindUtilities.isFunction((CsmObject)csmObject)) {
            charSequence2 = ((CsmFunction)csmObject).getSignature();
        }
        for (int i = 0; i < nodeArray.length; ++i) {
            CharSequence charSequence3;
            if (!(nodeArray[i] instanceof AbstractCsmNode)) continue;
            CsmObject csmObject2 = ((AbstractCsmNode)nodeArray[i]).getCsmObject();
            if (csmObject.equals(csmObject2)) {
                return nodeArray[i];
            }
            if (node != null || csmObject2 == null || charSequence == null || !CsmKindUtilities.isQualified((CsmObject)csmObject2) || CharSequenceKey.Comparator.compare(charSequence, charSequence3 = ((CsmQualifiedNamedElement)csmObject2).getQualifiedName()) != 0) continue;
            if (CsmKindUtilities.isFunction((CsmObject)csmObject) || CsmKindUtilities.isFunction((CsmObject)csmObject2)) {
                if (!CsmKindUtilities.isFunction((CsmObject)csmObject) || !CsmKindUtilities.isFunction((CsmObject)csmObject2)) continue;
                CharSequence charSequence4 = ((CsmFunction)csmObject2).getSignature();
                if (CharSequenceKey.Comparator.compare(charSequence2, charSequence4) == 0) {
                    return nodeArray[i];
                }
                node = nodeArray[i];
                continue;
            }
            node = nodeArray[i];
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureInited() {
        Object object = this.childrenUpdater.getLock(this.getProject());
        synchronized (object) {
            if (!this.isInited) {
                this.addNotify(true);
            }
        }
    }

    protected void addNotify() {
        this.addNotify(noLoadinNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNotify(boolean bl) {
        Object object = this.childrenUpdater.getLock(this.getProject());
        synchronized (object) {
            if (this.isInited || this.isDisposed) {
                return;
            }
            if (this.isNamespace() && !bl) {
                this.myKeys = new HashMap<PersistentKey, SortedName>();
                this.myKeys.put(PersistentKey.createKey(this.getProject()), new SortedName(0, "", 0));
            } else {
                this.myKeys = this.getMembers();
            }
            this.myChanges = new HashMap<PersistentKey, ChangeListener>();
            this.isInited = true;
            this.resetKeys();
        }
        super.addNotify();
        if (this.isNamespace() && !bl) {
            RequestProcessor.getDefault().post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Object object = HostKeyArray.this.childrenUpdater.getLock(HostKeyArray.this.getProject());
                    synchronized (object) {
                        HostKeyArray.this.myKeys = HostKeyArray.this.getMembers();
                        HostKeyArray.this.resetKeys();
                    }
                }
            });
        }
    }

    protected void removeNotify() {
        super.removeNotify();
        this.isInited = false;
        this.myKeys.clear();
        this.myChanges.clear();
        this.childrenUpdater.unregister(this.myProject, this.myID);
        this.resetKeys();
        if (traceEvents) {
            System.out.println("Remove key " + this.myID.toString());
        }
    }

    protected void destroyNodes(Node[] nodeArray) {
        for (Node node : nodeArray) {
            Children children = node.getChildren();
            if (!(children instanceof HostKeyArray)) continue;
            ((HostKeyArray)children).dispose();
        }
        super.destroyNodes(nodeArray);
        if (traceEvents) {
            System.out.println("Destroy nodes " + nodeArray.length + " in " + this.myID.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onPprojectParsingFinished(CsmProject csmProject) {
        if (!this.isInited || csmProject != this.getProject()) {
            return;
        }
        Object object = this.childrenUpdater.getLock(this.getProject());
        synchronized (object) {
            PersistentKey persistentKey = PersistentKey.createKey(csmProject);
            if (this.myKeys.containsKey(persistentKey)) {
                this.myKeys.remove(persistentKey);
                this.resetKeys();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyComparator
    implements Comparator<Map.Entry<PersistentKey, SortedName>> {
        private MyComparator() {
        }

        @Override
        public int compare(Map.Entry<PersistentKey, SortedName> entry, Map.Entry<PersistentKey, SortedName> entry2) {
            SortedName sortedName;
            SortedName sortedName2 = entry.getValue();
            int n = sortedName2.compareTo(sortedName = entry2.getValue());
            if (n != 0) {
                return n;
            }
            String string = entry.getKey().toString();
            String string2 = entry2.getKey().toString();
            return string.compareTo(string2);
        }
    }
}

