/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdiscovery.provider;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.netbeans.modules.cnd.discovery.api.DiscoveryUtils;
import org.netbeans.modules.cnd.discovery.api.ItemProperties;
import org.netbeans.modules.cnd.discovery.api.PkgConfigManager;
import org.netbeans.modules.cnd.discovery.api.Progress;
import org.netbeans.modules.cnd.discovery.api.SourceFileProperties;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.PathCache;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogReader {
    private static boolean TRACE = Boolean.getBoolean("cnd.dwarfdiscovery.trace.read.log");
    private String workingDir;
    private String baseWorkingDir;
    private final String root;
    private final String fileName;
    private List<SourceFileProperties> result;
    private static final String CURRENT_DIRECTORY = "Current working directory";
    private static final String ENTERING_DIRECTORY = "Entering directory";
    private static final String LABEL_CD = "cd ";
    private static final String INVOKE_SUN_C = "cc ";
    private static final String INVOKE_SUN_CC = "CC ";
    private static final String INVOKE_GNU_C = "gcc ";
    private static final String INVOKE_GNU_CC = "g++ ";
    private static final String INVOKE_MSVC = "cl ";
    private static final String MAKE_DELIMITER = ";";
    private static final String PKG_CONFIG_PATTERN = "pkg-config ";
    private static final String ECHO_PATTERN = "echo ";
    private static final FileFilter dirFilter = new FileFilter(){

        public boolean accept(File file) {
            return file.isDirectory();
        }
    };

    public LogReader(String string, String string2) {
        this.root = string2.length() > 0 ? CndFileUtils.normalizeFile((File)new File(string2)).getAbsolutePath() : string2;
        this.fileName = string;
        this.setWorkingDir(string2);
    }

    private void run(Progress progress) {
        if (TRACE) {
            System.out.println("LogReader is run for " + this.fileName);
        }
        Pattern pattern = Pattern.compile(";|\\|\\||&&");
        this.result = new ArrayList<SourceFileProperties>();
        File file = new File(this.fileName);
        if (file.exists() && file.canRead()) {
            try {
                String string;
                PkgConfigManager.PkgConfig pkgConfig = PkgConfigManager.getDefault().getPkgConfig(null);
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                long l = file.length();
                long l2 = 0L;
                int n = 0;
                if (l <= 0L) {
                    progress = null;
                }
                if (progress != null) {
                    progress.start(100);
                }
                int n2 = 0;
                while ((string = bufferedReader.readLine()) != null) {
                    String[] stringArray;
                    l2 += (long)(string.length() + 1);
                    string = string.trim();
                    while (string.endsWith("\\") && (stringArray = bufferedReader.readLine()) != null) {
                        string = string.substring(0, string.length() - 1) + " " + stringArray.trim();
                    }
                    string = LogReader.trimBackApostropheCalls(string, pkgConfig);
                    stringArray = pattern.split(string);
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (!this.parseLine(stringArray[i])) continue;
                        ++n2;
                    }
                    if (l2 * 100L / l <= (long)n || n >= 100) continue;
                    ++n;
                    if (progress == null) continue;
                    progress.increment();
                }
                if (progress != null) {
                    progress.done();
                }
                if (TRACE) {
                    System.out.println("Files found: " + n2);
                    System.out.println("Files included in result: " + this.result.size());
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public List<SourceFileProperties> getResults(Progress progress) {
        if (this.result == null) {
            this.run(progress);
        }
        return this.result;
    }

    private boolean checkDirectoryChange(String string) {
        String string2;
        String string3;
        String string4 = null;
        String string5 = null;
        if (string.startsWith(CURRENT_DIRECTORY)) {
            string4 = string.substring(CURRENT_DIRECTORY.length() + 1).trim();
            if (TRACE) {
                string5 = "**>> by [Current working directory] ";
            }
        } else if (string.indexOf(ENTERING_DIRECTORY) >= 0) {
            string3 = string.substring(string.indexOf(ENTERING_DIRECTORY) + ENTERING_DIRECTORY.length() + 1).trim();
            string4 = string3.replaceAll("`|'|\"", "");
            if (TRACE) {
                string5 = "**>> by [Entering directory] ";
            }
            this.baseWorkingDir = string4;
        } else if (string.startsWith(LABEL_CD)) {
            int n = string.indexOf(MAKE_DELIMITER);
            string4 = (n == -1 ? string : string.substring(0, n)).substring(LABEL_CD.length()).trim();
            if (TRACE) {
                string5 = "**>> by [ cd ] ";
            }
            if (string4.startsWith("/")) {
                this.baseWorkingDir = string4;
            }
        } else if (string.startsWith("/") && string.indexOf(" ") < 0) {
            string4 = string.trim();
            if (TRACE) {
                string5 = "**>> by [just path string] ";
            }
        }
        if (string4 == null) {
            return false;
        }
        if (Utilities.isWindows() && string4.startsWith("/cygdrive/") && string4.length() > 11) {
            string4 = "" + string4.charAt(10) + ":" + string4.substring(11);
        }
        if (!string4.startsWith(".") && new File(string4).exists()) {
            if (TRACE) {
                System.err.print(string5);
            }
            this.setWorkingDir(string4);
            return true;
        }
        string3 = this.workingDir + File.separator + string4;
        if (new File(string3).exists()) {
            if (TRACE) {
                System.err.print(string5);
            }
            this.setWorkingDir(string3);
            return true;
        }
        if (Utilities.isWindows() && string4.length() > 3 && string4.charAt(0) == '/' && string4.charAt(2) == '/' && new File(string2 = "" + string4.charAt(1) + ":" + string4.substring(2)).exists()) {
            if (TRACE) {
                System.err.print(string5);
            }
            this.setWorkingDir(string2);
            return true;
        }
        if (this.baseWorkingDir != null && new File(string3 = this.baseWorkingDir + File.separator + string4).exists()) {
            if (TRACE) {
                System.err.print(string5);
            }
            this.setWorkingDir(string3);
            return true;
        }
        return false;
    }

    static LineInfo testCompilerInvocation(String string) {
        LineInfo lineInfo = new LineInfo(string);
        int n = 0;
        int n2 = -1;
        if (lineInfo.compilerType == CompilerType.UNKNOWN && (n = string.indexOf(INVOKE_GNU_C)) >= 0) {
            lineInfo.compilerType = CompilerType.C;
            n2 = n + INVOKE_GNU_C.length();
        }
        if (lineInfo.compilerType == CompilerType.UNKNOWN && (n = string.indexOf(INVOKE_GNU_CC)) >= 0) {
            lineInfo.compilerType = CompilerType.CPP;
            n2 = n + INVOKE_GNU_CC.length();
        }
        if (lineInfo.compilerType == CompilerType.UNKNOWN && (n = string.indexOf(INVOKE_SUN_C)) >= 0) {
            lineInfo.compilerType = CompilerType.C;
            n2 = n + INVOKE_SUN_C.length();
        }
        if (lineInfo.compilerType == CompilerType.UNKNOWN && (n = string.indexOf(INVOKE_SUN_CC)) >= 0) {
            lineInfo.compilerType = CompilerType.CPP;
            n2 = n + INVOKE_SUN_CC.length();
        }
        if (lineInfo.compilerType == CompilerType.UNKNOWN && (n = string.indexOf(INVOKE_MSVC)) >= 0) {
            lineInfo.compilerType = CompilerType.CPP;
            n2 = n + INVOKE_MSVC.length();
        }
        if (lineInfo.compilerType != CompilerType.UNKNOWN) {
            lineInfo.compileLine = string.substring(n);
            while (n2 < string.length() && (string.charAt(n2) == ' ' || string.charAt(n2) == '\t')) {
                ++n2;
            }
            if (n2 >= string.length() || string.charAt(n2) != '-') {
                lineInfo.compilerType = CompilerType.UNKNOWN;
            }
        }
        return lineInfo;
    }

    private void setWorkingDir(String string) {
        if (TRACE) {
            System.err.println("**>> new working dir: " + string);
        }
        this.workingDir = CndFileUtils.normalizeFile((File)new File(string)).getAbsolutePath();
    }

    private boolean parseLine(String string) {
        if (this.checkDirectoryChange(string)) {
            return false;
        }
        if (this.workingDir == null) {
            return false;
        }
        if (!this.workingDir.startsWith(this.root)) {
            return false;
        }
        LineInfo lineInfo = LogReader.testCompilerInvocation(string);
        if (lineInfo.compilerType != CompilerType.UNKNOWN) {
            this.gatherLine(lineInfo.compileLine, string.startsWith("+"), lineInfo.compilerType == CompilerType.CPP);
            return true;
        }
        return false;
    }

    static String trimBackApostropheCalls(String string, PkgConfigManager.PkgConfig pkgConfig) {
        StringTokenizer stringTokenizer;
        int n;
        int n2 = string.indexOf(96);
        if (string.lastIndexOf(96) == n2) {
            return string;
        }
        if (n2 < 0 || n2 == string.length() - 1) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (n2 > 0) {
            stringBuilder.append(string.substring(0, n2));
        }
        if ((n = (string = string.substring(n2 + 1)).indexOf(96)) < 0) {
            return string;
        }
        String string2 = string.substring(0, n);
        if (string2.startsWith(PKG_CONFIG_PATTERN)) {
            String string3;
            string2 = string2.substring(PKG_CONFIG_PATTERN.length());
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2);
            boolean bl = false;
            String string4 = null;
            while (stringTokenizer2.hasMoreTokens()) {
                string3 = stringTokenizer2.nextToken();
                if (string3.equals("--cflags")) {
                    bl = true;
                    continue;
                }
                if (string3.startsWith("-")) {
                    bl = false;
                    continue;
                }
                string4 = string3;
            }
            if (bl && pkgConfig != null && string4 != null && (string3 = pkgConfig.getPkgConfig(string4)) != null) {
                for (String string5 : string3.getIncludePaths()) {
                    stringBuilder.append(" -I" + string5);
                }
                for (String string5 : string3.getMacros()) {
                    stringBuilder.append(" -D" + string5);
                }
                stringBuilder.append(" ");
            }
        } else if (string2.startsWith(ECHO_PATTERN) && (stringTokenizer = new StringTokenizer(string2 = string2.substring(ECHO_PATTERN.length()))).hasMoreTokens()) {
            stringBuilder.append(" ");
            stringBuilder.append(stringTokenizer.nextToken());
            stringBuilder.append(" ");
        }
        stringBuilder.append(string.substring(n + 1));
        return LogReader.trimBackApostropheCalls(stringBuilder.toString(), pkgConfig);
    }

    private boolean gatherLine(String string, boolean bl, boolean bl2) {
        Object object22;
        ArrayList arrayList = new ArrayList();
        HashMap hashMap = new HashMap();
        String string2 = DiscoveryUtils.gatherCompilerLine((String)string, (boolean)bl, arrayList, hashMap, null);
        if (string2 == null) {
            return false;
        }
        String string3 = null;
        string3 = string2.startsWith("/") ? string2 : this.workingDir + "/" + string2;
        ArrayList<String> arrayList2 = new ArrayList<String>(arrayList.size());
        for (Object object22 : arrayList) {
            arrayList2.add(PathCache.getString((String)object22));
        }
        HashMap hashMap2 = new HashMap(hashMap.size());
        for (Map.Entry stringArray : hashMap.entrySet()) {
            if (stringArray.getValue() == null) {
                hashMap2.put(PathCache.getString((String)stringArray.getKey()), null);
                continue;
            }
            hashMap2.put(PathCache.getString((String)stringArray.getKey()), PathCache.getString((String)stringArray.getValue()));
        }
        object22 = new File(string3);
        if (!((File)object22).exists() || !((File)object22).isFile()) {
            block17: {
                if (TRACE) {
                    System.err.println("**** Not found " + string3);
                }
                if (!string2.startsWith("/")) {
                    try {
                        String[] iOException = new String[1];
                        boolean bl3 = LogReader.findFiles(new File(this.root), string2, iOException);
                        if (iOException[0] == null) {
                            if (TRACE) {
                                System.err.println("** And there is no such file under root");
                            }
                        } else {
                            if (bl3) {
                                this.result.add(new CommandLineSource(bl2, iOException[0], string2, arrayList, hashMap));
                                if (TRACE) {
                                    System.err.println("** Gotcha: " + iOException[0] + File.separator + string2);
                                }
                                this.setWorkingDir(iOException[0]);
                                return true;
                            }
                            if (TRACE) {
                                System.err.println("**There are several candidates and I'm not clever enough yet to find correct one.");
                            }
                        }
                    }
                    catch (IOException iOException) {
                        if (!TRACE) break block17;
                        Exceptions.printStackTrace((Throwable)iOException);
                    }
                }
            }
            if (TRACE) {
                System.err.println("" + (string.length() > 120 ? string.substring(0, 117) + ">>>" : string) + " [" + string2 + "]");
            }
            return false;
        }
        if (TRACE) {
            System.err.println("**** Gotcha: " + string3);
        }
        this.result.add(new CommandLineSource(bl2, this.workingDir, string2, arrayList2, hashMap2));
        return true;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 2) {
            System.err.println("Not enough parameters. Format: bla-bla-bla filename root");
            return;
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        TRACE = true;
        LogReader logReader = new LogReader(string, string2);
        List<SourceFileProperties> list = logReader.getResults(null);
        System.err.print("\n*** Results: ");
        for (SourceFileProperties sourceFileProperties : list) {
            String string3 = sourceFileProperties.getItemName();
            while (string3.indexOf("../") == 0) {
                string3 = string3.substring(3);
            }
            System.err.print(string3 + " ");
        }
        System.err.println();
    }

    private static boolean findFiles(File file, String string, String[] stringArray) throws IOException {
        File file2 = new File(file.getAbsolutePath() + File.separator + string);
        if (file2.exists() && file2.isFile()) {
            if (stringArray[0] != null && !new File(stringArray[0] + File.separator + string).getCanonicalPath().equals(file2.getCanonicalPath())) {
                return false;
            }
            stringArray[0] = file.getAbsolutePath();
        }
        for (File file3 : file.listFiles(dirFilter)) {
            if (LogReader.findFiles(file3, string, stringArray)) continue;
            return false;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CommandLineSource
    implements SourceFileProperties {
        private String compilePath;
        private String sourceName;
        private String fullName;
        private ItemProperties.LanguageKind language;
        private List<String> userIncludes;
        private List<String> systemIncludes = Collections.emptyList();
        private Map<String, String> userMacros;
        private Map<String, String> systemMacros = Collections.emptyMap();
        private Set<String> includedFiles = Collections.emptySet();

        private CommandLineSource(boolean bl, String string, String string2, List<String> list, Map<String, String> map) {
            this.language = bl ? ItemProperties.LanguageKind.CPP : ItemProperties.LanguageKind.C;
            this.compilePath = string;
            this.sourceName = string2;
            if (this.sourceName.startsWith("/")) {
                this.fullName = this.sourceName;
                this.sourceName = DiscoveryUtils.getRelativePath((String)string, (String)this.sourceName);
            } else {
                this.fullName = string + "/" + this.sourceName;
            }
            File file = new File(this.fullName);
            this.fullName = CndFileUtils.normalizeFile((File)file).getAbsolutePath();
            this.fullName = PathCache.getString(this.fullName);
            this.userIncludes = list;
            this.userMacros = map;
        }

        public String getCompilePath() {
            return this.compilePath;
        }

        public String getItemPath() {
            return this.fullName;
        }

        public String getItemName() {
            return this.sourceName;
        }

        public List<String> getUserInludePaths() {
            return this.userIncludes;
        }

        public List<String> getSystemInludePaths() {
            return this.systemIncludes;
        }

        public Set<String> getIncludedFiles() {
            return this.includedFiles;
        }

        public Map<String, String> getUserMacros() {
            return this.userMacros;
        }

        public Map<String, String> getSystemMacros() {
            return this.systemMacros;
        }

        public ItemProperties.LanguageKind getLanguageKind() {
            return this.language;
        }
    }

    static class LineInfo {
        public String compileLine;
        public CompilerType compilerType = CompilerType.UNKNOWN;

        LineInfo(String string) {
            this.compileLine = string;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum CompilerType {
        CPP,
        C,
        UNKNOWN;

    }
}

