/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modeldiscovery.provider;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.compilers.CompilerSet;
import org.netbeans.modules.cnd.api.compilers.CompilerSetManager;
import org.netbeans.modules.cnd.api.remote.RemoteFile;
import org.netbeans.modules.cnd.api.utils.PlatformInfo;
import org.netbeans.modules.cnd.discovery.api.PkgConfigManager;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PkgConfigImpl
implements PkgConfigManager.PkgConfig {
    private HashMap<String, PackageConfigurationImpl> configurations = new HashMap();
    private Map<String, Pair> seachBase;
    private String drivePrefix;
    private PlatformInfo pi;

    public PkgConfigImpl(Project project) {
        MakeConfiguration makeConfiguration;
        if (project != null && (makeConfiguration = (MakeConfiguration)project.getLookup().lookup(MakeConfiguration.class)) != null) {
            this.pi = makeConfiguration.getPlatformInfo();
            CompilerSet compilerSet = makeConfiguration.getCompilerSet().getCompilerSet();
            this.initPackagesFromSet(compilerSet);
            return;
        }
        this.pi = PlatformInfo.localhost();
        this.initPackagesFromSet(null);
    }

    PkgConfigImpl(PlatformInfo platformInfo, CompilerSet compilerSet) {
        this.pi = platformInfo;
        this.initPackagesFromSet(compilerSet);
    }

    private List<String> envPaths(String string) {
        String string2 = System.getenv("PKG_CONFIG_PATH");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        if (string2 != null && string2.length() > 0) {
            StringTokenizer stringTokenizer = this.pi.isWindows() ? new StringTokenizer(string2, ";") : new StringTokenizer(string2, ":");
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken());
            }
        }
        return arrayList;
    }

    private void initPackagesFromSet(CompilerSet compilerSet) {
        if (this.pi.isWindows()) {
            String string = null;
            if (compilerSet == null) {
                compilerSet = CompilerSetManager.getDefault().getCompilerSet(CompilerSet.CompilerFlavor.toFlavor((String)"Cygwin", (int)3));
            }
            if (compilerSet != null && (string = compilerSet.getDirectory()) != null && string.endsWith("bin")) {
                this.drivePrefix = string.substring(0, string.length() - 4);
                string = string.substring(0, string.length() - 3) + "lib/pkgconfig/";
            }
            if (string == null) {
                this.drivePrefix = "c:/cygwin";
                string = "c:/cygwin/lib/pkgconfig/";
            }
            this.initPackages(this.envPaths(string));
        } else {
            this.initPackages(this.envPaths("/usr/lib/pkgconfig/"));
        }
    }

    private void initPackages(List<String> list) {
        HashSet<File> hashSet = new HashSet<File>();
        for (String string : list) {
            File file = RemoteFile.create((ExecutionEnvironment)this.pi.getExecutionEnvironment(), (String)string);
            if (hashSet.contains(file)) continue;
            hashSet.add(file);
            if (!file.exists() || !file.isDirectory() || !file.canRead()) continue;
            for (File file2 : file.listFiles()) {
                String string2 = file2.getName();
                if (!string2.endsWith(".pc") || !file2.canRead() || !file2.isFile()) continue;
                String string3 = string2.substring(0, string2.length() - 3);
                PackageConfigurationImpl packageConfigurationImpl = new PackageConfigurationImpl(string3);
                this.readConfig(file2, packageConfigurationImpl);
                this.configurations.put(string3, packageConfigurationImpl);
            }
        }
    }

    public PkgConfigManager.PackageConfiguration getPkgConfig(String string) {
        return this.getConfig(string);
    }

    public PkgConfigManager.ResolvedPath getResolvedPath(String string) {
        Map<String, Pair> map = this.getLibraryItems();
        Pair pair = map.get(string);
        if (pair != null) {
            return new ResolvedPathImpl(pair.path, pair.configurations);
        }
        return null;
    }

    void trace() {
        ArrayList<String> arrayList = new ArrayList<String>(this.configurations.keySet());
        Collections.sort(arrayList);
        for (String object : arrayList) {
            this.traceConfig(object, false);
        }
        Map<String, Pair> map = this.getLibraryItems();
        System.out.println("Known includes size: " + map.size());
        arrayList = new ArrayList(map.keySet());
        Collections.sort(arrayList);
        for (String string : arrayList) {
            Pair pair = (Pair)map.get(string);
            StringBuilder stringBuilder = new StringBuilder();
            for (PkgConfigManager.PackageConfiguration packageConfiguration : pair.configurations) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(packageConfiguration.getName());
            }
            System.out.println(string + "\t" + pair.path + "\t[" + stringBuilder.toString() + "]");
        }
    }

    void traceConfig(String string, boolean bl) {
        this.traceConfig(string, bl, new HashSet<String>(), "");
    }

    private void traceConfig(String string, boolean bl, Set<String> set, String string2) {
        if (set.contains(string)) {
            return;
        }
        set.add(string);
        PackageConfigurationImpl packageConfigurationImpl = this.configurations.get(string);
        if (packageConfigurationImpl != null) {
            System.out.println(string2 + "Package definition");
            System.out.println(string2 + "Name:     " + string);
            System.out.println(string2 + "Requires: " + packageConfigurationImpl.requires);
            System.out.println(string2 + "Macros:   " + packageConfigurationImpl.macros);
            System.out.println(string2 + "Paths:    " + packageConfigurationImpl.paths);
            if (bl) {
                for (String string3 : packageConfigurationImpl.requires) {
                    this.traceConfig(string3, bl, set, string2 + "    ");
                }
            }
        } else {
            System.out.println("Not found package definition " + string);
        }
    }

    void traceRecursiveConfig(String string) {
        PkgConfigManager.PackageConfiguration packageConfiguration = this.getConfig(string);
        if (packageConfiguration != null) {
            System.out.println("Recursive package definition");
            System.out.println("Name:    " + string);
            System.out.println("Package: " + string);
            System.out.println("Macros:  " + packageConfiguration.getMacros());
            System.out.println("Paths:   " + packageConfiguration.getIncludePaths());
        }
    }

    private PkgConfigManager.PackageConfiguration getConfig(String string) {
        PackageConfigurationImpl packageConfigurationImpl = new PackageConfigurationImpl(string);
        this.getConfig(packageConfigurationImpl, this.configurations.get(string));
        return packageConfigurationImpl;
    }

    private void getConfig(PackageConfigurationImpl packageConfigurationImpl, PackageConfigurationImpl packageConfigurationImpl2) {
        if (packageConfigurationImpl2 != null) {
            for (String string : packageConfigurationImpl2.macros) {
                if (packageConfigurationImpl.macros.contains(string)) continue;
                packageConfigurationImpl.macros.add(string);
            }
            for (String string : packageConfigurationImpl2.paths) {
                if (packageConfigurationImpl.paths.contains(string)) continue;
                packageConfigurationImpl.paths.add(string);
            }
            for (String string : packageConfigurationImpl2.requires) {
                this.getConfig(packageConfigurationImpl, this.configurations.get(string));
            }
        }
    }

    private Map<String, Pair> getLibraryItems() {
        Map<String, Pair> map = null;
        if (this.seachBase != null) {
            map = this.seachBase;
        }
        if (map == null) {
            this.seachBase = map = this._getLibraryItems();
        }
        return map;
    }

    private Map<String, Pair> _getLibraryItems() {
        HashMap<String, HashSet<PackageConfigurationImpl>> hashMap = new HashMap<String, HashSet<PackageConfigurationImpl>>();
        for (String object : this.configurations.keySet()) {
            PackageConfigurationImpl packageConfigurationImpl = this.configurations.get(object);
            if (packageConfigurationImpl == null) continue;
            for (String string : packageConfigurationImpl.paths) {
                if (this.drivePrefix == null ? string.equals("/usr/include") || string.equals("/usr/sfw/include") : string.substring(this.drivePrefix.length()).equals("/usr/include") || string.substring(this.drivePrefix.length()).equals("/usr/sfw/include")) continue;
                HashSet<PackageConfigurationImpl> hashSet = (HashSet<PackageConfigurationImpl>)hashMap.get(string);
                if (hashSet == null) {
                    hashSet = new HashSet<PackageConfigurationImpl>();
                    hashMap.put(string, hashSet);
                }
                hashSet.add(packageConfigurationImpl);
            }
        }
        HashMap hashMap2 = new HashMap();
        for (Map.Entry entry : hashMap.entrySet()) {
            Pair pair = new Pair((String)entry.getKey(), (Set)entry.getValue());
            File file = RemoteFile.create((ExecutionEnvironment)this.pi.getExecutionEnvironment(), (String)((String)entry.getKey()));
            this.addLibraryItem(hashMap2, pair, "", file, 0);
        }
        return hashMap2;
    }

    private void addLibraryItem(Map<String, Pair> map, Pair pair, String string, File file, int n) {
        if (n > 2) {
            return;
        }
        if (file.isDirectory() && file.canRead()) {
            for (File file2 : file.listFiles()) {
                if (!file2.canRead()) continue;
                if (file2.isDirectory()) {
                    if (n == 0) {
                        this.addLibraryItem(map, pair, file2.getName(), file2, n + 1);
                        continue;
                    }
                    this.addLibraryItem(map, pair, string + "/" + file2.getName(), file2, n + 1);
                    continue;
                }
                if (!file2.isFile()) continue;
                String string2 = string.length() == 0 ? file2.getName() : string + "/" + file2.getName();
                map.put(string2, pair);
            }
        }
    }

    private void readConfig(File file, PackageConfigurationImpl packageConfigurationImpl) {
        try {
            String string;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("pcfiledir", file.getParent());
            BufferedReader bufferedReader = new BufferedReader(RemoteFile.createReader((File)file));
            while ((string = bufferedReader.readLine()) != null) {
                String string2;
                Object object;
                if ((string = string.trim()).startsWith("#")) continue;
                if (string.startsWith("Requires:")) {
                    String string3 = string.substring(9).trim();
                    string3 = this.expandMacros(string3, hashMap);
                    object = new StringTokenizer(string3, " ,");
                    while (((StringTokenizer)object).hasMoreTokens()) {
                        string2 = ((StringTokenizer)object).nextToken();
                        if (string2.startsWith("<") || string2.startsWith(">") || string2.startsWith("=") || Character.isDigit(string2.charAt(0))) continue;
                        packageConfigurationImpl.requires.add(string2);
                    }
                    continue;
                }
                if (string.startsWith("Requires.private:")) continue;
                if (string.startsWith("Version:")) {
                    packageConfigurationImpl.version = string.substring(8).trim();
                    continue;
                }
                if (string.startsWith("Cflags:")) {
                    String string4 = string.substring(7).trim();
                    string4 = this.expandMacros(string4, hashMap);
                    object = new StringTokenizer(string4, " ");
                    while (((StringTokenizer)object).hasMoreTokens()) {
                        string2 = ((StringTokenizer)object).nextToken();
                        if (string2.startsWith("-I")) {
                            string2 = string2.substring(2);
                            if (this.drivePrefix != null) {
                                string2 = this.drivePrefix + string2;
                            }
                            packageConfigurationImpl.paths.add(string2);
                            continue;
                        }
                        if (!string2.startsWith("-D")) continue;
                        packageConfigurationImpl.macros.add(string2.substring(2));
                    }
                    continue;
                }
                if (string.indexOf("=") <= 0) continue;
                int n = string.indexOf("=");
                object = string.substring(0, n).trim();
                string2 = string.substring(n + 1).trim();
                hashMap.put((String)object, this.expandMacros(string2, hashMap));
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private String expandMacros(String string, Map<String, String> map) {
        if (string.indexOf("${") >= 0) {
            while (string.indexOf("${") >= 0) {
                String string2;
                String string3;
                int n = string.indexOf("${");
                int n2 = string.indexOf("}");
                if (n2 < n || (string3 = map.get(string2 = string.substring(n + 2, n2))) == null || string3.indexOf("${") >= 0) break;
                string = string.substring(0, n) + string3 + string.substring(n2 + 1);
            }
        }
        return string;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Pair {
        private String path;
        private Set<PkgConfigManager.PackageConfiguration> configurations;

        private Pair(String string, Set<PkgConfigManager.PackageConfiguration> set) {
            this.path = string;
            this.configurations = set;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ResolvedPathImpl
    implements PkgConfigManager.ResolvedPath {
        private String path;
        private Set<PkgConfigManager.PackageConfiguration> packages;

        private ResolvedPathImpl(String string, Set<PkgConfigManager.PackageConfiguration> set) {
            this.path = string;
            this.packages = set;
        }

        public String getIncludePath() {
            return this.path;
        }

        public Collection<PkgConfigManager.PackageConfiguration> getPackages() {
            ArrayList<PkgConfigManager.PackageConfiguration> arrayList = new ArrayList<PkgConfigManager.PackageConfiguration>(this.packages.size());
            for (PkgConfigManager.PackageConfiguration packageConfiguration : this.packages) {
                arrayList.add(PkgConfigImpl.this.getPkgConfig(packageConfiguration.getName()));
            }
            return arrayList;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PackageConfigurationImpl
    implements PkgConfigManager.PackageConfiguration {
        List<String> requires = new ArrayList<String>();
        List<String> macros = new ArrayList<String>();
        List<String> paths = new ArrayList<String>();
        private String name;
        private String version;

        private PackageConfigurationImpl(String string) {
            this.name = string;
        }

        public Collection<String> getIncludePaths() {
            return new ArrayList<String>(this.paths);
        }

        public Collection<String> getMacros() {
            return new ArrayList<String>(this.macros);
        }

        public String getName() {
            return this.name;
        }
    }
}

