/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grails.settings;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.prefs.Preferences;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.modules.groovy.grails.api.GrailsEnvironment;
import org.openide.util.Exceptions;
import org.openide.util.NbCollections;
import org.openide.util.NbPreferences;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GrailsSettings {
    public static final String GRAILS_BASE_PROPERTY = "grailsBase";
    private static final String GRAILS_HOME_KEY = "grailsHome";
    private static final String GRAILS_PORT_KEY = "grailsPrj-Port-";
    private static final String GRAILS_ENV_KEY = "grailsPrj-Env-";
    private static final String GRAILS_JAVA_PLATFORM_KEY = "grailsPrj-JavaPlatform-";
    private static final String GRAILS_DEBUG_BROWSER_KEY = "grailsPrj-DebugBrowser-";
    private static final String GRAILS_DISPLAY_BROWSER_KEY = "grailsPrj-DisplayBrowser-";
    private static final String GRAILS_PROJECT_PLUGINS_DIR_KEY = "grailsPrj-ProjectPluginsDir-";
    private static final String GRAILS_GLOBAL_PLUGINS_DIR_KEY = "grailsPrj-GlobalPluginsDir-";
    private static GrailsSettings instance;
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    private GrailsSettings() {
    }

    public static synchronized GrailsSettings getInstance() {
        if (instance == null) {
            instance = new GrailsSettings();
        }
        return instance;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getGrailsBase() {
        String string = null;
        GrailsSettings grailsSettings = this;
        synchronized (grailsSettings) {
            string = this.getPreferences().get(GRAILS_HOME_KEY, null);
        }
        if (string == null || string.length() <= 0) {
            string = this.findGroovyPlatform();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGrailsBase(String string) {
        String string2;
        GrailsSettings grailsSettings = this;
        synchronized (grailsSettings) {
            string2 = this.getGrailsBase();
            this.getPreferences().put(GRAILS_HOME_KEY, string);
        }
        this.propertyChangeSupport.firePropertyChange(GRAILS_BASE_PROPERTY, string2, string);
    }

    public String getPortForProject(Project project) {
        assert (project != null);
        return this.getPreferences().get(this.getPortKey(project), null);
    }

    public void setPortForProject(Project project, String string) {
        assert (project != null);
        assert (string != null);
        this.getPreferences().put(this.getPortKey(project), string);
    }

    public GrailsEnvironment getEnvForProject(Project project) {
        assert (project != null);
        String string = this.getPreferences().get(this.getEnvKey(project), null);
        if (string != null) {
            return GrailsEnvironment.valueOf(string);
        }
        return null;
    }

    public void setEnvForProject(Project project, GrailsEnvironment grailsEnvironment) {
        assert (project != null);
        assert (grailsEnvironment != null);
        this.getPreferences().put(this.getEnvKey(project), grailsEnvironment.toString());
    }

    public String getDebugBrowserForProject(Project project) {
        assert (project != null);
        return this.getPreferences().get(this.getDebugBrowserKey(project), null);
    }

    public void setDebugBrowserProject(Project project, String string) {
        assert (project != null);
        assert (string != null);
        this.getPreferences().put(this.getDebugBrowserKey(project), string);
    }

    public String getJavaPlatformForProject(Project project) {
        assert (project != null);
        return this.getPreferences().get(this.getJavaPlatformKey(project), null);
    }

    public void setJavaPlatformForProject(Project project, String string) {
        assert (project != null);
        assert (string != null);
        this.getPreferences().put(this.getJavaPlatformKey(project), string);
    }

    public boolean getDisplayBrowserForProject(Project project) {
        assert (project != null);
        return this.getPreferences().getBoolean(this.getDisplayBrowserKey(project), true);
    }

    public void setDisplayBrowserForProject(Project project, boolean bl) {
        assert (project != null);
        this.getPreferences().putBoolean(this.getDisplayBrowserKey(project), bl);
    }

    public String getProjectPluginsDirForProject(Project project) {
        assert (project != null);
        return this.getPreferences().get(this.getProjectPluginsDirKey(project), null);
    }

    public void setProjectPluginsDirForProject(Project project, String string) {
        assert (project != null);
        this.getPreferences().put(this.getProjectPluginsDirKey(project), string);
    }

    public String getGlobalPluginsDirForProject(Project project) {
        assert (project != null);
        return this.getPreferences().get(this.getGlobalPluginsDirKey(project), null);
    }

    public void setGlobalPluginsDirForProject(Project project, String string) {
        assert (project != null);
        this.getPreferences().put(this.getGlobalPluginsDirKey(project), string);
    }

    private String getProjectName(Project project) {
        assert (project != null);
        ProjectInformation projectInformation = (ProjectInformation)project.getLookup().lookup(ProjectInformation.class);
        assert (projectInformation != null);
        return projectInformation.getName();
    }

    private String getPortKey(Project project) {
        assert (project != null);
        return GRAILS_PORT_KEY + this.getProjectName(project);
    }

    private String getEnvKey(Project project) {
        assert (project != null);
        return GRAILS_ENV_KEY + this.getProjectName(project);
    }

    private String getDebugBrowserKey(Project project) {
        assert (project != null);
        return GRAILS_DEBUG_BROWSER_KEY + this.getProjectName(project);
    }

    private String getJavaPlatformKey(Project project) {
        assert (project != null);
        return GRAILS_JAVA_PLATFORM_KEY + this.getProjectName(project);
    }

    private String getDisplayBrowserKey(Project project) {
        assert (project != null);
        return GRAILS_DISPLAY_BROWSER_KEY + this.getProjectName(project);
    }

    private String getProjectPluginsDirKey(Project project) {
        assert (project != null);
        return GRAILS_PROJECT_PLUGINS_DIR_KEY + this.getProjectName(project);
    }

    private String getGlobalPluginsDirKey(Project project) {
        assert (project != null);
        return GRAILS_GLOBAL_PLUGINS_DIR_KEY + this.getProjectName(project);
    }

    private Preferences getPreferences() {
        return NbPreferences.forModule(GrailsSettings.class);
    }

    private String findGroovyPlatform() {
        String string = System.getenv("GRAILS_HOME");
        if (string == null) {
            for (String string2 : GrailsSettings.dirsOnPath()) {
                File file = null;
                file = Utilities.isWindows() ? new File(string2, "grails.bat") : new File(string2, "grails");
                if (!file.isFile()) continue;
                try {
                    string = file.getCanonicalFile().getParentFile().getParent();
                    break;
                }
                catch (Exception exception) {
                    Exceptions.printStackTrace((Throwable)exception);
                }
            }
        }
        return string;
    }

    public static Iterable<String> dirsOnPath() {
        String string = System.getenv("PATH");
        if (string == null) {
            string = System.getenv("Path");
        }
        if (string == null) {
            return Collections.emptyList();
        }
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(Arrays.asList(string.split(File.pathSeparator)));
        Iterator iterator = linkedHashSet.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (new File(string2).isDirectory()) continue;
            iterator.remove();
        }
        return NbCollections.iterable(linkedHashSet.iterator());
    }
}

