/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grails.server;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.server.ServerInstance;
import org.netbeans.modules.groovy.grails.api.GrailsPlatform;
import org.netbeans.modules.groovy.grails.server.GrailsInstance;
import org.netbeans.spi.server.ServerInstanceFactory;
import org.netbeans.spi.server.ServerInstanceImplementation;
import org.netbeans.spi.server.ServerInstanceProvider;
import org.openide.util.ChangeSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GrailsInstanceProvider
implements ServerInstanceProvider {
    private static final ExecutorService PROCESS_EXECUTOR = Executors.newCachedThreadPool();
    private static GrailsInstanceProvider instance;
    private final Map<Process, Project> running = new HashMap<Process, Project>();
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private GrailsInstance grailsInstance;

    private GrailsInstanceProvider() {
    }

    public static synchronized GrailsInstanceProvider getInstance() {
        if (instance == null) {
            instance = new GrailsInstanceProvider();
            GrailsInstanceProvider.instance.grailsInstance = GrailsInstance.forProvider(instance);
        }
        return instance;
    }

    public List<ServerInstance> getInstances() {
        if (!GrailsPlatform.getDefault().isConfigured()) {
            return Collections.emptyList();
        }
        return Collections.singletonList(ServerInstanceFactory.createServerInstance((ServerInstanceImplementation)this.grailsInstance));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Process, Project> getRunningProjects() {
        GrailsInstanceProvider grailsInstanceProvider = this;
        synchronized (grailsInstanceProvider) {
            return new HashMap<Process, Project>(this.running);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serverStarted(Project project, Process process) {
        assert (process != null);
        GrailsInstanceProvider grailsInstanceProvider = this;
        synchronized (grailsInstanceProvider) {
            this.running.put(process, project);
            PROCESS_EXECUTOR.submit(new ProcessHandler(this, process));
        }
        this.grailsInstance.refreshChildren();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serverStopped(Process process) {
        GrailsInstanceProvider grailsInstanceProvider = this;
        synchronized (grailsInstanceProvider) {
            this.running.remove(process);
        }
        this.grailsInstance.refreshChildren();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runtimeChanged() {
        GrailsInstanceProvider grailsInstanceProvider = this;
        synchronized (grailsInstanceProvider) {
            this.running.clear();
        }
        this.grailsInstance.refreshNode();
        this.grailsInstance.refreshChildren();
        this.changeSupport.fireChange();
    }

    private static class ProcessHandler
    implements Runnable {
        private final GrailsInstanceProvider provider;
        private final Process serverProcess;

        public ProcessHandler(GrailsInstanceProvider grailsInstanceProvider, Process process) {
            this.provider = grailsInstanceProvider;
            this.serverProcess = process;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                try {
                    this.serverProcess.waitFor();
                }
                catch (InterruptedException interruptedException) {
                    this.serverProcess.destroy();
                    Object var3_2 = null;
                    this.provider.serverStopped(this.serverProcess);
                }
                Object var3_1 = null;
                this.provider.serverStopped(this.serverProcess);
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.provider.serverStopped(this.serverProcess);
                throw throwable;
            }
        }
    }
}

