/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.asm.model.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.RandomAccess;
import org.netbeans.modules.asm.model.lang.AsmElement;
import org.netbeans.modules.asm.model.lang.Register;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsmModelUtilities {
    public static final List<Register> emptyRegList = Collections.emptyList();

    public static boolean checkCompound(AsmElement asmElement) {
        int n = -1;
        for (AsmElement asmElement2 : asmElement.getCompounds()) {
            int n2;
            int n3 = asmElement2.getStartOffset();
            if (n3 > (n2 = asmElement2.getEndOffset()) || n > n3) {
                return false;
            }
            n = n2;
        }
        return true;
    }

    public static AsmElement findAt(AsmElement asmElement, int n) {
        assert (asmElement.getCompounds() instanceof RandomAccess);
        assert (AsmModelUtilities.checkCompound(asmElement));
        int n2 = Collections.binarySearch(asmElement.getCompounds(), new DummyCompound(n), CompoundCorparator.getInstance());
        return n2 < 0 ? null : asmElement.getCompounds().get(n2);
    }

    public static AsmElement findAtRecursive(AsmElement asmElement, int n) {
        AsmElement asmElement2 = AsmModelUtilities.findAt(asmElement, n);
        if (asmElement2 == null) {
            return asmElement;
        }
        return AsmModelUtilities.findAtRecursive(asmElement2, n);
    }

    public static void walkCompound(AsmElement asmElement, AsmVisitor asmVisitor) {
        for (AsmElement asmElement2 : asmElement.getCompounds()) {
            if (asmVisitor.visit(asmElement2)) {
                AsmModelUtilities.walkCompound(asmElement2, asmVisitor);
                continue;
            }
            return;
        }
    }

    public static Register getFirstParent(Register register) {
        while (register.getDirectParent() != null) {
            register = register.getDirectParent();
        }
        return register;
    }

    public static Collection<Register> getRegistersClosure(Collection<Register> collection) {
        HashSet<Register> hashSet = new HashSet<Register>();
        for (Register register : collection) {
            hashSet.add(AsmModelUtilities.getFirstParent(register));
        }
        return hashSet;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CompoundCorparator
    implements Comparator<AsmElement> {
        private static final Comparator<AsmElement> instance = new CompoundCorparator();

        public static Comparator<AsmElement> getInstance() {
            return instance;
        }

        @Override
        public int compare(AsmElement asmElement, AsmElement asmElement2) {
            if (asmElement.getEndOffset() < asmElement2.getStartOffset()) {
                return -1;
            }
            if (asmElement2.getEndOffset() < asmElement.getStartOffset()) {
                return 1;
            }
            return 0;
        }

        private CompoundCorparator() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DummyCompound
    implements AsmElement {
        private int pos;

        public DummyCompound(int n) {
            this.pos = n;
        }

        @Override
        public int getStartOffset() {
            return this.pos;
        }

        @Override
        public int getEndOffset() {
            return this.pos;
        }

        @Override
        public List<AsmElement> getCompounds() {
            return Collections.emptyList();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface AsmFilter<T extends AsmElement> {
        public boolean accept(T var1);
    }

    public static interface AsmVisitor {
        public boolean visit(AsmElement var1);
    }
}

