/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.asm.model;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.asm.model.AsmModel;
import org.netbeans.modules.asm.model.lang.Register;
import org.netbeans.modules.asm.model.lang.instruction.Instruction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAsmModel
implements AsmModel {
    private Map<String, Instruction> str2inst = new HashMap<String, Instruction>();
    private Map<String, Register> str2reg = new HashMap<String, Register>();

    protected AbstractAsmModel() {
    }

    protected void init() {
        this.str2inst.clear();
        this.str2reg.clear();
        for (Instruction asmNameable : this.getInstructionSet()) {
            AbstractAsmModel.splitAndAdd(asmNameable.getName(), asmNameable, this.str2inst);
        }
        for (Register register : this.getRegisterSet()) {
            AbstractAsmModel.splitAndAdd(register.getName(), register, this.str2reg);
        }
    }

    public Instruction getInstructionByName(String string) {
        return this.str2inst.get(string);
    }

    public Register getRegisterByName(String string) {
        return this.str2reg.get(string);
    }

    private static <T> void splitAndAdd(String string, T t, Map<String, T> map) {
        for (String string2 : string.split(";")) {
            map.put(string2, t);
        }
    }
}

