/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.memory;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import org.netbeans.modules.dlight.api.indicator.IndicatorConfiguration;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.indicators.graph.GraphConfig;
import org.netbeans.modules.dlight.indicators.graph.RepairPanel;
import org.netbeans.modules.dlight.memory.MemoryIndicatorConfiguration;
import org.netbeans.modules.dlight.memory.MemoryIndicatorPanel;
import org.netbeans.modules.dlight.spi.indicator.Indicator;
import org.netbeans.modules.dlight.util.DLightExecutorService;
import org.netbeans.modules.dlight.util.UIThread;
import org.netbeans.modules.dlight.util.UIUtilities;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryIndicator
extends Indicator<MemoryIndicatorConfiguration> {
    private MemoryIndicatorPanel panel = new MemoryIndicatorPanel();
    private final Set<String> acceptedColumnNames = new HashSet<String>();
    private long lastValue;

    public MemoryIndicator(MemoryIndicatorConfiguration memoryIndicatorConfiguration) {
        super((IndicatorConfiguration)memoryIndicatorConfiguration);
        for (DataTableMetadata.Column column : this.getMetadataColumns()) {
            this.acceptedColumnNames.add(column.getColumnName());
        }
    }

    public JComponent getComponent() {
        return this.panel.getPanel();
    }

    public void reset() {
    }

    public void updated(List<DataRow> list) {
        for (DataRow dataRow : list) {
            for (String string : dataRow.getColumnNames()) {
                if (!this.acceptedColumnNames.contains(string)) continue;
                String string2 = dataRow.getStringValue(string);
                this.lastValue = Long.parseLong(string2);
            }
        }
    }

    protected void tick() {
        this.panel.addData(this.lastValue);
    }

    protected void repairNeeded(boolean bl) {
        if (bl) {
            final RepairPanel repairPanel = new RepairPanel(this.getRepairActionProvider().getValidationStatus());
            repairPanel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    final Future future = MemoryIndicator.this.getRepairActionProvider().asyncRepair();
                    DLightExecutorService.submit((Callable)new Callable<Boolean>(){

                        @Override
                        public Boolean call() throws Exception {
                            UIThread.invoke((Runnable)new Runnable(){

                                public void run() {
                                    repairPanel.setEnabled(false);
                                }
                            });
                            Boolean bl = (Boolean)future.get();
                            UIThread.invoke((Runnable)new Runnable(){

                                public void run() {
                                    repairPanel.setEnabled(true);
                                }
                            });
                            return bl;
                        }
                    }, (String)"Click On Repair in Memory Indicator task");
                }
            });
            UIThread.invoke((Runnable)new Runnable(){

                public void run() {
                    MemoryIndicator.this.panel.getPanel().setOverlay((JComponent)repairPanel);
                }
            });
        } else {
            final JEditorPane jEditorPane = UIUtilities.createJEditorPane((String)this.getRepairActionProvider().getMessage(this.getRepairActionProvider().getValidationStatus()), (boolean)true, (Color)GraphConfig.TEXT_COLOR);
            UIThread.invoke((Runnable)new Runnable(){

                public void run() {
                    MemoryIndicator.this.panel.getPanel().setOverlay((JComponent)jEditorPane);
                }
            });
        }
    }

    private static String getMessage(String string) {
        return NbBundle.getMessage(MemoryIndicator.class, (String)string);
    }
}

