/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.dd.impl.client;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.j2ee.dd.impl.common.ParseUtils;
import org.openide.filesystems.FileObject;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ClientParseUtils {
    private static final Logger LOGGER = Logger.getLogger(ClientParseUtils.class.getName());

    public static String getVersion(InputStream inputStream) throws IOException, SAXException {
        return ParseUtils.getVersion(inputStream, (DefaultHandler)new VersionHandler(), (EntityResolver)DDResolver.getInstance());
    }

    public static String getVersion(InputSource inputSource) throws IOException, SAXException {
        return ParseUtils.getVersion(inputSource, (DefaultHandler)new VersionHandler(), (EntityResolver)DDResolver.getInstance());
    }

    public static SAXParseException parse(FileObject fileObject) throws SAXException, IOException {
        return ClientParseUtils.parse(new InputSource(fileObject.getInputStream()));
    }

    public static SAXParseException parse(InputSource inputSource) throws SAXException, IOException {
        return ParseUtils.parseDD(inputSource, DDResolver.getInstance());
    }

    public static SAXParseException parse(InputSource inputSource, EntityResolver entityResolver) throws SAXException, IOException {
        return ParseUtils.parseDD(inputSource, entityResolver);
    }

    private static class DDResolver
    implements EntityResolver {
        static DDResolver resolver;

        private DDResolver() {
        }

        static synchronized DDResolver getInstance() {
            if (resolver == null) {
                resolver = new DDResolver();
            }
            return resolver;
        }

        public InputSource resolveEntity(String string, String string2) {
            if ("-//Sun Microsystems, Inc.//DTD J2EE Application Client 1.3//EN".equals(string)) {
                return new InputSource("nbres:/org/netbeans/modules/j2ee/dd/impl/resources/application-client_1_3.dtd");
            }
            if ("http://java.sun.com/xml/ns/j2ee/application-client_1_4.xsd".equals(string2)) {
                return new InputSource("nbres:/org/netbeans/modules/j2ee/dd/impl/resources/application-client_1_4.xsd");
            }
            if ("http://java.sun.com/xml/ns/javaee/application-client_5.xsd".equals(string2)) {
                return new InputSource("nbres:/org/netbeans/modules/j2ee/dd/impl/resources/application-client_5.xsd");
            }
            return null;
        }
    }

    private static class VersionHandler
    extends DefaultHandler {
        private VersionHandler() {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if ("application-client".equals(string3)) {
                String string4 = this.parseVersion(attributes.getValue("version"));
                String string5 = string4 != null ? "version:" + string4 : "Invalid version: null";
                throw new SAXException(string5);
            }
        }

        private String parseVersion(String string) {
            if (string == null) {
                return null;
            }
            try {
                Double.valueOf(string);
                return string;
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.log(Level.INFO, "Not a valid version: " + string, numberFormatException);
                return null;
            }
        }
    }
}

