/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import org.netbeans.modules.subversion.Subversion;
import org.openide.filesystems.FileUtil;

public class FileUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File file, File file2) throws IOException {
        if (file == null || file2 == null) {
            throw new NullPointerException("sourceFile and targetFile must not be null");
        }
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = FileUtils.createInputStream(file);
            FileUtils.copyStreamToFile(bufferedInputStream, file2);
        }
        finally {
            if (bufferedInputStream != null) {
                try {
                    ((InputStream)bufferedInputStream).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void copyDirFiles(File file, File file2) {
        FileUtils.copyDirFiles(file, file2, false);
    }

    public static void copyDirFiles(File file, File file2, boolean bl) {
        File[] fileArray = file.listFiles();
        if (fileArray == null || fileArray.length == 0) {
            file2.mkdirs();
            if (bl) {
                file2.setLastModified(file.lastModified());
            }
            return;
        }
        if (bl) {
            file2.setLastModified(file.lastModified());
        }
        for (int i = 0; i < fileArray.length; ++i) {
            try {
                File file3 = FileUtil.normalizeFile((File)new File(file2.getAbsolutePath() + "/" + fileArray[i].getName()));
                if (fileArray[i].isDirectory()) {
                    FileUtils.copyDirFiles(fileArray[i], file3, bl);
                    continue;
                }
                FileUtils.copyFile(fileArray[i], file3);
                if (!bl) continue;
                file3.setLastModified(fileArray[i].lastModified());
                continue;
            }
            catch (IOException iOException) {
                Subversion.LOG.log(Level.INFO, null, iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyStreamToFile(InputStream inputStream, File file) throws IOException {
        if (inputStream == null || file == null) {
            throw new NullPointerException("sourcStream and targetFile must not be null");
        }
        File file2 = file.getParentFile();
        if (!file2.exists() && !file2.mkdirs()) {
            throw new IOException("Could not create directory '" + file2 + "'");
        }
        BufferedOutputStream bufferedOutputStream = null;
        try {
            bufferedOutputStream = FileUtils.createOutputStream(file);
            try {
                byte[] byArray = new byte[32768];
                int n = inputStream.read(byArray);
                while (n > 0) {
                    ((OutputStream)bufferedOutputStream).write(byArray, 0, n);
                    n = inputStream.read(byArray);
                }
            }
            catch (IOException iOException) {
                file.delete();
                throw iOException;
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (bufferedOutputStream != null) {
                try {
                    ((OutputStream)bufferedOutputStream).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getFileContentsAsByteArray(File file) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(5120);
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = FileUtils.createInputStream(file);
            byte[] byArray = new byte[1024];
            int n = bufferedInputStream.read(byArray);
            while (n > 0) {
                byteArrayOutputStream.write(byArray, 0, n);
                n = bufferedInputStream.read(byArray);
            }
        }
        finally {
            if (bufferedInputStream != null) {
                bufferedInputStream.close();
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static void deleteRecursively(File file) {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                FileUtils.deleteRecursively(fileArray[i]);
            }
        }
        file.delete();
    }

    public static void renameFile(File file, File file2) throws IOException {
        int n;
        boolean bl = file2.exists();
        if (bl) {
            for (n = 0; n < 3; ++n) {
                if (file2.delete()) {
                    bl = false;
                    break;
                }
                try {
                    Thread.sleep(71L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (!bl) {
            for (n = 0; n < 3; ++n) {
                if (file.renameTo(file2)) {
                    return;
                }
                try {
                    Thread.sleep(71L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        FileUtils.copyFile(file, file2);
        for (n = 0; n < 3; ++n) {
            if (file.delete()) {
                return;
            }
            try {
                Thread.sleep(71L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        throw new IOException("Can not delete: " + file.getAbsolutePath());
    }

    private FileUtils() {
    }

    public static BufferedInputStream createInputStream(File file) throws IOException {
        int n = 0;
        while (true) {
            try {
                return new BufferedInputStream(new FileInputStream(file));
            }
            catch (IOException iOException) {
                if (++n > 7) {
                    throw iOException;
                }
                try {
                    Thread.sleep(n * 34);
                }
                catch (InterruptedException interruptedException) {
                    throw iOException;
                }
            }
        }
    }

    public static BufferedOutputStream createOutputStream(File file) throws IOException {
        int n = 0;
        while (true) {
            try {
                return new BufferedOutputStream(new FileOutputStream(file));
            }
            catch (IOException iOException) {
                if (++n > 7) {
                    throw iOException;
                }
                try {
                    Thread.sleep(n * 34);
                }
                catch (InterruptedException interruptedException) {
                    throw iOException;
                }
            }
        }
    }

    public static File createTmpFolder(String string) {
        String string2 = System.getProperty("java.io.tmpdir");
        File file = new File(string2);
        File file2 = null;
        try {
            File file3 = File.createTempFile(string, "", file);
            if (!file3.delete()) {
                return file2;
            }
            if (!file3.mkdirs()) {
                return file2;
            }
            file2 = FileUtil.normalizeFile((File)file3);
        }
        catch (IOException iOException) {
            Subversion.LOG.log(Level.SEVERE, null, iOException);
        }
        return file2;
    }

    public static String getExistingFilenameInParent(File file) {
        File[] fileArray;
        String string = null;
        if (file == null) {
            return string;
        }
        File file2 = file.getParentFile();
        if (file2 == null) {
            return string;
        }
        for (File file3 : fileArray = file2.listFiles()) {
            if (!file.getName().equalsIgnoreCase(file3.getName())) continue;
            string = file3.getName();
            break;
        }
        return string;
    }
}

