/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.io.File;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.logging.Level;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class FileSelector
extends JPanel
implements ListSelectionListener {
    private File[] files;
    private DialogDescriptor dialogDescriptor;
    private JButton okButton;
    private JButton cancelButton;
    final JList filesList = new JList();
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;

    public FileSelector() {
        this.initComponents();
        this.filesList.addListSelectionListener(this);
        this.dialogDescriptor = new DialogDescriptor((Object)this, NbBundle.getMessage(FileSelector.class, (String)"LBL_FileSelector_Title"));
        this.okButton = new JButton(NbBundle.getMessage(FileSelector.class, (String)"CTL_FileSelector_Select"));
        this.okButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FileSelector.class, (String)"CTL_FileSelector_Select"));
        this.okButton.setEnabled(false);
        this.cancelButton = new JButton(NbBundle.getMessage(FileSelector.class, (String)"CTL_FileSelector_Cancel"));
        this.cancelButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FileSelector.class, (String)"CTL_FileSelector_Cancel"));
        this.dialogDescriptor.setOptions(new Object[]{this.okButton, this.cancelButton});
        this.dialogDescriptor.setModal(true);
        this.dialogDescriptor.setHelpCtx(new HelpCtx(this.getClass()));
        this.dialogDescriptor.setValid(false);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jLabel1.setText(NbBundle.getMessage(FileSelector.class, (String)"FileSelector.jLabel1.text"));
        this.filesList.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            public int getSize() {
                return this.strings.length;
            }

            public Object getElementAt(int n) {
                return this.strings[n];
            }
        });
        this.filesList.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.filesList);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 606, Short.MAX_VALUE).add((Component)this.jLabel1)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 109, Short.MAX_VALUE).addContainerGap()));
    }

    public boolean show(File[] fileArray) {
        int n;
        Arrays.sort(fileArray);
        this.files = fileArray;
        DefaultListModel<File> defaultListModel = new DefaultListModel<File>();
        for (File file : fileArray) {
            defaultListModel.addElement(file);
        }
        this.filesList.setModel(defaultListModel);
        this.preselectFile(fileArray);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(this.dialogDescriptor);
        dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FileSelector.class, (String)"LBL_FileSelector_Title"));
        dialog.setVisible(true);
        this.dialogDescriptor.setHelpCtx(new HelpCtx("org.netbeans.modules.subversion.FileSelector"));
        int n2 = n = this.dialogDescriptor.getValue() == this.okButton ? 1 : 0;
        if (n) {
            this.saveSelectedFile(fileArray);
        }
        return n != 0;
    }

    public File getSelectedFile() {
        return (File)this.filesList.getSelectedValue();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        boolean bl = this.filesList.getSelectedValue() != null;
        this.dialogDescriptor.setValid(bl);
        this.okButton.setEnabled(bl);
    }

    private void preselectFile(File[] fileArray) {
        String string = this.getHash(fileArray);
        if (string == null || string.trim().equals("")) {
            return;
        }
        String string2 = SvnModuleConfig.getDefault().getFileSelectorPreset(string);
        if (string2 != null && !string2.trim().equals("")) {
            File file = new File(string2);
            this.filesList.setSelectedValue(file, true);
        }
    }

    private void saveSelectedFile(File[] fileArray) {
        String string = this.getHash(fileArray);
        if (string == null || string.trim().equals("")) {
            return;
        }
        File file = this.getSelectedFile();
        if (file != null) {
            SvnModuleConfig.getDefault().setFileSelectorPreset(string, file.getAbsolutePath());
        }
    }

    /*
     * WARNING - void declaration
     */
    private String getHash(File[] fileArray) {
        void var3_6;
        Arrays.sort(fileArray);
        StringBuffer stringBuffer = new StringBuffer();
        for (File file : fileArray) {
            stringBuffer.append(file.getAbsolutePath());
        }
        Object var3_4 = null;
        try {
            String string = SvnUtils.getHash("MD5", stringBuffer.toString().getBytes());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Subversion.LOG.log(Level.SEVERE, null, noSuchAlgorithmException);
        }
        return var3_6;
    }
}

