/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.update;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import org.netbeans.modules.subversion.FileInformation;
import org.netbeans.modules.subversion.FileStatusCache;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.ui.properties.SvnPropertiesAction;
import org.netbeans.modules.subversion.ui.status.OpenInEditorAction;
import org.netbeans.modules.subversion.ui.update.FileUpdateInfo;
import org.netbeans.modules.subversion.ui.update.ResolveConflictsAction;
import org.netbeans.modules.subversion.ui.update.UpdateResultNode;
import org.netbeans.modules.versioning.util.FilePathCellRenderer;
import org.netbeans.modules.versioning.util.TableSorter;
import org.netbeans.modules.versioning.util.VersioningEvent;
import org.netbeans.modules.versioning.util.VersioningListener;
import org.openide.awt.MouseUtils;
import org.openide.explorer.view.NodeTableModel;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

class UpdateResultsTable
implements MouseListener,
ListSelectionListener,
AncestorListener,
VersioningListener {
    private NodeTableModel tableModel;
    private JTable table;
    private JScrollPane component;
    private UpdateResultNode[] nodes = new UpdateResultNode[0];
    private String[] tableColumns;
    private TableSorter sorter;
    private final Map<String, String[]> columnLabels = new HashMap<String, String[]>(4);
    private static final Comparator NodeComparator = new Comparator(){

        public int compare(Object object, Object object2) {
            Node.Property property = (Node.Property)object;
            Node.Property property2 = (Node.Property)object2;
            String string = (String)property.getValue("sortkey");
            if (string != null) {
                String string2 = (String)property2.getValue("sortkey");
                return string.compareToIgnoreCase(string2);
            }
            try {
                String string3 = (String)property.getValue();
                String string4 = (String)property2.getValue();
                return string3.compareToIgnoreCase(string4);
            }
            catch (Exception exception) {
                Subversion.LOG.log(Level.SEVERE, null, exception);
                return 0;
            }
        }
    };
    private static ActionEvaluator conflictEvaluator = new ActionEvaluator(){

        public boolean isAction(FileUpdateInfo fileUpdateInfo) {
            return (fileUpdateInfo.getAction() & FileUpdateInfo.ACTION_CONFLICTED & FileUpdateInfo.ACTION_TYPE_FILE) != 0;
        }
    };
    private static ActionEvaluator notDeletedEvaluator = new ActionEvaluator(){

        public boolean isAction(FileUpdateInfo fileUpdateInfo) {
            return (fileUpdateInfo.getAction() & ~FileUpdateInfo.ACTION_DELETED) != 0;
        }
    };

    public UpdateResultsTable() {
        ResourceBundle resourceBundle = NbBundle.getBundle(UpdateResultsTable.class);
        this.columnLabels.put("name", new String[]{resourceBundle.getString("CTL_UpdateResults_Column_File_Title"), resourceBundle.getString("CTL_UpdateResults_Column_File_Desc")});
        this.columnLabels.put("status", new String[]{resourceBundle.getString("CTL_UpdateResults_Column_Status_Title"), resourceBundle.getString("CTL_UpdateResults_Column_Status_Desc")});
        this.columnLabels.put("path", new String[]{resourceBundle.getString("CTL_UpdateResults_Column_Path_Title"), resourceBundle.getString("CTL_UpdateResults_Column_Path_Desc")});
        this.tableModel = new NodeTableModel();
        Subversion.getInstance().getStatusCache().addVersioningListener(this);
        this.sorter = new TableSorter((TableModel)this.tableModel);
        this.sorter.setColumnComparator(Node.Property.class, NodeComparator);
        this.table = new JTable((TableModel)this.sorter);
        this.sorter.setTableHeader(this.table.getTableHeader());
        int n = new JLabel((String)"FONTSIZE").getPreferredSize().height * 6 / 5;
        this.table.setRowHeight(n);
        this.component = new JScrollPane(this.table, 22, 31);
        this.component.getViewport().setBackground(this.table.getBackground());
        Color color = UIManager.getColor("scrollpane_border");
        if (color == null) {
            color = UIManager.getColor("controlShadow");
        }
        this.component.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, color));
        this.table.addMouseListener(this);
        this.table.setDefaultRenderer(Node.Property.class, new SyncTableCellRenderer());
        this.table.getSelectionModel().addListSelectionListener(this);
        this.table.addAncestorListener(this);
        this.table.getAccessibleContext().setAccessibleName(NbBundle.getMessage(UpdateResultsTable.class, (String)"ACSN_UpdateResults"));
        this.table.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(UpdateResultsTable.class, (String)"ACSD_UpdateResults"));
        this.setColumns(new String[]{"name", "status", "path"});
    }

    void setDefaultColumnSizes() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int n = UpdateResultsTable.this.table.getWidth();
                for (int i = 0; i < UpdateResultsTable.this.tableColumns.length; ++i) {
                    if ("path".equals(UpdateResultsTable.this.tableColumns[i])) {
                        UpdateResultsTable.this.table.getColumnModel().getColumn(i).setPreferredWidth(n * 60 / 100);
                        continue;
                    }
                    UpdateResultsTable.this.table.getColumnModel().getColumn(i).setPreferredWidth(n * 20 / 100);
                }
            }
        });
    }

    public void ancestorAdded(AncestorEvent ancestorEvent) {
        this.setDefaultColumnSizes();
    }

    public void ancestorMoved(AncestorEvent ancestorEvent) {
    }

    public void ancestorRemoved(AncestorEvent ancestorEvent) {
    }

    public UpdateResultNode[] getDisplayedNodes() {
        int n = this.sorter.getRowCount();
        UpdateResultNode[] updateResultNodeArray = new UpdateResultNode[n];
        for (int i = 0; i < n; ++i) {
            updateResultNodeArray[i] = this.nodes[this.sorter.modelIndex(i)];
        }
        return updateResultNodeArray;
    }

    public JComponent getComponent() {
        return this.component;
    }

    final void setColumns(String[] stringArray) {
        if (Arrays.equals(stringArray, this.tableColumns)) {
            return;
        }
        this.setDefaultColumnSizes();
        this.setModelProperties(stringArray);
        this.tableColumns = stringArray;
        for (int i = 0; i < this.tableColumns.length; ++i) {
            this.sorter.setColumnComparator(i, null);
            this.sorter.setSortingStatus(i, 0);
            if (!"status".equals(this.tableColumns[i])) continue;
            this.sorter.setSortingStatus(i, 1);
            break;
        }
    }

    private void setModelProperties(String[] stringArray) {
        Node.Property[] propertyArray = new Node.Property[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            String[] stringArray2 = this.columnLabels.get(string);
            propertyArray[i] = new ColumnDescriptor(string, String.class, stringArray2[0], stringArray2[1]);
        }
        this.tableModel.setProperties(propertyArray);
    }

    void setTableModel(UpdateResultNode[] updateResultNodeArray) {
        this.nodes = updateResultNodeArray;
        this.tableModel.setNodes((Node[])updateResultNodeArray);
    }

    void focus() {
        this.table.requestFocus();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.onPopup(mouseEvent);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.onPopup(mouseEvent);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent) && MouseUtils.isDoubleClick((MouseEvent)mouseEvent)) {
            int n = this.table.rowAtPoint(mouseEvent.getPoint());
            if (n == -1) {
                return;
            }
            n = this.sorter.modelIndex(n);
            this.performOpen(n);
        }
    }

    private void onPopup(MouseEvent mouseEvent) {
        final int[] nArray = this.table.getSelectedRows();
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(new JMenuItem(new AbstractAction(NbBundle.getMessage(UpdateResultsTable.class, (String)"CTL_MenuItem_Open")){
            {
                super(string);
                this.setEnabled(nArray.length == 1 && UpdateResultsTable.this.hasAction(nArray, notDeletedEvaluator));
            }

            public void actionPerformed(ActionEvent actionEvent) {
                UpdateResultsTable.this.performOpen(nArray[0]);
            }
        }));
        jPopupMenu.add(new JMenuItem(new AbstractAction(NbBundle.getMessage(UpdateResultsTable.class, (String)"CTL_MenuItem_ResolveConflicts")){
            {
                super(string);
                this.setEnabled(nArray.length > -1 && UpdateResultsTable.this.hasAction(nArray, conflictEvaluator));
            }

            public void actionPerformed(ActionEvent actionEvent) {
                ResolveConflictsAction.resolveConflicts(UpdateResultsTable.this.getSelectedFiles(nArray));
            }
        }));
        jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
    }

    private boolean hasAction(int[] nArray, ActionEvaluator actionEvaluator) {
        for (int n : nArray) {
            int n2 = this.sorter.modelIndex(n);
            UpdateResultNode updateResultNode = this.nodes[n2];
            FileUpdateInfo fileUpdateInfo = (FileUpdateInfo)updateResultNode.getLookup().lookup(FileUpdateInfo.class);
            if (fileUpdateInfo != null && actionEvaluator.isAction(fileUpdateInfo)) continue;
            return false;
        }
        return true;
    }

    private void performOpen(int n) {
        FileUpdateInfo fileUpdateInfo = (FileUpdateInfo)this.nodes[n].getLookup().lookup(FileUpdateInfo.class);
        if (fileUpdateInfo == null) {
            return;
        }
        if ((fileUpdateInfo.getAction() & FileUpdateInfo.ACTION_TYPE_FILE) != 0) {
            this.performOpenInEditorAction((Node)this.nodes[n]);
        } else {
            this.performOpenSvnProperties(fileUpdateInfo.getFile());
        }
    }

    private void performOpenInEditorAction(Node node) {
        Action action = node.getPreferredAction();
        if (action == null || !action.isEnabled()) {
            action = new OpenInEditorAction();
        }
        if (action.isEnabled()) {
            action.actionPerformed(new ActionEvent(this, 0, ""));
        }
    }

    private void performOpenSvnProperties(File file) {
        SvnPropertiesAction.openProperties(file, file.getName());
    }

    private File[] getSelectedFiles(int[] nArray) {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (int n : nArray) {
            int n2 = this.sorter.modelIndex(n);
            UpdateResultNode updateResultNode = this.nodes[n2];
            FileUpdateInfo fileUpdateInfo = (FileUpdateInfo)updateResultNode.getLookup().lookup(FileUpdateInfo.class);
            if (fileUpdateInfo == null) continue;
            arrayList.add(fileUpdateInfo.getFile());
        }
        return arrayList.toArray(new File[arrayList.size()]);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        final ArrayList<UpdateResultNode> arrayList = new ArrayList<UpdateResultNode>();
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        final TopComponent topComponent = (TopComponent)SwingUtilities.getAncestorOfClass(TopComponent.class, this.table);
        if (topComponent == null) {
            return;
        }
        int n = listSelectionModel.getMinSelectionIndex();
        if (n > -1) {
            int n2 = listSelectionModel.getMaxSelectionIndex();
            for (int i = n; i <= n2; ++i) {
                if (!listSelectionModel.isSelectedIndex(i)) continue;
                int n3 = this.sorter.modelIndex(i);
                arrayList.add(this.nodes[n3]);
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                topComponent.setActivatedNodes(arrayList.toArray(new Node[arrayList.size()]));
            }
        });
    }

    public void versioningEvent(VersioningEvent versioningEvent) {
        if (this.nodes.length == 0) {
            return;
        }
        if (versioningEvent.getId() == FileStatusCache.EVENT_FILE_STATUS_CHANGED) {
            File file = (File)versioningEvent.getParams()[0];
            FileInformation fileInformation = (FileInformation)versioningEvent.getParams()[2];
            ArrayList<UpdateResultNode> arrayList = new ArrayList<UpdateResultNode>();
            boolean bl = false;
            for (UpdateResultNode updateResultNode : this.nodes) {
                FileUpdateInfo fileUpdateInfo = (FileUpdateInfo)updateResultNode.getLookup().lookup(FileUpdateInfo.class);
                if (fileUpdateInfo != null) {
                    int n = fileUpdateInfo.getAction();
                    if ((n & FileUpdateInfo.ACTION_CONFLICTED & FileUpdateInfo.ACTION_TYPE_FILE) != 0 && fileUpdateInfo.getFile().equals(file)) {
                        if ((fileInformation.getStatus() & 0x40) == 0) {
                            n &= ~FileUpdateInfo.ACTION_CONFLICTED;
                            FileUpdateInfo fileUpdateInfo2 = new FileUpdateInfo(fileUpdateInfo.getFile(), n |= FileUpdateInfo.ACTION_CONFLICTED_RESOLVED);
                            arrayList.add(new UpdateResultNode(fileUpdateInfo2));
                            bl = true;
                            continue;
                        }
                    }
                    arrayList.add(updateResultNode);
                    continue;
                }
                arrayList.add(updateResultNode);
            }
            if (bl) {
                this.setTableModel(arrayList.toArray(new UpdateResultNode[arrayList.size()]));
            }
        }
    }

    private class SyncTableCellRenderer
    extends DefaultTableCellRenderer {
        private FilePathCellRenderer pathRenderer = new FilePathCellRenderer();

        private SyncTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component;
            Object object2;
            int n3 = jTable.convertColumnIndexToModel(n2);
            if (n3 == 0) {
                object2 = UpdateResultsTable.this.nodes[UpdateResultsTable.this.sorter.modelIndex(n)];
                if (!bl) {
                    object = "<html>" + object2.getHtmlDisplayName();
                }
            }
            if ((component = n3 == 2 ? this.pathRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2) : super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2)) instanceof JComponent) {
                object2 = UpdateResultsTable.this.nodes[UpdateResultsTable.this.sorter.modelIndex(n)].getInfo().getFile().getAbsolutePath();
                ((JComponent)component).setToolTipText((String)object2);
            }
            return component;
        }
    }

    private static interface ActionEvaluator {
        public boolean isAction(FileUpdateInfo var1);
    }

    private static class ColumnDescriptor
    extends PropertySupport.ReadOnly {
        public ColumnDescriptor(String string, Class clazz, String string2, String string3) {
            super(string, clazz, string2, string3);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return null;
        }
    }
}

