/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.update;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.netbeans.modules.subversion.FileStatusCache;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.actions.ContextAction;
import org.netbeans.modules.subversion.ui.update.FileUpdateInfo;
import org.netbeans.modules.subversion.ui.update.UpdateResults;
import org.netbeans.modules.subversion.util.Context;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.util.Utils;
import org.netbeans.modules.versioning.util.VersioningOutputManager;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.ISVNNotifyListener;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateAction
extends ContextAction {
    @Override
    protected String getBaseName(Node[] nodeArray) {
        return "CTL_MenuItem_Update";
    }

    @Override
    protected int getFileEnabledStatus() {
        return 4088;
    }

    @Override
    protected int getDirectoryEnabledStatus() {
        return -8;
    }

    @Override
    protected void performContextAction(Node[] nodeArray) {
        if (!Subversion.getInstance().checkClientAvailable()) {
            return;
        }
        this.performUpdate(nodeArray);
    }

    private void performUpdate(final Node[] nodeArray) {
        final Context context = this.getContext(nodeArray);
        ContextAction.ProgressSupport progressSupport = new ContextAction.ProgressSupport(this, nodeArray){

            public void perform() {
                UpdateAction.update(context, this, UpdateAction.this.getContextDisplayName(nodeArray));
            }
        };
        progressSupport.start(this.createRequestProcessor(nodeArray));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void update(Context context, SvnProgressSupport svnProgressSupport, String string) {
        SvnClient svnClient;
        int n;
        Serializable serializable;
        Object object;
        File[] fileArray = context.getRootFiles();
        SVNUrl sVNUrl = null;
        try {
            object = fileArray;
            int n2 = ((File[])object).length;
            for (int i = 0; i < n2 && (sVNUrl = SvnUtils.getRepositoryRootUrl((File)(serializable = object[i]))) == null; ++i) {
                Subversion.LOG.log(Level.WARNING, "Could not retrieve repository root for context file {0}", new Object[]{serializable});
            }
        }
        catch (SVNClientException sVNClientException) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), true, true);
            return;
        }
        object = Subversion.getInstance().getStatusCache();
        ((FileStatusCache)object).refreshCached(context);
        File[][] fileArray2 = Utils.splitFlatOthers((File[])fileArray);
        ArrayList<File> arrayList = new ArrayList<File>();
        serializable = new ArrayList();
        for (n = 0; n < fileArray2[1].length; ++n) {
            arrayList.add(fileArray2[1][n]);
        }
        for (n = 0; n < fileArray2[0].length; ++n) {
            serializable.add(fileArray2[0][n]);
        }
        UpdateOutputListener updateOutputListener = new UpdateOutputListener();
        try {
            svnClient = Subversion.getInstance().getClient(sVNUrl);
            svnClient.removeNotifyListener(Subversion.getInstance().getRefreshHandler());
            svnClient.addNotifyListener(updateOutputListener);
            svnProgressSupport.setCancellableDelegate(svnClient);
        }
        catch (SVNClientException sVNClientException) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), true, true);
            return;
        }
        try {
            UpdateNotifyListener updateNotifyListener = new UpdateNotifyListener();
            svnClient.addNotifyListener(updateNotifyListener);
            try {
                UpdateAction.updateRoots(arrayList, svnProgressSupport, svnClient, true);
                if (svnProgressSupport.isCanceled()) {
                    return;
                }
                UpdateAction.updateRoots((List<File>)((Object)serializable), svnProgressSupport, svnClient, false);
            }
            finally {
                svnClient.removeNotifyListener(updateNotifyListener);
            }
            if (updateNotifyListener.causedConflict) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(UpdateAction.class, (String)"MSG_UpdateCausedConflicts_Prompt"), 2);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                    }
                });
            } else {
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(UpdateAction.class, (String)"MSG_Update_Completed"));
            }
        }
        catch (SVNClientException sVNClientException) {
            svnProgressSupport.annotate(sVNClientException);
        }
        finally {
            UpdateAction.openResults(updateOutputListener.getResults(), sVNUrl, string);
        }
    }

    private static void openResults(final List<FileUpdateInfo> list, final SVNUrl sVNUrl, final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                UpdateResults updateResults = new UpdateResults(list, sVNUrl, string);
                VersioningOutputManager versioningOutputManager = VersioningOutputManager.getInstance();
                versioningOutputManager.addComponent(sVNUrl.toString() + "-UpdateExecutor", (JComponent)updateResults);
            }
        });
    }

    private static void updateRoots(List<File> list, SvnProgressSupport svnProgressSupport, SvnClient svnClient, boolean bl) throws SVNClientException {
        for (File file : list) {
            if (svnProgressSupport.isCanceled()) break;
            long l = svnClient.update(file, SVNRevision.HEAD, bl);
            UpdateAction.revisionUpdateWorkaround(bl, file, svnClient, l);
        }
    }

    private static void revisionUpdateWorkaround(final boolean bl, final File file, final SvnClient svnClient, final long l) throws SVNClientException {
        Utils.post((Runnable)new Runnable(){

            public void run() {
                SVNRevision.Number number;
                List<File> list;
                if (bl) {
                    list = SvnUtils.listRecursively(file);
                } else {
                    list = new ArrayList<File>();
                    list.add(file);
                    number = file.listFiles();
                    if (number != null) {
                        for (SVNRevision.Number number2 : number) {
                            list.add((File)number2);
                        }
                    }
                }
                number = list.toArray(new File[list.size()]);
                SVNRevision.Number number3 = null;
                if (l < -1L) {
                    ISVNInfo iSVNInfo = null;
                    try {
                        iSVNInfo = svnClient.getInfoFromWorkingCopy(file);
                        number3 = iSVNInfo.getRevision();
                        if (number3 == null) {
                            iSVNInfo = svnClient.getInfo(file);
                            number3 = iSVNInfo.getRevision();
                        }
                    }
                    catch (SVNClientException sVNClientException) {
                        SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), true, true);
                    }
                } else {
                    number3 = new SVNRevision.Number(l);
                }
                Subversion.getInstance().getStatusCache().patchRevision((File[])number, number3);
                Subversion.getInstance().refreshAnnotations((File[])number);
            }
        });
    }

    public static void performUpdate(final Context context, final String string) {
        SVNUrl sVNUrl;
        if (!Subversion.getInstance().checkClientAvailable()) {
            return;
        }
        if (context == null || context.getRoots().size() == 0) {
            return;
        }
        try {
            sVNUrl = UpdateAction.getSvnUrl(context);
        }
        catch (SVNClientException sVNClientException) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), true, true);
            return;
        }
        RequestProcessor requestProcessor = Subversion.getInstance().getRequestProcessor(sVNUrl);
        SvnProgressSupport svnProgressSupport = new SvnProgressSupport(){

            public void perform() {
                UpdateAction.update(context, this, string);
            }
        };
        svnProgressSupport.start(requestProcessor, sVNUrl, NbBundle.getMessage(UpdateAction.class, (String)"MSG_Update_Progress"));
    }

    private static class UpdateNotifyListener
    implements ISVNNotifyListener {
        private Pattern p = Pattern.compile("C   (.+)");
        boolean causedConflict = false;

        private UpdateNotifyListener() {
        }

        public void logMessage(String string) {
            if (this.causedConflict) {
                return;
            }
            Matcher matcher = this.p.matcher(string);
            if (matcher.matches()) {
                this.causedConflict = true;
            }
        }

        public void setCommand(int n) {
        }

        public void logCommandLine(String string) {
        }

        public void logError(String string) {
        }

        public void logRevision(long l, String string) {
        }

        public void logCompleted(String string) {
        }

        public void onNotify(File file, SVNNodeKind sVNNodeKind) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UpdateOutputListener
    implements ISVNNotifyListener {
        private List<FileUpdateInfo> results;

        private UpdateOutputListener() {
        }

        public void setCommand(int n) {
        }

        public void logCommandLine(String string) {
        }

        public void logMessage(String string) {
            FileUpdateInfo[] fileUpdateInfoArray = FileUpdateInfo.createFromLogMsg(string);
            if (fileUpdateInfoArray != null) {
                for (FileUpdateInfo fileUpdateInfo : fileUpdateInfoArray) {
                    if (fileUpdateInfo == null) continue;
                    this.getResults().add(fileUpdateInfo);
                }
            }
        }

        public void logError(String string) {
        }

        public void logRevision(long l, String string) {
        }

        public void logCompleted(String string) {
        }

        public void onNotify(File file, SVNNodeKind sVNNodeKind) {
        }

        List<FileUpdateInfo> getResults() {
            if (this.results == null) {
                this.results = new ArrayList<FileUpdateInfo>();
            }
            return this.results;
        }
    }
}

