/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.commit;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.plaf.basic.BasicTreeUI;
import org.jdesktop.layout.LayoutStyle;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.hooks.spi.SvnHook;
import org.netbeans.modules.subversion.hooks.spi.SvnHookContext;
import org.netbeans.modules.subversion.ui.commit.CommitTable;
import org.netbeans.modules.versioning.util.AutoResizingPanel;
import org.netbeans.modules.versioning.util.ListenersSupport;
import org.netbeans.modules.versioning.util.PlaceholderPanel;
import org.netbeans.modules.versioning.util.StringSelector;
import org.netbeans.modules.versioning.util.Utils;
import org.netbeans.modules.versioning.util.VersioningListener;
import org.netbeans.modules.versioning.util.VerticallyNonResizingPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommitPanel
extends AutoResizingPanel
implements PreferenceChangeListener,
TableModelListener {
    static final Object EVENT_SETTINGS_CHANGED = new Object();
    final JLabel filesLabel = new JLabel();
    final JPanel filesPanel = new JPanel();
    final JLabel filesSectionButton = new JLabel();
    final JPanel filesSectionPanel = new JPanel();
    final JLabel hooksSectionButton = new JLabel();
    final PlaceholderPanel hooksSectionPanel = new PlaceholderPanel();
    final JTabbedPane hooksTabbedPane = new JTabbedPane();
    final JLabel jLabel1 = new JLabel();
    final JLabel jLabel2 = new JLabel();
    final JScrollPane jScrollPane1 = new JScrollPane();
    final JTextArea messageTextArea = new JTextArea();
    final JLabel recentLink = new JLabel();
    private CommitTable commitTable;
    private boolean hooksOn;
    ListenersSupport listenerSupport = new ListenersSupport((Object)this);

    public CommitPanel() {
        this.initComponents();
    }

    void initHooks(List<SvnHook> list, SvnHookContext svnHookContext) {
        if (list.size() < 1) {
            this.hooksSectionButton.setVisible(false);
            this.hooksSectionPanel.setVisible(false);
            this.hooksOn = false;
            return;
        }
        this.hooksOn = true;
        if (list.size() == 1) {
            SvnHook svnHook = list.get(0);
            this.hooksSectionPanel.add((Component)svnHook.createComponent(svnHookContext));
            this.hooksSectionButton.setText(svnHook.getDisplayName());
        } else {
            this.hooksSectionPanel.add((Component)this.hooksTabbedPane);
            this.hooksSectionButton.setText(CommitPanel.getMessage("LBL_Advanced"));
            for (SvnHook svnHook : list) {
                this.hooksTabbedPane.add((Component)svnHook.createComponent(svnHookContext), svnHook.getDisplayName());
            }
        }
        this.hooksSectionPanel.setVisible(false);
        this.hooksSectionButton.setVisible(true);
    }

    void setCommitTable(CommitTable commitTable) {
        this.commitTable = commitTable;
    }

    void setErrorLabel(String string) {
        this.jLabel2.setText(string);
    }

    public void addNotify() {
        super.addNotify();
        this.filesPanel.setPreferredSize(new Dimension(0, 2 * this.messageTextArea.getPreferredSize().height));
        SvnModuleConfig.getDefault().getPreferences().addPreferenceChangeListener(this);
        this.commitTable.getTableModel().addTableModelListener(this);
        this.listenerSupport.fireVersioningEvent(EVENT_SETTINGS_CHANGED);
        this.recentLink.setCursor(Cursor.getPredefinedCursor(12));
        this.recentLink.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                CommitPanel.this.onBrowseRecentMessages();
            }
        });
        final List list = Utils.getStringList((Preferences)SvnModuleConfig.getDefault().getPreferences(), (String)"recentCommitMessage");
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (list.size() > 0) {
                    CommitPanel.this.messageTextArea.setText((String)list.get(0));
                }
                CommitPanel.this.messageTextArea.selectAll();
            }
        });
        if (this.hooksOn) {
            JTree jTree = new JTree();
            BasicTreeUI basicTreeUI = (BasicTreeUI)jTree.getUI();
            Icon icon = basicTreeUI.getExpandedIcon();
            Icon icon2 = basicTreeUI.getCollapsedIcon();
            this.filesSectionButton.setIcon(icon);
            this.hooksSectionButton.setIcon(icon2);
            this.hooksSectionPanel.setVisible(false);
            this.initSectionButton(this.filesSectionButton, this.filesSectionPanel, icon2, icon);
            this.initSectionButton(this.hooksSectionButton, (JPanel)this.hooksSectionPanel, icon2, icon);
        }
    }

    private void initSectionButton(final JLabel jLabel, final JPanel jPanel, final Icon icon, final Icon icon2) {
        jLabel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (jPanel.isVisible()) {
                    jPanel.setVisible(false);
                    jLabel.setIcon(icon);
                } else {
                    jPanel.setVisible(true);
                    jLabel.setIcon(icon2);
                    CommitPanel.this.enlargeVerticallyAsNecessary();
                }
            }
        });
    }

    public void removeNotify() {
        this.commitTable.getTableModel().removeTableModelListener(this);
        SvnModuleConfig.getDefault().getPreferences().removePreferenceChangeListener(this);
        super.removeNotify();
    }

    private void onBrowseRecentMessages() {
        String string = StringSelector.select((String)CommitPanel.getMessage("CTL_CommitForm_RecentTitle"), (String)CommitPanel.getMessage("CTL_CommitForm_RecentPrompt"), (List)Utils.getStringList((Preferences)SvnModuleConfig.getDefault().getPreferences(), (String)"recentCommitMessage"));
        if (string != null) {
            this.messageTextArea.replaceSelection(string);
        }
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
        if (preferenceChangeEvent.getKey().startsWith("commitExclusions")) {
            this.commitTable.dataChanged();
            this.listenerSupport.fireVersioningEvent(EVENT_SETTINGS_CHANGED);
        }
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        this.listenerSupport.fireVersioningEvent(EVENT_SETTINGS_CHANGED);
    }

    private void initComponents() {
        this.jLabel1.setLabelFor(this.messageTextArea);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)CommitPanel.getMessage("CTL_CommitForm_Message"));
        this.recentLink.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/subversion/resources/icons/recent_messages.png")));
        this.recentLink.setToolTipText(CommitPanel.getMessage("CTL_CommitForm_RecentMessages"));
        this.messageTextArea.setColumns(60);
        this.messageTextArea.setLineWrap(true);
        this.messageTextArea.setRows(4);
        this.messageTextArea.setTabSize(4);
        this.messageTextArea.setWrapStyleWord(true);
        this.messageTextArea.setMinimumSize(new Dimension(100, 18));
        this.jScrollPane1.setViewportView(this.messageTextArea);
        this.messageTextArea.getAccessibleContext().setAccessibleName(CommitPanel.getMessage("ACSN_CommitForm_Message"));
        this.messageTextArea.getAccessibleContext().setAccessibleDescription(CommitPanel.getMessage("ACSD_CommitForm_Message"));
        Mnemonics.setLocalizedText((JLabel)this.filesSectionButton, (String)CommitPanel.getMessage("LBL_CommitDialog_FilesToCommit"));
        Mnemonics.setLocalizedText((JLabel)this.filesLabel, (String)CommitPanel.getMessage("CTL_CommitForm_FilesToCommit"));
        this.filesSectionPanel.setLayout(new BoxLayout(this.filesSectionPanel, 1));
        this.filesSectionPanel.add(this.filesLabel);
        this.filesSectionPanel.add(this.makeVerticalStrut(this.filesLabel, this.filesPanel, 0));
        this.filesSectionPanel.add(this.filesPanel);
        this.filesLabel.setAlignmentX(0.0f);
        this.filesPanel.setAlignmentX(0.0f);
        Mnemonics.setLocalizedText((JLabel)this.hooksSectionButton, (String)CommitPanel.getMessage("LBL_Advanced"));
        VerticallyNonResizingPanel verticallyNonResizingPanel = new VerticallyNonResizingPanel();
        verticallyNonResizingPanel.setLayout(new BoxLayout((Container)verticallyNonResizingPanel, 0));
        verticallyNonResizingPanel.add(this.jLabel1);
        verticallyNonResizingPanel.add(Box.createHorizontalGlue());
        verticallyNonResizingPanel.add(this.recentLink);
        this.jLabel1.setAlignmentY(1.0f);
        this.recentLink.setAlignmentY(1.0f);
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        this.add((Component)verticallyNonResizingPanel);
        this.add(this.makeVerticalStrut(this.jLabel1, this.jScrollPane1, 0));
        this.add(this.jScrollPane1);
        this.add(this.makeVerticalStrut(this.jScrollPane1, this.filesSectionButton, 0));
        this.add(this.filesSectionButton);
        this.add(this.makeVerticalStrut(this.filesSectionButton, this.filesSectionPanel, 0));
        this.add(this.filesSectionPanel);
        this.add(this.makeVerticalStrut(this.filesSectionPanel, this.hooksSectionButton, 0));
        this.add(this.hooksSectionButton);
        this.add(this.makeVerticalStrut(this.hooksSectionButton, (JComponent)this.hooksSectionPanel, 0));
        this.add((Component)this.hooksSectionPanel);
        this.add(this.makeVerticalStrut((JComponent)this.hooksSectionPanel, this.jLabel2, 0));
        this.add(this.jLabel2);
        verticallyNonResizingPanel.setAlignmentX(0.0f);
        this.jScrollPane1.setAlignmentX(0.0f);
        this.filesSectionButton.setAlignmentX(0.0f);
        this.filesSectionPanel.setAlignmentX(0.0f);
        this.hooksSectionButton.setAlignmentX(0.0f);
        this.hooksSectionPanel.setAlignmentX(0.0f);
        this.jLabel2.setAlignmentX(0.0f);
        this.setBorder(BorderFactory.createEmptyBorder(26, this.getContainerGap(7), 0, 15));
        this.getAccessibleContext().setAccessibleName(CommitPanel.getMessage("ACSN_CommitDialog"));
        this.getAccessibleContext().setAccessibleDescription(CommitPanel.getMessage("ACSD_CommitDialog"));
    }

    private Component makeVerticalStrut(JComponent jComponent, JComponent jComponent2, int n) {
        int n2 = LayoutStyle.getSharedInstance().getPreferredGap(jComponent, jComponent2, n, 5, (Container)((Object)this));
        return Box.createVerticalStrut(n2);
    }

    private int getContainerGap(int n) {
        return LayoutStyle.getSharedInstance().getContainerGap((JComponent)((Object)this), n, null);
    }

    private static String getMessage(String string) {
        return NbBundle.getMessage(CommitPanel.class, (String)string);
    }

    public void addVersioningListener(VersioningListener versioningListener) {
        this.listenerSupport.addListener(versioningListener);
    }

    public void removeVersioningListener(VersioningListener versioningListener) {
        this.listenerSupport.removeListener(versioningListener);
    }
}

