/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.client;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import org.netbeans.modules.subversion.Subversion;
import org.openide.filesystems.FileUtil;
import org.tigris.subversion.svnclientadapter.ISVNNotifyListener;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;

public class SvnClientRefreshHandler
implements ISVNNotifyListener {
    private final Set<File> filesToRefresh = new HashSet<File>();

    public void setCommand(int n) {
    }

    public void logCommandLine(String string) {
    }

    public void logMessage(String string) {
    }

    public void logError(String string) {
    }

    public void logRevision(long l, String string) {
    }

    public void logCompleted(String string) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNotify(File file, SVNNodeKind sVNNodeKind) {
        if (file == null) {
            return;
        }
        file = FileUtil.normalizeFile((File)file);
        Set<File> set = this.filesToRefresh;
        synchronized (set) {
            if (Subversion.LOG.isLoggable(Level.FINE)) {
                Subversion.LOG.fine("scheduling for refresh: [" + file + "]");
            }
            this.filesToRefresh.add(file);
        }
    }

    public void refreshImediately(File ... fileArray) {
        for (int i = 0; i < fileArray.length; ++i) {
            fileArray[i] = FileUtil.normalizeFile((File)fileArray[i]);
        }
        this.refresh(fileArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        File[] fileArray;
        Set<File> set = this.filesToRefresh;
        synchronized (set) {
            fileArray = this.filesToRefresh.toArray(new File[this.filesToRefresh.size()]);
            this.filesToRefresh.clear();
        }
        this.refresh(fileArray);
    }

    private void refresh(File ... fileArray) {
        if (Subversion.LOG.isLoggable(Level.FINE)) {
            for (File file : fileArray) {
                Subversion.LOG.fine("refreshing: [" + file + "]");
            }
        }
        this.refreshFS(fileArray);
        Subversion.getInstance().getStatusCache().refreshAsync(fileArray);
    }

    private void refreshFS(File ... fileArray) {
        HashSet<File> hashSet = new HashSet<File>();
        for (File file : fileArray) {
            File file2 = file.getParentFile();
            if (file2 == null) continue;
            hashSet.add(file2);
            Subversion.LOG.fine("scheduling for fs refresh: [" + file2 + "]");
        }
        if (hashSet.size() > 0) {
            FileUtil.refreshFor((File[])hashSet.toArray(new File[hashSet.size()]));
        }
    }
}

