/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.netbeans.modules.subversion.FileStatusCache;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnClientFactory;
import org.netbeans.modules.subversion.util.FileUtils;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class VersionsCache {
    private static VersionsCache instance;

    private VersionsCache() {
    }

    public static synchronized VersionsCache getInstance() {
        if (instance == null) {
            instance = new VersionsCache();
        }
        return instance;
    }

    public File getFileRevision(SVNUrl sVNUrl, SVNUrl sVNUrl2, String string, String string2) throws IOException {
        return this.getFileRevision(sVNUrl, sVNUrl2, string, string, string2);
    }

    public File getFileRevision(SVNUrl sVNUrl, SVNUrl sVNUrl2, String string, String string2, String string3) throws IOException {
        try {
            SvnClient svnClient = Subversion.getInstance().getClient(sVNUrl);
            InputStream inputStream = this.getInputStream(svnClient, sVNUrl2, string, string2);
            return this.createContent(string3, inputStream);
        }
        catch (SVNClientException sVNClientException) {
            IOException iOException = new IOException("Can not load: " + sVNUrl2 + " in revision: " + string);
            iOException.initCause(sVNClientException);
            throw iOException;
        }
    }

    public File getFileRevision(File file, String string) throws IOException {
        return this.getFileRevision(file, string, string);
    }

    public File getFileRevision(File file, String string, String string2) throws IOException {
        try {
            SvnClientFactory.checkClientAvailable();
        }
        catch (SVNClientException sVNClientException) {
            return null;
        }
        if ("BASE".equals(string)) {
            try {
                File file2 = this.getMetadataDir(file.getParentFile());
                if (file2 == null) {
                    return null;
                }
                File file3 = new File(file2, "text-base/" + file.getName() + ".svn-base");
                if (!file3.exists()) {
                    return null;
                }
                File file4 = new File(file2, "text-base/" + file.getName() + ".netbeans-base");
                if (file4.canRead() && file3.isFile() && file4.lastModified() >= file3.lastModified()) {
                    return file4;
                }
                SvnClient svnClient = Subversion.getInstance().getClient(file);
                InputStream inputStream = svnClient.getContent(file, SVNRevision.BASE);
                file4 = FileUtil.normalizeFile((File)file4);
                file4.deleteOnExit();
                FileUtils.copyStreamToFile(new BufferedInputStream(inputStream), file4);
                file4.setLastModified(file3.lastModified());
                return file4;
            }
            catch (SVNClientException sVNClientException) {
                IOException iOException = new IOException();
                iOException.initCause(sVNClientException);
                throw iOException;
            }
        }
        if ("PRISTINE".equals(string)) {
            String string3 = file.getName();
            File file5 = this.getMetadataDir(file.getParentFile());
            if (file5 != null) {
                File file6 = new File(file5, "text-base");
                File file7 = new File(file6, string3 + ".svn-base");
                if (file7.isFile()) {
                    return file7;
                }
                return null;
            }
            return null;
        }
        if ("LOCAL".equals(string)) {
            return file;
        }
        SVNRevision sVNRevision = SvnUtils.toSvnRevision(string);
        try {
            InputStream inputStream;
            SvnClient svnClient = Subversion.getInstance().getClient(file);
            FileStatusCache fileStatusCache = Subversion.getInstance().getStatusCache();
            try {
                SVNUrl sVNUrl;
                inputStream = (fileStatusCache.getStatus(file).getStatus() & 0x1DF8) != 0 ? svnClient.getContent(file, sVNRevision) : ((sVNUrl = SvnUtils.getRepositoryUrl(file)) != null ? this.getInputStream(svnClient, sVNUrl, string, string2) : new ByteArrayInputStream(NbBundle.getMessage(VersionsCache.class, (String)"MSG_UnknownURL").getBytes()));
            }
            catch (SVNClientException sVNClientException) {
                if (SvnClientExceptionHandler.isFileNotFoundInRevision(sVNClientException.getMessage()) || SvnClientExceptionHandler.isPathNotFound(sVNClientException.getMessage())) {
                    inputStream = new ByteArrayInputStream(new byte[0]);
                }
                throw sVNClientException;
            }
            return this.createContent(file.getName(), inputStream);
        }
        catch (SVNClientException sVNClientException) {
            IOException iOException = new IOException("Can not load: " + file.getAbsolutePath() + " in revision: " + string);
            iOException.initCause(sVNClientException);
            throw iOException;
        }
    }

    private InputStream getInputStream(SvnClient svnClient, SVNUrl sVNUrl, String string, String string2) throws SVNClientException {
        InputStream inputStream = null;
        try {
            inputStream = SvnClientFactory.isCLI() ? svnClient.getContent(sVNUrl.appendPath("@" + string2), SvnUtils.toSvnRevision(string)) : svnClient.getContent(sVNUrl, SvnUtils.toSvnRevision(string), SvnUtils.toSvnRevision(string2));
        }
        catch (SVNClientException sVNClientException) {
            if (SvnClientExceptionHandler.isFileNotFoundInRevision(sVNClientException.getMessage()) || SvnClientExceptionHandler.isPathNotFound(sVNClientException.getMessage())) {
                inputStream = new ByteArrayInputStream(new byte[0]);
            }
            throw sVNClientException;
        }
        return inputStream;
    }

    private File createContent(String string, InputStream inputStream) throws IOException {
        File file = File.createTempFile("nb-svn", string);
        file = FileUtil.normalizeFile((File)file);
        file.deleteOnExit();
        FileUtils.copyStreamToFile(new BufferedInputStream(inputStream), file);
        return file;
    }

    private File getMetadataDir(File file) {
        File file2 = new File(file, SvnUtils.SVN_ADMIN_DIR);
        if (!file2.isDirectory()) {
            return null;
        }
        return file2;
    }
}

