/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import org.netbeans.modules.subversion.FileStatusCache;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.spi.VCSAnnotator;
import org.netbeans.modules.versioning.spi.VCSInterceptor;
import org.netbeans.modules.versioning.spi.VersioningSystem;
import org.netbeans.modules.versioning.util.Utils;
import org.netbeans.modules.versioning.util.VersioningEvent;
import org.netbeans.modules.versioning.util.VersioningListener;
import org.netbeans.spi.queries.CollocationQueryImplementation;
import org.openide.util.NbBundle;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SubversionVCS
extends VersioningSystem
implements VersioningListener,
PreferenceChangeListener,
PropertyChangeListener {
    private final Set<File> unversionedParents = Collections.synchronizedSet(new HashSet(20));
    private final CollocationQueryImplementation collocationQueryImplementation = new CollocationQueryImplementation(){

        public boolean areCollocated(File file, File file2) {
            File file3 = SubversionVCS.this.getTopmostManagedAncestor(file);
            File file4 = SubversionVCS.this.getTopmostManagedAncestor(file2);
            if (file3 == null || !file3.equals(file4)) {
                return false;
            }
            try {
                SVNUrl sVNUrl = SvnUtils.getRepositoryRootUrl(file);
                if (sVNUrl == null) {
                    Subversion.LOG.log(Level.WARNING, "areCollocated returning false due to missing repository url for {0} {1}", new Object[]{file, file2});
                    return false;
                }
                SVNUrl sVNUrl2 = SvnUtils.getRepositoryRootUrl(file2);
                SVNUrl sVNUrl3 = SvnUtils.getRepositoryRootUrl(file3);
                return sVNUrl.equals((Object)sVNUrl2) && sVNUrl.equals((Object)sVNUrl3);
            }
            catch (SVNClientException sVNClientException) {
                if (!SvnClientExceptionHandler.isTooOldClientForWC(sVNClientException.getMessage())) {
                    Subversion.LOG.log(Level.INFO, null, sVNClientException);
                }
                Subversion.LOG.log(Level.WARNING, "areCollocated returning false due to catched exception " + file + " " + file2);
                return false;
            }
        }

        public File findRoot(File file) {
            return SubversionVCS.this.getTopmostManagedAncestor(file);
        }
    };

    public SubversionVCS() {
        this.putProperty("String VCS.DisplayName", NbBundle.getMessage(SubversionVCS.class, (String)"CTL_Subversion_DisplayName"));
        this.putProperty("String VCS.MenuLabel", NbBundle.getMessage(SubversionVCS.class, (String)"CTL_Subversion_MainMenu"));
        SvnModuleConfig.getDefault().getPreferences().addPreferenceChangeListener(this);
    }

    public File getTopmostManagedAncestor(File file) {
        Subversion.LOG.log(Level.FINE, "looking for managed parent for {0}", new Object[]{file});
        if (this.unversionedParents.contains(file)) {
            Subversion.LOG.fine(" cached as unversioned");
            return null;
        }
        File file2 = null;
        if (SvnUtils.isPartOfSubversionMetadata(file)) {
            Subversion.LOG.fine(" part of metaddata");
            while (file != null) {
                if (SvnUtils.isAdministrative(file)) {
                    Subversion.LOG.log(Level.FINE, " will use parent {0}", new Object[]{file});
                    file2 = file;
                    file = file.getParentFile();
                    break;
                }
                file = file.getParentFile();
            }
        }
        File file3 = null;
        HashSet<File> hashSet = new HashSet<File>();
        while (file != null) {
            if (this.unversionedParents.contains(file)) {
                Subversion.LOG.log(Level.FINE, " already known as unversioned {0}", new Object[]{file});
                break;
            }
            if (Utils.isScanForbidden((File)file)) break;
            if (new File(file, SvnUtils.SVN_ENTRIES_DIR).exists()) {
                Subversion.LOG.log(Level.FINE, " found managed parent {0}", new Object[]{file});
                file3 = file;
                hashSet.clear();
            } else {
                Subversion.LOG.log(Level.FINE, " found unversioned {0}", new Object[]{file});
                if (file.exists()) {
                    hashSet.add(file);
                }
            }
            file = file.getParentFile();
        }
        if (hashSet.size() > 0) {
            Subversion.LOG.log(Level.FINE, " storing unversioned");
            this.unversionedParents.addAll(hashSet);
        }
        if (file3 == null && file2 != null) {
            Subversion.LOG.log(Level.FINE, "setting metadata root as managed parent {0}", new Object[]{file2});
            file3 = file2;
        }
        Subversion.LOG.log(Level.FINE, "returning managed parent {0}", new Object[]{file3});
        return file3;
    }

    public VCSAnnotator getVCSAnnotator() {
        return Subversion.getInstance().getVCSAnnotator();
    }

    public VCSInterceptor getVCSInterceptor() {
        return Subversion.getInstance().getVCSInterceptor();
    }

    public void getOriginalFile(File file, File file2) {
        Subversion.getInstance().getOriginalFile(file, file2);
    }

    public CollocationQueryImplementation getCollocationQueryImplementation() {
        return this.collocationQueryImplementation;
    }

    public void versioningEvent(VersioningEvent versioningEvent) {
        if (versioningEvent.getId() == FileStatusCache.EVENT_FILE_STATUS_CHANGED) {
            File file = (File)versioningEvent.getParams()[0];
            this.fireStatusChanged(file);
        }
    }

    public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
        if (preferenceChangeEvent.getKey().startsWith("commitExclusions")) {
            this.fireStatusChanged(null);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("annotationsChanged")) {
            this.fireAnnotationsChanged((Set)propertyChangeEvent.getNewValue());
        } else if (propertyChangeEvent.getPropertyName().equals("versionedFilesChanged")) {
            Subversion.LOG.fine("cleaning unversioned parents cache");
            this.unversionedParents.clear();
            this.fireVersionedFilesChanged();
        }
    }
}

