/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.model;

import java.util.HashMap;
import java.util.Set;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DesignEvent {
    private final long eventID;
    private final Set<DesignComponent> fullyComponents;
    private final Set<DesignComponent> partlyComponents;
    private final Set<DesignComponent> fullyHierarchies;
    private final Set<DesignComponent> partlyHierarchies;
    private Set<DesignComponent> descriptorChangedComponents;
    private Set<DesignComponent> createdComponents;
    private HashMap<DesignComponent, HashMap<String, PropertyValue>> oldPropertyValues;
    private boolean selectionChanged;
    private boolean structureChanged;

    DesignEvent(long l, Set<DesignComponent> set, Set<DesignComponent> set2, Set<DesignComponent> set3, Set<DesignComponent> set4, Set<DesignComponent> set5, Set<DesignComponent> set6, HashMap<DesignComponent, HashMap<String, PropertyValue>> hashMap, boolean bl) {
        this.eventID = l;
        this.fullyComponents = set;
        this.partlyComponents = set2;
        this.fullyHierarchies = set3;
        this.partlyHierarchies = set4;
        this.descriptorChangedComponents = set5;
        this.createdComponents = set6;
        this.oldPropertyValues = hashMap;
        this.selectionChanged = bl;
        this.structureChanged = !set.isEmpty() || !set2.isEmpty() || !set3.isEmpty() || !set4.isEmpty() || !set5.isEmpty() || !set6.isEmpty() || !hashMap.isEmpty();
    }

    public long getEventID() {
        return this.eventID;
    }

    public Set<DesignComponent> getFullyAffectedComponents() {
        return this.fullyComponents;
    }

    public Set<DesignComponent> getFullyAffectedHierarchies() {
        return this.fullyHierarchies;
    }

    public Set<DesignComponent> getPartlyAffectedComponents() {
        return this.partlyComponents;
    }

    public Set<DesignComponent> getPartlyAffectedHierarchies() {
        return this.partlyHierarchies;
    }

    public Set<DesignComponent> getDescriptorChangedComponents() {
        return this.descriptorChangedComponents;
    }

    public Set<DesignComponent> getCreatedComponents() {
        return this.createdComponents;
    }

    public PropertyValue getOldPropertyValue(DesignComponent designComponent, String string) {
        HashMap<String, PropertyValue> hashMap = this.oldPropertyValues.get(designComponent);
        if (hashMap == null) {
            return null;
        }
        return hashMap.get(string);
    }

    public boolean isComponentPropertyChanged(DesignComponent designComponent, String string) {
        HashMap<String, PropertyValue> hashMap = this.oldPropertyValues.get(designComponent);
        return hashMap != null && hashMap.containsKey(string);
    }

    public boolean isSelectionChanged() {
        return this.selectionChanged;
    }

    public boolean isStructureChanged() {
        return this.structureChanged;
    }
}

