/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.archive.wizard;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.Document;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.j2ee.archive.ui.JavaEePlatformUiSupport;
import org.netbeans.modules.j2ee.archive.wizard.DeployableWizardIterator;
import org.netbeans.modules.j2ee.archive.wizard.DeployableWizardPanel;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ServerManager;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

class DeployablePanelVisual
extends JPanel
implements DocumentListener,
ActionListener {
    private static final Logger log = Logger.getLogger(DeployablePanelVisual.class.getName());
    private transient DeployableWizardPanel panel;
    private static File savedArchiveLoc = null;
    private JButton addServerButton;
    private JTextField archiveFileField;
    private JLabel archiveFileLabel;
    private JButton archiveLocationButton;
    private JLabel createdFolderLabel;
    private JTextField createdFolderTextField;
    private JButton projectLocationButton;
    private JLabel projectLocationLabel;
    private JTextField projectLocationTextField;
    private JLabel projectNameLabel;
    private JTextField projectNameTextField;
    private JComboBox serverInstanceComboBox;
    private JLabel targetServerLabel;
    private static final ResourceBundle bundle = NbBundle.getBundle(DeployablePanelVisual.class);

    public DeployablePanelVisual(DeployableWizardPanel deployableWizardPanel) {
        this.initComponents();
        this.panel = deployableWizardPanel;
        this.projectNameTextField.getDocument().addDocumentListener(this);
        this.projectLocationTextField.getDocument().addDocumentListener(this);
        this.archiveFileField.getDocument().addDocumentListener(this);
        this.serverInstanceComboBox.addActionListener(this);
    }

    public String getProjectName() {
        return this.projectNameTextField.getText();
    }

    private String validFreeProjectName(File file, String string, int n) {
        String string2 = MessageFormat.format(string, n);
        File file2 = new File(file, string2);
        return file2.exists() ? null : string2;
    }

    private void initComponents() {
        this.projectNameLabel = new JLabel();
        this.projectNameTextField = new JTextField();
        this.projectLocationLabel = new JLabel();
        this.projectLocationTextField = new JTextField();
        this.projectLocationButton = new JButton();
        this.createdFolderLabel = new JLabel();
        this.createdFolderTextField = new JTextField();
        this.archiveFileLabel = new JLabel();
        this.archiveFileField = new JTextField();
        this.archiveLocationButton = new JButton();
        this.targetServerLabel = new JLabel();
        this.serverInstanceComboBox = new JComboBox();
        this.addServerButton = new JButton();
        this.projectNameLabel.setLabelFor(this.projectNameTextField);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/j2ee/archive/wizard/Bundle");
        Mnemonics.setLocalizedText((JLabel)this.projectNameLabel, (String)resourceBundle.getString("projectName_TEXT"));
        this.projectLocationLabel.setLabelFor(this.projectLocationTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectLocationLabel, (String)resourceBundle.getString("projectLocation_TEXT"));
        Mnemonics.setLocalizedText((AbstractButton)this.projectLocationButton, (String)resourceBundle.getString("browse_TEXT"));
        this.projectLocationButton.setActionCommand(resourceBundle.getString("BROWSE"));
        this.projectLocationButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DeployablePanelVisual.this.projectLocationButtonActionPerformed(actionEvent);
            }
        });
        this.createdFolderLabel.setLabelFor(this.createdFolderTextField);
        Mnemonics.setLocalizedText((JLabel)this.createdFolderLabel, (String)resourceBundle.getString("projectFolder_TEXT"));
        this.createdFolderTextField.setEditable(false);
        Mnemonics.setLocalizedText((JLabel)this.archiveFileLabel, (String)resourceBundle.getString("archiveFileLabel_TEXT"));
        Mnemonics.setLocalizedText((AbstractButton)this.archiveLocationButton, (String)resourceBundle.getString("browse_TEXT"));
        this.archiveLocationButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DeployablePanelVisual.this.archiveLocationButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.targetServerLabel, (String)resourceBundle.getString("targetServerLabel_TEXT"));
        this.serverInstanceComboBox.setModel(JavaEePlatformUiSupport.createPlatformComboBoxModel(null));
        this.serverInstanceComboBox.setPrototypeDisplayValue("The Gr8est Marvelous Nr. 1 Server");
        Mnemonics.setLocalizedText((AbstractButton)this.addServerButton, (String)resourceBundle.getString("LBL_AddServer"));
        this.addServerButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DeployablePanelVisual.this.addServerButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.projectNameLabel).add((Component)this.projectLocationLabel, -1, 112, Short.MAX_VALUE).add((Component)this.createdFolderLabel).add((Component)this.archiveFileLabel)).addPreferredGap(0)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.targetServerLabel).add(33, 33, 33))).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.serverInstanceComboBox, 0, 196, Short.MAX_VALUE).add((Component)this.createdFolderTextField, -1, 196, Short.MAX_VALUE).add(2, (Component)this.projectNameTextField, -1, 196, Short.MAX_VALUE).add((Component)this.projectLocationTextField, -1, 196, Short.MAX_VALUE).add(2, (Component)this.archiveFileField, -1, 196, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1, false).add((Component)this.projectLocationButton, -1, -1, Short.MAX_VALUE).add((Component)this.archiveLocationButton, -1, -1, Short.MAX_VALUE).add((Component)this.addServerButton, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.projectNameLabel).add((Component)this.projectNameTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.projectLocationLabel).add((Component)this.projectLocationTextField, -2, -1, -2).add((Component)this.projectLocationButton)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.createdFolderLabel).add((Component)this.createdFolderTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.archiveFileLabel).add((Component)this.archiveFileField, -2, -1, -2).add((Component)this.archiveLocationButton)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.targetServerLabel).add((Component)this.serverInstanceComboBox, -2, -1, -2).add((Component)this.addServerButton)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void addServerButtonActionPerformed(ActionEvent actionEvent) {
        String string;
        Object object = this.serverInstanceComboBox.getSelectedItem();
        String string2 = null;
        if (object != null) {
            string2 = JavaEePlatformUiSupport.getServerInstanceID(object);
        }
        if ((string = ServerManager.showAddServerInstanceWizard()) != null) {
            string2 = string;
        }
        this.serverInstanceComboBox.setModel(JavaEePlatformUiSupport.createPlatformComboBoxModel(string2));
        this.panel.fireChangeEvent();
    }

    private void archiveLocationButtonActionPerformed(ActionEvent actionEvent) {
        File file;
        JFileChooser jFileChooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jFileChooser, null);
        jFileChooser.setDialogTitle(NbBundle.getMessage(DeployablePanelVisual.class, (String)"DLG_TITLE_ArchiveChooser"));
        jFileChooser.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                String string = file.getAbsolutePath();
                return DeployablePanelVisual.this.acceptableArchive(string);
            }

            public String getDescription() {
                return NbBundle.getMessage(DeployablePanelVisual.class, (String)"ARCHIVE_CHOOSER_DESCRIPTOR");
            }
        });
        String string = this.archiveFileField.getText();
        if (string.length() > 0) {
            file = new File(string);
            if (file.exists()) {
                jFileChooser.setSelectedFile(file);
            }
        } else if (savedArchiveLoc != null) {
            jFileChooser.setCurrentDirectory(savedArchiveLoc);
        }
        if (0 == jFileChooser.showOpenDialog(this)) {
            file = jFileChooser.getSelectedFile();
            this.archiveFileField.setText(FileUtil.normalizeFile((File)file).getAbsolutePath());
            savedArchiveLoc = file.getParentFile();
        }
        this.panel.fireChangeEvent();
    }

    private void projectLocationButtonActionPerformed(ActionEvent actionEvent) {
        File file;
        JFileChooser jFileChooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jFileChooser, null);
        jFileChooser.setDialogTitle(NbBundle.getMessage(DeployablePanelVisual.class, (String)"DLG_TITLE_FolderChooser"));
        jFileChooser.setFileSelectionMode(1);
        String string = this.projectLocationTextField.getText();
        if (string.length() > 0 && (file = new File(string)).exists()) {
            jFileChooser.setSelectedFile(file);
        }
        if (0 == jFileChooser.showOpenDialog(this)) {
            file = jFileChooser.getSelectedFile();
            this.projectLocationTextField.setText(FileUtil.normalizeFile((File)file).getAbsolutePath());
        }
        this.panel.fireChangeEvent();
    }

    public void addNotify() {
        super.addNotify();
        this.projectNameTextField.requestFocus();
    }

    boolean valid(WizardDescriptor wizardDescriptor) {
        File file;
        File file2;
        if (this.projectNameTextField.getText().length() == 0) {
            this.setError(wizardDescriptor, "ERR_valid_folder_name");
            return false;
        }
        File file3 = FileUtil.normalizeFile((File)new File(this.projectLocationTextField.getText()).getAbsoluteFile());
        if (!file3.isDirectory()) {
            this.setError(wizardDescriptor, "ERR_valid_path");
            return false;
        }
        for (file2 = file = FileUtil.normalizeFile((File)new File(this.createdFolderTextField.getText()).getAbsoluteFile()); file2 != null && !file2.exists(); file2 = file2.getParentFile()) {
        }
        if (file2 == null || !file2.canWrite()) {
            this.setError(wizardDescriptor, "ERR_cannot_write_folder");
            return false;
        }
        if (FileUtil.toFileObject((File)file2) == null) {
            this.setError(wizardDescriptor, "ERR_valid_path");
            return false;
        }
        File[] fileArray = file.listFiles();
        if (file.exists() && fileArray != null && fileArray.length > 0) {
            this.setError(wizardDescriptor, "ERR_folder_not_empty");
            return false;
        }
        String string = this.archiveFileField.getText();
        if (string.trim().length() < 1) {
            this.setInfo(wizardDescriptor, "ERR_empty_archive_name");
            return false;
        }
        file3 = FileUtil.normalizeFile((File)new File(string).getAbsoluteFile());
        if (!(file3.exists() && file3.isFile() && file3.canRead())) {
            this.setError(wizardDescriptor, "ERR_invalid_archive");
            return false;
        }
        if (this.serverInstanceComboBox.getItemCount() == 0) {
            this.setError(wizardDescriptor, "ERR_no_possible_target");
            return false;
        }
        if (this.serverInstanceComboBox.getSelectedItem() == null) {
            this.setError(wizardDescriptor, "ERR_no_target");
            return false;
        }
        String string2 = file3.getAbsoluteFile().getAbsolutePath();
        if (!this.acceptableArchive(string2, wizardDescriptor)) {
            this.setError(wizardDescriptor, "ERR_unsupported_archive");
            return false;
        }
        if ("unknown".equals(wizardDescriptor.getProperty("type"))) {
            boolean bl;
            File file4 = new File(string2);
            try {
                JarFile jarFile = new JarFile(file4);
                boolean bl2 = DeployableWizardIterator.isEjbJar(jarFile);
                boolean bl3 = DeployableWizardIterator.hasMain(jarFile);
                bl = !bl2 && !bl3;
            }
            catch (IOException iOException) {
                log.log(Level.WARNING, "Error during archive type discovery", iOException);
                bl = true;
            }
            if (bl) {
                this.setError(wizardDescriptor, "ERR_Cannot_Deteremine_Type");
                return false;
            }
        }
        wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)"");
        return true;
    }

    private void setError(WizardDescriptor wizardDescriptor, String string) {
        String string2 = bundle.getString(string);
        wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)string2);
    }

    private void setInfo(WizardDescriptor wizardDescriptor, String string) {
        String string2 = bundle.getString(string);
        wizardDescriptor.putProperty("WizardPanel_infoMessage", (Object)string2);
    }

    boolean acceptableArchive(String string, WizardDescriptor wizardDescriptor) {
        boolean bl = false;
        if (string.endsWith(".war")) {
            wizardDescriptor.putProperty("type", (Object)"war");
            bl = true;
        }
        if (string.endsWith(".car")) {
            wizardDescriptor.putProperty("type", (Object)"car");
            bl = true;
        }
        if (string.endsWith(".rar")) {
            wizardDescriptor.putProperty("type", (Object)"rar");
            bl = true;
        }
        if (string.endsWith(".ear")) {
            wizardDescriptor.putProperty("type", (Object)"ear");
            bl = true;
        }
        if (string.endsWith(".jar")) {
            wizardDescriptor.putProperty("type", (Object)"unknown");
            bl = true;
        }
        return bl;
    }

    void store(WizardDescriptor wizardDescriptor) {
        String string = this.projectNameTextField.getText().trim();
        String string2 = this.createdFolderTextField.getText().trim();
        wizardDescriptor.putProperty("projdir", (Object)new File(string2));
        wizardDescriptor.putProperty("name", (Object)string);
        wizardDescriptor.putProperty("targetServer", this.serverInstanceComboBox.getSelectedItem());
        wizardDescriptor.putProperty("sourceArchive", (Object)new File(this.archiveFileField.getText().trim()));
    }

    void read(WizardDescriptor wizardDescriptor) {
        File file = (File)wizardDescriptor.getProperty("projdir");
        file = file == null || file.getParentFile() == null || !file.getParentFile().isDirectory() ? ProjectChooser.getProjectsFolder() : file.getParentFile();
        this.projectLocationTextField.setText(file.getAbsolutePath());
        String string = (String)wizardDescriptor.getProperty("name");
        if (string == null) {
            int n = 0;
            String string2 = bundle.getString("TXT_DefaultProjectName");
            while ((string = this.validFreeProjectName(file, string2, n)) == null) {
                ++n;
            }
        }
        this.projectNameTextField.setText(string);
        this.projectNameTextField.selectAll();
    }

    void validate(WizardDescriptor wizardDescriptor) throws WizardValidationException {
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateTexts(documentEvent);
        if (this.projectNameTextField.getDocument() == documentEvent.getDocument()) {
            this.firePropertyChange("name", null, this.projectNameTextField.getText());
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateTexts(documentEvent);
        if (this.projectNameTextField.getDocument() == documentEvent.getDocument()) {
            this.firePropertyChange("name", null, this.projectNameTextField.getText());
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateTexts(documentEvent);
        if (this.projectNameTextField.getDocument() == documentEvent.getDocument()) {
            this.firePropertyChange("name", null, this.projectNameTextField.getText());
        }
    }

    private void updateTexts(DocumentEvent documentEvent) {
        Document document = documentEvent.getDocument();
        if (document == this.projectNameTextField.getDocument() || document == this.projectLocationTextField.getDocument()) {
            String string = this.projectNameTextField.getText();
            String string2 = this.projectLocationTextField.getText();
            this.createdFolderTextField.setText(string2 + File.separatorChar + string);
        }
        this.panel.fireChangeEvent();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.panel.fireChangeEvent();
    }

    private boolean acceptableArchive(String string) {
        return string.endsWith(".war") || string.endsWith(".car") || string.endsWith(".ear") || string.endsWith(".jar") || string.endsWith(".rar");
    }
}

