/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.spi;

import java.util.HashMap;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.impl.CurrentDocumentScheduler;
import org.netbeans.modules.parsing.impl.CursorSensitiveScheduler;
import org.netbeans.modules.parsing.impl.SchedulerAccessor;
import org.netbeans.modules.parsing.impl.SelectedNodesScheduler;
import org.netbeans.modules.parsing.impl.SourceAccessor;
import org.netbeans.modules.parsing.impl.SourceCache;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.modules.parsing.spi.SourceModificationEvent;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Scheduler {
    public static final int DEFAULT_REPARSE_DELAY = 500;
    int reparseDelay = 500;
    private Source source;
    public static final Class<? extends Scheduler> CURSOR_SENSITIVE_TASK_SCHEDULER = CursorSensitiveScheduler.class;
    public static final Class<? extends Scheduler> EDITOR_SENSITIVE_TASK_SCHEDULER = CurrentDocumentScheduler.class;
    public static final Class<? extends Scheduler> SELECTED_NODES_SENSITIVE_TASK_SCHEDULER = SelectedNodesScheduler.class;
    private RequestProcessor requestProcessor;
    private RequestProcessor.Task task;

    protected final void schedule(SchedulerEvent schedulerEvent) {
        if (this.source != null) {
            this.schedule(this.source, schedulerEvent);
        }
    }

    protected final synchronized void schedule(final Source source, final SchedulerEvent schedulerEvent) {
        assert (source != null);
        if (this.task != null) {
            this.task.cancel();
        }
        this.task = null;
        this.source = source;
        if (this.requestProcessor == null) {
            this.requestProcessor = new RequestProcessor();
        }
        this.task = this.requestProcessor.create(new Runnable(){

            public void run() {
                SourceCache sourceCache = SourceAccessor.getINSTANCE().getCache(source);
                HashMap hashMap = new HashMap();
                hashMap.put(Scheduler.this.getClass(), schedulerEvent);
                SourceAccessor.getINSTANCE().setSchedulerEvents(source, hashMap);
                sourceCache.scheduleTasks(Scheduler.this.getClass());
            }
        });
        this.task.schedule(this.reparseDelay);
    }

    protected abstract SchedulerEvent createSchedulerEvent(SourceModificationEvent var1);

    private static boolean notNull(Iterable<?> iterable) {
        for (Object obj : iterable) {
            if (obj != null) continue;
            return false;
        }
        return true;
    }

    static {
        SchedulerAccessor.set(new Accessor());
    }

    private static class Accessor
    extends SchedulerAccessor {
        private Accessor() {
        }

        public SchedulerEvent createSchedulerEvent(Scheduler scheduler, SourceModificationEvent sourceModificationEvent) {
            return scheduler.createSchedulerEvent(sourceModificationEvent);
        }
    }
}

