/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.impl.indexing.lucene;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.KeywordAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FilterIndexReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.DefaultSimilarity;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.NoLockFactory;
import org.apache.lucene.store.RAMDirectory;
import org.netbeans.modules.parsing.impl.indexing.IndexDocumentImpl;
import org.netbeans.modules.parsing.impl.indexing.IndexImpl;
import org.netbeans.modules.parsing.impl.indexing.lucene.DocumentUtil;
import org.netbeans.modules.parsing.impl.indexing.lucene.LMListener;
import org.netbeans.modules.parsing.impl.indexing.lucene.LuceneDocument;
import org.netbeans.modules.parsing.impl.indexing.lucene.LuceneIndexManager;
import org.netbeans.modules.parsing.impl.indexing.lucene.TermComparator;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuceneIndex
implements IndexImpl {
    private static final Logger LOGGER = Logger.getLogger(LuceneIndex.class.getName());
    private static final boolean debugIndexMerging = Boolean.getBoolean("LuceneIndex.debugIndexMerge");
    static final int VERSION = 1;
    private static final int MAX_DOCS = 2000;
    private final File indexFolder;
    private volatile Directory directory;
    private volatile IndexReader reader;
    private volatile boolean closed;
    private static final LMListener lmListener = new LMListener();
    private final List<LuceneDocument> toAdd = new LinkedList<LuceneDocument>();
    private final List<String> toRemove = new LinkedList<String>();
    private final Set<String> staleFiles = new HashSet<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDocument(IndexDocumentImpl indexDocumentImpl) {
        boolean bl;
        LuceneIndex luceneIndex = this;
        synchronized (luceneIndex) {
            assert (indexDocumentImpl instanceof LuceneDocument);
            this.toAdd.add((LuceneDocument)indexDocumentImpl);
            bl = this.toAdd.size() > 2000 || lmListener.isLowMemory();
        }
        if (bl) {
            try {
                LOGGER.fine("Extra flush forced");
                this.store();
            }
            catch (IOException iOException) {
                LOGGER.log(Level.WARNING, null, LuceneIndex.annotateException(iOException, this.indexFolder));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDocument(String string) {
        boolean bl;
        LuceneIndex luceneIndex = this;
        synchronized (luceneIndex) {
            this.toRemove.add(string);
            bl = this.toAdd.size() > 2000 || lmListener.isLowMemory();
        }
        if (bl) {
            try {
                LOGGER.fine("Extra flush forced");
                this.store();
            }
            catch (IOException iOException) {
                LOGGER.log(Level.WARNING, null, LuceneIndex.annotateException(iOException, this.indexFolder));
            }
        }
    }

    @Override
    public void store() throws IOException {
        LuceneIndexManager.getDefault().writeAccess(new LuceneIndexManager.Action<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void run() throws IOException {
                LinkedList linkedList;
                LinkedList linkedList2;
                LuceneIndex.this.checkPreconditions();
                LuceneIndex luceneIndex = LuceneIndex.this;
                synchronized (luceneIndex) {
                    linkedList2 = new LinkedList(LuceneIndex.this.toAdd);
                    linkedList = new LinkedList(LuceneIndex.this.toRemove);
                    LuceneIndex.this.toAdd.clear();
                    LuceneIndex.this.toRemove.clear();
                    for (LuceneDocument luceneDocument : linkedList2) {
                        LuceneIndex.this.staleFiles.remove(luceneDocument.getSourceName());
                    }
                    LuceneIndex.this.staleFiles.removeAll(linkedList);
                }
                if (linkedList2.size() > 0 || linkedList.size() > 0) {
                    LuceneIndex.this.flush(LuceneIndex.this.indexFolder, linkedList2, linkedList, LuceneIndex.this.directory, lmListener);
                }
                return null;
            }
        });
    }

    @Override
    public Collection<? extends IndexDocumentImpl> query(final String string, final String string2, final QuerySupport.Kind kind, final String ... stringArray) throws IOException {
        assert (string != null);
        assert (string2 != null);
        assert (kind != null);
        return LuceneIndexManager.getDefault().readAccess(new LuceneIndexManager.Action<List<IndexDocumentImpl>>(){

            @Override
            public List<IndexDocumentImpl> run() throws IOException {
                LuceneIndex.this.checkPreconditions();
                IndexReader indexReader = LuceneIndex.this.getReader(false);
                if (indexReader != null) {
                    return LuceneIndex._query(indexReader, string, string2, kind, stringArray);
                }
                return Collections.emptyList();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fileModified(String string) {
        LuceneIndex luceneIndex = this;
        synchronized (luceneIndex) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(this + ", adding stale file: " + string);
            }
            this.staleFiles.add(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<? extends String> getStaleFiles() {
        LuceneIndex luceneIndex = this;
        synchronized (luceneIndex) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(this + ", stale files: " + this.staleFiles);
            }
            return new LinkedList<String>(this.staleFiles);
        }
    }

    public LuceneIndex(URL uRL) throws IOException {
        assert (uRL != null);
        try {
            this.indexFolder = new File(uRL.toURI());
            this.directory = FSDirectory.getDirectory((File)this.indexFolder, (LockFactory)NoLockFactory.getNoLockFactory());
        }
        catch (URISyntaxException uRISyntaxException) {
            IOException iOException = new IOException();
            iOException.initCause(uRISyntaxException);
            throw iOException;
        }
    }

    public void clear() throws IOException {
        this.checkPreconditions();
        LuceneIndexManager.getDefault().writeAccess(new LuceneIndexManager.Action<Void>(){

            @Override
            public Void run() throws IOException {
                LuceneIndex.this._clear();
                return null;
            }
        });
    }

    public void close() throws IOException {
        this.checkPreconditions();
        LuceneIndexManager.getDefault().writeAccess(new LuceneIndexManager.Action<Void>(){

            @Override
            public Void run() throws IOException {
                LuceneIndex.this._close();
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _clear() throws IOException {
        block10: {
            this._close();
            try {
                File[] fileArray;
                String[] stringArray = this.directory.list();
                boolean bl = false;
                Object object = stringArray;
                int n = ((String[])object).length;
                for (int i = 0; i < n; ++i) {
                    String string = object[i];
                    try {
                        this.directory.deleteFile(string);
                        continue;
                    }
                    catch (IOException iOException) {
                        if (!this.directory.fileExists(string)) continue;
                        bl = true;
                    }
                }
                if (!bl || (fileArray = ((File)(object = ((FSDirectory)this.directory).getFile())).listFiles()) == null) break block10;
                for (File file : fileArray) {
                    if (file.delete()) continue;
                    Class<?> clazz = this.directory.getClass();
                    int n2 = -1;
                    try {
                        Field field = clazz.getDeclaredField("refCount");
                        field.setAccessible(true);
                        n2 = field.getInt(this.directory);
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                    throw new IOException("Cannot delete: " + file.getAbsolutePath() + "(" + file.exists() + "," + file.canRead() + "," + file.canWrite() + "," + ((File)object).canRead() + "," + ((File)object).canWrite() + "," + n2 + ")");
                }
            }
            finally {
                this.directory = FSDirectory.getDirectory((File)this.indexFolder, (LockFactory)NoLockFactory.getNoLockFactory());
                this.closed = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _close() throws IOException {
        try {
            if (this.reader != null) {
                this.reader.close();
                this.reader = null;
            }
        }
        finally {
            this.directory.close();
            this.closed = true;
        }
    }

    private static List<IndexDocumentImpl> _query(IndexReader indexReader, String string, String string2, QuerySupport.Kind kind, String ... stringArray) throws IOException {
        Object object;
        Serializable serializable;
        LinkedList<IndexDocumentImpl> linkedList = new LinkedList<IndexDocumentImpl>();
        TreeSet<Term> treeSet = new TreeSet<Term>(new TermComparator());
        switch (kind) {
            case EXACT: {
                treeSet.add(new Term(string, string2));
                break;
            }
            case PREFIX: {
                if (string2.length() == 0) {
                    LuceneIndex.emptyPrefixSearch(indexReader, stringArray, linkedList);
                    return linkedList;
                }
                serializable = new Term(string, string2);
                LuceneIndex.prefixSearch((Term)serializable, indexReader, treeSet);
                break;
            }
            case CASE_INSENSITIVE_PREFIX: {
                if (string2.length() == 0) {
                    LuceneIndex.emptyPrefixSearch(indexReader, stringArray, linkedList);
                    return linkedList;
                }
                serializable = new Term(string, string2.toLowerCase());
                LuceneIndex.prefixSearch((Term)serializable, indexReader, treeSet);
                break;
            }
            case CAMEL_CASE: {
                Object object2;
                int n3;
                if (string2.length() == 0) {
                    throw new IllegalArgumentException();
                }
                serializable = new StringBuilder();
                object = null;
                int n2 = 0;
                do {
                    object2 = string2.substring(n2, (n3 = LuceneIndex.findNextUpper(string2, n2 + 1)) == -1 ? string2.length() : n3);
                    if (n2 == 0) {
                        object = object2;
                    }
                    ((StringBuilder)serializable).append((String)object2);
                    ((StringBuilder)serializable).append(n3 != -1 ? "[\\p{javaLowerCase}\\p{Digit}_\\$]*" : ".*");
                    n2 = n3;
                } while (n3 != -1);
                object2 = Pattern.compile(((StringBuilder)serializable).toString());
                LuceneIndex.regExpSearch((Pattern)object2, new Term(string, (String)object), indexReader, treeSet);
                break;
            }
            case CASE_INSENSITIVE_REGEXP: {
                if (string2.length() == 0) {
                    throw new IllegalArgumentException();
                }
                serializable = Pattern.compile(string2, 2);
                if (Character.isJavaIdentifierStart(string2.charAt(0))) {
                    LuceneIndex.regExpSearch((Pattern)serializable, new Term(string, string2.toLowerCase()), indexReader, treeSet);
                    break;
                }
                LuceneIndex.regExpSearch((Pattern)serializable, new Term(string, ""), indexReader, treeSet);
                break;
            }
            case REGEXP: {
                if (string2.length() == 0) {
                    throw new IllegalArgumentException();
                }
                serializable = Pattern.compile(string2);
                if (Character.isJavaIdentifierStart(string2.charAt(0))) {
                    LuceneIndex.regExpSearch((Pattern)serializable, new Term(string, string2), indexReader, treeSet);
                    break;
                }
                LuceneIndex.regExpSearch((Pattern)serializable, new Term(string, ""), indexReader, treeSet);
                break;
            }
            case CASE_INSENSITIVE_CAMEL_CASE: {
                Object object3;
                int n;
                if (string2.length() == 0) {
                    LuceneIndex.emptyPrefixSearch(indexReader, stringArray, linkedList);
                    return linkedList;
                }
                serializable = new Term(string, string2.toLowerCase());
                LuceneIndex.prefixSearch((Term)serializable, indexReader, treeSet);
                object = new StringBuilder();
                String string3 = null;
                int n3 = 0;
                do {
                    object3 = string2.substring(n3, (n = LuceneIndex.findNextUpper(string2, n3 + 1)) == -1 ? string2.length() : n);
                    if (n3 == 0) {
                        string3 = object3;
                    }
                    ((StringBuilder)object).append((String)object3);
                    ((StringBuilder)object).append(n != -1 ? "[\\p{javaLowerCase}\\p{Digit}_\\$]*" : ".*");
                    n3 = n;
                } while (n != -1);
                object3 = Pattern.compile(((StringBuilder)object).toString());
                LuceneIndex.regExpSearch((Pattern)object3, new Term(string, string3), indexReader, treeSet);
                break;
            }
            default: {
                throw new UnsupportedOperationException(kind.toString());
            }
        }
        serializable = indexReader.termDocs();
        object = treeSet.iterator();
        TreeSet<Integer> treeSet2 = new TreeSet<Integer>();
        int[] nArray = new int[25];
        int[] nArray2 = new int[25];
        block11: while (object.hasNext()) {
            int n;
            serializable.seek((Term)object.next());
            while ((n = serializable.read(nArray, nArray2)) > 0) {
                for (int i = 0; i < n; ++i) {
                    treeSet2.add(nArray[i]);
                }
                if (n >= nArray.length) continue;
                continue block11;
            }
        }
        FieldSelector fieldSelector = DocumentUtil.selector(stringArray);
        for (Integer n : treeSet2) {
            Document document = indexReader.document(n.intValue(), fieldSelector);
            linkedList.add(new LuceneDocument(document));
        }
        return linkedList;
    }

    private static void deleteFile(IndexReader indexReader, Searcher searcher, String string) throws IOException {
        int n;
        Hits hits = searcher.search(DocumentUtil.sourceNameQuery(string));
        int[] nArray = new int[hits.length()];
        int n2 = 0;
        for (n = 0; n < nArray.length; ++n) {
            nArray[n2++] = hits.id(n);
        }
        for (n = 0; n < n2; ++n) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Deleting from index: " + string + ", lucene document idx=" + nArray[n]);
            }
            indexReader.deleteDocument(nArray[n]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void flush(File file, List<LuceneDocument> list, List<String> list2, Directory directory, LMListener lMListener) throws IOException {
        LOGGER.log(Level.FINE, "Flushing: {0}", file);
        try {
            Iterator<Object> iterator;
            IndexSearcher indexSearcher;
            IndexReader indexReader = this.getReader(true);
            if (indexReader != null) {
                try {
                    indexSearcher = new IndexSearcher(indexReader);
                    try {
                        iterator = list2.iterator();
                        while (iterator.hasNext()) {
                            String object2 = iterator.next();
                            iterator.remove();
                            LuceneIndex.deleteFile(indexReader, (Searcher)indexSearcher, object2);
                        }
                        for (LuceneDocument luceneDocument : list) {
                            LuceneIndex.deleteFile(indexReader, (Searcher)indexSearcher, luceneDocument.getSourceName());
                        }
                    }
                    finally {
                        indexSearcher.close();
                    }
                }
                finally {
                    indexReader.close();
                }
            }
            indexSearcher = new IndexWriter(directory, false, (Analyzer)new KeywordAnalyzer(), indexReader == null);
            try {
                void var9_16;
                if (debugIndexMerging) {
                    indexSearcher.setInfoStream(System.err);
                }
                iterator = null;
                Object var9_12 = null;
                if (lMListener.isLowMemory()) {
                    IndexSearcher indexSearcher2 = indexSearcher;
                } else {
                    iterator = new RAMDirectory();
                    IndexWriter indexWriter = new IndexWriter(iterator, (Analyzer)new KeywordAnalyzer(), true);
                }
                Iterator<LuceneDocument> iterator2 = list.iterator();
                while (iterator2.hasNext()) {
                    LuceneDocument luceneDocument = iterator2.next();
                    iterator2.remove();
                    var9_16.addDocument(luceneDocument.doc);
                    if (iterator != null && lMListener.isLowMemory()) {
                        var9_16.close();
                        indexSearcher.addIndexes(new Directory[]{iterator});
                        iterator = new RAMDirectory();
                        IndexWriter indexWriter = new IndexWriter(iterator, (Analyzer)new KeywordAnalyzer(), true);
                    }
                    LOGGER.log(Level.FINEST, "LuceneDocument merged: {0}", luceneDocument);
                }
                if (iterator != null) {
                    var9_16.close();
                    indexSearcher.addIndexes(new Directory[]{iterator});
                    Object var9_18 = null;
                    iterator = null;
                }
            }
            finally {
                indexSearcher.close();
            }
        }
        finally {
            LOGGER.log(Level.FINE, "Index flushed: {0}", file);
        }
    }

    private void checkPreconditions() throws IOException {
        if (this.closed) {
            throw new IOException("Index already closed: " + this.indexFolder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexReader getReader(boolean bl) throws IOException {
        Object object = this.reader;
        if (object == null) {
            boolean bl2 = IndexReader.indexExists((Directory)this.directory);
            if (bl2) {
                try {
                    object = new NoNormsReader(IndexReader.open((Directory)this.directory));
                }
                catch (IOException iOException) {
                    throw LuceneIndex.annotateException(iOException, this.indexFolder);
                }
                LuceneIndex luceneIndex = this;
                synchronized (luceneIndex) {
                    if (this.reader == null) {
                        this.reader = object;
                    } else {
                        try {
                            object.close();
                        }
                        catch (IOException iOException) {
                            LOGGER.log(Level.WARNING, null, iOException);
                        }
                        object = this.reader;
                    }
                }
            }
            LOGGER.fine(String.format("LuceneIndex[%s] does not exist.", this.toString()));
        }
        if (bl) {
            LuceneIndex luceneIndex = this;
            synchronized (luceneIndex) {
                this.reader = null;
            }
        }
        return object;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.indexFolder.getAbsolutePath() + "]";
    }

    private static IOException annotateException(IOException iOException, File file) {
        String string;
        File[] fileArray;
        File[] fileArray2 = fileArray = file == null ? null : file.listFiles();
        if (fileArray == null) {
            string = "Non existing index folder";
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            for (File file2 : fileArray) {
                stringBuilder.append(file2.getName() + " f: " + file2.isFile() + " r: " + file2.canRead() + " w: " + file2.canWrite() + "\n");
            }
            string = stringBuilder.toString();
        }
        return (IOException)Exceptions.attachMessage((Throwable)iOException, (String)string);
    }

    private static void emptyPrefixSearch(IndexReader indexReader, String[] stringArray, List<? super IndexDocumentImpl> list) throws IOException {
        int n = indexReader.maxDoc();
        for (int i = 0; i < n; ++i) {
            Document document;
            if (indexReader.isDeleted(i) || (document = indexReader.document(i, DocumentUtil.selector(stringArray))) == null) continue;
            list.add(new LuceneDocument(document));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void prefixSearch(Term term, IndexReader indexReader, Set<? super Term> set) throws IOException {
        String string = term.field();
        String string2 = term.text();
        TermEnum termEnum = indexReader.terms(term);
        try {
            Term term2;
            while ((term2 = termEnum.term()) != null && string == term2.field() && term2.text().startsWith(string2)) {
                set.add((Term)term2);
                if (termEnum.next()) continue;
                break;
            }
        }
        finally {
            termEnum.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void regExpSearch(Pattern pattern, Term term, IndexReader indexReader, Set<? super Term> set) throws IOException {
        String string;
        CharSequence charSequence;
        String string2 = term.text();
        if (string2.length() > 0) {
            char c;
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append(string2.charAt(0));
            for (int i = 1; i < string2.length() && Character.isJavaIdentifierPart(c = string2.charAt(i)); ++i) {
                ((StringBuilder)charSequence).append(c);
            }
            string = ((StringBuilder)charSequence).toString();
            term = new Term(term.field(), string);
        } else {
            string = string2;
        }
        charSequence = term.field();
        TermEnum termEnum = indexReader.terms(term);
        try {
            Term term2;
            while ((term2 = termEnum.term()) != null && charSequence == term2.field() && term2.text().startsWith(string)) {
                Matcher matcher = pattern.matcher(term2.text());
                if (matcher.matches()) {
                    set.add((Term)term2);
                }
                if (termEnum.next()) continue;
                break;
            }
        }
        finally {
            termEnum.close();
        }
    }

    private static int findNextUpper(String string, int n) {
        for (int i = n; i < string.length(); ++i) {
            if (!Character.isUpperCase(string.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    private static final class NoNormsReader
    extends FilterIndexReader {
        private byte[] norms;

        public NoNormsReader(IndexReader indexReader) {
            super(indexReader);
        }

        public byte[] norms(String string) throws IOException {
            byte[] byArray = this.fakeNorms();
            return byArray;
        }

        public void norms(String string, byte[] byArray, int n) throws IOException {
            byte[] byArray2 = this.fakeNorms();
            System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
        }

        public boolean hasNorms(String string) throws IOException {
            return false;
        }

        protected void doSetNorm(int n, String string, byte by) throws CorruptIndexException, IOException {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doClose() throws IOException {
            NoNormsReader noNormsReader = this;
            synchronized (noNormsReader) {
                this.norms = null;
            }
            super.doClose();
        }

        private synchronized byte[] fakeNorms() {
            if (this.norms == null) {
                this.norms = new byte[this.maxDoc()];
                Arrays.fill(this.norms, DefaultSimilarity.encodeNorm((float)1.0f));
            }
            return this.norms;
        }
    }
}

