/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.impl.indexing;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.editor.AtomicLockEvent;
import org.netbeans.editor.AtomicLockListener;
import org.netbeans.editor.BaseDocument;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.impl.Utilities;
import org.netbeans.modules.parsing.impl.indexing.CacheFolder;
import org.netbeans.modules.parsing.impl.indexing.CancelRequest;
import org.netbeans.modules.parsing.impl.indexing.DeletedIndexable;
import org.netbeans.modules.parsing.impl.indexing.EventKind;
import org.netbeans.modules.parsing.impl.indexing.FileObjectCrawler;
import org.netbeans.modules.parsing.impl.indexing.FileObjectIndexable;
import org.netbeans.modules.parsing.impl.indexing.PathKind;
import org.netbeans.modules.parsing.impl.indexing.PathRecognizerRegistry;
import org.netbeans.modules.parsing.impl.indexing.PathRegistry;
import org.netbeans.modules.parsing.impl.indexing.PathRegistryEvent;
import org.netbeans.modules.parsing.impl.indexing.PathRegistryListener;
import org.netbeans.modules.parsing.impl.indexing.SPIAccessor;
import org.netbeans.modules.parsing.impl.indexing.SupportAccessor;
import org.netbeans.modules.parsing.impl.indexing.TimeStamps;
import org.netbeans.modules.parsing.impl.indexing.Util;
import org.netbeans.modules.parsing.impl.indexing.friendapi.IndexingActivityInterceptor;
import org.netbeans.modules.parsing.impl.indexing.friendapi.IndexingController;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.ParserResultTask;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.modules.parsing.spi.indexing.BinaryIndexer;
import org.netbeans.modules.parsing.spi.indexing.BinaryIndexerFactory;
import org.netbeans.modules.parsing.spi.indexing.Context;
import org.netbeans.modules.parsing.spi.indexing.CustomIndexer;
import org.netbeans.modules.parsing.spi.indexing.CustomIndexerFactory;
import org.netbeans.modules.parsing.spi.indexing.EmbeddingIndexer;
import org.netbeans.modules.parsing.spi.indexing.EmbeddingIndexerFactory;
import org.netbeans.modules.parsing.spi.indexing.Indexable;
import org.netbeans.modules.parsing.spi.indexing.support.IndexingSupport;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;
import org.openide.util.TopologicalSortException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RepositoryUpdater
implements PathRegistryListener,
FileChangeListener,
PropertyChangeListener,
DocumentListener,
AtomicLockListener {
    private static RepositoryUpdater instance;
    private static final Logger LOGGER;
    private static final Logger TEST_LOGGER;
    private static final boolean PERF_TEST;
    private static final boolean noRootsScan;
    private static final boolean notInterruptible;
    private static final int FILE_LOCKS_DELAY;
    private static final String PROP_LAST_INDEXED_VERSION;
    private static final String PROP_LAST_DIRTY_VERSION;
    private static final String PROP_MODIFIED_UNDER_WRITE_LOCK;
    private final Map<URL, List<URL>> scannedRoots2Dependencies = Collections.synchronizedMap(new HashMap());
    private final Set<URL> scannedBinaries = Collections.synchronizedSet(new HashSet());
    private final Set<URL> scannedUnknown = Collections.synchronizedSet(new HashSet());
    private volatile State state = State.CREATED;
    private volatile Task worker;
    private volatile Reference<Document> activeDocumentRef = null;
    private Lookup.Result<? extends IndexingActivityInterceptor> indexingActivityInterceptors = null;
    private IndexingController controller;
    private static final Map<List<StackTraceElement>, Long> lastRecordedStackTraces;
    private static long stackTraceId;
    private static final Comparator<URL> C;

    public static synchronized RepositoryUpdater getDefault() {
        if (instance == null) {
            instance = new RepositoryUpdater();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(boolean bl) {
        InitialRootsWork initialRootsWork = null;
        RepositoryUpdater repositoryUpdater = this;
        synchronized (repositoryUpdater) {
            if (this.state == State.CREATED) {
                this.state = State.STARTED;
                LOGGER.fine("Initializing...");
                this.indexingActivityInterceptors = Lookup.getDefault().lookupResult(IndexingActivityInterceptor.class);
                PathRegistry.getDefault().addPathRegistryListener(this);
                FileUtil.addFileChangeListener((FileChangeListener)this);
                EditorRegistry.addPropertyChangeListener((PropertyChangeListener)this);
                if (bl) {
                    initialRootsWork = new InitialRootsWork(this.scannedRoots2Dependencies, this.scannedBinaries, false);
                }
            }
        }
        if (initialRootsWork != null) {
            this.scheduleWork(initialRootsWork, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        boolean bl = false;
        RepositoryUpdater repositoryUpdater = this;
        synchronized (repositoryUpdater) {
            if (this.state != State.STOPPED) {
                this.state = State.STOPPED;
                LOGGER.fine("Closing...");
                PathRegistry.getDefault().removePathRegistryListener(this);
                FileUtil.removeFileChangeListener((FileChangeListener)this);
                EditorRegistry.removePropertyChangeListener((PropertyChangeListener)this);
                bl = true;
            }
        }
        if (bl) {
            this.getWorker().cancelAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isScanInProgress() {
        boolean bl;
        RepositoryUpdater repositoryUpdater = this;
        synchronized (repositoryUpdater) {
            bl = this.state == State.CREATED || this.state == State.STARTED;
        }
        return bl || this.getWorker().isWorking() || !PathRegistry.getDefault().isFinished();
    }

    public boolean waitUntilFinished(long l) throws InterruptedException {
        long l2;
        long l3 = l2 = System.currentTimeMillis();
        do {
            boolean bl = !this.getWorker().waitUntilFinished(l);
            l3 = System.currentTimeMillis();
            if (!bl) continue;
            return false;
        } while (this.isScanInProgress() && (l <= 0L || l3 - l2 < l));
        return l <= 0L || l3 - l2 < l;
    }

    public void addIndexingJob(URL uRL, Collection<? extends URL> collection, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        FileObject fileObject;
        assert (uRL != null);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("addIndexingJob: rootUrl=" + uRL + ", fileUrls=" + collection + ", followUpJob=" + bl + ", checkEditor=" + bl2 + ", wait=" + bl3);
        }
        if ((fileObject = URLMapper.findFileObject((URL)uRL)) == null) {
            LOGGER.info(uRL + " can't be translated to FileObject");
            return;
        }
        FileListWork fileListWork = null;
        if (collection != null && collection.size() > 0) {
            HashSet<FileObject> hashSet = new HashSet<FileObject>();
            for (URL uRL2 : collection) {
                FileObject fileObject2 = URLMapper.findFileObject((URL)uRL2);
                if (fileObject2 == null) continue;
                if (FileUtil.isParentOf((FileObject)fileObject, (FileObject)fileObject2)) {
                    hashSet.add(fileObject2);
                    continue;
                }
                if (!LOGGER.isLoggable(Level.WARNING)) continue;
                LOGGER.warning(fileObject2 + " does not lie under " + fileObject + ", not indexing it");
            }
            if (hashSet.size() > 0) {
                fileListWork = new FileListWork(uRL, hashSet, bl, bl2, bl4);
            }
        } else {
            fileListWork = new FileListWork(uRL, bl, bl2, bl4);
        }
        if (fileListWork != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Scheduling index refreshing: root=" + uRL + ", files=" + collection);
            }
            this.scheduleWork(fileListWork, bl3);
        }
    }

    public void addIndexingJob(String string) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("addIndexingJob: indexerName=" + string);
        }
        Object object = null;
        HashSet<String> hashSet = new HashSet<String>();
        for (String string2 : Util.getAllMimeTypes()) {
            Collection collection = MimeLookup.getLookup((String)string2).lookupAll(CustomIndexerFactory.class);
            for (CustomIndexerFactory customIndexerFactory : collection) {
                if (!customIndexerFactory.getIndexerName().equals(string)) continue;
                if (object != null && object.getClass() != customIndexerFactory.getClass()) {
                    LOGGER.warning("Different CustomIndexerFactory implementations using the same name: " + object.getClass().getName() + ", " + customIndexerFactory.getClass().getName());
                    continue;
                }
                object = customIndexerFactory;
                hashSet.add(string2);
            }
        }
        if (object == null) {
            throw new InvalidParameterException("No CustomIndexerFactory with name: '" + string + "'");
        }
        if (((Object)hashSet).equals(Util.getAllMimeTypes())) {
            hashSet = null;
        }
        RefreshIndices refreshIndices = new RefreshIndices((Set<String>)hashSet, (CustomIndexerFactory)object, this.scannedRoots2Dependencies);
        this.scheduleWork(refreshIndices, false);
    }

    public void refreshAll() {
        this.scheduleWork(new RootsWork(this.scannedRoots2Dependencies, this.scannedBinaries, false), false);
    }

    public synchronized IndexingController getController() {
        if (this.controller == null) {
            this.controller = new Controller();
        }
        return this.controller;
    }

    @Override
    public void pathsChanged(PathRegistryEvent pathRegistryEvent) {
        assert (pathRegistryEvent != null);
        if (LOGGER.isLoggable(Level.FINE)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Paths changed:\n");
            for (PathRegistryEvent.Change object : pathRegistryEvent.getChanges()) {
                stringBuilder.append(" event=").append((Object)object.getEventKind());
                stringBuilder.append(" pathKind=").append((Object)object.getPathKind());
                stringBuilder.append(" pathType=").append(object.getPathType());
                stringBuilder.append(" affected paths:\n");
                Set<? extends ClassPath> set = object.getAffectedPaths();
                if (set != null) {
                    for (ClassPath classPath : set) {
                        stringBuilder.append("  \"");
                        stringBuilder.append(classPath.toString(ClassPath.PathConversionMode.PRINT));
                        stringBuilder.append("\"\n");
                    }
                }
                stringBuilder.append("--\n");
            }
            stringBuilder.append("====\n");
            LOGGER.fine(stringBuilder.toString());
        }
        boolean bl = false;
        boolean bl2 = false;
        for (PathRegistryEvent.Change change : pathRegistryEvent.getChanges()) {
            if (change.getPathKind() == PathKind.UNKNOWN_SOURCE) continue;
            bl2 = true;
            if (change.getEventKind() != EventKind.PATHS_CHANGED && change.getEventKind() != EventKind.INCLUDES_CHANGED) continue;
            bl = true;
            break;
        }
        if (bl2) {
            this.scheduleWork(new RootsWork(this.scannedRoots2Dependencies, this.scannedBinaries, !bl), false);
        }
    }

    public void fileFolderCreated(FileEvent fileEvent) {
        if (!this.authorize(fileEvent)) {
            return;
        }
        boolean bl = false;
        FileObject fileObject = fileEvent.getFile();
        URL uRL = null;
        if (fileObject != null && fileObject.isValid() && VisibilityQuery.getDefault().isVisible(fileObject)) {
            uRL = this.getOwningSourceRoot(fileObject);
            if (uRL != null) {
                this.scheduleWork(new FileListWork(uRL, Collections.singleton(fileObject), false, false, true), false);
                bl = true;
            } else {
                uRL = this.getOwningBinaryRoot(fileObject);
                if (uRL != null) {
                    this.scheduleWork(new BinaryWork(uRL), false);
                    bl = true;
                }
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Folder created (" + (bl ? "processed" : "ignored") + "): " + FileUtil.getFileDisplayName((FileObject)fileObject) + " Owner: " + uRL);
        }
    }

    public void fileDataCreated(FileEvent fileEvent) {
        this.fileChanged(fileEvent);
    }

    public void fileChanged(FileEvent fileEvent) {
        if (!this.authorize(fileEvent)) {
            return;
        }
        boolean bl = false;
        FileObject fileObject = fileEvent.getFile();
        URL uRL = null;
        if (fileObject != null && fileObject.isValid() && VisibilityQuery.getDefault().isVisible(fileObject)) {
            uRL = this.getOwningSourceRoot(fileObject);
            if (uRL != null) {
                this.scheduleWork(new FileListWork(uRL, Collections.singleton(fileObject), false, false, true), false);
                bl = true;
            } else {
                uRL = this.getOwningBinaryRoot(fileObject);
                if (uRL != null) {
                    this.scheduleWork(new BinaryWork(uRL), false);
                    bl = true;
                }
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("File modified (" + (bl ? "processed" : "ignored") + "): " + FileUtil.getFileDisplayName((FileObject)fileObject) + " Owner: " + uRL);
        }
    }

    public void fileDeleted(FileEvent fileEvent) {
        if (!this.authorize(fileEvent)) {
            return;
        }
        boolean bl = false;
        FileObject fileObject = fileEvent.getFile();
        URL uRL = null;
        if (fileObject != null && VisibilityQuery.getDefault().isVisible(fileObject)) {
            uRL = this.getOwningSourceRoot(fileObject);
            if (uRL != null) {
                if (fileObject.isData()) {
                    String string = FileUtil.getRelativePath((FileObject)URLMapper.findFileObject((URL)uRL), (FileObject)fileObject);
                    assert (string != null) : "FileObject not under root: f=" + fileObject + ", root=" + uRL;
                    this.scheduleWork(new DeleteWork(uRL, Collections.singleton(string)), false);
                    bl = true;
                }
            } else {
                uRL = this.getOwningBinaryRoot(fileObject);
                if (uRL != null) {
                    this.scheduleWork(new BinaryWork(uRL), false);
                    bl = true;
                }
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("File deleted (" + (bl ? "processed" : "ignored") + "): " + FileUtil.getFileDisplayName((FileObject)fileObject) + " Owner: " + uRL);
        }
    }

    public void fileRenamed(FileRenameEvent fileRenameEvent) {
        if (!this.authorize((FileEvent)fileRenameEvent)) {
            return;
        }
        final FileObject fileObject = fileRenameEvent.getFile();
        String string = fileRenameEvent.getExt().length() == 0 ? fileRenameEvent.getName() : fileRenameEvent.getName() + "." + fileRenameEvent.getExt();
        final URL uRL = this.getOwningSourceRoot(fileObject);
        boolean bl = false;
        if (uRL != null) {
            FileObject fileObject2 = URLMapper.findFileObject((URL)uRL);
            String string2 = FileUtil.getRelativePath((FileObject)fileObject2, (FileObject)fileObject.getParent()) + "/" + string;
            if (fileObject.isData()) {
                this.scheduleWork(new DeleteWork(uRL, Collections.singleton(string2)), false);
            } else {
                HashSet<String> hashSet = new HashSet<String>();
                RepositoryUpdater.collectFilePaths(fileObject, string2, hashSet);
                this.scheduleWork(new DeleteWork(uRL, hashSet), false);
            }
            if (VisibilityQuery.getDefault().isVisible(fileObject) && fileObject.isData()) {
                RequestProcessor.getDefault().create(new Runnable(){

                    public void run() {
                        RepositoryUpdater.this.scheduleWork(new FileListWork(uRL, Collections.singleton(fileObject), false, false, true), false);
                    }
                }).schedule(FILE_LOCKS_DELAY);
            }
            bl = true;
        } else {
            URL uRL2 = this.getOwningBinaryRoot(fileObject);
            if (uRL2 != null) {
                File file = FileUtil.toFile((FileObject)fileObject.getParent());
                if (file != null) {
                    try {
                        URL uRL3 = new File(file, string).toURI().toURL();
                        this.scheduleWork(new BinaryWork(uRL3), false);
                    }
                    catch (MalformedURLException malformedURLException) {
                        LOGGER.log(Level.WARNING, null, malformedURLException);
                    }
                }
                this.scheduleWork(new BinaryWork(uRL2), false);
                bl = true;
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("File renamed (" + (bl ? "processed" : "ignored") + "): " + FileUtil.getFileDisplayName((FileObject)fileObject) + " Owner: " + uRL + " Original Name: " + string);
        }
    }

    public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Serializable serializable;
        assert (SwingUtilities.isEventDispatchThread()) : "Changes in focused editor component should be delivered on AWT";
        List<Serializable> list = Collections.emptyList();
        if (propertyChangeEvent.getPropertyName() == null) {
            list = EditorRegistry.componentList();
        } else if (propertyChangeEvent.getPropertyName().equals("focusLost") || propertyChangeEvent.getPropertyName().equals("lastFocusedRemoved")) {
            if (propertyChangeEvent.getOldValue() instanceof JTextComponent) {
                serializable = (JTextComponent)propertyChangeEvent.getOldValue();
                list = Collections.singletonList(serializable);
                this.handleActiveDocumentChange(((JTextComponent)serializable).getDocument(), null);
            }
        } else if (propertyChangeEvent.getPropertyName().equals("focusGained")) {
            if (propertyChangeEvent.getNewValue() instanceof JTextComponent) {
                serializable = (JTextComponent)propertyChangeEvent.getNewValue();
                this.handleActiveDocumentChange(null, ((JTextComponent)serializable).getDocument());
            }
        } else if (propertyChangeEvent.getPropertyName().equals("focusedDocument")) {
            serializable = EditorRegistry.focusedComponent();
            if (serializable == null) {
                serializable = EditorRegistry.lastFocusedComponent();
            }
            if (serializable != null) {
                list = Collections.singletonList(serializable);
            }
            this.handleActiveDocumentChange((Document)propertyChangeEvent.getOldValue(), (Document)propertyChangeEvent.getNewValue());
        }
        serializable = new HashMap();
        if (list.size() > 0) {
            for (JTextComponent object : list) {
                Object object2;
                URL uRL;
                Document document = object.getDocument();
                FileObject fileObject = NbEditorUtilities.getFileObject((Document)document);
                if (fileObject == null || (uRL = this.getOwningSourceRoot(fileObject)) == null) continue;
                long l = DocumentUtilities.getDocumentVersion((Document)document);
                Long l2 = (Long)document.getProperty(PROP_LAST_INDEXED_VERSION);
                boolean bl = false;
                if (object.isShowing()) {
                    bl = l2 == null ? (object2 = (Long)document.getProperty(PROP_LAST_DIRTY_VERSION)) != null : l2 < l;
                } else {
                    object2 = (Long)document.getProperty(PROP_LAST_DIRTY_VERSION);
                    boolean bl2 = bl = l2 != null || object2 != null;
                }
                if (!bl) continue;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Document modified (reindexing): " + FileUtil.getFileDisplayName((FileObject)fileObject) + " Owner: " + uRL);
                }
                if ((object2 = (FileListWork)serializable.get(uRL)) == null) {
                    object2 = new FileListWork(uRL, Collections.singleton(fileObject), false, object.isShowing(), true);
                    serializable.put(uRL, object2);
                    continue;
                }
                ((FileListWork)object2).addFile(fileObject);
            }
        }
        if (serializable.isEmpty()) {
            this.scheduleWork(null, false);
        } else {
            for (FileListWork fileListWork : serializable.values()) {
                this.scheduleWork(fileListWork, false);
            }
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.removeUpdate(documentEvent);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        Document document = documentEvent.getDocument();
        if (document instanceof BaseDocument) {
            document.putProperty(PROP_MODIFIED_UNDER_WRITE_LOCK, true);
        } else {
            this.handleDocumentModification(document);
        }
    }

    public void atomicLock(AtomicLockEvent atomicLockEvent) {
        Document document = (Document)atomicLockEvent.getSource();
        document.putProperty(PROP_MODIFIED_UNDER_WRITE_LOCK, null);
    }

    public void atomicUnlock(AtomicLockEvent atomicLockEvent) {
        Document document = (Document)atomicLockEvent.getSource();
        Boolean bl = (Boolean)document.getProperty(PROP_MODIFIED_UNDER_WRITE_LOCK);
        document.putProperty(PROP_MODIFIED_UNDER_WRITE_LOCK, null);
        if (bl != null && bl.booleanValue()) {
            this.handleDocumentModification(document);
        }
    }

    private RepositoryUpdater() {
    }

    private void handleActiveDocumentChange(Document document, Document document2) {
        Document document3;
        Document document4 = document3 = this.activeDocumentRef == null ? null : this.activeDocumentRef.get();
        if (document != null && document == document3) {
            if (document3 instanceof BaseDocument) {
                ((BaseDocument)document3).removeAtomicLockListener((AtomicLockListener)this);
            }
            document3.removeDocumentListener(this);
            this.activeDocumentRef = null;
            LOGGER.log(Level.FINE, "Unregistering active document listener: activeDocument={0}", document3);
        }
        if (document2 != null && document2 != document3) {
            if (document3 != null) {
                if (document3 instanceof BaseDocument) {
                    ((BaseDocument)document3).removeAtomicLockListener((AtomicLockListener)this);
                }
                document3.removeDocumentListener(this);
                LOGGER.log(Level.FINE, "Unregistering active document listener: activeDocument={0}", document3);
            }
            document3 = document2;
            this.activeDocumentRef = new WeakReference<Document>(document3);
            if (document3 instanceof BaseDocument) {
                ((BaseDocument)document3).addAtomicLockListener((AtomicLockListener)this);
            }
            document3.addDocumentListener(this);
            LOGGER.log(Level.FINE, "Registering active document listener: activeDocument={0}", document3);
        }
    }

    public void handleDocumentModification(Document document) {
        block10: {
            URL uRL;
            FileObject fileObject;
            block11: {
                Context context;
                Reference<Document> reference = this.activeDocumentRef;
                Document document2 = reference == null ? null : reference.get();
                fileObject = NbEditorUtilities.getFileObject((Document)document);
                if (fileObject == null || (uRL = this.getOwningSourceRoot(fileObject)) == null) break block10;
                if (document2 != document) break block11;
                long l = DocumentUtilities.getDocumentVersion((Document)document2);
                Long l2 = (Long)document2.getProperty(PROP_LAST_DIRTY_VERSION);
                boolean bl = false;
                if (l2 != null && l2 < l) {
                    bl = true;
                }
                document2.putProperty(PROP_LAST_DIRTY_VERSION, l);
                if (!bl) break block10;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Active document modified (marking dirty): " + FileUtil.getFileDisplayName((FileObject)fileObject) + " Owner: " + uRL);
                }
                Set<Indexable> set = Collections.singleton(SPIAccessor.getInstance().create(new FileObjectIndexable(URLMapper.findFileObject((URL)uRL), fileObject)));
                String string = DocumentUtilities.getMimeType((Document)document);
                Collection collection = MimeLookup.getLookup((String)string).lookupAll(CustomIndexerFactory.class);
                Collection collection2 = MimeLookup.getLookup((String)string).lookupAll(EmbeddingIndexerFactory.class);
                for (Object object : collection) {
                    try {
                        context = SPIAccessor.getInstance().createContext(CacheFolder.getDataFolder(uRL), uRL, ((CustomIndexerFactory)object).getIndexerName(), ((CustomIndexerFactory)object).getIndexVersion(), null, false, true, false, null);
                        ((CustomIndexerFactory)object).filesDirty(set, context);
                    }
                    catch (IOException iOException) {
                        LOGGER.log(Level.WARNING, null, iOException);
                    }
                }
                for (Object object : collection2) {
                    try {
                        context = SPIAccessor.getInstance().createContext(CacheFolder.getDataFolder(uRL), uRL, ((EmbeddingIndexerFactory)object).getIndexerName(), ((EmbeddingIndexerFactory)object).getIndexVersion(), null, false, true, false, null);
                        ((EmbeddingIndexerFactory)object).filesDirty(set, context);
                    }
                    catch (IOException iOException) {
                        LOGGER.log(Level.WARNING, null, iOException);
                    }
                }
                break block10;
            }
            try {
                this.addIndexingJob(uRL, Collections.singleton(fileObject.getURL()), false, true, false, true);
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                LOGGER.log(Level.WARNING, null, fileStateInvalidException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scheduleWork(Work work, boolean bl) {
        RepositoryUpdater.recordCaller();
        boolean bl2 = false;
        RepositoryUpdater repositoryUpdater = this;
        synchronized (repositoryUpdater) {
            if (this.state == State.STARTED) {
                this.state = State.INITIAL_SCAN_RUNNING;
                bl2 = !(work instanceof InitialRootsWork);
            }
        }
        if (bl2) {
            this.getWorker().schedule(new InitialRootsWork(this.scannedRoots2Dependencies, this.scannedBinaries, true), false);
            if (work instanceof RootsWork) {
                return;
            }
        }
        if (work != null) {
            this.getWorker().schedule(work, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Task getWorker() {
        Task task = this.worker;
        if (task == null) {
            RepositoryUpdater repositoryUpdater = this;
            synchronized (repositoryUpdater) {
                if (this.worker == null) {
                    this.worker = new Task();
                }
                task = this.worker;
            }
        }
        return task;
    }

    private URL getOwningSourceRoot(FileObject fileObject) {
        if (fileObject == null) {
            return null;
        }
        ArrayList<URL> arrayList = new ArrayList<URL>(this.scannedRoots2Dependencies.keySet());
        for (URL uRL : arrayList) {
            FileObject fileObject2 = URLMapper.findFileObject((URL)uRL);
            if (fileObject2 == null || !FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject)) continue;
            return uRL;
        }
        return null;
    }

    private URL getOwningBinaryRoot(FileObject fileObject) {
        String string;
        if (fileObject == null) {
            return null;
        }
        try {
            string = fileObject.getURL().getPath();
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            LOGGER.log(Level.WARNING, null, fileStateInvalidException);
            return null;
        }
        ArrayList<URL> arrayList = new ArrayList<URL>(this.scannedBinaries);
        for (URL uRL : arrayList) {
            String string2;
            URL uRL2 = FileUtil.getArchiveFile((URL)uRL);
            boolean bl = true;
            if (uRL2 == null) {
                uRL2 = uRL;
                bl = false;
            }
            if ((string2 = uRL2.getPath()).equals(string)) {
                return uRL;
            }
            if (bl || !string.startsWith(string2)) continue;
            return uRL;
        }
        return null;
    }

    private boolean authorize(FileEvent fileEvent) {
        Collection collection = this.indexingActivityInterceptors.allInstances();
        for (IndexingActivityInterceptor indexingActivityInterceptor : collection) {
            if (indexingActivityInterceptor.authorizeFileSystemEvent(fileEvent) != IndexingActivityInterceptor.Authorization.IGNORE) continue;
            return false;
        }
        return true;
    }

    private static void collectFilePaths(FileObject fileObject, String string, Set<String> set) {
        assert (fileObject.isFolder()) : "Expecting folder: " + fileObject;
        if (fileObject.isValid()) {
            for (FileObject fileObject2 : fileObject.getChildren()) {
                if (!fileObject2.isValid()) continue;
                String string2 = string + "/" + fileObject2.getNameExt();
                if (fileObject2.isData()) {
                    set.add(string2);
                    continue;
                }
                RepositoryUpdater.collectFilePaths(fileObject2, string2, set);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void recordCaller() {
        if (!LOGGER.isLoggable(Level.FINE)) {
            return;
        }
        Map<List<StackTraceElement>, Long> map = lastRecordedStackTraces;
        synchronized (map) {
            StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
            ArrayList<StackTraceElement> arrayList = new ArrayList<StackTraceElement>(stackTraceElementArray.length);
            for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                arrayList.add(stackTraceElement);
            }
            Long l = lastRecordedStackTraces.get(arrayList);
            if (l == null) {
                Long l2 = stackTraceId++;
                lastRecordedStackTraces.put(arrayList, l2);
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("RepositoryUpdater caller [id=").append(l2).append("] :\n");
                for (StackTraceElement stackTraceElement : arrayList) {
                    stringBuilder.append(stackTraceElement.toString());
                    stringBuilder.append("\n");
                }
                LOGGER.fine(stringBuilder.toString());
            } else {
                StackTraceElement stackTraceElement = Util.findCaller(stackTraceElementArray, new Object[0]);
                LOGGER.fine("RepositoryUpdater caller [refid=" + l + "]: " + stackTraceElement);
            }
        }
    }

    private static void printMap(Map<URL, List<URL>> map, Level level) {
        TreeSet<URL> treeSet = new TreeSet<URL>(C);
        treeSet.addAll(map.keySet());
        for (URL uRL : treeSet) {
            LOGGER.log(level, "  {0}:\n", uRL);
        }
    }

    private static StringBuilder printMap(Map<URL, List<URL>> map, StringBuilder stringBuilder) {
        TreeSet<URL> treeSet = new TreeSet<URL>(C);
        treeSet.addAll(map.keySet());
        for (URL uRL : treeSet) {
            stringBuilder.append("  ").append(uRL).append(":\n");
        }
        return stringBuilder;
    }

    private static void printCollection(Collection<? extends URL> collection, Level level) {
        TreeSet<URL> treeSet = new TreeSet<URL>(C);
        treeSet.addAll(collection);
        for (URL uRL : treeSet) {
            LOGGER.log(level, "  {0}\n", uRL);
        }
    }

    private static StringBuilder printCollection(Collection<? extends URL> collection, StringBuilder stringBuilder) {
        TreeSet<URL> treeSet = new TreeSet<URL>(C);
        treeSet.addAll(collection);
        for (URL uRL : treeSet) {
            stringBuilder.append("  ").append(uRL).append("\n");
        }
        return stringBuilder;
    }

    State getState() {
        return this.state;
    }

    Set<URL> getScannedBinaries() {
        return this.scannedBinaries;
    }

    Set<URL> getScannedSources() {
        return this.scannedRoots2Dependencies.keySet();
    }

    Set<URL> getScannedUnknowns() {
        return this.scannedUnknown;
    }

    static {
        LOGGER = Logger.getLogger(RepositoryUpdater.class.getName());
        TEST_LOGGER = Logger.getLogger(RepositoryUpdater.class.getName() + ".tests");
        PERF_TEST = Boolean.getBoolean("perf.refactoring.test");
        noRootsScan = Boolean.getBoolean("netbeans.indexing.noRootsScan");
        notInterruptible = Boolean.getBoolean("netbeans.indexing.notInterruptible");
        FILE_LOCKS_DELAY = org.openide.util.Utilities.isWindows() ? 2000 : 1000;
        PROP_LAST_INDEXED_VERSION = RepositoryUpdater.class.getName() + "-last-indexed-document-version";
        PROP_LAST_DIRTY_VERSION = RepositoryUpdater.class.getName() + "-last-dirty-document-version";
        PROP_MODIFIED_UNDER_WRITE_LOCK = RepositoryUpdater.class.getName() + "-modified-under-write-lock";
        lastRecordedStackTraces = new HashMap<List<StackTraceElement>, Long>();
        stackTraceId = 0L;
        C = new Comparator<URL>(){

            @Override
            public int compare(URL uRL, URL uRL2) {
                return uRL.toString().compareTo(uRL2.toString());
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Controller
    extends IndexingController {
        public Controller() {
            RepositoryUpdater.this.start(false);
        }

        @Override
        public void enterProtectedMode() {
            RepositoryUpdater.this.getWorker().enterProtectedMode();
        }

        @Override
        public void exitProtectedMode(Runnable runnable) {
            RepositoryUpdater.this.getWorker().exitProtectedMode(runnable);
        }

        @Override
        public boolean isInProtectedMode() {
            return RepositoryUpdater.this.getWorker().isInProtectedMode();
        }

        @Override
        public Map<URL, List<URL>> getRootDependencies() {
            return new HashMap<URL, List<URL>>(RepositoryUpdater.this.scannedRoots2Dependencies);
        }

        @Override
        public int getFileLocksDelay() {
            return FILE_LOCKS_DELAY;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DependenciesContext {
        private final Map<URL, List<URL>> initialRoots2Deps;
        private final Set<URL> initialBinaries;
        private final Set<URL> oldRoots;
        private final Set<URL> oldBinaries;
        private final Map<URL, List<URL>> newRoots2Deps;
        private final List<URL> newRootsToScan;
        private final Set<URL> newBinariesToScan;
        private final Set<URL> scannedRoots;
        private final Set<URL> scannedBinaries;
        private final Stack<URL> cycleDetector;
        private final boolean useInitialState;

        public DependenciesContext(Map<URL, List<URL>> map, Set<URL> set, boolean bl) {
            assert (map != null);
            assert (set != null);
            this.initialRoots2Deps = Collections.unmodifiableMap(map);
            this.initialBinaries = Collections.unmodifiableSet(set);
            this.oldRoots = new HashSet<URL>(map.keySet());
            this.oldBinaries = new HashSet<URL>(set);
            this.newRoots2Deps = new HashMap<URL, List<URL>>();
            this.newRootsToScan = new ArrayList<URL>();
            this.newBinariesToScan = new HashSet<URL>();
            this.scannedRoots = new HashSet<URL>();
            this.scannedBinaries = new HashSet<URL>();
            this.useInitialState = bl;
            this.cycleDetector = new Stack();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(super.toString());
            stringBuilder.append(": {\n");
            stringBuilder.append("  useInitialState=" + this.useInitialState).append("\n");
            stringBuilder.append("  initialRoots2Deps(").append(this.initialRoots2Deps.size()).append(")=\n");
            RepositoryUpdater.printMap((Map<URL, List<URL>>)this.initialRoots2Deps, stringBuilder);
            stringBuilder.append("  initialBinaries(").append(this.initialBinaries.size()).append(")=\n");
            RepositoryUpdater.printCollection((Collection<? extends URL>)this.initialBinaries, stringBuilder);
            stringBuilder.append("  oldRoots(").append(this.oldRoots.size()).append(")=\n");
            RepositoryUpdater.printCollection((Collection<? extends URL>)this.oldRoots, stringBuilder);
            stringBuilder.append("  oldBinaries(").append(this.oldBinaries.size()).append(")=\n");
            RepositoryUpdater.printCollection((Collection<? extends URL>)this.oldBinaries, stringBuilder);
            stringBuilder.append("  newRootsToScan(").append(this.newRootsToScan.size()).append(")=\n");
            RepositoryUpdater.printCollection((Collection<? extends URL>)this.newRootsToScan, stringBuilder);
            stringBuilder.append("  newBinariesToScan(").append(this.newBinariesToScan.size()).append(")=\n");
            RepositoryUpdater.printCollection((Collection<? extends URL>)this.newBinariesToScan, stringBuilder);
            stringBuilder.append("  scannedRoots(").append(this.scannedRoots.size()).append(")=\n");
            RepositoryUpdater.printCollection((Collection<? extends URL>)this.scannedRoots, stringBuilder);
            stringBuilder.append("  scannedBinaries(").append(this.scannedBinaries.size()).append(")=\n");
            RepositoryUpdater.printCollection((Collection<? extends URL>)this.scannedBinaries, stringBuilder);
            stringBuilder.append("} ----\n");
            return stringBuilder.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Task
    extends ParserResultTask {
        private final List<Work> todo = new LinkedList<Work>();
        private Work workInProgress = null;
        private Work cancelledWork = null;
        private boolean scheduled = false;
        private boolean allCancelled = false;
        private boolean cancelled = false;
        private int protectedMode = 0;
        private List<Runnable> followupTasks = null;

        private Task() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void schedule(Work work, boolean bl) {
            boolean bl2 = false;
            boolean bl3 = false;
            List<Work> list = this.todo;
            synchronized (list) {
                assert (work != null);
                if (!this.allCancelled) {
                    if (bl && Utilities.holdsParserLock()) {
                        if (this.protectedMode == 0) {
                            bl2 = true;
                        } else {
                            throw new IllegalStateException("Won't enforce " + work + " when in protected mode");
                        }
                    }
                    if (!bl2) {
                        if (this.workInProgress != null) {
                            this.workInProgress.cancelBy(work);
                        }
                        boolean bl4 = false;
                        if (!bl) {
                            for (Work work2 : this.todo) {
                                if (!work2.absorb(work)) continue;
                                bl4 = true;
                                break;
                            }
                        }
                        if (!bl4) {
                            LOGGER.log(Level.FINE, "Scheduling {0}", work);
                            this.todo.add(work);
                        } else {
                            LOGGER.log(Level.FINE, "Work absorbed {0}", work);
                        }
                        if (!this.scheduled && this.protectedMode == 0) {
                            this.scheduled = true;
                            Utilities.scheduleSpecialTask(this);
                        }
                        bl3 = bl;
                    }
                }
            }
            if (bl2) {
                LOGGER.log(Level.FINE, "Enforcing {0}", work);
                work.doTheWork();
            } else if (bl3) {
                LOGGER.log(Level.FINE, "Waiting for {0}", work);
                work.waitUntilDone();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancelAll() {
            List<Work> list = this.todo;
            synchronized (list) {
                if (!this.allCancelled) {
                    this.allCancelled = true;
                    this.todo.clear();
                    Work work = this.workInProgress;
                    if (work != null) {
                        work.setCancelled(true);
                    }
                    while (this.scheduled) {
                        try {
                            this.todo.wait(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                            break;
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isWorking() {
            List<Work> list = this.todo;
            synchronized (list) {
                return this.scheduled || this.protectedMode > 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void enterProtectedMode() {
            List<Work> list = this.todo;
            synchronized (list) {
                ++this.protectedMode;
                LOGGER.log(Level.FINE, "Entering protected mode: {0}", this.protectedMode);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void exitProtectedMode(Runnable runnable) {
            List<Work> list = this.todo;
            synchronized (list) {
                if (this.protectedMode <= 0) {
                    throw new IllegalStateException("Calling exitProtectedMode without enterProtectedMode");
                }
                if (runnable != null) {
                    if (this.followupTasks == null) {
                        this.followupTasks = new LinkedList<Runnable>();
                    }
                    this.followupTasks.add(runnable);
                }
                --this.protectedMode;
                LOGGER.log(Level.FINE, "Exiting protected mode: {0}", this.protectedMode);
                if (this.protectedMode == 0) {
                    final List<Runnable> list2 = this.followupTasks;
                    RequestProcessor.getDefault().create(new Runnable(){

                        public void run() {
                            Task.this.schedule(new Work(false, false, false){

                                protected boolean getDone() {
                                    if (list2 != null) {
                                        for (Runnable runnable : list2) {
                                            try {
                                                runnable.run();
                                            }
                                            catch (ThreadDeath threadDeath) {
                                                throw threadDeath;
                                            }
                                            catch (Throwable throwable) {
                                                LOGGER.log(Level.WARNING, null, throwable);
                                            }
                                        }
                                    }
                                    return true;
                                }
                            }, false);
                        }
                    }).schedule(FILE_LOCKS_DELAY);
                    LOGGER.log(Level.FINE, "Protected mode exited, scheduling postprocess tasks: {0}", list2);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isInProtectedMode() {
            List<Work> list = this.todo;
            synchronized (list) {
                return this.protectedMode > 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean waitUntilFinished(long l) throws InterruptedException {
            if (Utilities.holdsParserLock()) {
                throw new IllegalStateException("Can't wait for indexing to finish from inside a running parser task");
            }
            List<Work> list = this.todo;
            synchronized (list) {
                while (this.scheduled) {
                    if (l > 0L) {
                        this.todo.wait(l);
                        return !this.scheduled;
                    }
                    this.todo.wait();
                }
            }
            return true;
        }

        @Override
        public int getPriority() {
            return 0;
        }

        @Override
        public Class<? extends Scheduler> getSchedulerClass() {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancel() {
            RepositoryUpdater.recordCaller();
            if (notInterruptible) {
                return;
            }
            List<Work> list = this.todo;
            synchronized (list) {
                if (!this.cancelled) {
                    this.cancelled = true;
                    this.cancelledWork = this.workInProgress;
                    if (this.cancelledWork != null) {
                        this.cancelledWork.setCancelled(true);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(Parser.Result result, SchedulerEvent schedulerEvent) {
            List<Work> list;
            List<Work> list2 = this.todo;
            synchronized (list2) {
                this.cancelled = false;
                this.cancelledWork = null;
            }
            try {
                this._run();
                Object var6_5 = null;
                list = this.todo;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                List<Work> list3 = this.todo;
                synchronized (list3) {
                    if (this.cancelledWork != null && !this.cancelledWork.isFinished()) {
                        if (!this.allCancelled) {
                            this.cancelledWork.setCancelled(false);
                            this.todo.add(0, this.cancelledWork);
                        }
                        this.cancelledWork = null;
                    }
                    if (this.todo.isEmpty()) {
                        this.scheduled = false;
                    } else {
                        Utilities.scheduleSpecialTask(this);
                    }
                    this.todo.notifyAll();
                }
                throw throwable;
            }
            synchronized (list) {
                if (this.cancelledWork != null && !this.cancelledWork.isFinished()) {
                    if (!this.allCancelled) {
                        this.cancelledWork.setCancelled(false);
                        this.todo.add(0, this.cancelledWork);
                    }
                    this.cancelledWork = null;
                }
                if (this.todo.isEmpty()) {
                    this.scheduled = false;
                } else {
                    Utilities.scheduleSpecialTask(this);
                }
                this.todo.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void _run() {
            ProgressHandle progressHandle = null;
            try {
                Work work = this.getWork();
                while (work != null) {
                    Object var5_5;
                    if (progressHandle == null && work.supportsProgress()) {
                        progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(RepositoryUpdater.class, (String)"MSG_BackgroundCompileStart"));
                        progressHandle.start();
                    }
                    work.setProgressHandle(progressHandle);
                    try {
                        try {
                            work.doTheWork();
                        }
                        catch (ThreadDeath threadDeath) {
                            throw threadDeath;
                        }
                        catch (Throwable throwable) {
                            LOGGER.log(Level.WARNING, null, throwable);
                            var5_5 = null;
                            work.setProgressHandle(null);
                        }
                        var5_5 = null;
                        work.setProgressHandle(null);
                    }
                    catch (Throwable throwable) {
                        var5_5 = null;
                        work.setProgressHandle(null);
                        throw throwable;
                    }
                    work = this.getWork();
                }
                Object var7_7 = null;
                if (progressHandle == null) return;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (progressHandle == null) throw throwable;
                progressHandle.finish();
                progressHandle = null;
                throw throwable;
            }
            progressHandle.finish();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Work getWork() {
            List<Work> list = this.todo;
            synchronized (list) {
                Work work = !this.cancelled && this.protectedMode == 0 && this.todo.size() > 0 ? this.todo.remove(0) : null;
                this.workInProgress = work;
                return work;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class InitialRootsWork
    extends RootsWork {
        private final boolean waitForProjects;

        public InitialRootsWork(Map<URL, List<URL>> map, Set<URL> set, boolean bl) {
            super(map, set, true);
            this.waitForProjects = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean getDone() {
            boolean bl;
            try {
                if (this.waitForProjects) {
                    try {
                        OpenProjects.getDefault().openProjects().get();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                bl = super.getDone();
                Object var3_3 = null;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                if (RepositoryUpdater.this.state == State.INITIAL_SCAN_RUNNING) {
                    RepositoryUpdater repositoryUpdater = RepositoryUpdater.this;
                    synchronized (repositoryUpdater) {
                        if (RepositoryUpdater.this.state == State.INITIAL_SCAN_RUNNING) {
                            RepositoryUpdater.this.state = State.ACTIVE;
                        }
                    }
                }
                throw throwable;
            }
            if (RepositoryUpdater.this.state == State.INITIAL_SCAN_RUNNING) {
                RepositoryUpdater repositoryUpdater = RepositoryUpdater.this;
                synchronized (repositoryUpdater) {
                    if (RepositoryUpdater.this.state == State.INITIAL_SCAN_RUNNING) {
                        RepositoryUpdater.this.state = State.ACTIVE;
                    }
                }
            }
            return bl;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RootsWork
    extends Work {
        private final Map<URL, List<URL>> scannedRoots2Dependencies;
        private final Set<URL> scannedBinaries;
        private boolean useInitialState;
        private DependenciesContext depCtx;

        public RootsWork(Map<URL, List<URL>> map, Set<URL> set, boolean bl) {
            super(false, false, true);
            this.scannedRoots2Dependencies = map;
            this.scannedBinaries = set;
            this.useInitialState = bl;
        }

        @Override
        public String toString() {
            return super.toString() + ", useInitialState=" + this.useInitialState;
        }

        @Override
        public boolean getDone() {
            boolean bl;
            Object object;
            if (this.isCancelled()) {
                return false;
            }
            this.updateProgress(NbBundle.getMessage(RepositoryUpdater.class, (String)"MSG_ProjectDependencies"));
            long l = System.currentTimeMillis();
            if (this.depCtx == null) {
                this.depCtx = new DependenciesContext(this.scannedRoots2Dependencies, this.scannedBinaries, this.useInitialState);
                LinkedList<URL> linkedList = new LinkedList<URL>();
                object = PathRegistry.getDefault().getSources();
                LOGGER.log(Level.FINE, "PathRegistry.sources=");
                RepositoryUpdater.printCollection((Collection<? extends URL>)object, Level.FINE);
                linkedList.addAll((Collection<URL>)object);
                object = PathRegistry.getDefault().getLibraries();
                LOGGER.log(Level.FINE, "PathRegistry.libraries=");
                RepositoryUpdater.printCollection((Collection<? extends URL>)object, Level.FINE);
                linkedList.addAll((Collection<URL>)object);
                this.depCtx.newBinariesToScan.addAll(PathRegistry.getDefault().getBinaryLibraries());
                Object object2 = this.depCtx.newBinariesToScan.iterator();
                while (object2.hasNext()) {
                    if (!this.depCtx.oldBinaries.remove(object2.next())) continue;
                    object2.remove();
                }
                if (this.useInitialState) {
                    object = PathRegistry.getDefault().getUnknownRoots();
                    LOGGER.log(Level.FINE, "PathRegistry.unknown=");
                    RepositoryUpdater.printCollection((Collection<? extends URL>)object, Level.FINE);
                    linkedList.addAll((Collection<URL>)object);
                }
                for (URL hashMap2 : linkedList) {
                    RootsWork.findDependencies(hashMap2, this.depCtx, null, null);
                }
                try {
                    this.depCtx.newRootsToScan.addAll(org.openide.util.Utilities.topologicalSort(this.depCtx.newRoots2Deps.keySet(), (Map)this.depCtx.newRoots2Deps));
                }
                catch (TopologicalSortException topologicalSortException) {
                    LOGGER.log(Level.INFO, "Cycles detected in classpath roots dependencies, using partial ordering", topologicalSortException);
                    List list = topologicalSortException.partialSort();
                    this.depCtx.newRootsToScan.addAll(list);
                }
                Collections.reverse(this.depCtx.newRootsToScan);
                if (!this.useInitialState) {
                    object2 = new HashMap();
                    HashMap hashMap = new HashMap();
                    RootsWork.diff(this.depCtx.initialRoots2Deps, this.depCtx.newRoots2Deps, hashMap, object2);
                    Level level = Level.FINE;
                    if (LOGGER.isLoggable(level) && (hashMap.size() > 0 || object2.size() > 0)) {
                        LOGGER.log(level, "Changes in dependencies detected:");
                        LOGGER.log(level, "initialRoots2Deps({0})=", this.depCtx.initialRoots2Deps.size());
                        RepositoryUpdater.printMap((Map<URL, List<URL>>)this.depCtx.initialRoots2Deps, level);
                        LOGGER.log(level, "newRoots2Deps({0})=", this.depCtx.newRoots2Deps.size());
                        RepositoryUpdater.printMap((Map<URL, List<URL>>)this.depCtx.newRoots2Deps, level);
                        LOGGER.log(level, "addedOrChanged({0})=", hashMap.size());
                        RepositoryUpdater.printMap((Map<URL, List<URL>>)hashMap, level);
                        LOGGER.log(level, "removed({0})=", object2.size());
                        RepositoryUpdater.printMap((Map<URL, List<URL>>)((Map)object2), level);
                    }
                    this.depCtx.oldRoots.clear();
                    this.depCtx.oldRoots.addAll(object2.keySet());
                    this.depCtx.newRootsToScan.retainAll(hashMap.keySet());
                }
            } else {
                this.depCtx.newRootsToScan.removeAll(this.depCtx.scannedRoots);
                this.depCtx.scannedRoots.clear();
                this.depCtx.newBinariesToScan.removeAll(this.depCtx.scannedBinaries);
                this.depCtx.scannedBinaries.clear();
            }
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, "Resolving dependencies took: {0} ms", System.currentTimeMillis() - l);
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Running " + this + " on \n" + this.depCtx.toString());
            }
            if (bl = this.scanBinaries(this.depCtx)) {
                bl = this.scanSources(this.depCtx);
            }
            for (Object object2 : this.depCtx.scannedRoots) {
                List list = (List)this.depCtx.newRoots2Deps.get(object2);
                this.scannedRoots2Dependencies.put((URL)object2, list);
            }
            this.scannedRoots2Dependencies.keySet().removeAll(this.depCtx.oldRoots);
            this.scannedBinaries.addAll(this.depCtx.scannedBinaries);
            this.scannedBinaries.removeAll(this.depCtx.oldBinaries);
            object = Level.FINE;
            if (LOGGER.isLoggable((Level)object)) {
                LOGGER.log((Level)object, this + " " + (this.isCancelled() ? "cancelled" : "finished") + ": {");
                LOGGER.log((Level)object, "  scannedRoots2Dependencies(" + this.scannedRoots2Dependencies.size() + ")=");
                RepositoryUpdater.printMap((Map<URL, List<URL>>)this.scannedRoots2Dependencies, (Level)object);
                LOGGER.log((Level)object, "  scannedBinaries(" + this.scannedBinaries.size() + ")=");
                RepositoryUpdater.printCollection((Collection<? extends URL>)this.scannedBinaries, (Level)object);
                LOGGER.log((Level)object, "} ====");
            }
            return bl;
        }

        @Override
        protected boolean isCancelledBy(Work work) {
            boolean bl;
            boolean bl2 = bl = work instanceof RootsWork && this.useInitialState;
            if (bl && LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Cancelling " + this + ", because of " + work);
            }
            return bl;
        }

        @Override
        public boolean absorb(Work work) {
            if (work.getClass().equals(RootsWork.class)) {
                if (!((RootsWork)work).useInitialState) {
                    this.useInitialState = ((RootsWork)work).useInitialState;
                    LOGGER.fine("Absorbing " + work + ", updating useInitialState to " + this.useInitialState);
                }
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void findDependencies(URL uRL, DependenciesContext dependenciesContext, Set<String> set, Set<String> iterator) {
            if (dependenciesContext.useInitialState && dependenciesContext.initialRoots2Deps.containsKey(uRL)) {
                dependenciesContext.oldRoots.remove(uRL);
                return;
            }
            if (dependenciesContext.newRoots2Deps.containsKey(uRL)) {
                return;
            }
            FileObject fileObject = URLMapper.findFileObject((URL)uRL);
            if (fileObject == null) {
                return;
            }
            LinkedList<URL> linkedList = new LinkedList<URL>();
            dependenciesContext.cycleDetector.push(uRL);
            try {
                URL uRL2;
                Set<String> set2;
                if (set == null || iterator == null) {
                    Iterator<String> iterator2;
                    set2 = PathRegistry.getDefault().getSourceIdsFor(uRL);
                    if (null != set2 && !set2.isEmpty()) {
                        LOGGER.log(Level.FINER, "Resolving Ids based on sourceIds for {0}: {1}", new Object[]{uRL, set2});
                        iterator2 = new HashSet();
                        HashSet<String> object2 = new HashSet<String>();
                        for (String string : set2) {
                            iterator2.addAll(PathRecognizerRegistry.getDefault().getLibraryIdsForSourceId(string));
                            object2.addAll(PathRecognizerRegistry.getDefault().getBinaryLibraryIdsForSourceId(string));
                        }
                        if (set == null) {
                            set = iterator2;
                        }
                        if (iterator == null) {
                            iterator = object2;
                        }
                    } else {
                        set2 = PathRegistry.getDefault().getLibraryIdsFor(uRL);
                        if (null != set2 && !set2.isEmpty()) {
                            LOGGER.log(Level.FINER, "Resolving Ids based on libraryIds for {0}: {1}", new Object[]{uRL, set2});
                            iterator2 = new HashSet();
                            for (String string : set2) {
                                iterator2.addAll(PathRecognizerRegistry.getDefault().getBinaryLibraryIdsForLibraryId(string));
                            }
                            if (set == null) {
                                set = set2;
                            }
                            if (iterator == null) {
                                iterator = iterator2;
                            }
                        }
                    }
                }
                LOGGER.log(Level.FINER, "LibraryIds for {0}: {1}", new Object[]{uRL, set});
                LOGGER.log(Level.FINER, "BinaryLibraryIds for {0}: {1}", new Object[]{uRL, iterator});
                set2 = set == null ? PathRecognizerRegistry.getDefault().getLibraryIds() : set;
                for (String string : set2) {
                    ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)string);
                    if (classPath == null) continue;
                    for (ClassPath.Entry entry : classPath.entries()) {
                        uRL2 = entry.getURL();
                        if (uRL2.equals(uRL) || dependenciesContext.cycleDetector.contains(uRL2)) continue;
                        linkedList.add(uRL2);
                        RootsWork.findDependencies(uRL2, dependenciesContext, (Set<String>)set, iterator);
                    }
                }
                set2 = iterator == null ? PathRecognizerRegistry.getDefault().getBinaryLibraryIds() : iterator;
                for (String string : set2) {
                    ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)string);
                    if (classPath == null) continue;
                    for (ClassPath.Entry entry : classPath.entries()) {
                        uRL2 = entry.getURL();
                        URL[] uRLArray = PathRegistry.getDefault().sourceForBinaryQuery(uRL2, classPath, false);
                        if (uRLArray != null) {
                            for (URL uRL3 : uRLArray) {
                                if (uRL3.equals(uRL) || dependenciesContext.cycleDetector.contains(uRL3)) continue;
                                linkedList.add(uRL3);
                                RootsWork.findDependencies(uRL3, dependenciesContext, (Set<String>)set, iterator);
                            }
                            continue;
                        }
                        if (dependenciesContext.useInitialState) {
                            if (!dependenciesContext.initialBinaries.contains(uRL2)) {
                                dependenciesContext.newBinariesToScan.add(uRL2);
                            }
                            dependenciesContext.oldBinaries.remove(uRL2);
                        } else {
                            dependenciesContext.newBinariesToScan.add(uRL2);
                            dependenciesContext.oldBinaries.remove(uRL2);
                        }
                        Set<String> set3 = PathRegistry.getDefault().getSourceIdsFor(uRL2);
                        if (set3 == null || set3.isEmpty()) {
                            assert (!uRL2.equals(uRL) && !dependenciesContext.cycleDetector.contains(uRL2)) : "binaryRoot=" + uRL2 + ", rootURL=" + uRL + ", cycleDetector.contains(" + uRL2 + ")=" + DependenciesContext.access$2000(dependenciesContext).contains(uRL2);
                            linkedList.add(uRL2);
                            continue;
                        }
                        LOGGER.log(Level.INFO, "The root {0} is registsred for both {1} and {2}", new Object[]{uRL2, string, set3});
                    }
                }
                Object var19_34 = null;
                dependenciesContext.cycleDetector.pop();
            }
            catch (Throwable throwable) {
                Object var19_35 = null;
                dependenciesContext.cycleDetector.pop();
                throw throwable;
            }
            dependenciesContext.newRoots2Deps.put(uRL, linkedList);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean scanBinaries(DependenciesContext dependenciesContext) {
            assert (dependenciesContext != null);
            long l = 0L;
            long l2 = 0L;
            boolean bl = true;
            for (URL uRL : dependenciesContext.newBinariesToScan) {
                long l3;
                Object var13_9;
                if (this.isCancelled()) {
                    bl = false;
                    break;
                }
                long l4 = System.currentTimeMillis();
                try {
                    try {
                        this.updateProgress(uRL);
                        this.indexBinary(uRL);
                        dependenciesContext.scannedBinaries.add(uRL);
                    }
                    catch (IOException iOException) {
                        LOGGER.log(Level.WARNING, null, iOException);
                        var13_9 = null;
                        l3 = System.currentTimeMillis() - l4;
                        l2 += l3;
                        ++l;
                        if (PERF_TEST) {
                            RootsWork.reportRootScan(uRL, l3);
                        }
                        if (!LOGGER.isLoggable(Level.FINE)) continue;
                        LOGGER.fine(String.format("Indexing of: %s took: %d ms", uRL.toExternalForm(), l3));
                        continue;
                    }
                    var13_9 = null;
                }
                catch (Throwable throwable) {
                    var13_9 = null;
                    l3 = System.currentTimeMillis() - l4;
                    l2 += l3;
                    ++l;
                    if (PERF_TEST) {
                        RootsWork.reportRootScan(uRL, l3);
                    }
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine(String.format("Indexing of: %s took: %d ms", uRL.toExternalForm(), l3));
                    }
                    throw throwable;
                }
                l3 = System.currentTimeMillis() - l4;
                l2 += l3;
                ++l;
                if (PERF_TEST) {
                    RootsWork.reportRootScan(uRL, l3);
                }
                if (!LOGGER.isLoggable(Level.FINE)) continue;
                LOGGER.fine(String.format("Indexing of: %s took: %d ms", uRL.toExternalForm(), l3));
            }
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info(String.format("Complete indexing of %d binary roots took: %d ms", l, l2));
            }
            TEST_LOGGER.log(Level.FINEST, "scanBinary", dependenciesContext.newBinariesToScan);
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean scanSources(DependenciesContext dependenciesContext) {
            assert (dependenciesContext != null);
            long l = 0L;
            long l2 = 0L;
            boolean bl = true;
            for (URL uRL : dependenciesContext.newRootsToScan) {
                long l3;
                Object var13_9;
                long l4;
                block14: {
                    if (this.isCancelled()) {
                        bl = false;
                        break;
                    }
                    l4 = System.currentTimeMillis();
                    try {
                        try {
                            this.updateProgress(uRL);
                            if (this.scanSource(uRL)) {
                                dependenciesContext.scannedRoots.add(uRL);
                                break block14;
                            }
                            bl = false;
                            var13_9 = null;
                        }
                        catch (IOException iOException) {
                            LOGGER.log(Level.WARNING, null, iOException);
                            var13_9 = null;
                            l3 = System.currentTimeMillis() - l4;
                            l2 += l3;
                            ++l;
                            if (PERF_TEST) {
                                RootsWork.reportRootScan(uRL, l3);
                            }
                            if (!LOGGER.isLoggable(Level.FINE)) continue;
                            LOGGER.fine(String.format("Indexing of: %s took: %d ms", uRL.toExternalForm(), l3));
                            continue;
                        }
                    }
                    catch (Throwable throwable) {
                        var13_9 = null;
                        l3 = System.currentTimeMillis() - l4;
                        l2 += l3;
                        ++l;
                        if (PERF_TEST) {
                            RootsWork.reportRootScan(uRL, l3);
                        }
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine(String.format("Indexing of: %s took: %d ms", uRL.toExternalForm(), l3));
                        }
                        throw throwable;
                    }
                    l3 = System.currentTimeMillis() - l4;
                    l2 += l3;
                    ++l;
                    if (PERF_TEST) {
                        RootsWork.reportRootScan(uRL, l3);
                    }
                    if (!LOGGER.isLoggable(Level.FINE)) break;
                    LOGGER.fine(String.format("Indexing of: %s took: %d ms", uRL.toExternalForm(), l3));
                    break;
                }
                var13_9 = null;
                l3 = System.currentTimeMillis() - l4;
                l2 += l3;
                ++l;
                if (PERF_TEST) {
                    RootsWork.reportRootScan(uRL, l3);
                }
                if (!LOGGER.isLoggable(Level.FINE)) continue;
                LOGGER.fine(String.format("Indexing of: %s took: %d ms", uRL.toExternalForm(), l3));
            }
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info(String.format("Complete indexing of %d source roots took: %d ms", l, l2));
            }
            TEST_LOGGER.log(Level.FINEST, "scanSources", dependenciesContext.newRootsToScan);
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean scanSource(URL uRL) throws IOException {
            block13: {
                LOGGER.log(Level.FINE, "Scanning sources root: {0}", uRL);
                if (!noRootsScan || !this.useInitialState || !TimeStamps.existForRoot(uRL)) break block13;
                LinkedList linkedList = new LinkedList();
                try {
                    Object object;
                    FileObject fileObject = CacheFolder.getDataFolder(uRL);
                    HashSet hashSet = new HashSet();
                    for (String object2 : Util.getAllMimeTypes()) {
                        object = MimeLookup.getLookup((String)object2).lookupAll(CustomIndexerFactory.class);
                        hashSet.addAll(object);
                    }
                    for (CustomIndexerFactory customIndexerFactory : hashSet) {
                        object = SPIAccessor.getInstance().createContext(fileObject, uRL, customIndexerFactory.getIndexerName(), customIndexerFactory.getIndexVersion(), null, this.isFollowUpJob(), this.hasToCheckEditor(), false, null);
                        CustomIndexer customIndexer = customIndexerFactory.createIndexer();
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine("Fake indexing: indexer=" + customIndexer);
                        }
                        try {
                            SPIAccessor.getInstance().index(customIndexer, Collections.emptySet(), (Context)object);
                        }
                        catch (ThreadDeath threadDeath) {
                            throw threadDeath;
                        }
                        catch (Throwable throwable) {
                            LOGGER.log(Level.WARNING, null, throwable);
                        }
                    }
                    Object var11_17 = null;
                }
                catch (Throwable throwable) {
                    Object var11_18 = null;
                    for (Context context : linkedList) {
                        IndexingSupport indexingSupport = SPIAccessor.getInstance().context_getAttachedIndexingSupport(context);
                        if (indexingSupport == null) continue;
                        SupportAccessor.getInstance().store(indexingSupport);
                    }
                    throw throwable;
                }
                for (Context context : linkedList) {
                    IndexingSupport indexingSupport = SPIAccessor.getInstance().context_getAttachedIndexingSupport(context);
                    if (indexingSupport == null) continue;
                    SupportAccessor.getInstance().store(indexingSupport);
                }
                return true;
            }
            FileObject fileObject = URLMapper.findFileObject((URL)uRL);
            if (fileObject != null) {
                FileObjectCrawler fileObjectCrawler = new FileObjectCrawler(fileObject, this.useInitialState, null, this.getShuttdownRequest());
                Map<String, Collection<Indexable>> map = fileObjectCrawler.getResources();
                Collection<Indexable> collection = fileObjectCrawler.getDeletedResources();
                if (fileObjectCrawler.isFinished()) {
                    this.delete(collection, uRL);
                    if (this.index(map, uRL, !this.useInitialState)) {
                        fileObjectCrawler.storeTimestamps();
                        return true;
                    }
                }
                return false;
            }
            return true;
        }

        private static void reportRootScan(URL uRL, long l) {
            try {
                Class<?> clazz = Class.forName("org.netbeans.performance.test.utilities.LoggingScanClasspath", true, Thread.currentThread().getContextClassLoader());
                Method method = clazz.getMethod("reportScanOfFile", String.class, Long.class);
                method.invoke(clazz.newInstance(), uRL.toExternalForm(), new Long(l));
            }
            catch (Exception exception) {
                LOGGER.log(Level.WARNING, null, exception);
            }
        }

        private static <A, B> void diff(Map<A, B> map, Map<A, B> map2, Map<A, B> map3, Map<A, B> map4) {
            for (A a : map.keySet()) {
                if (!map2.containsKey(a)) {
                    map4.put(a, map.get(a));
                    continue;
                }
                if (org.openide.util.Utilities.compareObjects(map.get(a), map2.get(a))) continue;
                map3.put(a, map2.get(a));
            }
            for (A a : map2.keySet()) {
                if (map.containsKey(a)) continue;
                map3.put(a, map2.get(a));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RefreshIndices
    extends Work {
        private final Set<String> indexerMimeTypes;
        private final CustomIndexerFactory indexerFactory;
        private final Map<URL, List<URL>> scannedRoots2Dependencies;

        public RefreshIndices(Set<String> set, CustomIndexerFactory customIndexerFactory, Map<URL, List<URL>> map) {
            super(false, false, true);
            this.indexerMimeTypes = set;
            this.indexerFactory = customIndexerFactory;
            this.scannedRoots2Dependencies = map;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected boolean getDone() {
            for (URL uRL : this.scannedRoots2Dependencies.keySet()) {
                if (this.getShuttdownRequest().isRaised()) {
                    return true;
                }
                try {
                    IndexingSupport indexingSupport;
                    Object var16_17;
                    FileObject fileObject = URLMapper.findFileObject((URL)uRL);
                    if (fileObject == null) continue;
                    FileObjectCrawler fileObjectCrawler = new FileObjectCrawler(fileObject, false, this.indexerMimeTypes, this.getShuttdownRequest());
                    Map<String, Collection<Indexable>> map = fileObjectCrawler.getResources();
                    Collection<Indexable> collection = fileObjectCrawler.getDeletedResources();
                    if (!fileObjectCrawler.isFinished()) continue;
                    if (collection.size() > 0) {
                        this.delete(collection, uRL);
                    }
                    FileObject fileObject2 = CacheFolder.getDataFolder(uRL);
                    LinkedList<Context> linkedList = new LinkedList<Context>();
                    try {
                        for (String string : map.keySet()) {
                            Context context = SPIAccessor.getInstance().createContext(fileObject2, uRL, this.indexerFactory.getIndexerName(), this.indexerFactory.getIndexVersion(), null, false, false, true, null);
                            linkedList.add(context);
                            Collection<Indexable> collection2 = map.get(string);
                            if (collection2 == null) continue;
                            CustomIndexer customIndexer = this.indexerFactory.createIndexer();
                            if (LOGGER.isLoggable(Level.FINE)) {
                                LOGGER.fine("Reindexing " + collection2.size() + " indexables; using " + customIndexer + "; mimeType='" + string + "'");
                            }
                            try {
                                SPIAccessor.getInstance().index(customIndexer, Collections.unmodifiableCollection(collection2), context);
                            }
                            catch (ThreadDeath threadDeath) {
                                throw threadDeath;
                            }
                            catch (Throwable throwable) {
                                LOGGER.log(Level.WARNING, null, throwable);
                            }
                        }
                        var16_17 = null;
                    }
                    catch (Throwable throwable) {
                        var16_17 = null;
                        for (Context context : linkedList) {
                            indexingSupport = SPIAccessor.getInstance().context_getAttachedIndexingSupport(context);
                            if (indexingSupport == null) continue;
                            SupportAccessor.getInstance().store(indexingSupport);
                        }
                        throw throwable;
                    }
                    for (Context context : linkedList) {
                        indexingSupport = SPIAccessor.getInstance().context_getAttachedIndexingSupport(context);
                        if (indexingSupport == null) continue;
                        SupportAccessor.getInstance().store(indexingSupport);
                    }
                    fileObjectCrawler.storeTimestamps();
                }
                catch (IOException iOException) {
                    LOGGER.log(Level.WARNING, null, iOException);
                }
            }
            return true;
        }

        @Override
        public String toString() {
            return super.toString() + ", indexer=" + this.indexerFactory.getIndexerName() + "/" + this.indexerFactory.getIndexVersion() + ", mimeTypes=" + this.indexerMimeTypes;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DeleteWork
    extends Work {
        private final URL root;
        private final Set<String> relativePaths = new HashSet<String>();

        public DeleteWork(URL uRL, Set<String> set) {
            super(false, false, false);
            Parameters.notNull((CharSequence)"root", (Object)uRL);
            Parameters.notNull((CharSequence)"relativePath", set);
            this.root = uRL;
            this.relativePaths.addAll(set);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("DeleteWork@" + Integer.toHexString(System.identityHashCode(this)) + ": root=" + uRL + ", files=" + set);
            }
        }

        @Override
        public boolean getDone() {
            try {
                LinkedList<Indexable> linkedList = new LinkedList<Indexable>();
                for (String string : this.relativePaths) {
                    linkedList.add(SPIAccessor.getInstance().create(new DeletedIndexable(this.root, string)));
                }
                this.delete(linkedList, this.root);
                TEST_LOGGER.log(Level.FINEST, "delete");
            }
            catch (IOException iOException) {
                LOGGER.log(Level.WARNING, null, iOException);
            }
            return true;
        }

        @Override
        public boolean absorb(Work work) {
            if (work instanceof DeleteWork) {
                DeleteWork deleteWork = (DeleteWork)work;
                if (deleteWork.root.equals(this.root)) {
                    this.relativePaths.addAll(deleteWork.relativePaths);
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine(this + ", root=" + this.root + " absorbed: " + deleteWork.relativePaths);
                    }
                    return true;
                }
            }
            return false;
        }
    }

    private static final class BinaryWork
    extends Work {
        private final URL root;

        public BinaryWork(URL uRL) {
            super(false, false, true);
            this.root = uRL;
        }

        protected boolean getDone() {
            try {
                this.indexBinary(this.root);
            }
            catch (IOException iOException) {
                LOGGER.log(Level.WARNING, null, iOException);
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class FileListWork
    extends Work {
        private final URL root;
        private final Collection<FileObject> files = new HashSet<FileObject>();
        private final boolean forceRefresh;

        public FileListWork(URL uRL, boolean bl, boolean bl2, boolean bl3) {
            super(bl, bl2, false);
            assert (uRL != null);
            this.root = uRL;
            this.forceRefresh = bl3;
        }

        public FileListWork(URL uRL, Collection<FileObject> collection, boolean bl, boolean bl2, boolean bl3) {
            super(bl, bl2, false);
            assert (uRL != null);
            assert (collection != null && collection.size() > 0);
            this.root = uRL;
            this.files.addAll(collection);
            this.forceRefresh = bl3;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("FileListWork@" + Integer.toHexString(System.identityHashCode(this)) + ": root=" + uRL + ", file=" + collection);
            }
        }

        public void addFile(FileObject fileObject) {
            assert (fileObject != null);
            assert (FileUtil.isParentOf((FileObject)URLMapper.findFileObject((URL)this.root), (FileObject)fileObject)) : "File " + fileObject + " does not belong under the root: " + this.root;
            this.files.add(fileObject);
        }

        @Override
        protected boolean getDone() {
            FileObject fileObject = URLMapper.findFileObject((URL)this.root);
            if (fileObject != null) {
                try {
                    FileObjectCrawler fileObjectCrawler = this.files.isEmpty() ? new FileObjectCrawler(fileObject, !this.forceRefresh, null, this.getShuttdownRequest()) : new FileObjectCrawler(fileObject, this.files.toArray(new FileObject[this.files.size()]), !this.forceRefresh, null, this.getShuttdownRequest());
                    Map<String, Collection<Indexable>> map = fileObjectCrawler.getResources();
                    if (fileObjectCrawler.isFinished() && this.index(map, this.root, this.files.isEmpty() && this.forceRefresh)) {
                        fileObjectCrawler.storeTimestamps();
                        if (!this.files.isEmpty()) {
                            Map<FileObject, Document> map2 = FileListWork.getEditorFiles();
                            for (FileObject fileObject2 : this.files) {
                                Document document = map2.get(fileObject2);
                                if (document == null) continue;
                                long l = DocumentUtilities.getDocumentVersion((Document)document);
                                document.putProperty(PROP_LAST_INDEXED_VERSION, l);
                                document.putProperty(PROP_LAST_DIRTY_VERSION, null);
                            }
                        }
                    }
                }
                catch (IOException iOException) {
                    LOGGER.log(Level.WARNING, null, iOException);
                }
            }
            TEST_LOGGER.log(Level.FINEST, "filelist");
            return true;
        }

        @Override
        public boolean absorb(Work work) {
            if (work instanceof FileListWork) {
                FileListWork fileListWork = (FileListWork)work;
                if (fileListWork.root.equals(this.root) && fileListWork.isFollowUpJob() == this.isFollowUpJob() && fileListWork.hasToCheckEditor() == this.hasToCheckEditor()) {
                    this.files.addAll(fileListWork.files);
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine(this + ", root=" + this.root + " absorbed: " + fileListWork.files);
                    }
                    return true;
                }
            }
            return false;
        }

        private static Map<FileObject, Document> getEditorFiles() {
            HashMap<FileObject, Document> hashMap = new HashMap<FileObject, Document>();
            for (JTextComponent jTextComponent : EditorRegistry.componentList()) {
                Document document = jTextComponent.getDocument();
                FileObject fileObject = NbEditorUtilities.getFileObject((Document)document);
                if (fileObject == null) continue;
                hashMap.put(fileObject, document);
            }
            return hashMap;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class Work {
        private final AtomicBoolean cancelled = new AtomicBoolean(false);
        private final AtomicBoolean finished = new AtomicBoolean(false);
        private final boolean followUpJob;
        private final boolean checkEditor;
        private final CountDownLatch latch = new CountDownLatch(1);
        private final Map<String, List<EmbeddingIndexerFactory>> embeddedIndexers = new HashMap<String, List<EmbeddingIndexerFactory>>();
        private final CancelRequest cancelRequest = new CancelRequest(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean isRaised() {
                if (Work.this.cancelled.get()) {
                    RepositoryUpdater repositoryUpdater = RepositoryUpdater.getDefault();
                    synchronized (repositoryUpdater) {
                        if (RepositoryUpdater.getDefault().getState() == State.STOPPED) {
                            return true;
                        }
                    }
                }
                return false;
            }
        };
        private final boolean supportsProgress;
        private ProgressHandle progressHandle = null;

        protected Work(boolean bl, boolean bl2, boolean bl3) {
            this.followUpJob = bl;
            this.checkEditor = bl2;
            this.supportsProgress = bl3;
        }

        protected final boolean isFollowUpJob() {
            return this.followUpJob;
        }

        protected final boolean hasToCheckEditor() {
            return this.checkEditor;
        }

        protected final void updateProgress(String string) {
            assert (string != null);
            if (this.progressHandle == null) {
                return;
            }
            this.progressHandle.progress(string);
        }

        protected final void updateProgress(URL uRL) {
            assert (uRL != null);
            if (this.progressHandle == null) {
                return;
            }
            this.progressHandle.progress(this.urlForMessage(uRL));
        }

        protected final void updateProgress(URL uRL, int n, int n2) {
            assert (uRL != null);
            if (this.progressHandle == null) {
                return;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.urlForMessage(uRL));
            stringBuilder.append(" (").append(n).append(" of ").append(n2).append(")");
            this.progressHandle.progress(stringBuilder.toString());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void delete(Collection<Indexable> collection, URL uRL) throws IOException {
            if (collection == null || collection.size() == 0) {
                return;
            }
            LinkedList linkedList = new LinkedList();
            try {
                Object object;
                FileObject fileObject = CacheFolder.getDataFolder(uRL);
                HashSet hashSet = new HashSet();
                HashSet hashSet2 = new HashSet();
                for (String object2 : Util.getAllMimeTypes()) {
                    object = MimeLookup.getLookup((String)object2).lookupAll(CustomIndexerFactory.class);
                    hashSet.addAll(object);
                    Collection collection2 = MimeLookup.getLookup((String)object2).lookupAll(EmbeddingIndexerFactory.class);
                    hashSet2.addAll(collection2);
                }
                for (CustomIndexerFactory customIndexerFactory : hashSet) {
                    object = SPIAccessor.getInstance().createContext(fileObject, uRL, customIndexerFactory.getIndexerName(), customIndexerFactory.getIndexVersion(), null, this.followUpJob, this.checkEditor, false, null);
                    customIndexerFactory.filesDeleted(collection, (Context)object);
                }
                for (EmbeddingIndexerFactory embeddingIndexerFactory : hashSet2) {
                    object = SPIAccessor.getInstance().createContext(fileObject, uRL, embeddingIndexerFactory.getIndexerName(), embeddingIndexerFactory.getIndexVersion(), null, this.followUpJob, this.checkEditor, false, null);
                    embeddingIndexerFactory.filesDeleted(collection, (Context)object);
                }
                Object var12_15 = null;
            }
            catch (Throwable throwable) {
                Object var12_16 = null;
                for (Context context : linkedList) {
                    IndexingSupport indexingSupport = SPIAccessor.getInstance().context_getAttachedIndexingSupport(context);
                    if (indexingSupport == null) continue;
                    SupportAccessor.getInstance().store(indexingSupport);
                }
                throw throwable;
            }
            for (Context context : linkedList) {
                IndexingSupport indexingSupport = SPIAccessor.getInstance().context_getAttachedIndexingSupport(context);
                if (indexingSupport == null) continue;
                SupportAccessor.getInstance().store(indexingSupport);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected final boolean index(Map<String, Collection<Indexable>> map, URL uRL, boolean bl) throws IOException {
            LinkedList<Context> linkedList;
            block29: {
                boolean bl2;
                block28: {
                    boolean bl3;
                    block27: {
                        boolean bl4;
                        block26: {
                            linkedList = new LinkedList<Context>();
                            try {
                                int n = 0;
                                int n2 = 0;
                                for (String string : map.keySet()) {
                                    Collection<Indexable> collection = map.get(string);
                                    if (collection == null) continue;
                                    n2 += collection.size();
                                }
                                FileObject fileObject = CacheFolder.getDataFolder(uRL);
                                for (String string : map.keySet()) {
                                    Collection<Indexable> collection;
                                    block31: {
                                        block30: {
                                            if (this.getShuttdownRequest().isRaised()) {
                                                bl4 = false;
                                                Object var20_26 = null;
                                                break block26;
                                            }
                                            collection = map.get(string);
                                            if (collection == null) continue;
                                            if (LOGGER.isLoggable(Level.FINE)) {
                                                LOGGER.fine("-- Indexing " + string + " in " + uRL);
                                            }
                                            Collection collection2 = MimeLookup.getLookup((String)string).lookupAll(CustomIndexerFactory.class);
                                            boolean bl5 = true;
                                            for (CustomIndexerFactory customIndexerFactory : collection2) {
                                                if (this.getShuttdownRequest().isRaised()) {
                                                    bl3 = false;
                                                    break block27;
                                                }
                                                bl3 = customIndexerFactory.supportsEmbeddedIndexers();
                                                if (LOGGER.isLoggable(Level.FINER)) {
                                                    LOGGER.fine("CustomIndexerFactory: " + customIndexerFactory + ", supportsEmbeddedIndexers=" + bl3);
                                                }
                                                bl5 &= bl3;
                                                Context context = SPIAccessor.getInstance().createContext(fileObject, uRL, customIndexerFactory.getIndexerName(), customIndexerFactory.getIndexVersion(), null, this.followUpJob, this.checkEditor, bl, this.getShuttdownRequest());
                                                linkedList.add(context);
                                                CustomIndexer customIndexer = customIndexerFactory.createIndexer();
                                                if (LOGGER.isLoggable(Level.FINE)) {
                                                    LOGGER.fine("Indexing " + collection.size() + " indexables; using " + customIndexer + "; mimeType='" + string + "'");
                                                }
                                                try {
                                                    SPIAccessor.getInstance().index(customIndexer, Collections.unmodifiableCollection(collection), context);
                                                }
                                                catch (ThreadDeath threadDeath) {
                                                    throw threadDeath;
                                                }
                                                catch (Throwable throwable) {
                                                    LOGGER.log(Level.WARNING, null, throwable);
                                                }
                                            }
                                            if (!bl5) break block30;
                                            if (Util.canBeParsed(string)) {
                                                LOGGER.log(Level.FINE, "Using EmbeddingIndexers for {0}", collection);
                                                boolean bl6 = this.indexEmbedding(fileObject, uRL, collection, linkedList, n, n2);
                                                if (!bl6) {
                                                    bl2 = false;
                                                    break block28;
                                                }
                                                break block31;
                                            } else if (LOGGER.isLoggable(Level.FINE)) {
                                                LOGGER.fine(string + " has no Parser or EmbeddingProvider registered and won't be indexed by embedding indexers");
                                            }
                                            break block31;
                                        }
                                        if (LOGGER.isLoggable(Level.FINE)) {
                                            LOGGER.fine(string + " files indexed by custom indexers, embedding indexers forbidden");
                                        }
                                    }
                                    if (LOGGER.isLoggable(Level.FINE)) {
                                        LOGGER.fine("-- Finished indexing " + string + " in " + uRL);
                                    }
                                    n += collection.size();
                                }
                                break block29;
                            }
                            catch (Throwable throwable) {
                                Object var20_30 = null;
                                Iterator iterator = linkedList.iterator();
                                while (true) {
                                    if (!iterator.hasNext()) {
                                        throw throwable;
                                    }
                                    Context context = (Context)iterator.next();
                                    IndexingSupport indexingSupport = SPIAccessor.getInstance().context_getAttachedIndexingSupport(context);
                                    if (indexingSupport == null) continue;
                                    SupportAccessor.getInstance().store(indexingSupport);
                                }
                            }
                        }
                        for (Context context : linkedList) {
                            IndexingSupport indexingSupport = SPIAccessor.getInstance().context_getAttachedIndexingSupport(context);
                            if (indexingSupport == null) continue;
                            SupportAccessor.getInstance().store(indexingSupport);
                        }
                        return bl4;
                    }
                    Object var20_27 = null;
                    for (Context context : linkedList) {
                        IndexingSupport indexingSupport = SPIAccessor.getInstance().context_getAttachedIndexingSupport(context);
                        if (indexingSupport == null) continue;
                        SupportAccessor.getInstance().store(indexingSupport);
                    }
                    return bl3;
                }
                Object var20_28 = null;
                for (Context context : linkedList) {
                    IndexingSupport indexingSupport = SPIAccessor.getInstance().context_getAttachedIndexingSupport(context);
                    if (indexingSupport == null) continue;
                    SupportAccessor.getInstance().store(indexingSupport);
                }
                return bl2;
            }
            Object var20_29 = null;
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                Context context = (Context)iterator.next();
                IndexingSupport indexingSupport = SPIAccessor.getInstance().context_getAttachedIndexingSupport(context);
                if (indexingSupport == null) continue;
                SupportAccessor.getInstance().store(indexingSupport);
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void indexBinary(URL uRL) throws IOException {
            LOGGER.log(Level.FINE, "Scanning binary root: {0}", uRL);
            LinkedList<Context> linkedList = new LinkedList<Context>();
            try {
                FileObject fileObject = CacheFolder.getDataFolder(uRL);
                Collection collection = MimeLookup.getLookup((MimePath)MimePath.EMPTY).lookupAll(BinaryIndexerFactory.class);
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.fine("Using BinaryIndexerFactories: " + collection);
                }
                for (BinaryIndexerFactory binaryIndexerFactory : collection) {
                    Context context = SPIAccessor.getInstance().createContext(fileObject, uRL, binaryIndexerFactory.getIndexerName(), binaryIndexerFactory.getIndexVersion(), null, false, false, false, null);
                    linkedList.add(context);
                    BinaryIndexer binaryIndexer = binaryIndexerFactory.createIndexer();
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Indexing binary " + uRL + " using " + binaryIndexer);
                    }
                    SPIAccessor.getInstance().index(binaryIndexer, context);
                }
                Object var10_9 = null;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                for (Context context : linkedList) {
                    IndexingSupport indexingSupport = SPIAccessor.getInstance().context_getAttachedIndexingSupport(context);
                    if (indexingSupport == null) continue;
                    SupportAccessor.getInstance().store(indexingSupport);
                }
                throw throwable;
            }
            for (Context context : linkedList) {
                IndexingSupport indexingSupport = SPIAccessor.getInstance().context_getAttachedIndexingSupport(context);
                if (indexingSupport == null) continue;
                SupportAccessor.getInstance().store(indexingSupport);
            }
        }

        private boolean indexEmbedding(final FileObject fileObject, final URL uRL, Iterable<? extends Indexable> iterable, final List<Context> list, int n, int n2) throws IOException {
            for (final Indexable indexable : iterable) {
                if (this.getShuttdownRequest().isRaised()) {
                    return false;
                }
                try {
                    final FileObject fileObject2 = URLMapper.findFileObject((URL)indexable.getURL());
                    if (fileObject2 != null) {
                        final Source source = Source.create(fileObject2);
                        ParserManager.parse(Collections.singleton(source), new UserTask(){

                            public void run(ResultIterator resultIterator) throws Exception {
                                String string = source.getMimeType();
                                List list2 = Work.this.findEmbeddingIndexers(string);
                                for (EmbeddingIndexerFactory embeddingIndexerFactory : list2) {
                                    if (LOGGER.isLoggable(Level.FINE)) {
                                        LOGGER.fine("Indexing " + fileObject2.getPath() + "; using " + embeddingIndexerFactory + "; mimeType='" + string + "'");
                                    }
                                    this.visit(resultIterator, embeddingIndexerFactory);
                                }
                            }

                            private void visit(ResultIterator resultIterator, EmbeddingIndexerFactory embeddingIndexerFactory) throws ParseException, IOException {
                                Object object;
                                Object object2;
                                Object object3;
                                Object object4;
                                if (embeddingIndexerFactory != null && (object4 = resultIterator.getParserResult()) != null) {
                                    object3 = embeddingIndexerFactory.getIndexerName();
                                    int n = embeddingIndexerFactory.getIndexVersion();
                                    object2 = SPIAccessor.getInstance().createContext(fileObject, uRL, (String)object3, n, null, Work.this.followUpJob, Work.this.checkEditor, false, null);
                                    list.add(object2);
                                    object = embeddingIndexerFactory.createIndexer(indexable, ((Parser.Result)object4).getSnapshot());
                                    if (object != null) {
                                        try {
                                            SPIAccessor.getInstance().index((EmbeddingIndexer)object, indexable, (Parser.Result)object4, (Context)object2);
                                        }
                                        catch (ThreadDeath threadDeath) {
                                            throw threadDeath;
                                        }
                                        catch (Throwable throwable) {
                                            LOGGER.log(Level.WARNING, null, throwable);
                                        }
                                    }
                                }
                                object4 = resultIterator.getEmbeddings();
                                object3 = object4.iterator();
                                while (object3.hasNext()) {
                                    Embedding embedding = (Embedding)object3.next();
                                    object2 = embedding.getMimeType();
                                    object = Work.this.findEmbeddingIndexers((String)object2);
                                    Iterator iterator = object.iterator();
                                    while (iterator.hasNext()) {
                                        EmbeddingIndexerFactory embeddingIndexerFactory2 = (EmbeddingIndexerFactory)iterator.next();
                                        this.visit(resultIterator.getResultIterator(embedding), embeddingIndexerFactory2);
                                    }
                                }
                            }
                        });
                    }
                }
                catch (ParseException parseException) {
                    LOGGER.log(Level.WARNING, null, parseException);
                }
                this.updateProgress(uRL, ++n, n2);
            }
            return true;
        }

        private List<EmbeddingIndexerFactory> findEmbeddingIndexers(String string) {
            assert (string != null);
            List<EmbeddingIndexerFactory> list = this.embeddedIndexers.get(string);
            if (list != null) {
                return list;
            }
            list = new ArrayList<EmbeddingIndexerFactory>(MimeLookup.getLookup((String)string).lookupAll(EmbeddingIndexerFactory.class));
            if (list != null) {
                this.embeddedIndexers.put(string, list);
            }
            return list;
        }

        protected abstract boolean getDone();

        protected boolean isCancelledBy(Work work) {
            return false;
        }

        public boolean absorb(Work work) {
            return false;
        }

        protected final boolean isCancelled() {
            return this.cancelled.get();
        }

        protected final CancelRequest getShuttdownRequest() {
            return this.cancelRequest;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void doTheWork() {
            try {
                try {
                    this.finished.compareAndSet(false, this.getDone());
                }
                catch (Throwable throwable) {
                    LOGGER.log(Level.WARNING, null, throwable);
                    this.finished.set(true);
                    if (throwable instanceof ThreadDeath) {
                        throw (ThreadDeath)throwable;
                    }
                    Object var3_2 = null;
                    this.latch.countDown();
                }
                Object var3_1 = null;
                this.latch.countDown();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.latch.countDown();
                throw throwable;
            }
        }

        public final void waitUntilDone() {
            try {
                this.latch.await();
            }
            catch (InterruptedException interruptedException) {
                LOGGER.log(Level.WARNING, null, interruptedException);
            }
        }

        public final void setCancelled(boolean bl) {
            this.cancelled.set(bl);
        }

        public final void cancelBy(Work work) {
            if (this.isCancelledBy(work)) {
                LOGGER.log(Level.FINE, "{0} cancelled by {1}", new Object[]{this, work});
                this.cancelled.set(true);
                this.finished.set(true);
            }
        }

        public final boolean isFinished() {
            return this.finished.get();
        }

        public final boolean supportsProgress() {
            return this.supportsProgress;
        }

        public final void setProgressHandle(ProgressHandle progressHandle) {
            this.progressHandle = progressHandle;
        }

        private String urlForMessage(URL uRL) {
            String string = null;
            URL uRL2 = FileUtil.getArchiveFile((URL)uRL);
            if (uRL2 == null) {
                uRL2 = uRL;
            }
            try {
                if ("file".equals(uRL2.getProtocol())) {
                    File file = new File(new URI(uRL2.toString()));
                    string = file.getAbsolutePath();
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            return string == null ? uRL2.toString() : string;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "@" + Integer.toHexString(System.identityHashCode(this)) + "[followUpJob=" + this.followUpJob + ", checkEditor=" + this.checkEditor;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        CREATED,
        STARTED,
        INITIAL_SCAN_RUNNING,
        ACTIVE,
        STOPPED;

    }
}

