/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.impl.indexing;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.parsing.impl.indexing.CancelRequest;
import org.netbeans.modules.parsing.impl.indexing.DeletedIndexable;
import org.netbeans.modules.parsing.impl.indexing.SPIAccessor;
import org.netbeans.modules.parsing.impl.indexing.TimeStamps;
import org.netbeans.modules.parsing.spi.indexing.Indexable;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Crawler {
    private final URL root;
    private final boolean checkTimeStamps;
    private final TimeStamps timeStamps;
    private final Set<String> mimeTypesToCheck;
    private final CancelRequest cancelRequest;
    private Map<String, Collection<Indexable>> cache;
    private Collection<Indexable> deleted;
    private boolean finished;

    protected Crawler(URL uRL, boolean bl, Set<String> set, CancelRequest cancelRequest) throws IOException {
        this.root = uRL;
        this.checkTimeStamps = bl;
        this.timeStamps = TimeStamps.forRoot(uRL, bl);
        this.mimeTypesToCheck = set;
        this.cancelRequest = cancelRequest;
    }

    public final Map<String, Collection<Indexable>> getResources() throws IOException {
        this.init();
        return this.cache;
    }

    public final Collection<Indexable> getDeletedResources() throws IOException {
        this.init();
        return this.deleted;
    }

    public final void storeTimestamps() throws IOException {
        this.timeStamps.store();
    }

    public final boolean isFinished() {
        return this.finished;
    }

    protected final boolean isUpToDate(FileObject fileObject) {
        boolean bl = this.timeStamps.checkAndStoreTimestamp(fileObject);
        return this.checkTimeStamps ? bl : false;
    }

    protected final boolean isCancelled() {
        return this.cancelRequest.isRaised();
    }

    protected abstract boolean collectResources(Set<? extends String> var1, Map<String, Collection<Indexable>> var2);

    private void init() throws IOException {
        if (this.cache == null) {
            HashMap<String, Collection<Indexable>> hashMap = new HashMap<String, Collection<Indexable>>();
            this.finished = this.collectResources(this.mimeTypesToCheck, hashMap);
            this.cache = Collections.unmodifiableMap(hashMap);
            Set<String> set = this.timeStamps.getUnseenFiles();
            if (set != null) {
                this.deleted = new ArrayList<Indexable>(set.size());
                for (String string : set) {
                    this.deleted.add(SPIAccessor.getInstance().create(new DeletedIndexable(this.root, string)));
                }
                this.deleted = Collections.unmodifiableCollection(this.deleted);
            } else {
                this.deleted = Collections.emptyList();
            }
        }
    }
}

