/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.impl.event;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.logging.Logger;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenHierarchyEvent;
import org.netbeans.api.lexer.TokenHierarchyListener;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.impl.SourceAccessor;
import org.netbeans.modules.parsing.impl.SourceFlags;
import org.netbeans.modules.parsing.impl.TaskProcessor;
import org.netbeans.modules.parsing.spi.Parser;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public final class EventSupport {
    private static final Logger LOGGER = Logger.getLogger(EventSupport.class.getName());
    private static final RequestProcessor RP = new RequestProcessor("parsing-event-collector", 1);
    private final Source source;
    private volatile boolean initialized;
    private volatile boolean k24;
    private DocListener docListener;
    private FileChangeListener fileChangeListener;
    private DataObjectListener dobjListener;
    private ChangeListener parserListener;
    private final RequestProcessor.Task resetTask = RP.create(new Runnable(){

        public void run() {
            EventSupport.this.resetStateImpl();
        }
    });
    private static final EditorRegistryListener editorRegistryListener = new EditorRegistryListener();

    public EventSupport(Source source) {
        assert (source != null);
        this.source = source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        if (this.initialized) {
            return;
        }
        Parser parser = SourceAccessor.getINSTANCE().getCache(this.source).getParser();
        Object object = TaskProcessor.INTERNAL_LOCK;
        synchronized (object) {
            if (!this.initialized) {
                FileObject fileObject = this.source.getFileObject();
                if (fileObject != null) {
                    try {
                        this.fileChangeListener = new FileChangeListenerImpl();
                        fileObject.addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)this.fileChangeListener, (Object)fileObject));
                        DataObject dataObject = DataObject.find((FileObject)fileObject);
                        this.assignDocumentListener(dataObject);
                        this.dobjListener = new DataObjectListener(dataObject);
                        this.parserListener = new ParserListener();
                        if (parser != null) {
                            parser.addChangeListener(this.parserListener);
                        }
                    }
                    catch (DataObjectNotFoundException dataObjectNotFoundException) {
                        LOGGER.warning("Ignoring events non existent file: " + FileUtil.getFileDisplayName((FileObject)fileObject));
                    }
                }
                this.initialized = true;
            }
        }
    }

    public void resetState(boolean bl, int n, int n2) {
        EnumSet<SourceFlags> enumSet = EnumSet.of(SourceFlags.CHANGE_EXPECTED);
        if (bl) {
            enumSet.add(SourceFlags.INVALID);
            enumSet.add(SourceFlags.RESCHEDULE_FINISHED_TASKS);
            SourceAccessor.getINSTANCE().setSourceModification(this.source, n, n2);
        }
        SourceAccessor.getINSTANCE().setFlags(this.source, enumSet);
        TaskProcessor.resetState(this.source, bl, true);
        if (!this.k24) {
            this.resetTask.schedule(TaskProcessor.reparseDelay);
        }
    }

    private void resetStateImpl() {
        if (!this.k24) {
            boolean bl = SourceAccessor.getINSTANCE().testFlag(this.source, SourceFlags.RESCHEDULE_FINISHED_TASKS);
            if (bl) {
                SourceAccessor.getINSTANCE().getCache(this.source).sourceModified();
            }
            TaskProcessor.resetStateImpl(this.source);
        }
    }

    private void assignDocumentListener(DataObject dataObject) {
        EditorCookie.Observable observable = (EditorCookie.Observable)dataObject.getCookie(EditorCookie.Observable.class);
        if (observable != null) {
            this.docListener = new DocListener(observable);
        }
    }

    private static class EditorRegistryListener
    implements CaretListener,
    PropertyChangeListener {
        private TaskProcessor.Request request;
        private Reference<JTextComponent> lastEditorRef;

        public EditorRegistryListener() {
            EditorRegistry.addPropertyChangeListener((PropertyChangeListener)new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    EditorRegistryListener.this.editorRegistryChanged();
                }
            });
            this.editorRegistryChanged();
        }

        public void editorRegistryChanged() {
            Object object;
            Object object2;
            Object object3;
            JTextComponent jTextComponent;
            JTextComponent jTextComponent2 = EditorRegistry.lastFocusedComponent();
            JTextComponent jTextComponent3 = jTextComponent = this.lastEditorRef == null ? null : this.lastEditorRef.get();
            if (jTextComponent != jTextComponent2) {
                if (jTextComponent != null) {
                    jTextComponent.removeCaretListener(this);
                    jTextComponent.removePropertyChangeListener(this);
                    object3 = jTextComponent.getDocument();
                    object2 = null;
                    if (object3 != null && (object = NbEditorUtilities.getMimeType((Document)object3)) != null) {
                        object2 = Source.create((Document)object3);
                    }
                    if (object2 != null) {
                        SourceAccessor.getINSTANCE().getEventSupport((Source)object2).k24 = false;
                    }
                }
                this.lastEditorRef = new WeakReference<JTextComponent>(jTextComponent2);
                if (jTextComponent2 != null) {
                    jTextComponent2.addCaretListener(this);
                    jTextComponent2.addPropertyChangeListener(this);
                }
            }
            if ((object3 = EditorRegistry.focusedComponent()) != null) {
                object2 = jTextComponent2.getDocument();
                Object object4 = object = object2 == null ? null : Source.create((Document)object2);
                if (object != null) {
                    SourceAccessor.getINSTANCE().getEventSupport((Source)object).resetState(true, -1, -1);
                }
            }
        }

        public void caretUpdate(CaretEvent caretEvent) {
            Source source;
            Document document;
            JTextComponent jTextComponent;
            JTextComponent jTextComponent2 = jTextComponent = this.lastEditorRef == null ? null : this.lastEditorRef.get();
            if (jTextComponent != null && (document = jTextComponent.getDocument()) != null && (source = Source.create(document)) != null) {
                SourceAccessor.getINSTANCE().getEventSupport(source).resetState(false, -1, -1);
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("completion-active".equals(string)) {
                Document document;
                Source source = null;
                JTextComponent jTextComponent = this.lastEditorRef == null ? null : this.lastEditorRef.get();
                Document document2 = document = jTextComponent == null ? null : jTextComponent.getDocument();
                if (document != null) {
                    source = Source.create(document);
                }
                if (source != null) {
                    Object object = propertyChangeEvent.getNewValue();
                    if (object instanceof Boolean && ((Boolean)object).booleanValue()) {
                        assert (this.request == null);
                        this.request = TaskProcessor.resetState(source, false, false);
                        SourceAccessor.getINSTANCE().getEventSupport(source).k24 = true;
                    } else {
                        TaskProcessor.Request request = this.request;
                        this.request = null;
                        EventSupport eventSupport = SourceAccessor.getINSTANCE().getEventSupport(source);
                        eventSupport.k24 = false;
                        eventSupport.resetTask.schedule(TaskProcessor.reparseDelay);
                        TaskProcessor.resetStateImplAsync(request);
                    }
                }
            }
        }
    }

    private final class DataObjectListener
    implements PropertyChangeListener {
        private DataObject dobj;
        private final FileObject fobj;
        private PropertyChangeListener wlistener;

        public DataObjectListener(DataObject dataObject) {
            this.dobj = dataObject;
            this.fobj = dataObject.getPrimaryFile();
            this.wlistener = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)dataObject);
            this.dobj.addPropertyChangeListener(this.wlistener);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            DataObject dataObject = (DataObject)propertyChangeEvent.getSource();
            if (dataObject != this.dobj) {
                return;
            }
            String string = propertyChangeEvent.getPropertyName();
            if ("valid".equals(string)) {
                this.handleInvalidDataObject(dataObject);
            } else if (propertyChangeEvent.getPropertyName() == null && !this.dobj.isValid()) {
                this.handleInvalidDataObject(dataObject);
            }
        }

        private void handleInvalidDataObject(final DataObject dataObject) {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    DataObjectListener.this.handleInvalidDataObjectImpl(dataObject);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleInvalidDataObjectImpl(DataObject dataObject) {
            dataObject.removePropertyChangeListener(this.wlistener);
            if (this.fobj.isValid()) {
                try {
                    DataObject dataObject2 = DataObject.find((FileObject)this.fobj);
                    DataObjectListener dataObjectListener = this;
                    synchronized (dataObjectListener) {
                        if (dataObject2 == this.dobj) {
                            return;
                        }
                        this.dobj = dataObject2;
                        this.dobj.addPropertyChangeListener(this.wlistener);
                    }
                    EventSupport.this.assignDocumentListener(dataObject2);
                    EventSupport.this.resetState(true, -1, -1);
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        }
    }

    private class FileChangeListenerImpl
    extends FileChangeAdapter {
        private FileChangeListenerImpl() {
        }

        public void fileChanged(FileEvent fileEvent) {
            EventSupport.this.resetState(true, -1, -1);
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            EventSupport.this.resetState(true, -1, -1);
        }
    }

    private class ParserListener
    implements ChangeListener {
        private ParserListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            EventSupport.this.resetState(true, -1, -1);
        }
    }

    private class DocListener
    implements PropertyChangeListener,
    TokenHierarchyListener {
        private EditorCookie.Observable ec;
        private TokenHierarchyListener lexListener;

        public DocListener(EditorCookie.Observable observable) {
            assert (observable != null);
            this.ec = observable;
            this.ec.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.ec));
            Document document = EventSupport.this.source.getDocument(false);
            if (document != null) {
                TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)document);
                this.lexListener = (TokenHierarchyListener)WeakListeners.create(TokenHierarchyListener.class, (EventListener)this, (Object)tokenHierarchy);
                tokenHierarchy.addTokenHierarchyListener(this.lexListener);
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("document".equals(propertyChangeEvent.getPropertyName())) {
                Document document;
                Object object = propertyChangeEvent.getOldValue();
                if (object instanceof Document && this.lexListener != null) {
                    document = TokenHierarchy.get((Document)((Document)object));
                    document.removeTokenHierarchyListener(this.lexListener);
                    this.lexListener = null;
                }
                if ((document = EventSupport.this.source.getDocument(false)) != null) {
                    TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)document);
                    this.lexListener = (TokenHierarchyListener)WeakListeners.create(TokenHierarchyListener.class, (EventListener)this, (Object)tokenHierarchy);
                    tokenHierarchy.addTokenHierarchyListener(this.lexListener);
                    EventSupport.this.resetState(true, -1, -1);
                }
            }
        }

        public void tokenHierarchyChanged(TokenHierarchyEvent tokenHierarchyEvent) {
            EventSupport.this.resetState(true, tokenHierarchyEvent.affectedStartOffset(), tokenHierarchyEvent.affectedEndOffset());
        }
    }
}

