/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.Task;
import org.netbeans.modules.parsing.impl.SchedulerAccessor;
import org.netbeans.modules.parsing.impl.Schedulers;
import org.netbeans.modules.parsing.impl.SourceAccessor;
import org.netbeans.modules.parsing.impl.TaskProcessor;
import org.netbeans.modules.parsing.spi.EmbeddingProvider;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.ParserFactory;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.modules.parsing.spi.SchedulerTask;
import org.netbeans.modules.parsing.spi.SourceModificationEvent;
import org.netbeans.modules.parsing.spi.TaskFactory;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceCache {
    private final Source source;
    private Embedding embedding;
    private final String mimeType;
    private Snapshot snapshot;
    private boolean parserInitialized = false;
    private Parser parser;
    private boolean parsed = false;
    private Collection<Embedding> embeddings;
    private final Map<EmbeddingProvider, List<Embedding>> embeddingProviderToEmbedings = new HashMap<EmbeddingProvider, List<Embedding>>();
    private final Set<EmbeddingProvider> upToDateEmbeddingProviders = new HashSet<EmbeddingProvider>();
    private final Map<Embedding, SourceCache> embeddingToCache = new HashMap<Embedding, SourceCache>();
    private List<SchedulerTask> tasks;
    private Set<SchedulerTask> pendingTasks;

    public SourceCache(Source source, Embedding embedding) {
        assert (source != null);
        this.source = source;
        this.embedding = embedding;
        this.mimeType = embedding != null ? embedding.getMimeType() : source.getMimeType();
        this.mimeType.getClass();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setEmbedding(Embedding embedding) {
        Object object = TaskProcessor.INTERNAL_LOCK;
        synchronized (object) {
            assert (embedding.getMimeType().equals(this.mimeType));
            this.embedding = embedding;
            this.snapshot = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Snapshot getSnapshot() {
        boolean bl;
        Object object = TaskProcessor.INTERNAL_LOCK;
        synchronized (object) {
            if (this.snapshot != null) {
                return this.snapshot;
            }
            bl = this.embedding != null;
        }
        object = this.createSnapshot(bl);
        Object object2 = TaskProcessor.INTERNAL_LOCK;
        synchronized (object2) {
            if (this.snapshot == null) {
                this.snapshot = object;
            }
            return this.snapshot;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Snapshot createSnapshot(long[] lArray) {
        boolean bl;
        assert (lArray != null);
        assert (lArray.length == 1);
        Object object = TaskProcessor.INTERNAL_LOCK;
        synchronized (object) {
            bl = this.embedding != null;
        }
        lArray[0] = SourceAccessor.getINSTANCE().getLastEventId(this.source);
        return this.createSnapshot(bl);
    }

    private Snapshot createSnapshot(boolean bl) {
        Snapshot snapshot;
        Snapshot snapshot2 = snapshot = bl ? this.embedding.getSnapshot() : this.source.createSnapshot();
        assert (this.mimeType.equals(snapshot.getMimeType()));
        return snapshot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Parser getParser() {
        Object object;
        Object object2 = TaskProcessor.INTERNAL_LOCK;
        synchronized (object2) {
            if (this.parserInitialized) {
                return this.parser;
            }
        }
        object2 = this.getSnapshot();
        Parser parser = null;
        Lookup lookup = MimeLookup.getLookup((String)this.mimeType);
        ParserFactory parserFactory = (ParserFactory)lookup.lookup(ParserFactory.class);
        if (parserFactory != null) {
            object = Collections.singleton(object2);
            parser = parserFactory.createParser((Collection<Snapshot>)object);
        }
        object = TaskProcessor.INTERNAL_LOCK;
        synchronized (object) {
            if (!this.parserInitialized) {
                this.parser = parser;
                this.parserInitialized = true;
            }
            return this.parser;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Parser.Result getResult(Task task) throws ParseException {
        boolean bl;
        assert (TaskProcessor.holdsParserLock());
        Parser parser = this.getParser();
        if (parser == null) {
            return null;
        }
        Object object = TaskProcessor.INTERNAL_LOCK;
        synchronized (object) {
            bl = this.parsed;
            this.parsed = true;
        }
        if (!bl) {
            boolean bl2 = false;
            try {
                Snapshot snapshot = this.getSnapshot();
                FileObject fileObject = snapshot.getSource().getFileObject();
                if (fileObject != null && !fileObject.isValid()) {
                    Parser.Result result = null;
                    return result;
                }
                SourceModificationEvent sourceModificationEvent = SourceAccessor.getINSTANCE().getSourceModificationEvent(this.source);
                parser.parse(snapshot, task, sourceModificationEvent);
                SourceAccessor.getINSTANCE().parsed(this.source);
                bl2 = true;
            }
            finally {
                if (!bl2) {
                    Object object2 = TaskProcessor.INTERNAL_LOCK;
                    synchronized (object2) {
                        this.parsed = false;
                    }
                }
            }
        }
        return parser.getResult(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate() {
        Object object = TaskProcessor.INTERNAL_LOCK;
        synchronized (object) {
            this.snapshot = null;
            this.parsed = false;
            this.embeddings = null;
            this.upToDateEmbeddingProviders.clear();
            for (SourceCache sourceCache : this.embeddingToCache.values()) {
                sourceCache.invalidate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate(Snapshot snapshot) {
        Object object = TaskProcessor.INTERNAL_LOCK;
        synchronized (object) {
            this.invalidate();
            this.snapshot = snapshot;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<Embedding> getAllEmbeddings() {
        Collection<SchedulerTask> collection = this.createTasks();
        Snapshot snapshot = this.getSnapshot();
        Object object = TaskProcessor.INTERNAL_LOCK;
        synchronized (object) {
            if (this.embeddings == null) {
                this.embeddings = new ArrayList<Embedding>();
                for (SchedulerTask schedulerTask : collection) {
                    List<Embedding> list;
                    if (!(schedulerTask instanceof EmbeddingProvider)) continue;
                    EmbeddingProvider embeddingProvider = (EmbeddingProvider)schedulerTask;
                    if (this.upToDateEmbeddingProviders.contains(embeddingProvider)) {
                        list = this.embeddingProviderToEmbedings.get(embeddingProvider);
                        this.embeddings.addAll(list);
                        continue;
                    }
                    list = embeddingProvider.getEmbeddings(snapshot);
                    List<Embedding> list2 = this.embeddingProviderToEmbedings.get(embeddingProvider);
                    this.updateEmbeddings(list, list2, false, null);
                    this.embeddingProviderToEmbedings.put(embeddingProvider, list);
                    this.upToDateEmbeddingProviders.add(embeddingProvider);
                    this.embeddings.addAll(list);
                }
            }
            return this.embeddings;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refresh(EmbeddingProvider embeddingProvider, Class<? extends Scheduler> clazz) {
        List<Embedding> list;
        List<Embedding> list2 = embeddingProvider.getEmbeddings(this.getSnapshot());
        Object object = TaskProcessor.INTERNAL_LOCK;
        synchronized (object) {
            list = this.embeddingProviderToEmbedings.get(embeddingProvider);
        }
        this.updateEmbeddings(list2, list, true, clazz);
        object = TaskProcessor.INTERNAL_LOCK;
        synchronized (object) {
            this.embeddingProviderToEmbedings.put(embeddingProvider, list2);
            this.upToDateEmbeddingProviders.add(embeddingProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void updateEmbeddings(List<Embedding> list, List<Embedding> list2, boolean bl, Class<? extends Scheduler> clazz) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Iterator iterator = TaskProcessor.INTERNAL_LOCK;
        synchronized (iterator) {
            if (list2 != null && list.size() == list2.size()) {
                void var7_8;
                boolean i = false;
                while (var7_8 < list.size()) {
                    if (list.get((int)var7_8) == null) {
                        throw new NullPointerException();
                    }
                    SourceCache sourceCache = this.embeddingToCache.remove(list2.get((int)var7_8));
                    if (sourceCache != null) {
                        sourceCache.setEmbedding(list.get((int)var7_8));
                        assert (list.get((int)var7_8).getMimeType().equals(sourceCache.getSnapshot().getMimeType()));
                        this.embeddingToCache.put(list.get((int)var7_8), sourceCache);
                    } else {
                        SourceCache sourceCache2 = this.getCache(list.get((int)var7_8));
                    }
                    if (bl) {
                        void var8_12;
                        arrayList.add(var8_12);
                    }
                    ++var7_8;
                }
            } else {
                SourceCache sourceCache;
                if (list2 != null) {
                    for (Embedding embedding : list2) {
                        sourceCache = this.embeddingToCache.remove(embedding);
                        if (sourceCache == null) continue;
                        sourceCache.removeTasks();
                    }
                }
                if (bl) {
                    for (Embedding embedding : list) {
                        sourceCache = this.getCache(embedding);
                        arrayList.add(sourceCache);
                    }
                }
            }
        }
        for (SourceCache sourceCache : arrayList) {
            sourceCache.scheduleTasks(clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SourceCache getCache(Embedding embedding) {
        Object object = TaskProcessor.INTERNAL_LOCK;
        synchronized (object) {
            SourceCache sourceCache = this.embeddingToCache.get(embedding);
            if (sourceCache == null) {
                sourceCache = new SourceCache(this.source, embedding);
                assert (embedding.getMimeType().equals(sourceCache.getSnapshot().getMimeType()));
                this.embeddingToCache.put(embedding, sourceCache);
            }
            return sourceCache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<SchedulerTask> createTasks() {
        Object object;
        ArrayList<SchedulerTask> arrayList = null;
        HashSet<SchedulerTask> hashSet = null;
        if (this.tasks == null) {
            arrayList = new ArrayList<SchedulerTask>();
            hashSet = new HashSet<SchedulerTask>();
            object = MimeLookup.getLookup((String)this.mimeType);
            Collection collection = object.lookupAll(TaskFactory.class);
            Collection<? extends TaskFactory> collection2 = this.resortTaskFactories(collection);
            for (TaskFactory taskFactory : collection2) {
                Collection<? extends SchedulerTask> collection3 = taskFactory.create(this.getSnapshot());
                if (collection3 == null) continue;
                arrayList.addAll(collection3);
                hashSet.addAll(collection3);
            }
        }
        object = TaskProcessor.INTERNAL_LOCK;
        synchronized (object) {
            if (this.tasks == null && arrayList != null) {
                this.tasks = arrayList;
                this.pendingTasks = hashSet;
            }
            if (this.tasks != null) {
                return this.tasks;
            }
        }
        return this.createTasks();
    }

    private Collection<? extends TaskFactory> resortTaskFactories(Collection<? extends TaskFactory> collection) {
        ArrayList<? extends TaskFactory> arrayList = new ArrayList<TaskFactory>(collection);
        for (TaskFactory taskFactory : arrayList) {
            if (!taskFactory.getClass().getName().equals("org.netbeans.modules.javascript.editing.embedding.JsEmbeddingProvider$Factory")) continue;
            arrayList.remove(taskFactory);
            arrayList.add(0, taskFactory);
            break;
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleTasks(Class<? extends Scheduler> clazz) {
        ArrayList<SchedulerTask> arrayList = new ArrayList<SchedulerTask>();
        ArrayList<SchedulerTask> arrayList2 = new ArrayList<SchedulerTask>();
        Collection<SchedulerTask> collection = this.createTasks();
        Object object = TaskProcessor.INTERNAL_LOCK;
        synchronized (object) {
            for (SchedulerTask schedulerTask : collection) {
                if (clazz != null && schedulerTask.getSchedulerClass() != clazz && !(schedulerTask instanceof EmbeddingProvider)) continue;
                if (this.pendingTasks.remove(schedulerTask)) {
                    arrayList2.add(schedulerTask);
                    continue;
                }
                arrayList.add(schedulerTask);
                arrayList2.add(schedulerTask);
            }
        }
        if (!arrayList2.isEmpty()) {
            TaskProcessor.updatePhaseCompletionTask(arrayList2, arrayList, this.source, this, clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sourceModified() {
        Object object;
        SourceModificationEvent sourceModificationEvent = SourceAccessor.getINSTANCE().getSourceModificationEvent(this.source);
        if (sourceModificationEvent == null) {
            return;
        }
        HashMap hashMap = new HashMap();
        for (Scheduler object22 : Schedulers.getSchedulers()) {
            object = SchedulerAccessor.get().createSchedulerEvent(object22, sourceModificationEvent);
            if (object == null) continue;
            hashMap.put(object22.getClass(), (SchedulerEvent)object);
        }
        SourceAccessor.getINSTANCE().setSchedulerEvents(this.source, hashMap);
        if (hashMap.isEmpty()) {
            return;
        }
        ArrayList arrayList = new ArrayList();
        ArrayList<SchedulerTask> arrayList2 = new ArrayList<SchedulerTask>();
        object = this.createTasks();
        Object object2 = TaskProcessor.INTERNAL_LOCK;
        synchronized (object2) {
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                SchedulerTask schedulerTask = (SchedulerTask)iterator.next();
                Class<? extends Scheduler> clazz = schedulerTask.getSchedulerClass();
                if (clazz != null && !hashMap.containsKey(clazz)) continue;
                if (this.pendingTasks.remove(schedulerTask)) {
                    arrayList2.add(schedulerTask);
                    continue;
                }
                arrayList.add(schedulerTask);
                arrayList2.add(schedulerTask);
            }
        }
        if (!arrayList2.isEmpty()) {
            TaskProcessor.updatePhaseCompletionTask(arrayList2, arrayList, this.source, this, null);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("SourceCache ");
        stringBuilder.append(this.hashCode());
        stringBuilder.append(": ");
        Snapshot snapshot = this.getSnapshot();
        Source source = snapshot.getSource();
        FileObject fileObject = source.getFileObject();
        if (fileObject != null) {
            stringBuilder.append(fileObject.getNameExt());
        } else {
            stringBuilder.append(this.mimeType).append(" ").append(source.getDocument(false));
        }
        if (!snapshot.getMimeType().equals(source.getMimeType())) {
            stringBuilder.append("( ").append(snapshot.getMimeType()).append(" ");
            stringBuilder.append(snapshot.getOriginalOffset(0)).append("-").append(snapshot.getOriginalOffset(snapshot.getText().length() - 1)).append(")");
        }
        return stringBuilder.toString();
    }

    private void removeTasks() {
        if (this.tasks != null) {
            TaskProcessor.removePhaseCompletionTasks(this.tasks, this.source);
        }
        this.tasks = null;
    }
}

