/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.impl;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.parsing.impl.Schedulers;
import org.netbeans.modules.parsing.impl.indexing.RepositoryUpdater;
import org.openide.modules.ModuleInstall;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

public class Installer
extends ModuleInstall {
    public void restored() {
        super.restored();
        RepositoryUpdater.getDefault().start(false);
        WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

            public void run() {
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        Schedulers.init();
                    }
                });
            }
        });
    }

    public boolean closing() {
        boolean bl = super.closing();
        RepositoryUpdater.getDefault().stop();
        return bl;
    }

    public void validate() throws IllegalStateException {
        super.validate();
        long l = System.currentTimeMillis();
        try {
            List<MemoryPoolMXBean> list = null;
            list = ManagementFactory.getMemoryPoolMXBeans();
            for (MemoryPoolMXBean memoryPoolMXBean : list) {
                if (memoryPoolMXBean.getType() != MemoryType.HEAP || !memoryPoolMXBean.isUsageThresholdSupported()) continue;
                return;
            }
            IllegalStateException illegalStateException = new IllegalStateException("Cannot listen on usage threshold");
            throw (IllegalStateException)Exceptions.attachLocalizedMessage((Throwable)illegalStateException, (String)NbBundle.getMessage(Installer.class, (String)"ERR_NoUsageThreshold"));
        }
        finally {
            Logger logger = Logger.getLogger(Installer.class.getName());
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "threshold supported check took: {0}", System.currentTimeMillis() - l);
            }
        }
    }
}

