/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.api.indexing;

import java.net.URL;
import java.util.Collection;
import org.netbeans.modules.parsing.impl.Utilities;
import org.netbeans.modules.parsing.impl.indexing.RepositoryUpdater;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IndexingManager {
    private static IndexingManager instance;

    public static synchronized IndexingManager getDefault() {
        if (instance == null) {
            instance = new IndexingManager();
        }
        return instance;
    }

    public boolean isIndexing() {
        return Utilities.isScanInProgress();
    }

    public void refreshIndex(URL uRL, Collection<? extends URL> collection) {
        this.refreshIndex(uRL, collection, true);
    }

    public void refreshIndex(URL uRL, Collection<? extends URL> collection, boolean bl) {
        RepositoryUpdater.getDefault().addIndexingJob(uRL, collection, false, false, false, bl);
    }

    public void refreshIndexAndWait(URL uRL, Collection<? extends URL> collection) {
        this.refreshIndexAndWait(uRL, collection, true);
    }

    public void refreshIndexAndWait(URL uRL, Collection<? extends URL> collection, boolean bl) {
        RepositoryUpdater.getDefault().addIndexingJob(uRL, collection, false, false, true, bl);
    }

    public void refreshAllIndices(String string) {
        if (string != null) {
            RepositoryUpdater.getDefault().addIndexingJob(string);
        } else {
            RepositoryUpdater.getDefault().refreshAll();
        }
    }

    public void refreshAllIndices(FileObject ... fileObjectArray) {
        RepositoryUpdater.getDefault().refreshAll();
    }

    private IndexingManager() {
        RepositoryUpdater.getDefault().start(false);
    }
}

