/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.csl.hints.infrastructure;

import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintsProvider;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.csl.core.Language;
import org.netbeans.modules.csl.core.LanguageRegistry;
import org.netbeans.modules.csl.hints.infrastructure.GsfHintsManager;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.CursorMovedSchedulerEvent;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.ParserResultTask;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.HintsController;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectionHintsTask
extends ParserResultTask<ParserResult> {
    private static final Logger LOG = Logger.getLogger(SelectionHintsTask.class.getName());
    private boolean cancelled = false;

    public void run(ParserResult parserResult, SchedulerEvent schedulerEvent) {
        this.resume();
        final FileObject fileObject = parserResult.getSnapshot().getSource().getFileObject();
        if (fileObject == null || this.isCancelled()) {
            return;
        }
        if (!(schedulerEvent instanceof CursorMovedSchedulerEvent) || this.isCancelled()) {
            return;
        }
        CursorMovedSchedulerEvent cursorMovedSchedulerEvent = (CursorMovedSchedulerEvent)schedulerEvent;
        final int[] nArray = new int[]{Math.min(cursorMovedSchedulerEvent.getMarkOffset(), cursorMovedSchedulerEvent.getCaretOffset()), Math.max(cursorMovedSchedulerEvent.getMarkOffset(), cursorMovedSchedulerEvent.getCaretOffset())};
        if (nArray == null || nArray.length != 2 || nArray[0] == -1 || nArray[1] == -1 || nArray[0] == nArray[1]) {
            return;
        }
        try {
            ParserManager.parse(Collections.singleton(parserResult.getSnapshot().getSource()), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    Parser.Result result = resultIterator.getParserResult(nArray[0]);
                    if (!(result instanceof ParserResult)) {
                        return;
                    }
                    Language language = LanguageRegistry.getInstance().getLanguageByMimeType(result.getSnapshot().getMimeType());
                    if (language == null || SelectionHintsTask.this.isCancelled()) {
                        return;
                    }
                    HintsProvider hintsProvider = language.getHintsProvider();
                    if (hintsProvider == null || SelectionHintsTask.this.isCancelled()) {
                        return;
                    }
                    GsfHintsManager gsfHintsManager = language.getHintsManager();
                    if (gsfHintsManager == null || SelectionHintsTask.this.isCancelled()) {
                        return;
                    }
                    ArrayList<ErrorDescription> arrayList = new ArrayList<ErrorDescription>();
                    ArrayList<Hint> arrayList2 = new ArrayList<Hint>();
                    RuleContext ruleContext = gsfHintsManager.createRuleContext((ParserResult)result, language, -1, nArray[0], nArray[1]);
                    if (ruleContext != null && !SelectionHintsTask.this.isCancelled()) {
                        hintsProvider.computeSelectionHints(gsfHintsManager, ruleContext, arrayList2, nArray[0], nArray[1]);
                        for (Hint hint : arrayList2) {
                            if (SelectionHintsTask.this.isCancelled()) {
                                return;
                            }
                            ErrorDescription errorDescription = gsfHintsManager.createDescription(hint, ruleContext, false);
                            arrayList.add(errorDescription);
                        }
                    }
                    if (SelectionHintsTask.this.isCancelled()) {
                        return;
                    }
                    HintsController.setErrors((FileObject)fileObject, (String)SelectionHintsTask.class.getName(), arrayList);
                }
            });
        }
        catch (ParseException parseException) {
            LOG.log(Level.WARNING, null, parseException);
        }
    }

    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    public Class<? extends Scheduler> getSchedulerClass() {
        return Scheduler.CURSOR_SENSITIVE_TASK_SCHEDULER;
    }

    public synchronized void cancel() {
        this.cancelled = true;
    }

    private synchronized void resume() {
        this.cancelled = false;
    }

    private synchronized boolean isCancelled() {
        return this.cancelled;
    }
}

