/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.csl.editor.semantic;

import org.netbeans.modules.csl.api.ColoringAttributes;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.core.Language;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SequenceElement
implements Comparable<SequenceElement> {
    public final Language language;
    public OffsetRange range;
    public final ColoringAttributes.Coloring coloring;

    private SequenceElement() {
        this(null, null, null);
    }

    public SequenceElement(Language language, OffsetRange offsetRange, ColoringAttributes.Coloring coloring) {
        this.language = language;
        this.range = offsetRange;
        this.coloring = coloring;
    }

    @Override
    public int compareTo(SequenceElement sequenceElement) {
        if (sequenceElement instanceof ComparisonItem) {
            return -1 * ((ComparisonItem)sequenceElement).compareTo(this);
        }
        assert (sequenceElement.range != null);
        return this.range.compareTo(sequenceElement.range);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof SequenceElement)) {
            return false;
        }
        SequenceElement sequenceElement = (SequenceElement)object;
        return this.range.equals(sequenceElement.range);
    }

    public int hashCode() {
        return this.range.hashCode();
    }

    public String toString() {
        return "SequenceElement(range=" + this.range + ", lang=" + this.language + ", color=" + this.coloring + ")";
    }

    static class ComparisonItem
    extends SequenceElement {
        private int offset;

        ComparisonItem(int n) {
            this.offset = n;
        }

        public int compareTo(SequenceElement sequenceElement) {
            if (sequenceElement instanceof ComparisonItem) {
                return this.offset - ((ComparisonItem)sequenceElement).offset;
            }
            if (this.offset < sequenceElement.range.getStart()) {
                return -1;
            }
            if (this.offset >= sequenceElement.range.getEnd()) {
                return 1;
            }
            return 0;
        }
    }
}

