/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.csl.editor.fold;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.api.editor.fold.Fold;
import org.netbeans.api.editor.fold.FoldType;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.csl.api.DataLoadersBridge;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Severity;
import org.netbeans.modules.csl.api.StructureScanner;
import org.netbeans.modules.csl.core.Language;
import org.netbeans.modules.csl.core.LanguageRegistry;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.ParserResultTask;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.spi.editor.fold.FoldHierarchyTransaction;
import org.netbeans.spi.editor.fold.FoldManager;
import org.netbeans.spi.editor.fold.FoldOperation;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;

public class GsfFoldManager
implements FoldManager {
    private static final Logger LOG = Logger.getLogger(GsfFoldManager.class.getName());
    public static final FoldType CODE_BLOCK_FOLD_TYPE = new FoldType("code-block");
    public static final FoldType INITIAL_COMMENT_FOLD_TYPE = new FoldType("initial-comment");
    public static final FoldType IMPORTS_FOLD_TYPE = new FoldType("imports");
    public static final FoldType JAVADOC_FOLD_TYPE = new FoldType("javadoc");
    public static final FoldType TAG_FOLD_TYPE = new FoldType("tag");
    private static final String IMPORTS_FOLD_DESCRIPTION = "...";
    private static final String COMMENT_FOLD_DESCRIPTION = "...";
    private static final String JAVADOC_FOLD_DESCRIPTION = "...";
    private static final String CODE_BLOCK_FOLD_DESCRIPTION = "{...}";
    private static final String TAG_FOLD_DESCRIPTION = "<.../>";
    public static final FoldTemplate CODE_BLOCK_FOLD_TEMPLATE = new FoldTemplate(CODE_BLOCK_FOLD_TYPE, "{...}", 1, 1);
    public static final FoldTemplate INITIAL_COMMENT_FOLD_TEMPLATE = new FoldTemplate(INITIAL_COMMENT_FOLD_TYPE, "...", 2, 2);
    public static final FoldTemplate IMPORTS_FOLD_TEMPLATE = new FoldTemplate(IMPORTS_FOLD_TYPE, "...", 0, 0);
    public static final FoldTemplate JAVADOC_FOLD_TEMPLATE = new FoldTemplate(JAVADOC_FOLD_TYPE, "...", 3, 2);
    public static final FoldTemplate TAG_FOLD_TEMPLATE = new FoldTemplate(TAG_FOLD_TYPE, "<.../>", 0, 0);
    public static final String CODE_FOLDING_COLLAPSE_METHOD = "code-folding-collapse-method";
    public static final String CODE_FOLDING_COLLAPSE_INNERCLASS = "code-folding-collapse-innerclass";
    public static final String CODE_FOLDING_COLLAPSE_IMPORT = "code-folding-collapse-import";
    public static final String CODE_FOLDING_COLLAPSE_JAVADOC = "code-folding-collapse-javadoc";
    public static final String CODE_FOLDING_COLLAPSE_INITIAL_COMMENT = "code-folding-collapse-initial-comment";
    public static final String CODE_FOLDING_COLLAPSE_TAGS = "code-folding-collapse-tags";
    private FoldOperation operation;
    private FileObject file;
    private JavaElementFoldTask task;
    private Preferences prefs;
    private Map<FoldInfo, Fold> currentFolds;
    private Fold initialCommentFold;
    private Fold importsFold;

    public void init(FoldOperation foldOperation) {
        this.operation = foldOperation;
        String string = DocumentUtilities.getMimeType((JTextComponent)foldOperation.getHierarchy().getComponent());
        this.prefs = (Preferences)MimeLookup.getLookup((String)string).lookup(Preferences.class);
    }

    public synchronized void initFolds(FoldHierarchyTransaction foldHierarchyTransaction) {
        Document document = this.operation.getHierarchy().getComponent().getDocument();
        this.file = DataLoadersBridge.getDefault().getFileObject(document);
        if (this.file != null) {
            this.currentFolds = new HashMap<FoldInfo, Fold>();
            this.task = JavaElementFoldTask.getTask(this.file);
            this.task.setGsfFoldManager(this);
        }
    }

    public void insertUpdate(DocumentEvent documentEvent, FoldHierarchyTransaction foldHierarchyTransaction) {
    }

    public void removeUpdate(DocumentEvent documentEvent, FoldHierarchyTransaction foldHierarchyTransaction) {
    }

    public void changedUpdate(DocumentEvent documentEvent, FoldHierarchyTransaction foldHierarchyTransaction) {
    }

    public void removeEmptyNotify(Fold fold) {
        this.removeDamagedNotify(fold);
    }

    public void removeDamagedNotify(Fold fold) {
        this.currentFolds.remove(this.operation.getExtraInfo(fold));
        if (this.importsFold == fold) {
            this.importsFold = null;
        }
        if (this.initialCommentFold == fold) {
            this.initialCommentFold = null;
        }
    }

    public void expandNotify(Fold fold) {
    }

    public synchronized void release() {
        if (this.task != null) {
            this.task.setGsfFoldManager(null);
        }
        this.task = null;
        this.file = null;
        this.currentFolds = null;
        this.importsFold = null;
        this.initialCommentFold = null;
    }

    private boolean getSetting(String string) {
        return this.prefs.getBoolean(string, false);
    }

    private static boolean hasErrors(ParserResult parserResult) {
        for (Error error : parserResult.getDiagnostics()) {
            if (error.getSeverity() != Severity.ERROR) continue;
            return true;
        }
        return false;
    }

    protected static final class FoldInfo
    implements Comparable {
        private Position start;
        private Position end;
        private FoldTemplate template;
        private boolean collapseByDefault;

        public FoldInfo(Document document, int n, int n2, FoldTemplate foldTemplate, boolean bl) throws BadLocationException {
            this.start = document.createPosition(n);
            this.end = document.createPosition(n2);
            this.template = foldTemplate;
            this.collapseByDefault = bl;
        }

        public int hashCode() {
            return 1;
        }

        public boolean equals(Object object) {
            if (!(object instanceof FoldInfo)) {
                return false;
            }
            return this.compareTo(object) == 0;
        }

        public int compareTo(Object object) {
            FoldInfo foldInfo = (FoldInfo)object;
            if (this.start.getOffset() < foldInfo.start.getOffset()) {
                return -1;
            }
            if (this.start.getOffset() > foldInfo.start.getOffset()) {
                return 1;
            }
            if (this.end.getOffset() < foldInfo.end.getOffset()) {
                return -1;
            }
            if (this.end.getOffset() > foldInfo.end.getOffset()) {
                return 1;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CommitFolds
    implements Runnable {
        private boolean insideRender;
        private TreeSet<FoldInfo> infos;
        private long startTime;

        public CommitFolds(TreeSet<FoldInfo> treeSet) {
            this.infos = treeSet;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Document document = GsfFoldManager.this.operation.getHierarchy().getComponent().getDocument();
            if (!this.insideRender) {
                this.startTime = System.currentTimeMillis();
                this.insideRender = true;
                document.render(this);
                return;
            }
            GsfFoldManager.this.operation.getHierarchy().lock();
            try {
                FoldHierarchyTransaction foldHierarchyTransaction = GsfFoldManager.this.operation.openTransaction();
                try {
                    if (GsfFoldManager.this.currentFolds == null) {
                        return;
                    }
                    TreeMap<FoldInfo, Fold> treeMap = new TreeMap<FoldInfo, Fold>();
                    TreeSet treeSet = new TreeSet(GsfFoldManager.this.currentFolds.keySet());
                    int n = document.getLength();
                    for (FoldInfo foldInfo : this.infos) {
                        if (treeSet.remove(foldInfo)) continue;
                        int n2 = foldInfo.start.getOffset();
                        int n3 = foldInfo.end.getOffset();
                        if (n3 > n || n3 <= n2 || n3 - n2 <= foldInfo.template.getStartGuardedLength() + foldInfo.template.getEndGuardedLength()) continue;
                        Fold fold = GsfFoldManager.this.operation.addToHierarchy(foldInfo.template.getType(), foldInfo.template.getDescription(), foldInfo.collapseByDefault, n2, n3, foldInfo.template.getStartGuardedLength(), foldInfo.template.getEndGuardedLength(), (Object)foldInfo, foldHierarchyTransaction);
                        treeMap.put(foldInfo, fold);
                        if (foldInfo.template == IMPORTS_FOLD_TEMPLATE) {
                            GsfFoldManager.this.importsFold = fold;
                        }
                        if (foldInfo.template != INITIAL_COMMENT_FOLD_TEMPLATE) continue;
                        GsfFoldManager.this.initialCommentFold = fold;
                    }
                    for (FoldInfo foldInfo : treeSet) {
                        Fold fold = (Fold)GsfFoldManager.this.currentFolds.remove(foldInfo);
                        GsfFoldManager.this.operation.removeFromHierarchy(fold, foldHierarchyTransaction);
                        if (GsfFoldManager.this.importsFold == fold) {
                            GsfFoldManager.this.importsFold = null;
                        }
                        if (GsfFoldManager.this.initialCommentFold != fold) continue;
                        GsfFoldManager.this.initialCommentFold = fold;
                    }
                    GsfFoldManager.this.currentFolds.putAll(treeMap);
                }
                catch (BadLocationException badLocationException) {
                    LOG.log(Level.WARNING, null, badLocationException);
                }
                finally {
                    foldHierarchyTransaction.commit();
                }
            }
            finally {
                GsfFoldManager.this.operation.getHierarchy().unlock();
            }
            long l = System.currentTimeMillis();
            Logger.getLogger("TIMER").log(Level.FINE, "Folds - 2", new Object[]{GsfFoldManager.this.file, l - this.startTime});
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class JavaElementFoldTask
    extends ParserResultTask<ParserResult> {
        private final AtomicBoolean cancelled = new AtomicBoolean(false);
        private static Map<FileObject, JavaElementFoldTask> file2Task = new WeakHashMap<FileObject, JavaElementFoldTask>();
        private Reference<GsfFoldManager> manager;

        static JavaElementFoldTask getTask(FileObject fileObject) {
            JavaElementFoldTask javaElementFoldTask = file2Task.get(fileObject);
            if (javaElementFoldTask == null) {
                javaElementFoldTask = new JavaElementFoldTask();
                file2Task.put(fileObject, javaElementFoldTask);
            }
            return javaElementFoldTask;
        }

        synchronized void setGsfFoldManager(GsfFoldManager gsfFoldManager) {
            this.manager = new WeakReference<GsfFoldManager>(gsfFoldManager);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(ParserResult parserResult, SchedulerEvent schedulerEvent) {
            GsfFoldManager gsfFoldManager;
            this.cancelled.set(false);
            JavaElementFoldTask javaElementFoldTask = this;
            synchronized (javaElementFoldTask) {
                gsfFoldManager = this.manager != null ? this.manager.get() : null;
            }
            if (gsfFoldManager == null) {
                return;
            }
            long l = System.currentTimeMillis();
            if (GsfFoldManager.hasErrors(parserResult)) {
                return;
            }
            TreeSet<FoldInfo> treeSet = new TreeSet<FoldInfo>();
            boolean bl = this.gsfFoldScan(gsfFoldManager, parserResult, treeSet);
            if (!bl || this.cancelled.get()) {
                return;
            }
            GsfFoldManager gsfFoldManager2 = gsfFoldManager;
            gsfFoldManager2.getClass();
            SwingUtilities.invokeLater(gsfFoldManager2.new CommitFolds(treeSet));
            long l2 = System.currentTimeMillis();
            Logger.getLogger("TIMER").log(Level.FINE, "Folds - 1", new Object[]{parserResult.getSnapshot().getSource().getFileObject(), l2 - l});
        }

        private boolean gsfFoldScan(final GsfFoldManager gsfFoldManager, ParserResult parserResult, final TreeSet<FoldInfo> treeSet) {
            final Document document = gsfFoldManager.operation.getHierarchy().getComponent().getDocument();
            final boolean[] blArray = new boolean[]{false};
            Source source = parserResult.getSnapshot().getSource();
            try {
                ParserManager.parse(Collections.singleton(source), (UserTask)new UserTask(){

                    public void run(ResultIterator resultIterator) throws Exception {
                        String string = resultIterator.getSnapshot().getMimeType();
                        Language language = LanguageRegistry.getInstance().getLanguageByMimeType(string);
                        if (language == null) {
                            return;
                        }
                        StructureScanner structureScanner = language.getStructure();
                        if (structureScanner == null) {
                            return;
                        }
                        Parser.Result result = resultIterator.getParserResult();
                        if (!(result instanceof ParserResult)) {
                            return;
                        }
                        JavaElementFoldTask.this.scan(gsfFoldManager, (ParserResult)result, treeSet, document, structureScanner);
                        if (JavaElementFoldTask.this.cancelled.get()) {
                            return;
                        }
                        for (Embedding embedding : resultIterator.getEmbeddings()) {
                            this.run(resultIterator.getResultIterator(embedding));
                            if (!JavaElementFoldTask.this.cancelled.get()) continue;
                            return;
                        }
                        blArray[0] = true;
                    }
                });
            }
            catch (ParseException parseException) {
                LOG.log(Level.WARNING, null, parseException);
            }
            if (blArray[0]) {
                blArray[0] = this.checkInitialFold(gsfFoldManager, treeSet);
            }
            return blArray[0];
        }

        private boolean checkInitialFold(GsfFoldManager gsfFoldManager, TreeSet<FoldInfo> treeSet) {
            try {
                Document document = gsfFoldManager.operation.getHierarchy().getComponent().getDocument();
                TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)document);
                if (tokenHierarchy == null) {
                    return false;
                }
                TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
                while (tokenSequence.moveNext()) {
                    Token token = tokenSequence.token();
                    String string = token.id().primaryCategory();
                    if ("comment".equals(string)) {
                        int n = tokenSequence.offset();
                        int n2 = n + token.length();
                        boolean bl = gsfFoldManager.getSetting(GsfFoldManager.CODE_FOLDING_COLLAPSE_INITIAL_COMMENT);
                        if (gsfFoldManager.initialCommentFold != null) {
                            bl = gsfFoldManager.initialCommentFold.isCollapsed();
                        }
                        while (tokenSequence.moveNext()) {
                            token = tokenSequence.token();
                            string = token.id().primaryCategory();
                            if ("comment".equals(string)) {
                                n2 = tokenSequence.offset() + token.length();
                                continue;
                            }
                            if ("whitespace".equals(string)) continue;
                        }
                        try {
                            n = Utilities.getRowEnd((BaseDocument)((BaseDocument)document), (int)n);
                            if (n >= n2) {
                                return true;
                            }
                        }
                        catch (BadLocationException badLocationException) {
                            LOG.log(Level.WARNING, null, badLocationException);
                        }
                        treeSet.add(new FoldInfo(document, n, n2, INITIAL_COMMENT_FOLD_TEMPLATE, bl));
                        return true;
                    }
                    if ("whitespace".equals(string)) continue;
                    break;
                }
            }
            catch (BadLocationException badLocationException) {
                return false;
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                return false;
            }
            return true;
        }

        private void scan(GsfFoldManager gsfFoldManager, ParserResult parserResult, TreeSet<FoldInfo> treeSet, Document document, StructureScanner structureScanner) {
            this.addTree(gsfFoldManager, treeSet, parserResult, document, structureScanner);
        }

        private void addTree(GsfFoldManager gsfFoldManager, TreeSet<FoldInfo> treeSet, ParserResult parserResult, Document document, StructureScanner structureScanner) {
            boolean bl;
            Map<String, List<OffsetRange>> map = structureScanner.folds(parserResult);
            if (this.cancelled.get()) {
                return;
            }
            List<OffsetRange> list = map.get("codeblocks");
            if (list != null) {
                bl = gsfFoldManager.getSetting(GsfFoldManager.CODE_FOLDING_COLLAPSE_METHOD);
                for (OffsetRange offsetRange : list) {
                    this.addFold(offsetRange, treeSet, document, bl, CODE_BLOCK_FOLD_TEMPLATE);
                }
            }
            if ((list = map.get("comments")) != null) {
                bl = gsfFoldManager.getSetting(GsfFoldManager.CODE_FOLDING_COLLAPSE_JAVADOC);
                for (OffsetRange offsetRange : list) {
                    this.addFold(offsetRange, treeSet, document, bl, JAVADOC_FOLD_TEMPLATE);
                }
            }
            if ((list = map.get("initial-comment")) != null) {
                for (OffsetRange offsetRange : list) {
                    boolean bl2 = gsfFoldManager.getSetting(GsfFoldManager.CODE_FOLDING_COLLAPSE_INITIAL_COMMENT);
                    this.addFold(offsetRange, treeSet, document, bl2, INITIAL_COMMENT_FOLD_TEMPLATE);
                }
            }
            if ((list = map.get("imports")) != null) {
                for (OffsetRange offsetRange : list) {
                    boolean bl3 = gsfFoldManager.getSetting(GsfFoldManager.CODE_FOLDING_COLLAPSE_IMPORT);
                    this.addFold(offsetRange, treeSet, document, bl3, IMPORTS_FOLD_TEMPLATE);
                }
            }
            if ((list = map.get("tags")) != null) {
                for (OffsetRange offsetRange : list) {
                    boolean bl4 = gsfFoldManager.getSetting(GsfFoldManager.CODE_FOLDING_COLLAPSE_TAGS);
                    this.addFold(offsetRange, treeSet, document, bl4, TAG_FOLD_TEMPLATE);
                }
            }
        }

        private void addFold(OffsetRange offsetRange, TreeSet<FoldInfo> treeSet, Document document, boolean bl, FoldTemplate foldTemplate) {
            if (offsetRange != OffsetRange.NONE) {
                int n = offsetRange.getStart();
                int n2 = offsetRange.getEnd();
                if (n != -1 && n2 != -1 && n2 <= document.getLength()) {
                    try {
                        treeSet.add(new FoldInfo(document, n, n2, foldTemplate, bl));
                    }
                    catch (BadLocationException badLocationException) {
                        ErrorManager.getDefault().notify((Throwable)badLocationException);
                    }
                }
            }
        }

        public int getPriority() {
            return Integer.MAX_VALUE;
        }

        public Class<? extends Scheduler> getSchedulerClass() {
            return Scheduler.EDITOR_SENSITIVE_TASK_SCHEDULER;
        }

        public void cancel() {
            this.cancelled.set(true);
        }
    }

    protected static final class FoldTemplate {
        private FoldType type;
        private String description;
        private int startGuardedLength;
        private int endGuardedLength;

        protected FoldTemplate(FoldType foldType, String string, int n, int n2) {
            this.type = foldType;
            this.description = string;
            this.startGuardedLength = n;
            this.endGuardedLength = n2;
        }

        public FoldType getType() {
            return this.type;
        }

        public String getDescription() {
            return this.description;
        }

        public int getStartGuardedLength() {
            return this.startGuardedLength;
        }

        public int getEndGuardedLength() {
            return this.endGuardedLength;
        }
    }
}

