/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.csl.editor.completion;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JToolTip;
import javax.swing.text.JTextComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodParamsTipPaintComponent
extends JToolTip {
    private int drawX;
    private int drawY;
    private int drawHeight;
    private int drawWidth;
    private Font drawFont;
    private int fontHeight;
    private int descent;
    private FontMetrics fontMetrics;
    private List<List<String>> params;
    private int idx;
    private JTextComponent component;

    public MethodParamsTipPaintComponent(List<List<String>> list, int n, JTextComponent jTextComponent) {
        this.params = list;
        this.idx = n;
        this.component = jTextComponent;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        graphics.setColor(this.getBackground());
        Rectangle rectangle = graphics.getClipBounds();
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setColor(this.getForeground());
        this.draw(graphics);
    }

    protected void draw(Graphics graphics) {
        int n;
        Insets insets = this.getInsets();
        GraphicsConfiguration graphicsConfiguration = this.component.getGraphicsConfiguration();
        int n2 = n = graphicsConfiguration != null ? graphicsConfiguration.getBounds().width : Integer.MAX_VALUE;
        if (insets != null) {
            this.drawX = insets.left;
            this.drawY = insets.top;
        } else {
            this.drawX = 0;
            this.drawY = 0;
        }
        this.drawY += this.fontHeight - this.descent;
        int n3 = this.drawX;
        this.drawWidth = this.drawX;
        int n4 = 0;
        for (List<String> list : this.params) {
            for (String string : list) {
                if (this.getWidth(string, n4 == this.idx ? this.getDrawFont().deriveFont(1) : this.getDrawFont()) + this.drawX > n) {
                    this.drawY += this.fontHeight;
                    this.drawX = n3 + this.getWidth("        ", this.drawFont);
                }
                this.drawString(graphics, string, n4 == this.idx ? this.getDrawFont().deriveFont(1) : this.getDrawFont());
                if (this.drawWidth < this.drawX) {
                    this.drawWidth = this.drawX;
                }
                ++n4;
            }
            this.drawY += this.fontHeight;
            this.drawX = n3;
        }
        this.drawHeight = this.drawY - this.fontHeight + this.descent;
        if (insets != null) {
            this.drawHeight += insets.bottom;
            this.drawWidth += insets.right;
        }
    }

    protected void drawString(Graphics graphics, String string, Font font) {
        if (graphics != null) {
            graphics.setFont(font);
            graphics.drawString(string, this.drawX, this.drawY);
            graphics.setFont(this.drawFont);
        }
        this.drawX += this.getWidth(string, font);
    }

    protected int getWidth(String string, Font font) {
        if (font == null) {
            return this.fontMetrics.stringWidth(string);
        }
        return this.getFontMetrics(font).stringWidth(string);
    }

    protected int getHeight(String string, Font font) {
        if (font == null) {
            return this.fontMetrics.stringWidth(string);
        }
        return this.getFontMetrics(font).stringWidth(string);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.fontMetrics = this.getFontMetrics(font);
        this.fontHeight = this.fontMetrics.getHeight();
        this.descent = this.fontMetrics.getDescent();
        this.drawFont = font;
    }

    protected Font getDrawFont() {
        return this.drawFont;
    }

    @Override
    public Dimension getPreferredSize() {
        this.draw(null);
        Insets insets = this.getInsets();
        if (insets != null) {
            this.drawX += insets.right;
        }
        return new Dimension(this.drawWidth, this.drawHeight);
    }
}

